
# See http://d.hatena.ne.jp/alunko/20071021/1192908620

# zip ファイルを読み込む。
# unzip コマンドでの解凍結果と、このコマンドでの解凍結果を diff -r で比較すると良い。
# 
# 2009-05-09 katoy
#

$KCODE = "utf8"

require 'rubygems'
require 'kconv'
require 'zip/zipfilesystem'  # gem install rubyzip
require 'fileutils'
require 'pp'

class EdinetZip

  def self.include_instance?(src_zip)
    Zip::ZipFile.foreach(src_zip) do |entry|
      return true if /\.xbrl$/ =~ entry.name.downcase
    end
    return false
  end 

  def self.exstra_instances(src_zip, dest_dir)
    instance_files = []
    Zip::ZipFile.foreach(src_zip) do |entry|
      path = File.join(dest_dir, entry.name)
      FileUtils.makedirs(File.dirname(path))
      File.open(path, 'wb') { |f|
        f.write(entry.get_input_stream.read())
      }
      instance_files << path if /\.xbrl$/ =~ path
    end
    instance_files
  end

  def self.get_instance_files(argv)
    instance_files = []
    argv.each do |path|
      if /\.xbrl$/ =~ path.downcase
        instance_files << path
      else
        instance_files = instance_files | EdinetZip.exstra_instances(path, 'temp')
      end
    end
    instance_files
  end

  def self.xbrl_instance?(file_path)
    if /\.zip$/ =~ file_path.downcase
      return true if EdinetZip.include_instance?(file_path)
    elsif /\.xbrl$/ =~ file_path.downcase
      return true
    end
    $stderr.puts "--------- Not XBRL Instance or zip: #{file_path}"
    return false
  end
end

#--------- 呼び出し例 -----------
if __FILE__ == $0
  src_zip = '../../sample2009-edinet/XBRL_20090509_064405.zip'
  dest_dir = 'zzz'

  EdinetZip.exstra_instance(src_zip, dest_dir)
end