<schema xmlns="http://purl.oclc.org/dsdl/schematron" queryBinding="xslt2">

<!--

Copyright 2009, XBRL International Inc.

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
 
-->

  <ns prefix="ix"    uri="http://www.xbrl.org/2008/inlineXBRL"/>
  <ns prefix="ixt"   uri="http://www.xbrl.org/2008/inlineXBRL/transformation"/>
  <ns prefix="xbrli" uri="http://www.xbrl.org/2003/instance"/>
  <ns prefix="xhtml" uri="http://www.w3.org/1999/xhtml"/>
  <ns prefix="xs"    uri="http://www.w3.org/2001/XMLSchema"/>
  <ns prefix="xsi"   uri="http://www.w3.org/2001/XMLSchema-instance"/>

  <let name="transform-registry" value="document('inlinexbrl-1_0-transformation.xsd')"/>

<!-- 5.1.2 Validation rules -->
  <pattern id="unique-footnote-id">
    <rule context="ix:footnote">
      <assert test="1 eq count(//ix:footnote[@footnoteID eq current()/@footnoteID])">
        >For each ix:footnote element in the Inline XBRL Document Set there MUST NOT be any other ix:footnote element with the same {footnote id} property.</assert>
      <assert test="ancestor-or-self::*/@xml:lang"
        >The ix:footnote element MUST have an xml:lang attribute in scope.</assert>
    </rule>
  </pattern>

<!-- Validation rules common to sections 6.1.2, 9.1.2, 10.1.2, and 13.1.2 -->
  <pattern id="unique-id">
    <rule context="ix:*[@id]">
      <assert test="1 eq count(//ix:*[@id eq current()/@id])"
        >If the id attribute is present, the {id} property MUST NOT match the {id} property of any other element in the Inline XBRL Document Set.</assert>
    </rule>
  </pattern>

  <pattern id="tuple-ref">
    <rule context="ix:*[@tupleRef]">
      <assert test="//ix:tuple[@tupleID eq current()/@tupleRef]"
        >There MUST exist an ix:tuple element in the Inline XBRL Document Set with a {tuple id} property which has a value matching the {tuple reference} property.</assert>
    </rule>
  </pattern>

  <pattern id="footnote-refs">
    <rule context="ix:*[@footnoteRefs]">
      <assert test="every $footnoteID in tokenize(@footnoteRefs,' ') satisfies //ix:footnote[@footnoteID eq $footnoteID]"
        >For each token in {footnote references} there MUST exist an ix:footnote element in the Inline XBRL Document Set with a {footnote id} property which has a matching value.</assert>
    </rule>
  </pattern>

<!-- Validation rules common to sections 6.1.2, 9.1.2, and 10.1.2 -->
  <pattern id="context-ref">
    <rule context="ix:*[@contextRef]">
      <assert test="//xbrli:context[@id eq current()/@contextRef]"
        >There MUST exist an xbrli:context element in the Inline XBRL Document Set for which the actual value of the id attribute is equal to the {context reference} property.</assert>
    </rule>
  </pattern>

  <pattern id="format-name">
    <rule context="ix:*[@format]">
      <let name="format" value="resolve-QName(@format, .)"/>
      <assert test="$format eq xs:QName('ixt:datedoteu')
                 or $format eq xs:QName('ixt:datedotus')
                 or $format eq xs:QName('ixt:datelonguk')
                 or $format eq xs:QName('ixt:datelongus')
                 or $format eq xs:QName('ixt:dateshortuk')
                 or $format eq xs:QName('ixt:dateshortus')
                 or $format eq xs:QName('ixt:dateslasheu')
                 or $format eq xs:QName('ixt:dateslashus')
                 or $format eq xs:QName('ixt:numcomma')
                 or $format eq xs:QName('ixt:numcommadot')
                 or $format eq xs:QName('ixt:numdash')
                 or $format eq xs:QName('ixt:numdotcomma')
                 or $format eq xs:QName('ixt:numspacecomma')
                 or $format eq xs:QName('ixt:numspacedot')
                 "
        >If the format attribute is present, the {format} property MUST match the expanded name implied by the value of the name attribute of a signature element in the relevant Transformation Rules Registry.</assert>
    </rule>
  </pattern>

  <pattern id="formatted-value">
    <rule context="ix:*[@format][not(@xsi:nil eq 'true')]">
      <let name="format-local" value="if (contains(@format,':'))
                                      then substring-after(@format,':')
                                      else @format"/>
      <let name="type-decl"    value="$transform-registry/xs:schema/xs:simpleType[@name eq concat($format-local, 'Type')]"/>
      <!-- support just one level of (unmodified) restriction from another simple type -->
      <let name="regex"        value="$type-decl/xs:restriction/(if (resolve-QName(@base, .) eq xs:QName('xs:string'))
                                                                 then xs:pattern/@value
                                                                 else (for $base-name in resolve-QName(@base, .) return /*/xs:simpleType[QName(/*/@targetNamespace, @name) eq $base-name])
                                                                      /xs:restriction/xs:pattern/@value
                                                                )"/>
      <let name="doc"          value="$type-decl/xs:annotation/xs:documentation"/>
      <assert test="$regex and matches(., concat('^', $regex, '$'))"
        >If the format attribute is present, the {value} property MUST be valid in accordance with {format input type}: <value-of select="@format"/>: <value-of select="$regex"/>

        <value-of select="$doc"/>
      </assert>
    </rule>
  </pattern>

<!-- Validation rules common to sections 6.1.2 and 9.1.2 -->
  <pattern id="unit-ref">
    <rule context="ix:*[@unitRef]">
      <assert test="//xbrli:unit[@id eq current()/@unitRef]"
        >There MUST exist an xbrli:unit element in the Inline XBRL Document Set for which the actual value of the id attribute is equal to the {unit reference} property.</assert>
    </rule>
  </pattern>

  <pattern id="format-absent">
    <rule context="*[self::ix:numerator
                  or self::ix:denominator
                  or self::ix:nonFraction]
                    [not(@format)]
                    [not(@xsi:nil eq 'true')]">
      <assert test="matches(normalize-space(.), '^\+?\d*\.?\d*$')"
        >If the format attribute is not present, the {value} property MUST be a non-negative number.</assert>
    </rule>
  </pattern>

<!-- 7.1.3 Validation rules -->
  <pattern id="header-count">
    <rule context="/">
      <assert test="count(//ix:header) ge 1"
        >There MUST be at least one ix:header element in the Inline XBRL Document Set.</assert>
    </rule>
  </pattern>

<!-- 11.1.2 Validation rules -->
  <pattern id="references-for-each-target">
    <rule context="/">
      <!-- handles the case of the default target (where there's no target attribute) -->
      <assert test="every $target in distinct-values(//*[ self::ix:fraction
                                                        | self::ix:nonFraction
                                                        | self::ix:nonNumeric
                                                        | self::ix:tuple]/string(@target)
                                                    ) satisfies //ix:references[string(@target) eq $target]"
        >There MUST be at least one ix:references element in the Inline XBRL Document Set for each Target Document.</assert>
    </rule>
  </pattern>

<!-- 12.1.2 Validation rules -->
  <pattern id="resources-count">
    <rule context="/">
      <assert test="count(//ix:resources) ge 1"
        >There MUST be at least one ix:resources element in the Inline XBRL Document Set.</assert>
    </rule>
  </pattern>
  
  <pattern id="unique-context-id">
    <rule context="xbrli:context">
      <assert test="1 eq count(//xbrli:context[@id eq current()/@id])"
        >For each xbrli:context element in the Inline XBRL Document Set there MUST NOT be any other element in the Inline XBRL Document Set with the same actual value for its id attribute, if any.</assert>
    </rule>
  </pattern>

  <pattern id="unique-unit-id">
    <rule context="xbrli:unit">
      <assert test="1 eq count(//xbrli:unit[@id eq current()/@id])"
        >For each xbrli:unit element in the Inline XBRL Document Set there MUST NOT be any other element in the Inline XBRL Document Set with the same actual value for its id attribute, if any.</assert>
    </rule>
  </pattern>

<!-- 13.1.2 Validation rules -->
  <pattern id="order-attribute">
    <rule context="ix:*[@order]">
      <assert test="@tupleRef or ancestor::ix:tuple"
        >All elements MUST have an order attribute if and only if they are members of {tuple content}.</assert>
    </rule>
    <rule context="*[self::ix:fraction
                  or self::ix:nonFraction
                  or self::ix:nonNumeric
                  or self::ix:tuple] [not(@order)]">
      <assert test="not(@tupleRef or ancestor::ix:tuple)"
        >All elements MUST have an order attribute if and only if they are members of {tuple content}.</assert>
    </rule>
  </pattern>

  <pattern id="unique-tuple-id">
    <rule context="ix:tuple[@tupleID]">
      <assert test="1 eq count(//ix:tuple[@tupleID eq current()/@tupleID])"
        >For each ix:tuple element in the Inline XBRL Document Set there MUST NOT be any other ix:tuple element with the same {tuple id} property.</assert>
    </rule>
  </pattern>

  <pattern id="tuple-content-rules">
    <rule context="ix:tuple[not(@xsi:nil eq 'true')]">
      <let name="inline-content" value="( .//ix:fraction
                                        | .//ix:nonFraction
                                        | .//ix:nonNumeric
                                        | .//ix:tuple
                                        ) [not(@tupleRef)]
                                          [ancestor::ix:*[1] is current()]"/>
      <let name="tuple-content" value="$inline-content | //ix:*[@tupleRef eq current()/@tupleID]"/>

      <assert test="count($tuple-content) ge 1"
        >There MUST be at least one element in {tuple content}.</assert>
      <!-- Note: the following test is only as complete as Schematron can practically support; it won't detect circular structures via tupleRef more than one level deep -->
      <assert test="not(@tupleRef = ( @tupleID
                                    | .//ix:tuple/@tupleID
                                    | $tuple-content/@tupleID
                                    )
                       )"
        >The ix:tuple element MUST NOT directly or recursively form part of the {tuple content} property of any ix:tuple element in {tuple content}.</assert>
      <assert test="count($tuple-content/@order) eq count(distinct-values($tuple-content/@order))"
        >The values of all the order attributes amongst elements in {tuple content} MUST be unique.</assert>

      <!-- 13.1.1 Constraints on ix:tuple -->
      <assert test="$inline-content or @tupleID"
        >The element MUST either have one or more ix:fraction, ix:nonFraction, ix:nonNumeric or ix:tuple children, or have an tupleID atttribute.</assert>
      <assert test="every $fact in $tuple-content satisfies string($fact/@target) eq string(current()/@target)"
        >The {target} property of the ix:tuple element MUST be equal to the {target} property of all elements in {tuple content}.</assert>

    </rule>
  </pattern>


<!-- Constraints not enforced by the open content models of the XHTML+iXBRL XSD schema -->

  <!-- 4.1.1 Constraints on ix:exclude -->
  <pattern id="exclude-constraints">
    <rule context="ix:exclude">
      <assert test="ancestor::ix:nonNumeric">The ix:exclude element MUST be a descendant of an ix:nonNumeric element.</assert>
    </rule>
  </pattern>

  <!-- 6.1.1 Constraints on ix:fraction -->
  <pattern id="fraction-constraints">
    <rule context="ix:fraction[not(@xsi:nil eq 'true')]">
      <assert test="count(.//ix:numerator)   = 1">The ix:fraction element MUST have exactly one ix:numerator descendant element.</assert>
      <assert test="count(.//ix:denominator) = 1">The ix:fraction element MUST have exactly one ix:denominator descendant element.</assert>
    </rule>
  </pattern>

  <!-- 7.1.1 Constraints on ix:header -->
  <pattern id="header-constraints">
    <rule context="ix:header">
      <assert test="not(ancestor::xhtml:head)">The ix:header element MUST NOT be a descendant of an HTML head element.</assert>
    </rule>
  </pattern>

  <!-- 9.1.1 Constraints on ix:nonFraction -->
  <pattern id="nonFraction-constraints">
    <rule context="ix:nonFraction">
      <assert test="1 eq count( @decimals
                              | @precision
                              | @xsi:nil[. eq 'true']
                              )">The ix:nonFraction element MUST have exactly one of: a decimals attribute; or a precision attribute; or have an xsi:nil attribute with the value true.</assert>
    </rule>
  </pattern>

  <!-- 13.1.1 Constraints on ix:tuple -->
  <!-- [See above under 13.1.2 Validation rules] -->

</schema>
