#-*- coding: utf-8; -*-

require 'lib/mastermind'

describe "A game" do

  before do
    @random = mock("random", :null_object => true)

    @interactor = mock("interactor", :null_object => true)
    @game = Mastermind::Game.new(@interactor, @random) 
  end

  it "should create a secret code" do
    @random.should_receive(:next).exactly(4).times.with(no_args).and_return(0, 0, 0, 0)
    @game.play
  end

  it "should prompt for a guess" do
    @interactor.should_receive(:write).once.with("Enter guess #1: ")
    @game.take_turn(1, Mastermind::Code.new(:white, :white, :white, :white)) 
  end

  it "should get guess from user" do
    @interactor.should_receive(:readline).once.and_return 'wwww'
    @game.take_turn(1, Mastermind::Code.new(:white, :white, :white, :white))
  end

  it "should inform user of win on turn 1 when first guess is correc" do
    @random.should_receive(:next).exactly(4).times.with(no_args).and_return 0
    @interactor.should_receive(:readline).once.and_return 'bbbb'
    @interactor.should_receive(:writeline).once.with('You won in 1 turn.')
    @game.play 
  end

  it "should inform user of win on turn 2 when second guess is correct" do
    @random.should_receive(:next).exactly(4).times.with(no_args).and_return 0
    @interactor.should_receive(:readline).twice.and_return 'wwww', 'bbbb'
    @interactor.should_receive(:writeline).once.with('You won in 2 turns.')
    @game.play
  end

  it "should inform user of win on turn 6 when sixth guess is correct" do
    @random.should_receive(:next).exactly(4).times.with(no_args).and_return 0
    @interactor.should_receive(:readline).exactly(6).times.with(no_args).and_return(
      'wwww', 'cccc', 'gggg', 'rrrr', 'yyyy', 'bbbb')
    @interactor.should_receive(:writeline).once.with('You won in 6 turns.')
    @game.play
  end

  it "should inform user of win on turn 10 when tenth guess is correct" do
    @random.should_receive(:next).exactly(4).times.with(no_args).and_return 0
    @interactor.should_receive(:readline).exactly(10).times.and_return(
      'wwww', 'wwww', 'wwww', 'wwww', 'wwww', 'wwww', 'wwww', 'wwww', 'wwww', 'bbbb')
    @interactor.should_receive(:writeline).once.with('You won in 10 turns.')
    @interactor.should_not_receive(:writeline).with('You lose after 10 turns.')
    @game.play
  end

  it "should inform user of no score" do
    @interactor.should_receive(:readline).once.and_return 'bbbb'
    @interactor.should_receive(:writeline).once.with 'No scoring pegs'
    @game.take_turn(1, Mastermind::Code.new(:white, :white, :white, :white))
  end

  it "should inform user of all black score" do
    @interactor.should_receive(:readline).once.and_return 'wwww'
    @interactor.should_receive(:writeline).once.with 'Score: 4 black'
    @game.take_turn(1, Mastermind::Code.new(:white, :white, :white, :white))
  end

  it "should inform user of all white score" do
    @interactor.should_receive(:readline).once.and_return 'cgrb'
    @interactor.should_receive(:writeline).once.with 'Score: 4 white'
    @game.take_turn(1, Mastermind::Code.new(:black, :cyan, :green, :red))
  end

  it "should inform user of mixed score" do
    @interactor.should_receive(:readline).once.and_return 'byrc'
    @interactor.should_receive(:writeline).once.with 'Score: 1 black, 2 white'
    @game.take_turn(1, Mastermind::Code.new(:black, :cyan, :green, :red))
  end
end
