
// See
// - http://developer.yahoo.net/forum/index.php?showtopic=786
// > Stock Quote API returning commas in data items - YDN Forums

package stock
import java.util._
import  scala.collection.mutable.Map

object StockPriceFinder {
  def getLatestClosingPrice(symbol: String) = {
    val url = "http://ichart.finance.yahoo.com/table.csv?s=" +
    symbol + "&a=00&b=01&c=" + new GregorianCalendar().get(Calendar.YEAR)

    val data = scala.io.Source.fromURL(new java.net.URL(url)).mkString
    val mostRecentData = data.split("\n")(1)
    val closingPrice = mostRecentData.split(",")(4).toDouble
    closingPrice
  }

  def getTickersAndUnits() = {
    val stocksAndUnitsXML = scala.xml.XML.load("stocks.xml")

    (Map[String, Int]() /: (stocksAndUnitsXML \ "symbol")) { (map, symbolNode) =>
      val ticker = (symbolNode \ "@ticker").toString
      val units = (symbolNode \ "units").text.toInt
      map(ticker) = units //Creates and returns a new Map
      map
    }
  }
}
