
# See http://d.hatena.ne.jp/alunko/20071021/1192908620

# zip ファイルを読み込む。
# unzip コマンドでの解凍結果と、このコマンドでの解凍結果を diff -r で比較すると良い。
# 
# 2009-05-09 katoy
#

$KCODE = "utf8"

require 'rubygems'
require 'kconv'
require 'zip/zipfilesystem'  # gem install rubyzip
require 'fileutils'
require 'pp'

def unzip(src_zip, dest_dir)
  Zip::ZipFile.foreach(src_zip) do |entry|

    path = File.join(dest_dir, entry.name)
    if(entry.file?())
      FileUtils.makedirs(File.dirname(path))
      File.open(path, 'wb') { |f|
        f.write(entry.get_input_stream.read())
      }
    else
      FileUtils.makedirs(path)
    end
  end
end

src = '../sample2009-edinet/XBRL_20090509_064405.zip'
# src = '../XBRL-CONF-CR4-2008-07-02/XBRL-CONF-CR4-2008-07-02.zip'
dest = 'zzz'

unzip(src, dest)
