class ParserContext
  attr_reader :identifier
  attr_reader :scheme
  attr_reader :instant
  attr_reader :startdate
  attr_reader :enddate
  attr_reader :forever
  attr_reader :scenario
  attr_reader :segment

  def parse(reader, file='', dir='')

    id = reader['id'].to_sym

    node = reader.expand
    childs = node.children

    node.each_element do |c|
      case c.name
      when 'entity'
        c.each_element do |cc|
          case cc.name
          when 'identifier'
            @identifier = cc.first.to_s.to_sym
          when 'segment'
            @segment = cc
          else
            puts "******* ignore(0)  #{cc.name} in context at line:#{reader.line_number}"
          end
        end
      when 'period'
        c.each_element do |cc|
          case cc.name
          when 'instant'
            @instant = cc.first.to_s.to_sym
          when 'startDate'
            @startdate = cc.first.to_s.to_sym
          when 'endDate'
            @enddate = cc.first.to_s.to_sym
          when 'forever'
            @forever = true
          else
            puts "******* ignore(1) #{cc.name} in context at line:#{reader.line_number}"
          end
        end
      when 'scenario'
        @scenario = c
      else
        puts "******* ignore(2)  #{c.name} in context at line:#{reader.line_number}"
      end
    end
    reader.next

    {:id=>id, :context=>self}
  end

  def to_s
    if @instant != nil
      "context id='#{@id.to_s}' identifier='#{@identifier}' instant='#{instant}' scenario='#{@scenario}' segment='#{@segment}'"
    elsif @startdate != nil or @enddate != nil
      "context id='#{@id.to_s}' identifier='#{@identifier}' startdate='#{@startdate}' enddate='#{@enddate}' scenario='#{@scenario}' segment='#{@segment}'"
    elsif @forever != nil
      "context id='#{@id.to_s}' identifier='#{@identifier}' forever='#{@forever}' scenario='#{@scenario}' segment='#{@segment}'"
    else
      "context id='#{@id.to_s}' identifier='#{@identifier}' scenario='#{@scenario}' segment='#{@segment}'"
    end
  end

  def to_period
    if @instant != nil
      "#{instant}"
    elsif @startdate != nil or @enddate != nil
      "#{@startdate} - #{@enddate}"
    elsif @forever != nil
      "forever"
    else
      "context id='#{@id.to_s}' identifier='#{@identifier}' scenario='#{@segment}' scenario='#{@segment}'"
    end

  end
end
