/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.BindException;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.http.HttpServer;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.mapred.CleanupQueue;
import org.apache.hadoop.mapred.ClusterStatus;
import org.apache.hadoop.mapred.CommitTaskAction;
import org.apache.hadoop.mapred.CompletedJobStatusStore;
import org.apache.hadoop.mapred.Counters;
import org.apache.hadoop.mapred.DisallowedTaskTrackerException;
import org.apache.hadoop.mapred.HeartbeatResponse;
import org.apache.hadoop.mapred.ID;
import org.apache.hadoop.mapred.InterTrackerProtocol;
import org.apache.hadoop.mapred.JobChangeEvent;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobEndNotifier;
import org.apache.hadoop.mapred.JobHistory;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapred.JobInProgress;
import org.apache.hadoop.mapred.JobInProgressListener;
import org.apache.hadoop.mapred.JobPriority;
import org.apache.hadoop.mapred.JobProfile;
import org.apache.hadoop.mapred.JobQueueInfo;
import org.apache.hadoop.mapred.JobQueueTaskScheduler;
import org.apache.hadoop.mapred.JobStatus;
import org.apache.hadoop.mapred.JobStatusChangeEvent;
import org.apache.hadoop.mapred.JobSubmissionProtocol;
import org.apache.hadoop.mapred.JobTrackerInstrumentation;
import org.apache.hadoop.mapred.JobTrackerMetricsInst;
import org.apache.hadoop.mapred.KillJobAction;
import org.apache.hadoop.mapred.KillTaskAction;
import org.apache.hadoop.mapred.LaunchTaskAction;
import org.apache.hadoop.mapred.MRConstants;
import org.apache.hadoop.mapred.MapReducePolicyProvider;
import org.apache.hadoop.mapred.MapTaskStatus;
import org.apache.hadoop.mapred.QueueManager;
import org.apache.hadoop.mapred.ReduceTaskStatus;
import org.apache.hadoop.mapred.ReinitTrackerAction;
import org.apache.hadoop.mapred.Task;
import org.apache.hadoop.mapred.TaskAttemptID;
import org.apache.hadoop.mapred.TaskCompletionEvent;
import org.apache.hadoop.mapred.TaskGraphServlet;
import org.apache.hadoop.mapred.TaskID;
import org.apache.hadoop.mapred.TaskInProgress;
import org.apache.hadoop.mapred.TaskReport;
import org.apache.hadoop.mapred.TaskScheduler;
import org.apache.hadoop.mapred.TaskStatus;
import org.apache.hadoop.mapred.TaskTrackerAction;
import org.apache.hadoop.mapred.TaskTrackerManager;
import org.apache.hadoop.mapred.TaskTrackerStatus;
import org.apache.hadoop.net.DNSToSwitchMapping;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.net.NetworkTopology;
import org.apache.hadoop.net.Node;
import org.apache.hadoop.net.NodeBase;
import org.apache.hadoop.net.ScriptBasedMapping;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.AuthorizationException;
import org.apache.hadoop.security.authorize.ConfiguredPolicy;
import org.apache.hadoop.security.authorize.PolicyProvider;
import org.apache.hadoop.security.authorize.RefreshAuthorizationPolicyProtocol;
import org.apache.hadoop.util.HostsFileReader;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.util.VersionInfo;

public class JobTracker
implements MRConstants,
InterTrackerProtocol,
JobSubmissionProtocol,
TaskTrackerManager,
RefreshAuthorizationPolicyProtocol {
    static long TASKTRACKER_EXPIRY_INTERVAL;
    static long RETIRE_JOB_INTERVAL;
    static long RETIRE_JOB_CHECK_INTERVAL;
    private static long UPDATE_FAULTY_TRACKER_INTERVAL;
    private static double MAX_BLACKLIST_PERCENT;
    private double AVERAGE_BLACKLIST_THRESHOLD = 0.5;
    private int MAX_BLACKLISTS_PER_TRACKER = 4;
    State state = State.INITIALIZING;
    private static final int FS_ACCESS_RETRY_PERIOD = 10000;
    private DNSToSwitchMapping dnsToSwitchMapping;
    private NetworkTopology clusterMap = new NetworkTopology();
    private int numTaskCacheLevels;
    private Set<Node> nodesAtMaxLevel = new HashSet<Node>();
    private final TaskScheduler taskScheduler;
    private final List<JobInProgressListener> jobInProgressListeners = new CopyOnWriteArrayList<JobInProgressListener>();
    static final FsPermission SYSTEM_DIR_PERMISSION;
    static final FsPermission SYSTEM_FILE_PERMISSION;
    final int MAX_COMPLETE_USER_JOBS_IN_MEMORY;
    static final int MIN_TIME_BEFORE_RETIRE = 60000;
    private int nextJobId = 1;
    public static final Log LOG;
    private final JobTrackerInstrumentation myInstrumentation;
    int port;
    String localMachine;
    private String trackerIdentifier;
    long startTime;
    int totalSubmissions = 0;
    private int totalMapTaskCapacity;
    private int totalReduceTaskCapacity;
    private HostsFileReader hostsReader;
    private volatile boolean hasRestarted = false;
    private volatile boolean hasRecovered = false;
    private volatile long recoveryDuration;
    Map<JobID, JobInProgress> jobs = new TreeMap<JobID, JobInProgress>();
    TreeMap<String, ArrayList<JobInProgress>> userToJobsMap = new TreeMap();
    Map<String, Set<JobID>> trackerToJobsToCleanup = new HashMap<String, Set<JobID>>();
    Map<String, Set<TaskAttemptID>> trackerToTasksToCleanup = new HashMap<String, Set<TaskAttemptID>>();
    Map<TaskAttemptID, TaskInProgress> taskidToTIPMap = new TreeMap<TaskAttemptID, TaskInProgress>();
    TreeMap<TaskAttemptID, String> taskidToTrackerMap = new TreeMap();
    TreeMap<String, Set<TaskAttemptID>> trackerToTaskMap = new TreeMap();
    TreeMap<String, Set<TaskAttemptID>> trackerToMarkedTasksMap = new TreeMap();
    Map<String, HeartbeatResponse> trackerToHeartbeatResponseMap = new TreeMap<String, HeartbeatResponse>();
    Map<String, Node> hostnameToNodeMap = Collections.synchronizedMap(new TreeMap());
    int numResolved;
    private FaultyTrackersInfo faultyTrackers = new FaultyTrackersInfo();
    int totalMaps = 0;
    int totalReduces = 0;
    private HashMap<String, TaskTrackerStatus> taskTrackers = new HashMap();
    Map<String, Integer> uniqueHostsMap = new ConcurrentHashMap<String, Integer>();
    ExpireTrackers expireTrackers = new ExpireTrackers();
    Thread expireTrackersThread = null;
    RetireJobs retireJobs = new RetireJobs();
    Thread retireJobsThread = null;
    ExpireLaunchingTasks expireLaunchingTasks = new ExpireLaunchingTasks();
    Thread expireLaunchingTaskThread = new Thread((Runnable)this.expireLaunchingTasks, "expireLaunchingTasks");
    CompletedJobStatusStore completedJobStatusStore = null;
    Thread completedJobsStoreThread = null;
    RecoveryManager recoveryManager;
    TreeSet<TaskTrackerStatus> trackerExpiryQueue = new TreeSet<TaskTrackerStatus>(new Comparator<TaskTrackerStatus>(){

        @Override
        public int compare(TaskTrackerStatus p1, TaskTrackerStatus p2) {
            if (p1.getLastSeen() < p2.getLastSeen()) {
                return -1;
            }
            if (p1.getLastSeen() > p2.getLastSeen()) {
                return 1;
            }
            return p1.getTrackerName().compareTo(p2.getTrackerName());
        }
    });
    final HttpServer infoServer;
    int infoPort;
    Server interTrackerServer;
    static final String SUBDIR = "jobTracker";
    FileSystem fs = null;
    Path systemDir = null;
    private JobConf conf;
    long limitMaxMemForMapTasks;
    long limitMaxMemForReduceTasks;
    long memSizeForMapSlotOnJT;
    long memSizeForReduceSlotOnJT;
    private QueueManager queueManager;
    TaskCompletionEvent[] EMPTY_EVENTS = new TaskCompletionEvent[0];
    static final String MAPRED_CLUSTER_MAP_MEMORY_MB_PROPERTY = "mapred.cluster.map.memory.mb";
    static final String MAPRED_CLUSTER_REDUCE_MEMORY_MB_PROPERTY = "mapred.cluster.reduce.memory.mb";
    static final String MAPRED_CLUSTER_MAX_MAP_MEMORY_MB_PROPERTY = "mapred.cluster.max.map.memory.mb";
    static final String MAPRED_CLUSTER_MAX_REDUCE_MEMORY_MB_PROPERTY = "mapred.cluster.max.reduce.memory.mb";

    public static JobTracker startTracker(JobConf conf) throws IOException, InterruptedException {
        return JobTracker.startTracker(conf, JobTracker.generateNewIdentifier());
    }

    public static JobTracker startTracker(JobConf conf, String identifier) throws IOException, InterruptedException {
        JobTracker result = null;
        while (true) {
            try {
                result = new JobTracker(conf, identifier);
                result.taskScheduler.setTaskTrackerManager(result);
            }
            catch (RPC.VersionMismatch e) {
                throw e;
            }
            catch (BindException e) {
                throw e;
            }
            catch (UnknownHostException e) {
                throw e;
            }
            catch (AccessControlException ace) {
                throw ace;
            }
            catch (IOException e) {
                LOG.warn((Object)("Error starting tracker: " + StringUtils.stringifyException(e)));
                Thread.sleep(1000L);
                continue;
            }
            break;
        }
        if (result != null) {
            JobEndNotifier.startNotifier();
        }
        return result;
    }

    public void stopTracker() throws IOException {
        JobEndNotifier.stopNotifier();
        this.close();
    }

    @Override
    public long getProtocolVersion(String protocol, long clientVersion) throws IOException {
        if (protocol.equals(InterTrackerProtocol.class.getName())) {
            return 25L;
        }
        if (protocol.equals(JobSubmissionProtocol.class.getName())) {
            return 20L;
        }
        if (protocol.equals(RefreshAuthorizationPolicyProtocol.class.getName())) {
            return 1L;
        }
        throw new IOException("Unknown protocol to job tracker: " + protocol);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<TaskTrackerStatus> getStatusesOnHost(String hostName) {
        ArrayList<TaskTrackerStatus> statuses = new ArrayList<TaskTrackerStatus>();
        HashMap<String, TaskTrackerStatus> hashMap = this.taskTrackers;
        synchronized (hashMap) {
            for (TaskTrackerStatus status : this.taskTrackers.values()) {
                if (!hostName.equals(status.getHost())) continue;
                statuses.add(status);
            }
        }
        return statuses;
    }

    JobTracker(JobConf conf) throws IOException, InterruptedException {
        this(conf, JobTracker.generateNewIdentifier());
    }

    JobTracker(JobConf conf, String identifier) throws IOException, InterruptedException {
        JobTrackerInstrumentation tmp;
        TASKTRACKER_EXPIRY_INTERVAL = conf.getLong("mapred.tasktracker.expiry.interval", 600000L);
        RETIRE_JOB_INTERVAL = conf.getLong("mapred.jobtracker.retirejob.interval", 86400000L);
        RETIRE_JOB_CHECK_INTERVAL = conf.getLong("mapred.jobtracker.retirejob.check", 60000L);
        this.MAX_COMPLETE_USER_JOBS_IN_MEMORY = conf.getInt("mapred.jobtracker.completeuserjobs.maximum", 100);
        this.MAX_BLACKLISTS_PER_TRACKER = conf.getInt("mapred.max.tracker.blacklists", 4);
        this.AVERAGE_BLACKLIST_THRESHOLD = conf.getFloat("mapred.cluster.average.blacklist.threshold", 0.5f);
        this.conf = conf;
        JobConf jobConf = new JobConf(conf);
        this.initializeTaskMemoryRelatedConfig();
        this.hostsReader = new HostsFileReader(conf.get("mapred.hosts", ""), conf.get("mapred.hosts.exclude", ""));
        this.queueManager = new QueueManager(this.conf);
        Class<TaskScheduler> schedulerClass = conf.getClass("mapred.jobtracker.taskScheduler", JobQueueTaskScheduler.class, TaskScheduler.class);
        this.taskScheduler = ReflectionUtils.newInstance(schedulerClass, conf);
        InetSocketAddress addr = JobTracker.getAddress(conf);
        this.localMachine = addr.getHostName();
        this.port = addr.getPort();
        if (conf.getBoolean("hadoop.security.authorization", false)) {
            PolicyProvider policyProvider = ReflectionUtils.newInstance(conf.getClass("hadoop.security.authorization.policyprovider", MapReducePolicyProvider.class, PolicyProvider.class), conf);
            SecurityUtil.setPolicy(new ConfiguredPolicy(conf, policyProvider));
        }
        int handlerCount = conf.getInt("mapred.job.tracker.handler.count", 10);
        this.interTrackerServer = RPC.getServer(this, addr.getHostName(), addr.getPort(), handlerCount, false, conf);
        if (LOG.isDebugEnabled()) {
            Properties p = System.getProperties();
            for (String string : p.keySet()) {
                String val = p.getProperty(string);
                LOG.debug((Object)("Property '" + string + "' is " + val));
            }
        }
        String infoAddr = NetUtils.getServerAddress(conf, "mapred.job.tracker.info.bindAddress", "mapred.job.tracker.info.port", "mapred.job.tracker.http.address");
        InetSocketAddress infoSocAddr = NetUtils.createSocketAddr(infoAddr);
        String string = infoSocAddr.getHostName();
        int tmpInfoPort = infoSocAddr.getPort();
        this.startTime = System.currentTimeMillis();
        this.infoServer = new HttpServer("job", string, tmpInfoPort, tmpInfoPort == 0, conf);
        this.infoServer.setAttribute("job.tracker", this);
        boolean historyInitialized = JobHistory.init(conf, this.localMachine, this.startTime);
        String historyLogDir = null;
        FileSystem historyFS = null;
        if (historyInitialized) {
            historyLogDir = conf.get("hadoop.job.history.location");
            this.infoServer.setAttribute("historyLogDir", historyLogDir);
            historyFS = new Path(historyLogDir).getFileSystem(conf);
            this.infoServer.setAttribute("fileSys", historyFS);
        }
        this.infoServer.addServlet("reducegraph", "/taskgraph", TaskGraphServlet.class);
        this.infoServer.start();
        this.trackerIdentifier = identifier;
        Class<? extends JobTrackerInstrumentation> metricsInst = JobTracker.getInstrumentationClass(jobConf);
        try {
            Constructor<? extends JobTrackerInstrumentation> c = metricsInst.getConstructor(JobTracker.class, JobConf.class);
            tmp = c.newInstance(this, jobConf);
        }
        catch (Exception e) {
            LOG.error((Object)"failed to initialize job tracker metrics", (Throwable)e);
            tmp = new JobTrackerMetricsInst(this, jobConf);
        }
        this.myInstrumentation = tmp;
        this.port = this.interTrackerServer.getListenerAddress().getPort();
        this.conf.set("mapred.job.tracker", this.localMachine + ":" + this.port);
        LOG.info((Object)("JobTracker up at: " + this.port));
        this.infoPort = this.infoServer.getPort();
        this.conf.set("mapred.job.tracker.http.address", string + ":" + this.infoPort);
        LOG.info((Object)("JobTracker webserver: " + this.infoServer.getPort()));
        this.recoveryManager = new RecoveryManager();
        while (!Thread.currentThread().isInterrupted()) {
            try {
                if (this.fs == null) {
                    this.fs = FileSystem.get(conf);
                }
                if (this.systemDir == null) {
                    this.systemDir = new Path(this.getSystemDir());
                }
                FileStatus[] systemDirData = this.fs.listStatus(this.systemDir);
                if (conf.getBoolean("mapred.jobtracker.restart.recover", false) && !JobHistory.isDisableHistory() && systemDirData != null) {
                    for (FileStatus status : systemDirData) {
                        try {
                            this.recoveryManager.checkAndAddJob(status);
                        }
                        catch (Throwable t) {
                            LOG.warn((Object)("Failed to add the job " + status.getPath().getName()), t);
                        }
                    }
                    this.hasRestarted = this.recoveryManager.shouldRecover();
                    if (this.hasRestarted) break;
                }
                LOG.info((Object)"Cleaning up the system directory");
                this.fs.delete(this.systemDir, true);
                if (FileSystem.mkdirs(this.fs, this.systemDir, new FsPermission(SYSTEM_DIR_PERMISSION))) break;
                LOG.error((Object)("Mkdirs failed to create " + this.systemDir));
            }
            catch (AccessControlException ace) {
                LOG.warn((Object)("Failed to operate on mapred.system.dir (" + this.systemDir + ") because of permissions."));
                LOG.warn((Object)("Manually delete the mapred.system.dir (" + this.systemDir + ") and then start the JobTracker."));
                LOG.warn((Object)"Bailing out ... ");
                throw ace;
            }
            catch (IOException ie) {
                LOG.info((Object)("problem cleaning system directory: " + this.systemDir), (Throwable)ie);
            }
            Thread.sleep(10000L);
        }
        if (Thread.currentThread().isInterrupted()) {
            throw new InterruptedException();
        }
        jobConf.deleteLocalFiles(SUBDIR);
        if (!historyInitialized) {
            JobHistory.init(conf, this.localMachine, this.startTime);
            historyLogDir = conf.get("hadoop.job.history.location");
            this.infoServer.setAttribute("historyLogDir", historyLogDir);
            historyFS = new Path(historyLogDir).getFileSystem(conf);
            this.infoServer.setAttribute("fileSys", historyFS);
        }
        this.dnsToSwitchMapping = ReflectionUtils.newInstance(conf.getClass("topology.node.switch.mapping.impl", ScriptBasedMapping.class, DNSToSwitchMapping.class), conf);
        this.numTaskCacheLevels = conf.getInt("mapred.task.cache.levels", 2);
        this.completedJobStatusStore = new CompletedJobStatusStore(conf);
    }

    private static SimpleDateFormat getDateFormat() {
        return new SimpleDateFormat("yyyyMMddHHmm");
    }

    private static String generateNewIdentifier() {
        return JobTracker.getDateFormat().format(new Date());
    }

    static boolean validateIdentifier(String id) {
        try {
            JobTracker.getDateFormat().parse(id);
            return true;
        }
        catch (ParseException parseException) {
            return false;
        }
    }

    static boolean validateJobNumber(String id) {
        try {
            Integer.parseInt(id);
            return true;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
    }

    public boolean hasRestarted() {
        return this.hasRestarted;
    }

    public boolean hasRecovered() {
        return this.hasRecovered;
    }

    public long getRecoveryDuration() {
        return this.hasRestarted() ? this.recoveryDuration : 0L;
    }

    public static Class<? extends JobTrackerInstrumentation> getInstrumentationClass(Configuration conf) {
        return conf.getClass("mapred.jobtracker.instrumentation", JobTrackerMetricsInst.class, JobTrackerInstrumentation.class);
    }

    public static void setInstrumentationClass(Configuration conf, Class<? extends JobTrackerInstrumentation> t) {
        conf.setClass("mapred.jobtracker.instrumentation", t, JobTrackerInstrumentation.class);
    }

    JobTrackerInstrumentation getInstrumentation() {
        return this.myInstrumentation;
    }

    public static InetSocketAddress getAddress(Configuration conf) {
        String jobTrackerStr = conf.get("mapred.job.tracker", "localhost:8012");
        return NetUtils.createSocketAddr(jobTrackerStr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void offerService() throws InterruptedException, IOException {
        while (true) {
            try {
                this.recoveryManager.updateRestartCount();
            }
            catch (IOException ioe) {
                LOG.warn((Object)"Failed to initialize recovery manager. ", (Throwable)ioe);
                Thread.sleep(10000L);
                LOG.warn((Object)"Retrying...");
                continue;
            }
            break;
        }
        this.taskScheduler.start();
        try {
            this.recoveryManager.recover();
        }
        catch (Throwable t) {
            LOG.warn((Object)"Recovery manager crashed! Ignoring.", t);
        }
        this.expireTrackersThread = new Thread((Runnable)this.expireTrackers, "expireTrackers");
        this.expireTrackersThread.start();
        this.retireJobsThread = new Thread((Runnable)this.retireJobs, "retireJobs");
        this.retireJobsThread.start();
        this.expireLaunchingTaskThread.start();
        if (this.completedJobStatusStore.isActive()) {
            this.completedJobsStoreThread = new Thread((Runnable)this.completedJobStatusStore, "completedjobsStore-housekeeper");
            this.completedJobsStoreThread.start();
        }
        this.interTrackerServer.start();
        JobTracker jobTracker = this;
        synchronized (jobTracker) {
            this.state = State.RUNNING;
        }
        LOG.info((Object)"Starting RUNNING");
        this.interTrackerServer.join();
        LOG.info((Object)"Stopped interTrackerServer");
    }

    void close() throws IOException {
        if (this.infoServer != null) {
            LOG.info((Object)"Stopping infoServer");
            try {
                this.infoServer.stop();
            }
            catch (Exception ex) {
                LOG.warn((Object)"Exception shutting down JobTracker", (Throwable)ex);
            }
        }
        if (this.interTrackerServer != null) {
            LOG.info((Object)"Stopping interTrackerServer");
            this.interTrackerServer.stop();
        }
        if (this.expireTrackersThread != null && this.expireTrackersThread.isAlive()) {
            LOG.info((Object)"Stopping expireTrackers");
            this.expireTrackersThread.interrupt();
            try {
                this.expireTrackersThread.join();
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
        }
        if (this.retireJobsThread != null && this.retireJobsThread.isAlive()) {
            LOG.info((Object)"Stopping retirer");
            this.retireJobsThread.interrupt();
            try {
                this.retireJobsThread.join();
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
        }
        if (this.taskScheduler != null) {
            this.taskScheduler.terminate();
        }
        if (this.expireLaunchingTaskThread != null && this.expireLaunchingTaskThread.isAlive()) {
            LOG.info((Object)"Stopping expireLaunchingTasks");
            this.expireLaunchingTaskThread.interrupt();
            try {
                this.expireLaunchingTaskThread.join();
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
        }
        if (this.completedJobsStoreThread != null && this.completedJobsStoreThread.isAlive()) {
            LOG.info((Object)"Stopping completedJobsStore thread");
            this.completedJobsStoreThread.interrupt();
            try {
                this.completedJobsStoreThread.join();
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
        }
        LOG.info((Object)"stopped all jobtracker services");
    }

    void createTaskEntry(TaskAttemptID taskid, String taskTracker, TaskInProgress tip) {
        LOG.info((Object)("Adding task " + (tip.isCleanupAttempt(taskid) ? "(cleanup)" : "") + "'" + taskid + "' to tip " + tip.getTIPId() + ", for tracker '" + taskTracker + "'"));
        this.taskidToTrackerMap.put(taskid, taskTracker);
        Set<TaskAttemptID> taskset = this.trackerToTaskMap.get(taskTracker);
        if (taskset == null) {
            taskset = new TreeSet<TaskAttemptID>();
            this.trackerToTaskMap.put(taskTracker, taskset);
        }
        taskset.add(taskid);
        this.taskidToTIPMap.put(taskid, tip);
    }

    void removeTaskEntry(TaskAttemptID taskid) {
        Set<TaskAttemptID> trackerSet;
        String tracker = this.taskidToTrackerMap.remove(taskid);
        if (tracker != null && (trackerSet = this.trackerToTaskMap.get(tracker)) != null) {
            trackerSet.remove(taskid);
        }
        this.taskidToTIPMap.remove(taskid);
        LOG.debug((Object)("Removing task '" + taskid + "'"));
    }

    void markCompletedTaskAttempt(String taskTracker, TaskAttemptID taskid) {
        Set<TaskAttemptID> taskset = this.trackerToMarkedTasksMap.get(taskTracker);
        if (taskset == null) {
            taskset = new TreeSet<TaskAttemptID>();
            this.trackerToMarkedTasksMap.put(taskTracker, taskset);
        }
        taskset.add(taskid);
        LOG.debug((Object)("Marked '" + taskid + "' from '" + taskTracker + "'"));
    }

    void markCompletedJob(JobInProgress job) {
        for (TaskInProgress tip : job.getSetupTasks()) {
            for (TaskStatus taskStatus : tip.getTaskStatuses()) {
                if (taskStatus.getRunState() == TaskStatus.State.RUNNING || taskStatus.getRunState() == TaskStatus.State.COMMIT_PENDING || taskStatus.getRunState() == TaskStatus.State.UNASSIGNED) continue;
                this.markCompletedTaskAttempt(taskStatus.getTaskTracker(), taskStatus.getTaskID());
            }
        }
        for (TaskInProgress tip : job.getMapTasks()) {
            for (TaskStatus taskStatus : tip.getTaskStatuses()) {
                if (taskStatus.getRunState() == TaskStatus.State.RUNNING || taskStatus.getRunState() == TaskStatus.State.COMMIT_PENDING || taskStatus.getRunState() == TaskStatus.State.FAILED_UNCLEAN || taskStatus.getRunState() == TaskStatus.State.KILLED_UNCLEAN || taskStatus.getRunState() == TaskStatus.State.UNASSIGNED) continue;
                this.markCompletedTaskAttempt(taskStatus.getTaskTracker(), taskStatus.getTaskID());
            }
        }
        for (TaskInProgress tip : job.getReduceTasks()) {
            for (TaskStatus taskStatus : tip.getTaskStatuses()) {
                if (taskStatus.getRunState() == TaskStatus.State.RUNNING || taskStatus.getRunState() == TaskStatus.State.COMMIT_PENDING || taskStatus.getRunState() == TaskStatus.State.FAILED_UNCLEAN || taskStatus.getRunState() == TaskStatus.State.KILLED_UNCLEAN || taskStatus.getRunState() == TaskStatus.State.UNASSIGNED) continue;
                this.markCompletedTaskAttempt(taskStatus.getTaskTracker(), taskStatus.getTaskID());
            }
        }
    }

    private void removeMarkedTasks(String taskTracker) {
        Set<TaskAttemptID> markedTaskSet = this.trackerToMarkedTasksMap.get(taskTracker);
        if (markedTaskSet != null) {
            for (TaskAttemptID taskid : markedTaskSet) {
                this.removeTaskEntry(taskid);
                LOG.info((Object)("Removed completed task '" + taskid + "' from '" + taskTracker + "'"));
            }
            this.trackerToMarkedTasksMap.remove(taskTracker);
        }
    }

    private synchronized void removeJobTasks(JobInProgress job) {
        for (TaskInProgress tip : job.getMapTasks()) {
            for (TaskStatus taskStatus : tip.getTaskStatuses()) {
                this.removeTaskEntry(taskStatus.getTaskID());
            }
        }
        for (TaskInProgress tip : job.getReduceTasks()) {
            for (TaskStatus taskStatus : tip.getTaskStatuses()) {
                this.removeTaskEntry(taskStatus.getTaskID());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void finalizeJob(JobInProgress job) {
        this.markCompletedJob(job);
        JobEndNotifier.registerNotification(job.getJobConf(), job.getStatus());
        JobID id = job.getStatus().getJobID();
        if (job.hasRestarted()) {
            try {
                JobHistory.JobInfo.finalizeRecovery(id, job.getJobConf());
            }
            catch (IOException ioe) {
                LOG.info((Object)("Failed to finalize the log file recovery for job " + id), (Throwable)ioe);
            }
        }
        JobTrackerInstrumentation metrics = this.getInstrumentation();
        metrics.finalizeJob(this.conf, id);
        long now = System.currentTimeMillis();
        this.addJobForCleanup(id);
        if (job.getStatus().getRunState() == 2 && job.getNoOfBlackListedTrackers() > 0) {
            for (String hostName : job.getBlackListedTrackers()) {
                this.faultyTrackers.incrementFaults(hostName);
            }
        }
        Map<JobID, JobInProgress> map = this.jobs;
        synchronized (map) {
            TaskScheduler taskScheduler = this.taskScheduler;
            synchronized (taskScheduler) {
                TreeMap<String, ArrayList<JobInProgress>> treeMap = this.userToJobsMap;
                synchronized (treeMap) {
                    ArrayList<JobInProgress> userJobs;
                    String jobUser = job.getProfile().getUser();
                    if (!this.userToJobsMap.containsKey(jobUser)) {
                        this.userToJobsMap.put(jobUser, new ArrayList());
                    }
                    ArrayList<JobInProgress> arrayList = userJobs = this.userToJobsMap.get(jobUser);
                    synchronized (arrayList) {
                        int rjobRunState;
                        JobInProgress rjob;
                        userJobs.add(job);
                        while (userJobs.size() > this.MAX_COMPLETE_USER_JOBS_IN_MEMORY && (rjob = userJobs.get(0)) != job && rjob.getFinishTime() + 60000L <= now && ((rjobRunState = rjob.getStatus().getRunState()) == 2 || rjobRunState == 3 || rjobRunState == 5)) {
                            this.removeJobTasks(rjob);
                            userJobs.remove(0);
                            this.jobs.remove(rjob.getProfile().getJobID());
                            for (JobInProgressListener listener : this.jobInProgressListeners) {
                                listener.jobRemoved(rjob);
                            }
                            LOG.info((Object)("Retired job with id: '" + rjob.getProfile().getJobID() + "' of user: '" + jobUser + "'"));
                        }
                    }
                    if (userJobs.isEmpty()) {
                        this.userToJobsMap.remove(jobUser);
                    }
                }
            }
        }
    }

    public int getTotalSubmissions() {
        return this.totalSubmissions;
    }

    public String getJobTrackerMachine() {
        return this.localMachine;
    }

    public String getTrackerIdentifier() {
        return this.trackerIdentifier;
    }

    public int getTrackerPort() {
        return this.port;
    }

    public int getInfoPort() {
        return this.infoPort;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public Vector<JobInProgress> runningJobs() {
        Vector<JobInProgress> v = new Vector<JobInProgress>();
        for (JobInProgress jip : this.jobs.values()) {
            JobStatus status = jip.getStatus();
            if (status.getRunState() != 1) continue;
            v.add(jip);
        }
        return v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized List<JobInProgress> getRunningJobs() {
        Map<JobID, JobInProgress> map = this.jobs;
        synchronized (map) {
            return this.runningJobs();
        }
    }

    public Vector<JobInProgress> failedJobs() {
        Vector<JobInProgress> v = new Vector<JobInProgress>();
        for (JobInProgress jip : this.jobs.values()) {
            JobStatus status = jip.getStatus();
            if (status.getRunState() != 3 && status.getRunState() != 5) continue;
            v.add(jip);
        }
        return v;
    }

    public Vector<JobInProgress> completedJobs() {
        Vector<JobInProgress> v = new Vector<JobInProgress>();
        for (JobInProgress jip : this.jobs.values()) {
            JobStatus status = jip.getStatus();
            if (status.getRunState() != 2) continue;
            v.add(jip);
        }
        return v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<TaskTrackerStatus> taskTrackers() {
        HashMap<String, TaskTrackerStatus> hashMap = this.taskTrackers;
        synchronized (hashMap) {
            return this.taskTrackers.values();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<TaskTrackerStatus> activeTaskTrackers() {
        ArrayList<TaskTrackerStatus> activeTrackers = new ArrayList<TaskTrackerStatus>();
        HashMap<String, TaskTrackerStatus> hashMap = this.taskTrackers;
        synchronized (hashMap) {
            for (TaskTrackerStatus status : this.taskTrackers.values()) {
                if (this.faultyTrackers.isBlacklisted(status.getHost())) continue;
                activeTrackers.add(status);
            }
        }
        return activeTrackers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<List<String>> taskTrackerNames() {
        ArrayList<String> activeTrackers = new ArrayList<String>();
        ArrayList<String> blacklistedTrackers = new ArrayList<String>();
        HashMap<String, TaskTrackerStatus> hashMap = this.taskTrackers;
        synchronized (hashMap) {
            for (TaskTrackerStatus status : this.taskTrackers.values()) {
                if (!this.faultyTrackers.isBlacklisted(status.getHost())) {
                    activeTrackers.add(status.getTrackerName());
                    continue;
                }
                blacklistedTrackers.add(status.getTrackerName());
            }
        }
        ArrayList<List<String>> result = new ArrayList<List<String>>(2);
        result.add(activeTrackers);
        result.add(blacklistedTrackers);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<TaskTrackerStatus> blacklistedTaskTrackers() {
        ArrayList<TaskTrackerStatus> blacklistedTrackers = new ArrayList<TaskTrackerStatus>();
        HashMap<String, TaskTrackerStatus> hashMap = this.taskTrackers;
        synchronized (hashMap) {
            for (TaskTrackerStatus status : this.taskTrackers.values()) {
                if (!this.faultyTrackers.isBlacklisted(status.getHost())) continue;
                blacklistedTrackers.add(status);
            }
        }
        return blacklistedTrackers;
    }

    int getFaultCount(String hostName) {
        return this.faultyTrackers.getFaultCount(hostName);
    }

    int getBlacklistedTrackerCount() {
        return this.faultyTrackers.numBlacklistedTrackers;
    }

    public boolean isBlacklisted(String trackerID) {
        TaskTrackerStatus status = this.getTaskTracker(trackerID);
        if (status != null) {
            return this.faultyTrackers.isBlacklisted(status.getHost());
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TaskTrackerStatus getTaskTracker(String trackerID) {
        HashMap<String, TaskTrackerStatus> hashMap = this.taskTrackers;
        synchronized (hashMap) {
            return this.taskTrackers.get(trackerID);
        }
    }

    private void addNewTracker(TaskTrackerStatus status) {
        this.trackerExpiryQueue.add(status);
        if (this.getNode(status.getTrackerName()) == null) {
            this.resolveAndAddToTopology(status.getHost());
        }
    }

    public Node resolveAndAddToTopology(String name) {
        ArrayList<String> tmpList = new ArrayList<String>(1);
        tmpList.add(name);
        List<String> rNameList = this.dnsToSwitchMapping.resolve(tmpList);
        String rName = rNameList.get(0);
        String networkLoc = NodeBase.normalize(rName);
        return this.addHostToNodeMapping(name, networkLoc);
    }

    private Node addHostToNodeMapping(String host, String networkLoc) {
        Node node = this.clusterMap.getNode(networkLoc + "/" + host);
        if (node == null) {
            node = new NodeBase(host, networkLoc);
            this.clusterMap.add(node);
            if (node.getLevel() < this.getNumTaskCacheLevels()) {
                LOG.fatal((Object)("Got a host whose level is: " + node.getLevel() + "." + " Should get at least a level of value: " + this.getNumTaskCacheLevels()));
                try {
                    this.stopTracker();
                }
                catch (IOException ie) {
                    LOG.warn((Object)("Exception encountered during shutdown: " + StringUtils.stringifyException(ie)));
                    System.exit(-1);
                }
            }
            this.hostnameToNodeMap.put(host, node);
            this.nodesAtMaxLevel.add(JobTracker.getParentNode(node, this.getNumTaskCacheLevels() - 1));
        }
        return node;
    }

    public Collection<Node> getNodesAtMaxLevel() {
        return this.nodesAtMaxLevel;
    }

    public static Node getParentNode(Node node, int level) {
        for (int i = 0; i < level; ++i) {
            node = node.getParent();
        }
        return node;
    }

    public Node getNode(String name) {
        return this.hostnameToNodeMap.get(name);
    }

    public int getNumTaskCacheLevels() {
        return this.numTaskCacheLevels;
    }

    public int getNumResolvedTaskTrackers() {
        return this.numResolved;
    }

    @Override
    public int getNumberOfUniqueHosts() {
        return this.uniqueHostsMap.size();
    }

    @Override
    public void addJobInProgressListener(JobInProgressListener listener) {
        this.jobInProgressListeners.add(listener);
    }

    @Override
    public void removeJobInProgressListener(JobInProgressListener listener) {
        this.jobInProgressListeners.remove(listener);
    }

    private void updateJobInProgressListeners(JobChangeEvent event) {
        for (JobInProgressListener listener : this.jobInProgressListeners) {
            listener.jobUpdated(event);
        }
    }

    @Override
    public QueueManager getQueueManager() {
        return this.queueManager;
    }

    @Override
    public String getBuildVersion() throws IOException {
        return VersionInfo.getBuildVersion();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public synchronized HeartbeatResponse heartbeat(TaskTrackerStatus status, boolean restarted, boolean initialContact, boolean acceptNewTasks, short responseId) throws IOException {
        List<TaskTrackerAction> commitTasksList;
        List<TaskTrackerAction> killJobsList;
        List<TaskTrackerAction> killTasksList;
        LOG.debug((Object)("Got heartbeat from: " + status.getTrackerName() + " (restarted: " + restarted + " initialContact: " + initialContact + " acceptNewTasks: " + acceptNewTasks + ")" + " with responseId: " + responseId));
        if (!this.acceptTaskTracker(status)) {
            throw new DisallowedTaskTrackerException(status);
        }
        String trackerName = status.getTrackerName();
        long now = System.currentTimeMillis();
        boolean isBlacklisted = false;
        if (restarted) {
            this.faultyTrackers.markTrackerHealthy(status.getHost());
        } else {
            isBlacklisted = this.faultyTrackers.shouldAssignTasksToTracker(status.getHost(), now);
        }
        HeartbeatResponse prevHeartbeatResponse = this.trackerToHeartbeatResponseMap.get(trackerName);
        boolean addRestartInfo = false;
        if (!initialContact) {
            if (prevHeartbeatResponse == null) {
                if (!this.hasRestarted()) {
                    LOG.warn((Object)("Serious problem, cannot find record of 'previous' heartbeat for '" + trackerName + "'; reinitializing the tasktracker"));
                    return new HeartbeatResponse(responseId, new TaskTrackerAction[]{new ReinitTrackerAction()});
                }
                addRestartInfo = true;
                this.recoveryManager.unMarkTracker(trackerName);
            } else if (prevHeartbeatResponse.getResponseId() != responseId) {
                LOG.info((Object)("Ignoring 'duplicate' heartbeat from '" + trackerName + "'; resending the previous 'lost' response"));
                return prevHeartbeatResponse;
            }
        }
        short newResponseId = (short)(responseId + 1);
        status.setLastSeen(now);
        if (!this.processHeartbeat(status, initialContact)) {
            if (prevHeartbeatResponse != null) {
                this.trackerToHeartbeatResponseMap.remove(trackerName);
            }
            return new HeartbeatResponse(newResponseId, new TaskTrackerAction[]{new ReinitTrackerAction()});
        }
        HeartbeatResponse response = new HeartbeatResponse(newResponseId, null);
        ArrayList<TaskTrackerAction> actions = new ArrayList<TaskTrackerAction>();
        if (this.recoveryManager.shouldSchedule() && acceptNewTasks && !isBlacklisted) {
            TaskTrackerStatus taskTrackerStatus = this.getTaskTracker(trackerName);
            if (taskTrackerStatus == null) {
                LOG.warn((Object)("Unknown task tracker polling; ignoring: " + trackerName));
            } else {
                List<Task> tasks = this.getSetupAndCleanupTasks(taskTrackerStatus);
                if (tasks == null) {
                    tasks = this.taskScheduler.assignTasks(taskTrackerStatus);
                }
                if (tasks != null) {
                    for (Task task : tasks) {
                        this.expireLaunchingTasks.addNewTask(task.getTaskID());
                        LOG.debug((Object)(trackerName + " -> LaunchTask: " + task.getTaskID()));
                        actions.add(new LaunchTaskAction(task));
                    }
                }
            }
        }
        if ((killTasksList = this.getTasksToKill(trackerName)) != null) {
            actions.addAll(killTasksList);
        }
        if ((killJobsList = this.getJobsForCleanup(trackerName)) != null) {
            actions.addAll(killJobsList);
        }
        if ((commitTasksList = this.getTasksToSave(status)) != null) {
            actions.addAll(commitTasksList);
        }
        int nextInterval = this.getNextHeartbeatInterval();
        response.setHeartbeatInterval(nextInterval);
        response.setActions(actions.toArray(new TaskTrackerAction[actions.size()]));
        if (addRestartInfo) {
            response.setRecoveredJobs(this.recoveryManager.getJobsToRecover());
        }
        this.trackerToHeartbeatResponseMap.put(trackerName, response);
        this.removeMarkedTasks(trackerName);
        return response;
    }

    @Override
    public int getNextHeartbeatInterval() {
        int clusterSize = this.getClusterStatus().getTaskTrackers();
        int heartbeatInterval = Math.max((int)(1000.0 * Math.ceil((double)clusterSize / 100.0)), 3000);
        return heartbeatInterval;
    }

    private boolean inHostsList(TaskTrackerStatus status) {
        Set<String> hostsList = this.hostsReader.getHosts();
        return hostsList.isEmpty() || hostsList.contains(status.getHost());
    }

    private boolean inExcludedHostsList(TaskTrackerStatus status) {
        Set<String> excludeList = this.hostsReader.getExcludedHosts();
        return excludeList.contains(status.getHost());
    }

    private boolean acceptTaskTracker(TaskTrackerStatus status) {
        return this.inHostsList(status) && !this.inExcludedHostsList(status);
    }

    private boolean updateTaskTrackerStatus(String trackerName, TaskTrackerStatus status) {
        Integer n;
        TaskTrackerStatus oldStatus = this.taskTrackers.get(trackerName);
        if (oldStatus != null) {
            this.totalMaps -= oldStatus.countMapTasks();
            this.totalReduces -= oldStatus.countReduceTasks();
            if (!this.faultyTrackers.isBlacklisted(oldStatus.getHost())) {
                this.totalMapTaskCapacity -= oldStatus.getMaxMapTasks();
                this.totalReduceTaskCapacity -= oldStatus.getMaxReduceTasks();
            }
            if (status == null) {
                Integer numTaskTrackersInHost;
                this.taskTrackers.remove(trackerName);
                Integer n2 = numTaskTrackersInHost = this.uniqueHostsMap.get(oldStatus.getHost());
                n = numTaskTrackersInHost = Integer.valueOf(numTaskTrackersInHost - 1);
                if (numTaskTrackersInHost > 0) {
                    this.uniqueHostsMap.put(oldStatus.getHost(), numTaskTrackersInHost);
                } else {
                    this.uniqueHostsMap.remove(oldStatus.getHost());
                }
            }
        }
        if (status != null) {
            this.totalMaps += status.countMapTasks();
            this.totalReduces += status.countReduceTasks();
            if (!this.faultyTrackers.isBlacklisted(status.getHost())) {
                this.totalMapTaskCapacity += status.getMaxMapTasks();
                this.totalReduceTaskCapacity += status.getMaxReduceTasks();
            }
            boolean alreadyPresent = false;
            if (this.taskTrackers.containsKey(trackerName)) {
                alreadyPresent = true;
            }
            this.taskTrackers.put(trackerName, status);
            if (!alreadyPresent) {
                Integer numTaskTrackersInHost = this.uniqueHostsMap.get(status.getHost());
                if (numTaskTrackersInHost == null) {
                    numTaskTrackersInHost = 0;
                }
                n = numTaskTrackersInHost;
                Integer n3 = numTaskTrackersInHost = Integer.valueOf(numTaskTrackersInHost + 1);
                this.uniqueHostsMap.put(status.getHost(), numTaskTrackersInHost);
            }
        }
        return oldStatus != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean processHeartbeat(TaskTrackerStatus trackerStatus, boolean initialContact) {
        String trackerName = trackerStatus.getTrackerName();
        HashMap<String, TaskTrackerStatus> hashMap = this.taskTrackers;
        synchronized (hashMap) {
            TreeSet<TaskTrackerStatus> treeSet = this.trackerExpiryQueue;
            synchronized (treeSet) {
                boolean seenBefore = this.updateTaskTrackerStatus(trackerName, trackerStatus);
                if (initialContact) {
                    if (seenBefore) {
                        this.lostTaskTracker(trackerName);
                    }
                } else if (!seenBefore) {
                    LOG.warn((Object)("Status from unknown Tracker : " + trackerName));
                    this.updateTaskTrackerStatus(trackerName, null);
                    return false;
                }
                if (initialContact) {
                    if (this.isBlacklisted(trackerName)) {
                        this.faultyTrackers.numBlacklistedTrackers += 1;
                    }
                    this.addNewTracker(trackerStatus);
                }
            }
        }
        this.updateTaskStatuses(trackerStatus);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized List<TaskTrackerAction> getTasksToKill(String taskTracker) {
        Set<TaskAttemptID> taskIds = this.trackerToTaskMap.get(taskTracker);
        ArrayList<TaskTrackerAction> killList = new ArrayList<TaskTrackerAction>();
        if (taskIds != null) {
            for (TaskAttemptID killTaskId : taskIds) {
                TaskInProgress tip = this.taskidToTIPMap.get(killTaskId);
                if (tip == null || !tip.shouldClose(killTaskId) || tip.getJob().isComplete()) continue;
                killList.add(new KillTaskAction(killTaskId));
                LOG.debug((Object)(taskTracker + " -> KillTaskAction: " + killTaskId));
            }
        }
        Map<String, Set<TaskAttemptID>> map = this.trackerToTasksToCleanup;
        synchronized (map) {
            Set<TaskAttemptID> set = this.trackerToTasksToCleanup.remove(taskTracker);
            if (set != null) {
                for (TaskAttemptID id : set) {
                    killList.add(new KillTaskAction(id));
                }
            }
        }
        return killList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addJobForCleanup(JobID id) {
        for (String taskTracker : this.taskTrackers.keySet()) {
            LOG.debug((Object)("Marking job " + id + " for cleanup by tracker " + taskTracker));
            Map<String, Set<JobID>> map = this.trackerToJobsToCleanup;
            synchronized (map) {
                Set<JobID> jobsToKill = this.trackerToJobsToCleanup.get(taskTracker);
                if (jobsToKill == null) {
                    jobsToKill = new HashSet<JobID>();
                    this.trackerToJobsToCleanup.put(taskTracker, jobsToKill);
                }
                jobsToKill.add(id);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<TaskTrackerAction> getJobsForCleanup(String taskTracker) {
        Set<JobID> jobs = null;
        Map<String, Set<JobID>> map = this.trackerToJobsToCleanup;
        synchronized (map) {
            jobs = this.trackerToJobsToCleanup.remove(taskTracker);
        }
        if (jobs != null) {
            ArrayList<TaskTrackerAction> killList = new ArrayList<TaskTrackerAction>();
            for (JobID killJobId : jobs) {
                killList.add(new KillJobAction(killJobId));
                LOG.debug((Object)(taskTracker + " -> KillJobAction: " + killJobId));
            }
            return killList;
        }
        return null;
    }

    private synchronized List<TaskTrackerAction> getTasksToSave(TaskTrackerStatus tts) {
        List<TaskStatus> taskStatuses = tts.getTaskReports();
        if (taskStatuses != null) {
            ArrayList<TaskTrackerAction> saveList = new ArrayList<TaskTrackerAction>();
            for (TaskStatus taskStatus : taskStatuses) {
                TaskAttemptID taskId;
                TaskInProgress tip;
                if (taskStatus.getRunState() != TaskStatus.State.COMMIT_PENDING || (tip = this.taskidToTIPMap.get(taskId = taskStatus.getTaskID())) == null || !tip.shouldCommit(taskId)) continue;
                saveList.add(new CommitTaskAction(taskId));
                LOG.debug((Object)(tts.getTrackerName() + " -> CommitTaskAction: " + taskId));
            }
            return saveList;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized List<Task> getSetupAndCleanupTasks(TaskTrackerStatus taskTracker) throws IOException {
        int maxMapTasks = taskTracker.getMaxMapTasks();
        int maxReduceTasks = taskTracker.getMaxReduceTasks();
        int numMaps = taskTracker.countMapTasks();
        int numReduces = taskTracker.countReduceTasks();
        int numTaskTrackers = this.getClusterStatus().getTaskTrackers();
        int numUniqueHosts = this.getNumberOfUniqueHosts();
        Task t = null;
        Map<JobID, JobInProgress> map = this.jobs;
        synchronized (map) {
            if (numMaps < maxMapTasks) {
                for (JobInProgress job : this.jobs.values()) {
                    t = job.obtainJobCleanupTask(taskTracker, numTaskTrackers, numUniqueHosts, true);
                    if (t == null) continue;
                    return Collections.singletonList(t);
                }
                for (JobInProgress job : this.jobs.values()) {
                    t = job.obtainTaskCleanupTask(taskTracker, true);
                    if (t == null) continue;
                    return Collections.singletonList(t);
                }
                for (JobInProgress job : this.jobs.values()) {
                    t = job.obtainJobSetupTask(taskTracker, numTaskTrackers, numUniqueHosts, true);
                    if (t == null) continue;
                    return Collections.singletonList(t);
                }
            }
            if (numReduces < maxReduceTasks) {
                for (JobInProgress job : this.jobs.values()) {
                    t = job.obtainJobCleanupTask(taskTracker, numTaskTrackers, numUniqueHosts, false);
                    if (t == null) continue;
                    return Collections.singletonList(t);
                }
                for (JobInProgress job : this.jobs.values()) {
                    t = job.obtainTaskCleanupTask(taskTracker, false);
                    if (t == null) continue;
                    return Collections.singletonList(t);
                }
                for (JobInProgress job : this.jobs.values()) {
                    t = job.obtainJobSetupTask(taskTracker, numTaskTrackers, numUniqueHosts, false);
                    if (t == null) continue;
                    return Collections.singletonList(t);
                }
            }
        }
        return null;
    }

    @Override
    public synchronized String getFilesystemName() throws IOException {
        if (this.fs == null) {
            throw new IllegalStateException("FileSystem object not available yet");
        }
        return this.fs.getUri().toString();
    }

    @Override
    public void reportTaskTrackerError(String taskTracker, String errorClass, String errorMessage) throws IOException {
        LOG.warn((Object)("Report from " + taskTracker + ": " + errorMessage));
    }

    static String getJobUniqueString(String jobid) {
        return jobid.substring(4);
    }

    @Override
    public synchronized JobID getNewJobId() throws IOException {
        return new JobID(this.getTrackerIdentifier(), this.nextJobId++);
    }

    @Override
    public synchronized JobStatus submitJob(JobID jobId) throws IOException {
        if (this.jobs.containsKey(jobId)) {
            return this.jobs.get(jobId).getStatus();
        }
        JobInProgress job = new JobInProgress(jobId, this, this.conf);
        String queue = job.getProfile().getQueueName();
        if (!this.queueManager.getQueues().contains(queue)) {
            new CleanupQueue().addToQueue(this.conf, this.getSystemDirectoryForJob(jobId));
            throw new IOException("Queue \"" + queue + "\" does not exist");
        }
        try {
            this.checkAccess(job, QueueManager.QueueOperation.SUBMIT_JOB);
        }
        catch (IOException ioe) {
            LOG.warn((Object)("Access denied for user " + job.getJobConf().getUser() + ". Ignoring job " + jobId), (Throwable)ioe);
            new CleanupQueue().addToQueue(this.conf, this.getSystemDirectoryForJob(jobId));
            throw ioe;
        }
        try {
            this.checkMemoryRequirements(job);
        }
        catch (IOException ioe) {
            new CleanupQueue().addToQueue(this.conf, this.getSystemDirectoryForJob(jobId));
            throw ioe;
        }
        return this.addJob(jobId, job);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized JobStatus addJob(JobID jobId, JobInProgress job) {
        ++this.totalSubmissions;
        Map<JobID, JobInProgress> map = this.jobs;
        synchronized (map) {
            TaskScheduler taskScheduler = this.taskScheduler;
            synchronized (taskScheduler) {
                this.jobs.put(job.getProfile().getJobID(), job);
                for (JobInProgressListener listener : this.jobInProgressListeners) {
                    try {
                        listener.jobAdded(job);
                    }
                    catch (IOException ioe) {
                        LOG.warn((Object)("Failed to add and so skipping the job : " + job.getJobID() + ". Exception : " + ioe));
                    }
                }
            }
        }
        this.myInstrumentation.submitJob(job.getJobConf(), jobId);
        return job.getStatus();
    }

    private void checkAccess(JobInProgress job, QueueManager.QueueOperation oper) throws IOException {
        UserGroupInformation ugi = UserGroupInformation.getCurrentUGI();
        this.checkAccess(job, oper, ugi);
    }

    private void checkAccess(JobInProgress job, QueueManager.QueueOperation oper, UserGroupInformation ugi) throws IOException {
        String queue = job.getProfile().getQueueName();
        if (!this.queueManager.hasAccess(queue, job, oper, ugi)) {
            throw new AccessControlException("User " + ugi.getUserName() + " cannot perform " + "operation " + (Object)((Object)oper) + " on queue " + queue);
        }
    }

    @Override
    @Deprecated
    public synchronized ClusterStatus getClusterStatus() {
        return this.getClusterStatus(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized ClusterStatus getClusterStatus(boolean detailed) {
        HashMap<String, TaskTrackerStatus> hashMap = this.taskTrackers;
        synchronized (hashMap) {
            if (detailed) {
                List<List<String>> trackerNames = this.taskTrackerNames();
                return new ClusterStatus((Collection<String>)trackerNames.get(0), (Collection<String>)trackerNames.get(1), TASKTRACKER_EXPIRY_INTERVAL, this.totalMaps, this.totalReduces, this.totalMapTaskCapacity, this.totalReduceTaskCapacity, this.state);
            }
            return new ClusterStatus(this.taskTrackers.size() - this.getBlacklistedTrackerCount(), this.getBlacklistedTrackerCount(), TASKTRACKER_EXPIRY_INTERVAL, this.totalMaps, this.totalReduces, this.totalMapTaskCapacity, this.totalReduceTaskCapacity, this.state);
        }
    }

    @Override
    public synchronized void killJob(JobID jobid) throws IOException {
        if (null == jobid) {
            LOG.info((Object)"Null jobid object sent to JobTracker.killJob()");
            return;
        }
        JobInProgress job = this.jobs.get(jobid);
        if (null == job) {
            LOG.info((Object)("killJob(): JobId " + jobid.toString() + " is not a valid job"));
            return;
        }
        this.checkAccess(job, QueueManager.QueueOperation.ADMINISTER_JOBS);
        this.killJob(job);
    }

    private synchronized void killJob(JobInProgress job) {
        LOG.info((Object)("Killing job " + job.getJobID()));
        JobStatus prevStatus = (JobStatus)job.getStatus().clone();
        job.kill();
        JobStatus newStatus = (JobStatus)job.getStatus().clone();
        if (prevStatus.getRunState() != newStatus.getRunState() && newStatus.getRunState() == 5) {
            JobStatusChangeEvent event = new JobStatusChangeEvent(job, JobStatusChangeEvent.EventType.RUN_STATE_CHANGED, prevStatus, newStatus);
            this.updateJobInProgressListeners(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initJob(JobInProgress job) {
        block7: {
            if (null == job) {
                LOG.info((Object)"Init on null job is not valid");
                return;
            }
            try {
                JobStatus prevStatus = (JobStatus)job.getStatus().clone();
                LOG.info((Object)("Initializing " + job.getJobID()));
                job.initTasks();
                JobStatus newStatus = (JobStatus)job.getStatus().clone();
                if (prevStatus.getRunState() == newStatus.getRunState()) break block7;
                JobStatusChangeEvent event = new JobStatusChangeEvent(job, JobStatusChangeEvent.EventType.RUN_STATE_CHANGED, prevStatus, newStatus);
                JobTracker jobTracker = this;
                synchronized (jobTracker) {
                    this.updateJobInProgressListeners(event);
                }
            }
            catch (JobInProgress.KillInterruptedException kie) {
                LOG.error((Object)("Job initialization interrupted:\n" + StringUtils.stringifyException(kie)));
                this.killJob(job);
            }
            catch (Throwable t) {
                LOG.error((Object)("Job initialization failed:\n" + StringUtils.stringifyException(t)));
                this.failJob(job);
            }
        }
    }

    @Override
    public synchronized void failJob(JobInProgress job) {
        if (null == job) {
            LOG.info((Object)"Fail on null job is not valid");
            return;
        }
        JobStatus prevStatus = (JobStatus)job.getStatus().clone();
        LOG.info((Object)("Failing job " + job.getJobID()));
        job.fail();
        JobStatus newStatus = (JobStatus)job.getStatus().clone();
        if (prevStatus.getRunState() != newStatus.getRunState()) {
            JobStatusChangeEvent event = new JobStatusChangeEvent(job, JobStatusChangeEvent.EventType.RUN_STATE_CHANGED, prevStatus, newStatus);
            this.updateJobInProgressListeners(event);
        }
    }

    @Override
    public synchronized void setJobPriority(JobID jobid, String priority) throws IOException {
        JobInProgress job = this.jobs.get(jobid);
        if (null == job) {
            LOG.info((Object)("setJobPriority(): JobId " + jobid.toString() + " is not a valid job"));
            return;
        }
        this.checkAccess(job, QueueManager.QueueOperation.ADMINISTER_JOBS);
        JobPriority newPriority = JobPriority.valueOf(priority);
        this.setJobPriority(jobid, newPriority);
    }

    void storeCompletedJob(JobInProgress job) {
        this.completedJobStatusStore.store(job);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JobProfile getJobProfile(JobID jobid) {
        JobTracker jobTracker = this;
        synchronized (jobTracker) {
            JobInProgress job = this.jobs.get(jobid);
            if (job != null) {
                return job.getProfile();
            }
        }
        return this.completedJobStatusStore.readJobProfile(jobid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JobStatus getJobStatus(JobID jobid) {
        if (null == jobid) {
            LOG.warn((Object)"JobTracker.getJobStatus() cannot get status for null jobid");
            return null;
        }
        JobTracker jobTracker = this;
        synchronized (jobTracker) {
            JobInProgress job = this.jobs.get(jobid);
            if (job != null) {
                return job.getStatus();
            }
        }
        return this.completedJobStatusStore.readJobStatus(jobid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Counters getJobCounters(JobID jobid) {
        JobTracker jobTracker = this;
        synchronized (jobTracker) {
            JobInProgress job = this.jobs.get(jobid);
            if (job != null) {
                return job.getCounters();
            }
        }
        return this.completedJobStatusStore.readCounters(jobid);
    }

    @Override
    public synchronized TaskReport[] getMapTaskReports(JobID jobid) {
        JobInProgress job = this.jobs.get(jobid);
        if (job == null) {
            return new TaskReport[0];
        }
        Vector<TaskReport> reports = new Vector<TaskReport>();
        Vector<TaskInProgress> completeMapTasks = job.reportTasksInProgress(true, true);
        for (TaskInProgress tip : completeMapTasks) {
            reports.add(tip.generateSingleReport());
        }
        Vector<TaskInProgress> incompleteMapTasks = job.reportTasksInProgress(true, false);
        for (TaskInProgress tip : incompleteMapTasks) {
            reports.add(tip.generateSingleReport());
        }
        return reports.toArray(new TaskReport[reports.size()]);
    }

    @Override
    public synchronized TaskReport[] getReduceTaskReports(JobID jobid) {
        JobInProgress job = this.jobs.get(jobid);
        if (job == null) {
            return new TaskReport[0];
        }
        Vector<TaskReport> reports = new Vector<TaskReport>();
        Vector<TaskInProgress> completeReduceTasks = job.reportTasksInProgress(false, true);
        for (TaskInProgress tip : completeReduceTasks) {
            reports.add(tip.generateSingleReport());
        }
        Vector<TaskInProgress> incompleteReduceTasks = job.reportTasksInProgress(false, false);
        for (TaskInProgress tip : incompleteReduceTasks) {
            reports.add(tip.generateSingleReport());
        }
        return reports.toArray(new TaskReport[reports.size()]);
    }

    @Override
    public synchronized TaskReport[] getCleanupTaskReports(JobID jobid) {
        JobInProgress job = this.jobs.get(jobid);
        if (job == null) {
            return new TaskReport[0];
        }
        Vector<TaskReport> reports = new Vector<TaskReport>();
        Vector<TaskInProgress> completeTasks = job.reportCleanupTIPs(true);
        for (TaskInProgress tip : completeTasks) {
            reports.add(tip.generateSingleReport());
        }
        Vector<TaskInProgress> incompleteTasks = job.reportCleanupTIPs(false);
        for (TaskInProgress tip : incompleteTasks) {
            reports.add(tip.generateSingleReport());
        }
        return reports.toArray(new TaskReport[reports.size()]);
    }

    @Override
    public synchronized TaskReport[] getSetupTaskReports(JobID jobid) {
        JobInProgress job = this.jobs.get(jobid);
        if (job == null) {
            return new TaskReport[0];
        }
        Vector<TaskReport> reports = new Vector<TaskReport>();
        Vector<TaskInProgress> completeTasks = job.reportSetupTIPs(true);
        for (TaskInProgress tip : completeTasks) {
            reports.add(tip.generateSingleReport());
        }
        Vector<TaskInProgress> incompleteTasks = job.reportSetupTIPs(false);
        for (TaskInProgress tip : incompleteTasks) {
            reports.add(tip.generateSingleReport());
        }
        return reports.toArray(new TaskReport[reports.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized TaskCompletionEvent[] getTaskCompletionEvents(JobID jobid, int fromEventId, int maxEvents) throws IOException {
        JobTracker jobTracker = this;
        synchronized (jobTracker) {
            JobInProgress job = this.jobs.get(jobid);
            if (null != job) {
                if (job.inited()) {
                    return job.getTaskCompletionEvents(fromEventId, maxEvents);
                }
                return this.EMPTY_EVENTS;
            }
        }
        return this.completedJobStatusStore.readJobTaskCompletionEvents(jobid, fromEventId, maxEvents);
    }

    @Override
    public synchronized String[] getTaskDiagnostics(TaskAttemptID taskId) throws IOException {
        JobID jobId = taskId.getJobID();
        TaskID tipId = taskId.getTaskID();
        JobInProgress job = this.jobs.get(jobId);
        if (job == null) {
            throw new IllegalArgumentException("Job " + jobId + " not found.");
        }
        TaskInProgress tip = job.getTaskInProgress(tipId);
        if (tip == null) {
            throw new IllegalArgumentException("TIP " + tipId + " not found.");
        }
        List<String> taskDiagnosticInfo = tip.getDiagnosticInfo(taskId);
        return taskDiagnosticInfo == null ? null : taskDiagnosticInfo.toArray(new String[0]);
    }

    TaskStatus[] getTaskStatuses(TaskID tipid) {
        TaskInProgress tip = this.getTip(tipid);
        return tip == null ? new TaskStatus[]{} : tip.getTaskStatuses();
    }

    TaskStatus getTaskStatus(TaskAttemptID taskid) {
        TaskInProgress tip = this.getTip(taskid.getTaskID());
        return tip == null ? null : tip.getTaskStatus(taskid);
    }

    Counters getTipCounters(TaskID tipid) {
        TaskInProgress tip = this.getTip(tipid);
        return tip == null ? null : tip.getCounters();
    }

    TaskScheduler getTaskScheduler() {
        return this.taskScheduler;
    }

    public TaskInProgress getTip(TaskID tipid) {
        JobInProgress job = this.jobs.get(tipid.getJobID());
        return job == null ? null : job.getTaskInProgress(tipid);
    }

    @Override
    public synchronized boolean killTask(TaskAttemptID taskid, boolean shouldFail) throws IOException {
        TaskInProgress tip = this.taskidToTIPMap.get(taskid);
        if (tip != null) {
            this.checkAccess(tip.getJob(), QueueManager.QueueOperation.ADMINISTER_JOBS);
            return tip.killTask(taskid, shouldFail);
        }
        LOG.info((Object)("Kill task attempt failed since task " + taskid + " was not found"));
        return false;
    }

    public synchronized String getAssignedTracker(TaskAttemptID taskId) {
        return this.taskidToTrackerMap.get(taskId);
    }

    @Override
    public JobStatus[] jobsToComplete() {
        return this.getJobStatus(this.jobs.values(), true);
    }

    @Override
    public JobStatus[] getAllJobs() {
        return this.getJobStatus(this.jobs.values(), false);
    }

    @Override
    public String getSystemDir() {
        Path sysDir = new Path(this.conf.get("mapred.system.dir", "/tmp/hadoop/mapred/system"));
        return this.fs.makeQualified(sysDir).toString();
    }

    @Override
    public JobInProgress getJob(JobID jobid) {
        return this.jobs.get(jobid);
    }

    Path getSystemDirectoryForJob(JobID id) {
        return new Path(this.getSystemDir(), id.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void setJobPriority(JobID jobId, JobPriority priority) {
        JobInProgress job = this.jobs.get(jobId);
        if (job != null) {
            TaskScheduler taskScheduler = this.taskScheduler;
            synchronized (taskScheduler) {
                JobStatus oldStatus = (JobStatus)job.getStatus().clone();
                job.setPriority(priority);
                JobStatus newStatus = (JobStatus)job.getStatus().clone();
                JobStatusChangeEvent event = new JobStatusChangeEvent(job, JobStatusChangeEvent.EventType.PRIORITY_CHANGED, oldStatus, newStatus);
                this.updateJobInProgressListeners(event);
            }
        } else {
            LOG.warn((Object)("Trying to change the priority of an unknown job: " + jobId));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateTaskStatuses(TaskTrackerStatus status) {
        String trackerName = status.getTrackerName();
        for (TaskStatus report : status.getTaskReports()) {
            List<TaskAttemptID> failedFetchMaps;
            Map<String, Set<ID>> map;
            report.setTaskTracker(trackerName);
            TaskAttemptID taskId = report.getTaskID();
            this.expireLaunchingTasks.removeTask(taskId);
            JobInProgress job = this.getJob(taskId.getJobID());
            if (job == null) {
                map = this.trackerToJobsToCleanup;
                synchronized (map) {
                    Set<JobID> jobs = this.trackerToJobsToCleanup.get(trackerName);
                    if (jobs == null) {
                        jobs = new HashSet<JobID>();
                        this.trackerToJobsToCleanup.put(trackerName, jobs);
                    }
                    jobs.add(taskId.getJobID());
                    continue;
                }
            }
            if (!job.inited()) {
                map = this.trackerToTasksToCleanup;
                synchronized (map) {
                    Set<TaskAttemptID> tasks = this.trackerToTasksToCleanup.get(trackerName);
                    if (tasks == null) {
                        tasks = new HashSet<TaskAttemptID>();
                        this.trackerToTasksToCleanup.put(trackerName, tasks);
                    }
                    tasks.add(taskId);
                    continue;
                }
            }
            TaskInProgress tip = this.taskidToTIPMap.get(taskId);
            if (tip != null || this.hasRestarted()) {
                if (tip == null) {
                    tip = job.getTaskInProgress(taskId.getTaskID());
                    job.addRunningTaskToTIP(tip, taskId, status, false);
                }
                JobStatus prevStatus = (JobStatus)job.getStatus().clone();
                job.updateTaskStatus(tip, (TaskStatus)report.clone());
                JobStatus newStatus = (JobStatus)job.getStatus().clone();
                if (prevStatus.getRunState() != newStatus.getRunState()) {
                    JobStatusChangeEvent event = new JobStatusChangeEvent(job, JobStatusChangeEvent.EventType.RUN_STATE_CHANGED, prevStatus, newStatus);
                    this.updateJobInProgressListeners(event);
                }
            } else {
                LOG.info((Object)("Serious problem.  While updating status, cannot find taskid " + report.getTaskID()));
            }
            if ((failedFetchMaps = report.getFetchFailedMaps()) == null) continue;
            for (TaskAttemptID mapTaskId : failedFetchMaps) {
                TaskInProgress failedFetchMap = this.taskidToTIPMap.get(mapTaskId);
                if (failedFetchMap == null) continue;
                String failedFetchTrackerName = this.getAssignedTracker(mapTaskId);
                if (failedFetchTrackerName == null) {
                    failedFetchTrackerName = "Lost task tracker";
                }
                failedFetchMap.getJob().fetchFailureNotification(failedFetchMap, mapTaskId, failedFetchTrackerName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void lostTaskTracker(String trackerName) {
        LOG.info((Object)("Lost tracker '" + trackerName + "'"));
        Map<String, Set<ID>> map = this.trackerToJobsToCleanup;
        synchronized (map) {
            this.trackerToJobsToCleanup.remove(trackerName);
        }
        map = this.trackerToTasksToCleanup;
        synchronized (map) {
            this.trackerToTasksToCleanup.remove(trackerName);
        }
        this.recoveryManager.unMarkTracker(trackerName);
        Set<TaskAttemptID> lostTasks = this.trackerToTaskMap.get(trackerName);
        this.trackerToTaskMap.remove(trackerName);
        if (lostTasks != null) {
            HashSet<JobInProgress> jobsWithFailures = new HashSet<JobInProgress>();
            for (TaskAttemptID taskId : lostTasks) {
                TaskInProgress tip = this.taskidToTIPMap.get(taskId);
                JobInProgress job = tip.getJob();
                if (!tip.isComplete() || tip.isMapTask() && !tip.isJobSetupTask() && job.desiredReduces() != 0) {
                    if (job.getStatus().getRunState() != 1 && job.getStatus().getRunState() != 4) continue;
                    TaskStatus.State killState = tip.isRunningTask(taskId) && !tip.isJobSetupTask() && !tip.isJobCleanupTask() ? TaskStatus.State.KILLED_UNCLEAN : TaskStatus.State.KILLED;
                    job.failedTask(tip, taskId, "Lost task tracker: " + trackerName, tip.isMapTask() ? TaskStatus.Phase.MAP : TaskStatus.Phase.REDUCE, killState, trackerName);
                    jobsWithFailures.add(job);
                    continue;
                }
                this.markCompletedTaskAttempt(trackerName, taskId);
            }
            for (JobInProgress job : jobsWithFailures) {
                job.addTrackerTaskFailure(trackerName);
            }
            this.removeMarkedTasks(trackerName);
        }
    }

    public static String getLocalJobFilePath(JobID jobId) {
        return JobHistory.JobInfo.getLocalJobFilePath(jobId);
    }

    public static void main(String[] argv) throws IOException, InterruptedException {
        StringUtils.startupShutdownMessage(JobTracker.class, argv, LOG);
        if (argv.length != 0) {
            System.out.println("usage: JobTracker");
            System.exit(-1);
        }
        try {
            JobTracker tracker = JobTracker.startTracker(new JobConf());
            tracker.offerService();
        }
        catch (Throwable e) {
            LOG.fatal((Object)StringUtils.stringifyException(e));
            System.exit(-1);
        }
    }

    @Override
    public JobQueueInfo[] getQueues() throws IOException {
        return this.queueManager.getJobQueueInfos();
    }

    @Override
    public JobQueueInfo getQueueInfo(String queue) throws IOException {
        return this.queueManager.getJobQueueInfo(queue);
    }

    @Override
    public JobStatus[] getJobsFromQueue(String queue) throws IOException {
        Collection<JobInProgress> jips = this.taskScheduler.getJobs(queue);
        return this.getJobStatus(jips, false);
    }

    private synchronized JobStatus[] getJobStatus(Collection<JobInProgress> jips, boolean toComplete) {
        if (jips == null || jips.isEmpty()) {
            return new JobStatus[0];
        }
        ArrayList<JobStatus> jobStatusList = new ArrayList<JobStatus>();
        for (JobInProgress jip : jips) {
            JobStatus status = jip.getStatus();
            status.setStartTime(jip.getStartTime());
            status.setUsername(jip.getProfile().getUser());
            if (toComplete) {
                if (status.getRunState() != 1 && status.getRunState() != 4) continue;
                jobStatusList.add(status);
                continue;
            }
            jobStatusList.add(status);
        }
        return jobStatusList.toArray(new JobStatus[jobStatusList.size()]);
    }

    int getMaxTasksPerJob() {
        return this.conf.getInt("mapred.jobtracker.maxtasks.per.job", -1);
    }

    @Override
    public void refreshServiceAcl() throws IOException {
        if (!this.conf.getBoolean("hadoop.security.authorization", false)) {
            throw new AuthorizationException("Service Level Authorization not enabled!");
        }
        SecurityUtil.getPolicy().refresh();
    }

    private void initializeTaskMemoryRelatedConfig() {
        this.memSizeForMapSlotOnJT = JobConf.normalizeMemoryConfigValue(this.conf.getLong(MAPRED_CLUSTER_MAP_MEMORY_MB_PROPERTY, -1L));
        this.memSizeForReduceSlotOnJT = JobConf.normalizeMemoryConfigValue(this.conf.getLong(MAPRED_CLUSTER_REDUCE_MEMORY_MB_PROPERTY, -1L));
        if (this.conf.get("mapred.task.limit.maxvmem") != null) {
            LOG.warn((Object)(JobConf.deprecatedString("mapred.task.limit.maxvmem") + " instead use " + MAPRED_CLUSTER_MAX_MAP_MEMORY_MB_PROPERTY + " and " + MAPRED_CLUSTER_MAX_REDUCE_MEMORY_MB_PROPERTY));
            this.limitMaxMemForMapTasks = this.limitMaxMemForReduceTasks = JobConf.normalizeMemoryConfigValue(this.conf.getLong("mapred.task.limit.maxvmem", -1L));
            if (this.limitMaxMemForMapTasks != -1L && this.limitMaxMemForMapTasks >= 0L) {
                this.limitMaxMemForMapTasks = this.limitMaxMemForReduceTasks = this.limitMaxMemForMapTasks / 0x100000L;
            }
        } else {
            this.limitMaxMemForMapTasks = JobConf.normalizeMemoryConfigValue(this.conf.getLong(MAPRED_CLUSTER_MAX_MAP_MEMORY_MB_PROPERTY, -1L));
            this.limitMaxMemForReduceTasks = JobConf.normalizeMemoryConfigValue(this.conf.getLong(MAPRED_CLUSTER_MAX_REDUCE_MEMORY_MB_PROPERTY, -1L));
        }
        LOG.info((Object)new StringBuilder().append("Scheduler configured with ").append("(memSizeForMapSlotOnJT, memSizeForReduceSlotOnJT,").append(" limitMaxMemForMapTasks, limitMaxMemForReduceTasks) (").append(this.memSizeForMapSlotOnJT).append(", ").append(this.memSizeForReduceSlotOnJT).append(", ").append(this.limitMaxMemForMapTasks).append(", ").append(this.limitMaxMemForReduceTasks).append(")"));
    }

    private boolean perTaskMemoryConfigurationSetOnJT() {
        return this.limitMaxMemForMapTasks != -1L && this.limitMaxMemForReduceTasks != -1L && this.memSizeForMapSlotOnJT != -1L && this.memSizeForReduceSlotOnJT != -1L;
    }

    private void checkMemoryRequirements(JobInProgress job) throws IOException {
        if (!this.perTaskMemoryConfigurationSetOnJT()) {
            LOG.debug((Object)"Per-Task memory configuration is not set on JT. Not checking the job for invalid memory requirements.");
            return;
        }
        boolean invalidJob = false;
        String msg = "";
        long maxMemForMapTask = job.getJobConf().getMemoryForMapTask();
        long maxMemForReduceTask = job.getJobConf().getMemoryForReduceTask();
        if (maxMemForMapTask == -1L || maxMemForReduceTask == -1L) {
            invalidJob = true;
            msg = "Invalid job requirements.";
        }
        if (maxMemForMapTask > this.limitMaxMemForMapTasks || maxMemForReduceTask > this.limitMaxMemForReduceTasks) {
            invalidJob = true;
            msg = "Exceeds the cluster's max-memory-limit.";
        }
        if (invalidJob) {
            StringBuilder jobStr = new StringBuilder().append(job.getJobID().toString()).append("(").append(maxMemForMapTask).append(" memForMapTasks ").append(maxMemForReduceTask).append(" memForReduceTasks): ");
            LOG.warn((Object)(jobStr.toString() + msg));
            throw new IOException(jobStr.toString() + msg);
        }
    }

    static {
        Configuration.addDefaultResource("mapred-default.xml");
        Configuration.addDefaultResource("mapred-site.xml");
        TASKTRACKER_EXPIRY_INTERVAL = 600000L;
        UPDATE_FAULTY_TRACKER_INTERVAL = 86400000L;
        MAX_BLACKLIST_PERCENT = 0.5;
        SYSTEM_DIR_PERMISSION = FsPermission.createImmutable((short)475);
        SYSTEM_FILE_PERMISSION = FsPermission.createImmutable((short)448);
        LOG = LogFactory.getLog(JobTracker.class);
    }

    class RecoveryManager {
        Set<JobID> jobsToRecover;
        private int totalEventsRecovered = 0;
        private int restartCount = 0;
        private boolean shouldRecover = false;
        Set<String> recoveredTrackers = Collections.synchronizedSet(new HashSet());

        public RecoveryManager() {
            this.jobsToRecover = new TreeSet<JobID>();
        }

        public boolean contains(JobID id) {
            return this.jobsToRecover.contains(id);
        }

        void addJobForRecovery(JobID id) {
            this.jobsToRecover.add(id);
        }

        public boolean shouldRecover() {
            return this.shouldRecover;
        }

        public boolean shouldSchedule() {
            return this.recoveredTrackers.isEmpty();
        }

        private void markTracker(String trackerName) {
            this.recoveredTrackers.add(trackerName);
        }

        void unMarkTracker(String trackerName) {
            this.recoveredTrackers.remove(trackerName);
        }

        Set<JobID> getJobsToRecover() {
            return this.jobsToRecover;
        }

        private boolean isJobNameValid(String str) {
            if (str == null) {
                return false;
            }
            String[] parts = str.split("_");
            if (parts.length == 3 && parts[0].equals("job")) {
                return JobTracker.validateIdentifier(parts[1]) && JobTracker.validateJobNumber(parts[2]);
            }
            return false;
        }

        public void checkAndAddJob(FileStatus status) throws IOException {
            String fileName = status.getPath().getName();
            if (this.isJobNameValid(fileName)) {
                if (JobClient.isJobDirValid(status.getPath(), JobTracker.this.fs)) {
                    JobTracker.this.recoveryManager.addJobForRecovery(JobID.forName(fileName));
                    this.shouldRecover = true;
                } else {
                    LOG.info((Object)("Found an incomplete job directory " + fileName + "." + " Deleting it!!"));
                    JobTracker.this.fs.delete(status.getPath(), true);
                }
            }
        }

        private JobStatusChangeEvent updateJob(JobInProgress jip, JobHistory.JobInfo job) {
            String jobpriority = job.get(JobHistory.Keys.JOB_PRIORITY);
            JobPriority priority = JobPriority.valueOf(jobpriority);
            JobTracker.this.setJobPriority(jip.getJobID(), priority);
            JobStatus oldStatus = (JobStatus)jip.getStatus().clone();
            jip.updateJobInfo(job.getLong(JobHistory.Keys.SUBMIT_TIME), job.getLong(JobHistory.Keys.LAUNCH_TIME));
            JobStatus newStatus = (JobStatus)jip.getStatus().clone();
            return new JobStatusChangeEvent(jip, JobStatusChangeEvent.EventType.START_TIME_CHANGED, oldStatus, newStatus);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateTip(TaskInProgress tip, JobHistory.Task task) {
            String cause;
            long finishTime;
            long startTime = task.getLong(JobHistory.Keys.START_TIME);
            if (startTime != 0L) {
                tip.setExecStartTime(startTime);
            }
            if ((finishTime = task.getLong(JobHistory.Keys.FINISH_TIME)) != 0L) {
                tip.setExecFinishTime(finishTime);
            }
            if ((cause = task.get(JobHistory.Keys.TASK_ATTEMPT_ID)).length() > 0) {
                TaskAttemptID id = TaskAttemptID.forName(cause);
                TaskStatus status = tip.getTaskStatus(id);
                JobTracker jobTracker = JobTracker.this;
                synchronized (jobTracker) {
                    tip.getJob().failedTask(tip, id, status.getDiagnosticInfo(), status.getPhase(), status.getRunState(), status.getTaskTracker());
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void createTaskAttempt(JobInProgress job, TaskAttemptID attemptId, JobHistory.TaskAttempt attempt) {
            TaskID id = attemptId.getTaskID();
            String type = attempt.get(JobHistory.Keys.TASK_TYPE);
            TaskInProgress tip = job.getTaskInProgress(id);
            TaskStatus taskStatus = null;
            String trackerName = attempt.get(JobHistory.Keys.TRACKER_NAME);
            String trackerHostName = JobInProgress.convertTrackerNameToHostName(trackerName);
            int port = 0;
            String hport = attempt.get(JobHistory.Keys.HTTP_PORT);
            if (hport != null && hport.length() > 0) {
                port = attempt.getInt(JobHistory.Keys.HTTP_PORT);
            }
            long attemptStartTime = attempt.getLong(JobHistory.Keys.START_TIME);
            taskStatus = type.equals(JobHistory.Values.MAP.name()) ? new MapTaskStatus(attemptId, 0.0f, TaskStatus.State.RUNNING, "", "", trackerName, TaskStatus.Phase.MAP, new Counters()) : new ReduceTaskStatus(attemptId, 0.0f, TaskStatus.State.RUNNING, "", "", trackerName, TaskStatus.Phase.REDUCE, new Counters());
            taskStatus.setStartTime(attemptStartTime);
            ArrayList<TaskStatus> ttStatusList = new ArrayList<TaskStatus>();
            ttStatusList.add(taskStatus);
            TaskTrackerStatus ttStatus = new TaskTrackerStatus(trackerName, trackerHostName, port, ttStatusList, 0, 0, 0);
            ttStatus.setLastSeen(System.currentTimeMillis());
            JobTracker jobTracker = JobTracker.this;
            synchronized (jobTracker) {
                HashMap hashMap = JobTracker.this.taskTrackers;
                synchronized (hashMap) {
                    TreeSet<TaskTrackerStatus> treeSet = JobTracker.this.trackerExpiryQueue;
                    synchronized (treeSet) {
                        boolean isTrackerRegistered;
                        boolean bl = isTrackerRegistered = JobTracker.this.getTaskTracker(trackerName) != null;
                        if (!isTrackerRegistered) {
                            this.markTracker(trackerName);
                            JobTracker.this.addNewTracker(ttStatus);
                        }
                        JobTracker.this.updateTaskTrackerStatus(trackerName, ttStatus);
                    }
                }
                job.addRunningTaskToTIP(tip, attemptId, ttStatus, false);
                tip.updateStatus(taskStatus);
            }
            JobTracker.this.expireLaunchingTasks.addNewTask(attemptId);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addSuccessfulAttempt(JobInProgress job, TaskAttemptID attemptId, JobHistory.TaskAttempt attempt) {
            TaskID taskId = attemptId.getTaskID();
            String type = attempt.get(JobHistory.Keys.TASK_TYPE);
            TaskInProgress tip = job.getTaskInProgress(taskId);
            long attemptFinishTime = attempt.getLong(JobHistory.Keys.FINISH_TIME);
            TaskStatus taskStatus = (TaskStatus)tip.getTaskStatus(attemptId).clone();
            taskStatus.setFinishTime(attemptFinishTime);
            String stateString = attempt.get(JobHistory.Keys.STATE_STRING);
            taskStatus.setStateString(stateString);
            taskStatus.setProgress(1.0f);
            taskStatus.setRunState(TaskStatus.State.SUCCEEDED);
            if (type.equals(JobHistory.Values.REDUCE.name())) {
                long shuffleTime = Long.parseLong(attempt.get(JobHistory.Keys.SHUFFLE_FINISHED));
                long sortTime = Long.parseLong(attempt.get(JobHistory.Keys.SORT_FINISHED));
                taskStatus.setShuffleFinishTime(shuffleTime);
                taskStatus.setSortFinishTime(sortTime);
            }
            String counterString = attempt.get(JobHistory.Keys.COUNTERS);
            Counters counter = null;
            try {
                counter = Counters.fromEscapedCompactString(counterString);
            }
            catch (ParseException pe) {
                counter = new Counters();
            }
            taskStatus.setCounters(counter);
            JobTracker jobTracker = JobTracker.this;
            synchronized (jobTracker) {
                job.updateTaskStatus(tip, taskStatus);
            }
            JobTracker.this.expireLaunchingTasks.removeTask(attemptId);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addUnsuccessfulAttempt(JobInProgress job, TaskAttemptID attemptId, JobHistory.TaskAttempt attempt) {
            TaskID taskId = attemptId.getTaskID();
            TaskInProgress tip = job.getTaskInProgress(taskId);
            long attemptFinishTime = attempt.getLong(JobHistory.Keys.FINISH_TIME);
            TaskStatus taskStatus = (TaskStatus)tip.getTaskStatus(attemptId).clone();
            taskStatus.setFinishTime(attemptFinishTime);
            taskStatus.setProgress(0.0f);
            String stateString = attempt.get(JobHistory.Keys.STATE_STRING);
            taskStatus.setStateString(stateString);
            boolean hasFailed = attempt.get(JobHistory.Keys.TASK_STATUS).equals(JobHistory.Values.FAILED.name());
            if (hasFailed) {
                taskStatus.setRunState(TaskStatus.State.FAILED);
            } else {
                taskStatus.setRunState(TaskStatus.State.KILLED);
            }
            String diagInfo = attempt.get(JobHistory.Keys.ERROR);
            taskStatus.setDiagnosticInfo(diagInfo);
            JobTracker jobTracker = JobTracker.this;
            synchronized (jobTracker) {
                job.updateTaskStatus(tip, taskStatus);
            }
            JobTracker.this.expireLaunchingTasks.removeTask(attemptId);
        }

        Path getRestartCountFile() {
            return new Path(JobTracker.this.getSystemDir(), "jobtracker.info");
        }

        Path getTempRestartCountFile() {
            return new Path(JobTracker.this.getSystemDir(), "jobtracker.info.recover");
        }

        void updateRestartCount() throws IOException {
            Path restartFile = this.getRestartCountFile();
            Path tmpRestartFile = this.getTempRestartCountFile();
            FileSystem fs = restartFile.getFileSystem(JobTracker.this.conf);
            FsPermission filePerm = new FsPermission(SYSTEM_FILE_PERMISSION);
            if (fs.exists(restartFile)) {
                fs.delete(tmpRestartFile, false);
            } else if (fs.exists(tmpRestartFile)) {
                fs.rename(tmpRestartFile, restartFile);
            } else {
                this.shouldRecover = false;
                try {
                    FSDataOutputStream out = FileSystem.create(fs, restartFile, filePerm);
                    out.writeInt(0);
                    out.close();
                }
                catch (IOException ioe) {
                    LOG.warn((Object)("Writing to file " + restartFile + " failed!"));
                    LOG.warn((Object)"FileSystem is not ready yet!");
                    fs.delete(restartFile, false);
                    throw ioe;
                }
                return;
            }
            FSDataInputStream in = fs.open(restartFile);
            try {
                this.restartCount = in.readInt();
                ++this.restartCount;
            }
            catch (IOException ioe) {
                LOG.warn((Object)("System directory is garbled. Failed to read file " + restartFile));
                LOG.warn((Object)"Jobtracker recovery is not possible with garbled system directory! Please delete the system directory and restart the jobtracker. Note that deleting the system directory will result in loss of all the running jobs.");
                throw new RuntimeException(ioe);
            }
            finally {
                if (in != null) {
                    in.close();
                }
            }
            FSDataOutputStream out = FileSystem.create(fs, tmpRestartFile, filePerm);
            out.writeInt(this.restartCount);
            out.close();
            fs.delete(restartFile, false);
            fs.rename(tmpRestartFile, restartFile);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void recover() {
            Path jobHistoryFilePath;
            if (!this.shouldRecover()) {
                this.jobsToRecover.clear();
                return;
            }
            LOG.info((Object)("Restart count of the jobtracker : " + this.restartCount));
            HashMap<JobID, Path> jobHistoryFilenameMap = new HashMap<JobID, Path>();
            Iterator<JobID> idIter = this.jobsToRecover.iterator();
            while (idIter.hasNext()) {
                JobID id = idIter.next();
                LOG.info((Object)("Trying to recover details of job " + id));
                try {
                    JobInProgress job = new JobInProgress(id, JobTracker.this, JobTracker.this.conf, this.restartCount);
                    UserGroupInformation ugi = UserGroupInformation.readFrom(job.getJobConf());
                    LOG.info((Object)("Submitting job " + id + " on behalf of user " + ugi.getUserName() + " in groups : " + StringUtils.arrayToString(ugi.getGroupNames())));
                    try {
                        JobTracker.this.checkAccess(job, QueueManager.QueueOperation.SUBMIT_JOB, ugi);
                    }
                    catch (Throwable t) {
                        LOG.warn((Object)("Access denied for user " + ugi.getUserName() + " in groups : [" + StringUtils.arrayToString(ugi.getGroupNames()) + "]"));
                        throw t;
                    }
                    String logFileName = JobHistory.JobInfo.getJobHistoryFileName(job.getJobConf(), id);
                    if (logFileName != null) {
                        jobHistoryFilePath = JobHistory.JobInfo.getJobHistoryLogLocation(logFileName);
                        JobHistory.JobInfo.recoverJobHistoryFile(job.getJobConf(), jobHistoryFilePath);
                        jobHistoryFilenameMap.put(job.getJobID(), jobHistoryFilePath);
                    } else {
                        LOG.info((Object)("No history file found for job " + id));
                        idIter.remove();
                    }
                    JobTracker.this.addJob(id, job);
                }
                catch (Throwable t) {
                    LOG.warn((Object)("Failed to recover job " + id + " Ignoring the job."), t);
                    idIter.remove();
                }
            }
            long recoveryStartTime = System.currentTimeMillis();
            idIter = this.jobsToRecover.iterator();
            while (idIter.hasNext()) {
                FileSystem fs;
                JobID id = idIter.next();
                JobInProgress pJob = JobTracker.this.getJob(id);
                jobHistoryFilePath = (Path)jobHistoryFilenameMap.get(pJob.getJobID());
                String logFileName = jobHistoryFilePath.getName();
                try {
                    fs = jobHistoryFilePath.getFileSystem(JobTracker.this.conf);
                }
                catch (IOException ioe) {
                    LOG.warn((Object)("Failed to get the filesystem for job " + id + ". Ignoring."), (Throwable)ioe);
                    continue;
                }
                JobRecoveryListener listener = new JobRecoveryListener(pJob);
                try {
                    JobHistory.parseHistoryFromFS(jobHistoryFilePath.toString(), listener, fs);
                }
                catch (Throwable t) {
                    LOG.info((Object)("Error reading history file of job " + pJob.getJobID() + ". Ignoring the error and continuing."), t);
                }
                listener.close();
                this.totalEventsRecovered += listener.getNumEventsRecovered();
                try {
                    JobInProgress t = pJob;
                    synchronized (t) {
                        JobHistory.JobInfo.checkpointRecovery(logFileName, pJob.getJobConf());
                    }
                }
                catch (Throwable t) {
                    LOG.warn((Object)("Failed to delete log file (" + logFileName + ") for job " + id + ". Continuing."), t);
                }
                if (!pJob.isComplete()) continue;
                idIter.remove();
            }
            JobTracker.this.recoveryDuration = System.currentTimeMillis() - recoveryStartTime;
            JobTracker.this.hasRecovered = true;
            TreeSet<TaskTrackerStatus> treeSet = JobTracker.this.trackerExpiryQueue;
            synchronized (treeSet) {
                long now = System.currentTimeMillis();
                int size = JobTracker.this.trackerExpiryQueue.size();
                for (int i = 0; i < size; ++i) {
                    TaskTrackerStatus status = JobTracker.this.trackerExpiryQueue.first();
                    JobTracker.this.trackerExpiryQueue.remove(status);
                    status.setLastSeen(now);
                    JobTracker.this.trackerExpiryQueue.add(status);
                }
            }
            LOG.info((Object)"Restoration complete");
        }

        int totalEventsRecovered() {
            return this.totalEventsRecovered;
        }

        class JobRecoveryListener
        implements JobHistory.Listener {
            private JobInProgress jip;
            private JobHistory.JobInfo job;
            private int numEventsRecovered = 0;
            private Map<String, String> hangingAttempts = new HashMap<String, String>();
            private boolean hasUpdates = false;

            public JobRecoveryListener(JobInProgress jip) {
                this.jip = jip;
                this.job = new JobHistory.JobInfo(jip.getJobID().toString());
            }

            private void processTask(String taskId, JobHistory.Task task) {
                boolean hasHanging;
                boolean bl = hasHanging = this.hangingAttempts.remove(taskId) != null;
                if (hasHanging) {
                    this.numEventsRecovered += 2;
                }
                TaskID id = TaskID.forName(taskId);
                TaskInProgress tip = JobTracker.this.getTip(id);
                RecoveryManager.this.updateTip(tip, task);
            }

            private void processTaskAttempt(String taskAttemptId, JobHistory.TaskAttempt attempt) {
                TaskAttemptID id = TaskAttemptID.forName(taskAttemptId);
                String taskStatus = attempt.get(JobHistory.Keys.TASK_STATUS);
                if (taskStatus.length() > 0) {
                    if (taskStatus.equals(JobHistory.Values.SUCCESS.name())) {
                        this.hangingAttempts.put(id.getTaskID().toString(), taskAttemptId);
                        RecoveryManager.this.addSuccessfulAttempt(this.jip, id, attempt);
                    } else {
                        RecoveryManager.this.addUnsuccessfulAttempt(this.jip, id, attempt);
                        this.numEventsRecovered += 2;
                    }
                } else {
                    RecoveryManager.this.createTaskAttempt(this.jip, id, attempt);
                }
            }

            @Override
            public void handle(JobHistory.RecordTypes recType, Map<JobHistory.Keys, String> values) throws IOException {
                if (recType == JobHistory.RecordTypes.Job) {
                    this.job.handle((Map)values);
                    this.checkAndInit();
                } else if (recType.equals((Object)JobHistory.RecordTypes.Task)) {
                    String taskId = values.get((Object)JobHistory.Keys.TASKID);
                    JobHistory.Task task = new JobHistory.Task();
                    task.handle((Map)values);
                    if (this.isCleanup(task)) {
                        return;
                    }
                    this.processTask(taskId, task);
                } else if (recType.equals((Object)JobHistory.RecordTypes.MapAttempt)) {
                    String attemptId = values.get((Object)JobHistory.Keys.TASK_ATTEMPT_ID);
                    JobHistory.MapAttempt attempt = new JobHistory.MapAttempt();
                    attempt.handle((Map)values);
                    if (this.isCleanup(attempt)) {
                        return;
                    }
                    this.processTaskAttempt(attemptId, attempt);
                } else if (recType.equals((Object)JobHistory.RecordTypes.ReduceAttempt)) {
                    String attemptId = values.get((Object)JobHistory.Keys.TASK_ATTEMPT_ID);
                    JobHistory.ReduceAttempt attempt = new JobHistory.ReduceAttempt();
                    attempt.handle((Map)values);
                    if (this.isCleanup(attempt)) {
                        return;
                    }
                    this.processTaskAttempt(attemptId, attempt);
                }
            }

            private boolean isCleanup(JobHistory.Task task) {
                String taskType = task.get(JobHistory.Keys.TASK_TYPE);
                return JobHistory.Values.CLEANUP.name().equals(taskType);
            }

            private void checkAndInit() throws IOException {
                String jobStatus = this.job.get(JobHistory.Keys.JOB_STATUS);
                if (JobHistory.Values.PREP.name().equals(jobStatus)) {
                    this.hasUpdates = true;
                    LOG.info((Object)("Calling init from RM for job " + this.jip.getJobID().toString()));
                    try {
                        JobTracker.this.initJob(this.jip);
                    }
                    catch (Throwable t) {
                        LOG.error((Object)("Job initialization failed : \n" + StringUtils.stringifyException(t)));
                        JobTracker.this.failJob(this.jip);
                        throw new IOException(t);
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            void close() {
                if (this.hasUpdates) {
                    JobStatusChangeEvent event = RecoveryManager.this.updateJob(this.jip, this.job);
                    JobTracker jobTracker = JobTracker.this;
                    synchronized (jobTracker) {
                        JobTracker.this.updateJobInProgressListeners(event);
                    }
                }
            }

            public int getNumEventsRecovered() {
                return this.numEventsRecovered;
            }
        }
    }

    private class FaultyTrackersInfo {
        private Map<String, FaultInfo> potentiallyFaultyTrackers = new HashMap<String, FaultInfo>();
        private volatile int numBlacklistedTrackers = 0;

        private FaultyTrackersInfo() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void incrementFaults(String hostName) {
            Map<String, FaultInfo> map = this.potentiallyFaultyTrackers;
            synchronized (map) {
                FaultInfo fi = this.potentiallyFaultyTrackers.get(hostName);
                if (fi == null) {
                    fi = new FaultInfo();
                    this.potentiallyFaultyTrackers.put(hostName, fi);
                }
                int numFaults = fi.getFaultCount();
                fi.setFaultCount(++numFaults);
                fi.setLastUpdated(System.currentTimeMillis());
                if (!fi.isBlacklisted() && this.shouldBlacklist(hostName, numFaults)) {
                    LOG.info((Object)("Adding " + hostName + " to the blacklist" + " across all jobs"));
                    this.removeHostCapacity(hostName);
                    fi.setBlacklist(true);
                }
            }
        }

        private boolean shouldBlacklist(String hostName, int numFaults) {
            if (numFaults >= JobTracker.this.MAX_BLACKLISTS_PER_TRACKER) {
                long clusterSize = JobTracker.this.getClusterStatus().getTaskTrackers();
                long sum = 0L;
                for (FaultInfo f : this.potentiallyFaultyTrackers.values()) {
                    sum += (long)f.getFaultCount();
                }
                double avg = (double)sum / (double)clusterSize;
                long totalCluster = clusterSize + (long)this.numBlacklistedTrackers;
                if ((double)numFaults - avg > JobTracker.this.AVERAGE_BLACKLIST_THRESHOLD * avg && (double)this.numBlacklistedTrackers < (double)totalCluster * MAX_BLACKLIST_PERCENT) {
                    return true;
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void markTrackerHealthy(String hostName) {
            Map<String, FaultInfo> map = this.potentiallyFaultyTrackers;
            synchronized (map) {
                FaultInfo fi = this.potentiallyFaultyTrackers.remove(hostName);
                if (fi != null && fi.isBlacklisted()) {
                    LOG.info((Object)("Removing " + hostName + " from blacklist"));
                    this.addHostCapacity(hostName);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean shouldAssignTasksToTracker(String hostName, long now) {
            Map<String, FaultInfo> map = this.potentiallyFaultyTrackers;
            synchronized (map) {
                FaultInfo fi = this.potentiallyFaultyTrackers.get(hostName);
                if (fi != null && now - fi.getLastUpdated() > UPDATE_FAULTY_TRACKER_INTERVAL) {
                    int numFaults = fi.getFaultCount() - 1;
                    if (fi.isBlacklisted()) {
                        LOG.info((Object)("Removing " + hostName + " from blacklist"));
                        this.addHostCapacity(hostName);
                        fi.setBlacklist(false);
                    }
                    if (numFaults > 0) {
                        fi.setFaultCount(numFaults);
                        fi.setLastUpdated(now);
                    } else {
                        this.potentiallyFaultyTrackers.remove(hostName);
                    }
                }
                return fi != null && fi.isBlacklisted();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void removeHostCapacity(String hostName) {
            HashMap hashMap = JobTracker.this.taskTrackers;
            synchronized (hashMap) {
                for (TaskTrackerStatus status : JobTracker.this.getStatusesOnHost(hostName)) {
                    JobTracker.this.totalMapTaskCapacity -= status.getMaxMapTasks();
                    JobTracker.this.totalReduceTaskCapacity -= status.getMaxReduceTasks();
                }
                this.numBlacklistedTrackers += JobTracker.this.uniqueHostsMap.remove(hostName).intValue();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addHostCapacity(String hostName) {
            HashMap hashMap = JobTracker.this.taskTrackers;
            synchronized (hashMap) {
                int numTrackersOnHost = 0;
                for (TaskTrackerStatus status : JobTracker.this.getStatusesOnHost(hostName)) {
                    JobTracker.this.totalMapTaskCapacity += status.getMaxMapTasks();
                    JobTracker.this.totalReduceTaskCapacity += status.getMaxReduceTasks();
                    ++numTrackersOnHost;
                }
                JobTracker.this.uniqueHostsMap.put(hostName, numTrackersOnHost);
                this.numBlacklistedTrackers -= numTrackersOnHost;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean isBlacklisted(String hostName) {
            Map<String, FaultInfo> map = this.potentiallyFaultyTrackers;
            synchronized (map) {
                FaultInfo fi = null;
                fi = this.potentiallyFaultyTrackers.get(hostName);
                if (fi != null) {
                    return fi.isBlacklisted();
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        int getFaultCount(String hostName) {
            Map<String, FaultInfo> map = this.potentiallyFaultyTrackers;
            synchronized (map) {
                FaultInfo fi = null;
                fi = this.potentiallyFaultyTrackers.get(hostName);
                if (fi != null) {
                    return fi.getFaultCount();
                }
            }
            return 0;
        }
    }

    private static class FaultInfo {
        int numFaults = 0;
        long lastUpdated = System.currentTimeMillis();
        boolean blacklisted = false;

        FaultInfo() {
        }

        void setFaultCount(int num) {
            this.numFaults = num;
        }

        void setLastUpdated(long timeStamp) {
            this.lastUpdated = timeStamp;
        }

        int getFaultCount() {
            return this.numFaults;
        }

        long getLastUpdated() {
            return this.lastUpdated;
        }

        boolean isBlacklisted() {
            return this.blacklisted;
        }

        void setBlacklist(boolean blacklist) {
            this.blacklisted = blacklist;
        }
    }

    class RetireJobs
    implements Runnable {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                try {
                    Object object;
                    ArrayList<JobInProgress> retiredJobs;
                    do {
                        Thread.sleep(RETIRE_JOB_CHECK_INTERVAL);
                        retiredJobs = new ArrayList<JobInProgress>();
                        long now = System.currentTimeMillis();
                        long retireBefore = now - RETIRE_JOB_INTERVAL;
                        object = JobTracker.this.jobs;
                        synchronized (object) {
                            for (JobInProgress job : JobTracker.this.jobs.values()) {
                                if (job.getStatus().getRunState() == 1 || job.getStatus().getRunState() == 4 || job.getFinishTime() + 60000L >= now || job.getFinishTime() >= retireBefore) continue;
                                retiredJobs.add(job);
                            }
                        }
                    } while (retiredJobs.isEmpty());
                    object = JobTracker.this;
                    synchronized (object) {
                        Map<JobID, JobInProgress> map = JobTracker.this.jobs;
                        synchronized (map) {
                            TaskScheduler taskScheduler = JobTracker.this.taskScheduler;
                            synchronized (taskScheduler) {
                                for (JobInProgress job : retiredJobs) {
                                    JobTracker.this.removeJobTasks(job);
                                    JobTracker.this.jobs.remove(job.getProfile().getJobID());
                                    for (JobInProgressListener l : JobTracker.this.jobInProgressListeners) {
                                        l.jobRemoved(job);
                                    }
                                    String jobUser = job.getProfile().getUser();
                                    TreeMap<String, ArrayList<JobInProgress>> treeMap = JobTracker.this.userToJobsMap;
                                    synchronized (treeMap) {
                                        ArrayList<JobInProgress> userJobs;
                                        ArrayList<JobInProgress> arrayList = userJobs = JobTracker.this.userToJobsMap.get(jobUser);
                                        synchronized (arrayList) {
                                            userJobs.remove(job);
                                        }
                                        if (userJobs.isEmpty()) {
                                            JobTracker.this.userToJobsMap.remove(jobUser);
                                        }
                                    }
                                    LOG.info((Object)("Retired job with id: '" + job.getProfile().getJobID() + "' of user '" + jobUser + "'"));
                                    JobHistory.JobInfo.cleanupJob(job.getProfile().getJobID());
                                }
                            }
                        }
                    }
                }
                catch (InterruptedException t) {
                }
                catch (Throwable t) {
                    LOG.error((Object)("Error in retiring job:\n" + StringUtils.stringifyException(t)));
                    continue;
                }
                break;
            }
        }
    }

    class ExpireTrackers
    implements Runnable {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        Thread.sleep(TASKTRACKER_EXPIRY_INTERVAL / 3L);
                        JobTracker jobTracker = JobTracker.this;
                        synchronized (jobTracker) {
                            HashMap hashMap = JobTracker.this.taskTrackers;
                            synchronized (hashMap) {
                                TreeSet<TaskTrackerStatus> treeSet = JobTracker.this.trackerExpiryQueue;
                                synchronized (treeSet) {
                                    long now = System.currentTimeMillis();
                                    TaskTrackerStatus leastRecent = null;
                                    while (JobTracker.this.trackerExpiryQueue.size() > 0 && (leastRecent = JobTracker.this.trackerExpiryQueue.first()) != null && now - leastRecent.getLastSeen() > TASKTRACKER_EXPIRY_INTERVAL) {
                                        JobTracker.this.trackerExpiryQueue.remove(leastRecent);
                                        String trackerName = leastRecent.getTrackerName();
                                        TaskTrackerStatus newProfile = (TaskTrackerStatus)JobTracker.this.taskTrackers.get(leastRecent.getTrackerName());
                                        if (newProfile == null) continue;
                                        if (now - newProfile.getLastSeen() > TASKTRACKER_EXPIRY_INTERVAL) {
                                            JobTracker.this.lostTaskTracker(leastRecent.getTrackerName());
                                            if (JobTracker.this.isBlacklisted(trackerName)) {
                                                JobTracker.this.faultyTrackers.numBlacklistedTrackers -= 1;
                                            }
                                            JobTracker.this.updateTaskTrackerStatus(trackerName, null);
                                            continue;
                                        }
                                        JobTracker.this.trackerExpiryQueue.add(newProfile);
                                    }
                                }
                            }
                        }
                    }
                }
                catch (InterruptedException iex) {
                    return;
                }
                catch (Exception t) {
                    LOG.error((Object)("Tracker Expiry Thread got exception: " + StringUtils.stringifyException(t)));
                    continue;
                }
                break;
            }
        }
    }

    private class ExpireLaunchingTasks
    implements Runnable {
        private Map<TaskAttemptID, Long> launchingTasks = new LinkedHashMap<TaskAttemptID, Long>();

        private ExpireLaunchingTasks() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        Thread.sleep(TASKTRACKER_EXPIRY_INTERVAL / 3L);
                        long now = System.currentTimeMillis();
                        LOG.debug((Object)"Starting launching task sweep");
                        JobTracker jobTracker = JobTracker.this;
                        synchronized (jobTracker) {
                            Map<TaskAttemptID, Long> map = this.launchingTasks;
                            synchronized (map) {
                                Iterator<Map.Entry<TaskAttemptID, Long>> itr = this.launchingTasks.entrySet().iterator();
                                while (itr.hasNext()) {
                                    Map.Entry<TaskAttemptID, Long> pair = itr.next();
                                    TaskAttemptID taskId = pair.getKey();
                                    long age = now - pair.getValue();
                                    LOG.info((Object)(taskId + " is " + age + " ms debug."));
                                    if (age <= TASKTRACKER_EXPIRY_INTERVAL) break;
                                    LOG.info((Object)("Launching task " + taskId + " timed out."));
                                    TaskInProgress tip = null;
                                    tip = JobTracker.this.taskidToTIPMap.get(taskId);
                                    if (tip != null) {
                                        JobInProgress job = tip.getJob();
                                        String trackerName = JobTracker.this.getAssignedTracker(taskId);
                                        TaskTrackerStatus trackerStatus = JobTracker.this.getTaskTracker(trackerName);
                                        if (trackerStatus != null) {
                                            job.failedTask(tip, taskId, "Error launching task", tip.isMapTask() ? TaskStatus.Phase.MAP : TaskStatus.Phase.STARTING, TaskStatus.State.FAILED, trackerName);
                                        }
                                    }
                                    itr.remove();
                                }
                            }
                        }
                    }
                }
                catch (InterruptedException ie) {
                    return;
                }
                catch (Exception e) {
                    LOG.error((Object)("Expire Launching Task Thread got exception: " + StringUtils.stringifyException(e)));
                    continue;
                }
                break;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addNewTask(TaskAttemptID taskName) {
            Map<TaskAttemptID, Long> map = this.launchingTasks;
            synchronized (map) {
                this.launchingTasks.put(taskName, System.currentTimeMillis());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeTask(TaskAttemptID taskName) {
            Map<TaskAttemptID, Long> map = this.launchingTasks;
            synchronized (map) {
                this.launchingTasks.remove(taskName);
            }
        }
    }

    public static class IllegalStateException
    extends IOException {
        public IllegalStateException(String msg) {
            super(msg);
        }
    }

    public static enum State {
        INITIALIZING,
        RUNNING;

    }
}

