/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.jdom;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.Transform;
import net.sf.saxon.jdom.DocumentWrapper;
import net.sf.saxon.trans.XPathException;
import org.jdom.Document;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.xml.sax.InputSource;

public class JDOMTransform
extends Transform {
    public List preprocess(List sources) throws XPathException {
        try {
            ArrayList<DocumentWrapper> jdomSources = new ArrayList<DocumentWrapper>(sources.size());
            for (int i = 0; i < sources.size(); ++i) {
                InputSource is;
                Source ss;
                Source src = (Source)sources.get(i);
                if (src instanceof SAXSource) {
                    ss = (SAXSource)sources.get(i);
                    is = ((SAXSource)ss).getInputSource();
                } else if (src instanceof StreamSource) {
                    ss = (StreamSource)src;
                    is = ((StreamSource)ss).getInputStream() != null ? new InputSource(((StreamSource)ss).getInputStream()) : (((StreamSource)ss).getReader() != null ? new InputSource(((StreamSource)ss).getReader()) : new InputSource(((StreamSource)ss).getSystemId()));
                } else {
                    throw new IllegalArgumentException("Unknown kind of source");
                }
                is.setSystemId(src.getSystemId());
                SAXBuilder builder = new SAXBuilder();
                Document doc = builder.build(is);
                DocumentWrapper jdom = new DocumentWrapper(doc, is.getSystemId(), this.config);
                jdomSources.add(jdom);
            }
            return jdomSources;
        }
        catch (JDOMException e) {
            throw new XPathException((Throwable)e);
        }
        catch (IOException e) {
            throw new XPathException((Throwable)e);
        }
    }

    public static void main(String[] args) {
        new JDOMTransform().doTransform(args, "JDOMTransform");
    }
}

