/**
 * Copyright (C) 2012 RobotBrain. All Rights Reserved.
 * ̃vO̓t[\tgEFAłBȂ͂t[\tgEFAc
 * ɂĔsꂽGNU򓙈ʌOpo[W3(LGPLv3)߂
 * ōĔЕz܂͉ς邱Ƃł܂B
 * ̃vO͗Lpł邱ƂĔЕz܂S̖ۏ؂łB
 * Ɖ\̕ۏ؂ړIւ̓ḰAOɎꂽ̂܂ߑS݂
 * BڂGNU򓙈ʌOpo[W3(LGPLv3)B
 * Ȃ͂̃vOƋɁAGNU򓙈ʌOpo[W3(LGPLv3)
 * Rs[ꕔ󂯎Ă͂łB
 * 󂯎ĂȂ<http://www.gnu.org/licenses/>B
 */
package jp.robotbrain.tools;

import java.util.Scanner;

import jp.robotbrain.common.Location;
import jp.robotbrain.common.TextFile;
import jp.robotbrain.net.CookieException;
import jp.robotbrain.net.HttpRecvException;
import jp.robotbrain.net.HttpSendException;
import jp.robotbrain.net.Web;

/**
 * W͂nCp[ÑÑt@C_E[hNX
 * 
 * @since 2.70
 * @author Copyright (C) 2012 <a href="http://robotbrain.jp">
 * RobotBrain.</a> All Rights Reserved.
 */
public class WebDl {

	/**
	 * W͂nCp[ÑÑt@C_E[h܂B
	 * 
	 * @since 2.70
	 * @param args [0]_E[ht@Ci[tH_̃pX
	 *              [1]Ñt@C̕Zbg
	 * @see <a href=
	 * "http://java.sun.com/javase/ja/6/docs/ja/technotes/guides/intl/encoding.doc.html">Zbg</a>
	 */
	public static void main(String[] args) {
		if (args.length<=0) {
			throw new RuntimeException("args length error");
		}
		String folderPath = args[0];
		Scanner stdin = new Scanner(System.in);
		while(stdin.hasNext()) {
			// W͂̓ǂݍ
			String line = stdin.nextLine();
			// uURL + TabR[h + Nv̌`œĂ 
			String[] fields = line.split("\t");
			if (fields==null) continue;
			if (fields.length<=0) continue;
			String url = fields[0];
			// URĽƕϊ
			int lasts = url.lastIndexOf("/");
			if (lasts<0) continue;
			String fileName;
			if (lasts<7 || lasts>=url.length()-1) {
				fileName = "index.html";
			} else {
				fileName = url.substring(lasts+1);
			}
			// Zbg擾
			String charset = null;
			if (args.length>1) {
				charset = args[1];
			} else {
				charset = Web.getCharSet(url);
			}
			if (charset==null) 	{
				throw new RuntimeException("charset error");
			}
			// _E[h
			Web web = new Web(charset);
			try {
				String html = web.go(url);
				TextFile dest = new TextFile(folderPath + Location.FSP + convFileName(fileName), charset);
				dest.write(html, false);
			} catch (HttpSendException e) {
				throw new RuntimeException("http send error");
			} catch (HttpRecvException e) {
				throw new RuntimeException("http recv error");
			} catch (CookieException e) {
				throw new RuntimeException("http cookie error");
			}
		}
	}
	
	/**
	 * t@CƂĎgȂJbg܂B
	 * 
	 * @since 2.70
	 * @param p_src ̃t@C
	 * @return ϊ̃t@C
	 */
	private static String convFileName(String p_src) {
		String returnValue = p_src;
		returnValue = returnValue.replace("/" , "");
		returnValue = returnValue.replace("\\", "");
		returnValue = returnValue.replace(":" , "");
		returnValue = returnValue.replace("*" , "");
		returnValue = returnValue.replace("?" , "");
		returnValue = returnValue.replace("\"", "");
		returnValue = returnValue.replace("<" , "");
		returnValue = returnValue.replace(">" , "");
		returnValue = returnValue.replace("|" , "");
		return returnValue;
	}

}
