/**
 * Copyright (C) 2008-2011 RobotBrain. All Rights Reserved.
 * ̃vO̓t[\tgEFAłBȂ͂t[\tgEFAc
 * ɂĔsꂽGNU򓙈ʌOpo[W3(LGPLv3)߂
 * ōĔЕz܂͉ς邱Ƃł܂B
 * ̃vO͗Lpł邱ƂĔЕz܂S̖ۏ؂łB
 * Ɖ\̕ۏ؂ړIւ̓ḰAOɎꂽ̂܂ߑS݂
 * BڂGNU򓙈ʌOpo[W3(LGPLv3)B
 * Ȃ͂̃vOƋɁAGNU򓙈ʌOpo[W3(LGPLv3)
 * Rs[ꕔ󂯎Ă͂łB
 * 󂯎ĂȂ<http://www.gnu.org/licenses/>B
 */
package jp.robotbrain.signal;

import jp.robotbrain.framework.Gene;
import jp.robotbrain.framework.GeneList;
import jp.robotbrain.framework.GeneDefaultLabelList;
import jp.robotbrain.framework.GeneListException;
import jp.robotbrain.signal.CandleStickList;
import jp.robotbrain.signal.StochasticsList;

/**
 * XgLXeBNXXgXg[
 * 
 * @since 1.00
 * @author Copyright (C) 2008-2011 <a href="http://robotbrain.jp">
 * RobotBrain.</a> All Rights Reserved.
 */
@TypeIndexStream("StochasticsList")
@InputComponentList(values={"@CandleStickList"})
@GeneDefaultLabelList(values={"ccountRange","pcountD"})
public class StochasticsListStream extends IndexStream {

	/**
	 * VAo[WID
	 *  
	 * @since 1.00
	 */
	private static final long serialVersionUID = 1L;

	/**
	 * XgLXeBNXXg
	 * 
	 * @since 1.00
	 */
	private final StochasticsList m_stochasticsList;
	
	/**
	 * StochasticsListStream𐶐܂B
	 * 
	 * @since 1.00
	 * @param p_label x
	 * @param p_geneList p[^Xg
	 * @param p_ccountRangeLabel lZo邽߂Ɏg[\Ñp[^x
	 * @param p_pcountDLabel %DSlow%DZo邽߂Ɏg|Cg̃p[^x
	 */
	public StochasticsListStream(String p_label, GeneList p_geneList, String p_ccountRangeLabel, 
			String p_pcountDLabel) throws GeneListException, IndexStreamException {
		super(p_label);
		// p[^̎擾
		Gene ccountRangeGene = p_geneList.getGene(p_ccountRangeLabel);
		Gene pcountDGene = p_geneList.getGene(p_pcountDLabel);
		// XgLXeBNXC̐
		int ccountRange = ccountRangeGene.getIntValue();
		int pcountD = pcountDGene.getIntValue();
		m_stochasticsList = new StochasticsList(ccountRange, pcountD);
		// RXgvZ
		int cost = Math.max(ccountRange, pcountD);
		setDestinationMaxCost(cost);
		// eNjJwW̓|[gݒ
		getPortList().add("@CandleStickList",cost);
	}
	
	/* ( Javadoc)
	 * @see jp.robotbrain.signal.IndexStream#notifyIndexSub()
	 */
	@Override
	public void notifyIndexSub() throws IndexStreamException {
		// eNjJwW̓|[g擾
		IndexStreamPort port = getPortList().get("@CandleStickList");
		// CX^X`FbN
		if (!(port.getIndexStream().getValues() instanceof CandleStickList)) {
			throw new IndexStreamException("Instance Error");
		}
		// IuWFNgǉ
		m_stochasticsList.addObject((CandleStickList)port.getIndexStream().getValues());
		// ̃eNjJwWɒʒm
		notifyIndexNext();
	}

	/**
	 * XgLXeBNXXgԂ܂B
	 * 
	 * @since 1.00
	 * @return XgLXeBNXXg
	 */
	@Override
	public StochasticsList getValues() {
		return m_stochasticsList;
	}
	
	/* ( Javadoc)
	 * @see jp.robotbrain.signal.IndexStream#economizeCapacity()
	 */
	@Override
	public void economizeCapacity() {
		m_stochasticsList.setCapacity(getDestinationMaxCost());
	}

}
