/**
 * Copyright (C) 2008-2009 RobotBrain. All Rights Reserved.
 * ̃vO̓t[\tgEFAłBȂ͂t[\tgEFAc
 * ɂĔsꂽGNU򓙈ʌOpo[W3(LGPLv3)߂
 * ōĔЕz܂͉ς邱Ƃł܂B
 * ̃vO͗Lpł邱ƂĔЕz܂S̖ۏ؂łB
 * Ɖ\̕ۏ؂ړIւ̓ḰAOɎꂽ̂܂ߑS݂
 * BڂGNU򓙈ʌOpo[W3(LGPLv3)B
 * Ȃ͂̃vOƋɁAGNU򓙈ʌOpo[W3(LGPLv3)
 * Rs[ꕔ󂯎Ă͂łB
 * 󂯎ĂȂ<http://www.gnu.org/licenses/>B
 */
package jp.robotbrain.html;

import java.io.PrintStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;

/**
 * htmlɊ܂܂Ăform̏ێNX
 * 
 * @since 1.00
 * @author Copyright (C) 2008-2009 <a href="http://robotbrain.jp">
 * RobotBrain.</a> All Rights Reserved.
 */
public class HtmlForm implements Serializable {

	/**
	 * VAo[Whc
	 * 
	 * @since 1.00
	 */
	private static final long serialVersionUID = 1L;

	/**
	 * name
	 * 
	 * @since 1.00
	 */
	private String m_name;

	/**
	 * method
	 * 
	 * @since 1.00
	 */
	private String m_method;
	
	/**
	 * action
	 * 
	 * @since 1.00
	 */
	private String m_action;
	
	/**
	 * input^ÕXg
	 * 
	 * @since 1.00
	 */
	private HtmlInputList m_htmlInputList;

	/**
	 * select^ÕXg
	 * 
	 * @since 1.00
	 */
	private HtmlSelectList m_htmlSelectList;
	
	/**
	 * HtmlForm𐶐܂B
	 * 
	 * @since 1.00
	 */
	public HtmlForm() {
	}
	
	/**
	 * nameݒ肵܂B
	 * 
	 * @since 1.00
	 * @param p_name name
	 */
	public void setName(String p_name) {
		m_name = p_name;
	}

	/**
	 * nameԂ܂B
	 * 
	 * @since 1.00
	 * @return name
	 */
	public String getName() {
		return m_name;
	}

	/**
	 * methodɕϊĐݒ肵܂B
	 * 
	 * @since 1.00
	 * @param p_method method
	 */
	public void setMethod(String p_method) {
		m_method = p_method.toLowerCase();
	}

	/**
	 * methodԂ܂B
	 * 
	 * @since 1.00
	 * @return method
	 */
	public String getMethod() {
		return m_method;
	}
	
	/**
	 * actionݒ肵܂B
	 * 
	 * @since 1.00
	 * @param p_action action
	 */
	public void setAction(String p_action) {
		m_action = p_action;
	}

	/**
	 * actionԂ܂B
	 * 
	 * @since 1.00
	 * @return action
	 */
	public String getAction() {
		return m_action;
	}

	/**
	 * input^ÕXgݒ肵܂B
	 * 
	 * @since 1.00
	 * @param p_htmlInputList input^ÕXg
	 */
	public void setHtmlInputList(HtmlInputList p_htmlInputList) {
		m_htmlInputList = p_htmlInputList;
	}

	/**
	 * input^ÕXgԂ܂B
	 * 
	 * @since 1.00
	 * @return input^ÕXg
	 */
	public HtmlInputList getHtmlInputList() {
		return m_htmlInputList;
	}
	/**
	 * select^ÕXgݒ肵܂B
	 * 
	 * @since 1.00
	 * @param p_htmlSelectList select^ÕXg
	 */
	public void setHtmlSelectList(HtmlSelectList p_htmlSelectList) {
		m_htmlSelectList = p_htmlSelectList;
	}

	/**
	 * select^ÕXgԂ܂B
	 * 
	 * @since 1.00
	 * @return select^ÕXg
	 */
	public HtmlSelectList getHtmlSelectList() {
		return m_htmlSelectList;
	}

	/**
	 * form̍\vf̓ew肵o̓Xg[ɏo͂܂B
	 * 
	 * @since 1.00
	 * @param p_out o̓Xg[
	 */
	public void print(PrintStream p_out) {
		p_out.println(m_name+"\t"+m_method+"\t"+m_action);
		p_out.println("id\ttype\tname\tvalue\tselected");
		m_htmlInputList.print(p_out);
		m_htmlSelectList.print(p_out);
	}

	/**
	 * form̍\vfNG𐶐܂B
	 * 
	 * @since 1.00
	 * @param p_charset GR[hۂ̕Zbgw肵܂B
	 * @see <a href=
	 * "http://java.sun.com/javase/ja/6/docs/ja/technotes/guides/intl/encoding.doc.html">
	 * Zbg</a>
	 * @return NG
	 * @throws HtmlFormException NG̐Ɏsꍇ
	 * @throws UnsupportedEncodingException NG̃GR[hɎsꍇ
	 */
	public String createQueryString(String p_charset) throws HtmlFormException, UnsupportedEncodingException {
		String returnValue = m_htmlInputList.createQueryString(p_charset) + 
			m_htmlSelectList.createQueryString(p_charset);
		returnValue = returnValue.substring(1);
		return returnValue;
	}
	
	/**
	 * w肳ꂽformƌ`mF܂B
	 * 
	 * @since 1.00
	 * @param p_other form
	 * @return w肳ꂽformƌ`ꍇtrueԂ܂B
	 */
	public boolean equalsFormat(HtmlForm p_other) {
		if (!getName().equals(p_other.getName())) return false;
		if (!getMethod().equals(p_other.getMethod())) return false;
		if (!getAction().equals(p_other.getAction())) return false; 
		if (!getHtmlInputList().equalsFormat(p_other.getHtmlInputList())) return false;
		if (!getHtmlSelectList().equalsFormat(p_other.getHtmlSelectList())) return false;
		return true;	
	}
	
}
