/**
 * Copyright (C) 2010 RobotBrain. All Rights Reserved.
 * ̃vO̓t[\tgEFAłBȂ͂t[\tgEFAc
 * ɂĔsꂽGNU򓙈ʌOpo[W3(LGPLv3)߂
 * ōĔЕz܂͉ς邱Ƃł܂B
 * ̃vO͗Lpł邱ƂĔЕz܂S̖ۏ؂łB
 * Ɖ\̕ۏ؂ړIւ̓ḰAOɎꂽ̂܂ߑS݂
 * BڂGNU򓙈ʌOpo[W3(LGPLv3)B
 * Ȃ͂̃vOƋɁAGNU򓙈ʌOpo[W3(LGPLv3)
 * Rs[ꕔ󂯎Ă͂łB
 * 󂯎ĂȂ<http://www.gnu.org/licenses/>B
 */
package jp.robotbrain.common;

import java.util.ArrayList;

import jp.robotbrain.common.TextFile;

/**
 * CSVt@CǂݏNX
 * 
 * @since 2.33
 * @author Copyright (C) 2010 <a href="http://robotbrain.jp">
 * RobotBrain.</a> All Rights Reserved.
 */
public class CsvFile {

	/**
	 * CSV̓e
	 * 
	 * @since 2.33
	 */
	private String m_value;

	/**
	 * CsvFile𐶐܂B
	 * 
	 * @since 2.33
	 */
	public CsvFile() {
		m_value = "";
	}
	
	/**
	 * CsvFile𐶐܂B
	 * 
	 * @since 2.33
	 * @param p_value CSV̓e
	 */
	public CsvFile(String p_value) {
		m_value = p_value;
	}
	
	/**
	 * CSV̓eԂ܂B
	 * 
	 * @since 2.33
	 * @return CSV̓e
	 */
	public String getValue() {
		return m_value;
	}

	/**
	 * CSV̓eݒ肵܂B
	 * 
	 * @since 2.33
	 * @param p_value CSV̓e
	 */
	public void setValue(String p_value) {
		m_value = p_value;
	}
	
	/**
	 * CSVɍsǉ܂B
	 * 
	 * @since 2.33
	 * @param p_line CSV̍s
	 */
	public void append(String p_line) {
		m_value = m_value + p_line + TextFile.LSP;
	}

	/**
	 * CSVɍsǉ܂B
	 * 
	 * @since 2.33
	 * @param p_line CSV̍sBeڂzɓēn܂B
	 */
	public void append(String[] p_line) {
		StringBuilder s = new StringBuilder();
		for (int i=0;i<p_line.length;i++) {
			if (i==0)
				s.append(p_line[i]);
			else 
				s.append("," + p_line[i]);
		}
		m_value = m_value + s.toString() + TextFile.LSP;
	}
	
	/**
	 * CSV̌㕔XgԂ܂B
	 * 
	 * @since 2.33
	 * @param p_count CSV̌㕔s𒊏o邩w肵܂B
	 * @return CSV̌㕔Xg
	 */
	public CsvFile getTail(int p_count) {
		String[] lines = m_value.toString().split("\n|\r\n");
		if (lines.length<p_count) return new CsvFile(m_value);
		StringBuilder returnValue = new StringBuilder();
		for (int i=lines.length-p_count;i<lines.length;i++) {
			returnValue.append(lines[i]+TextFile.LSP);
		}
		return new CsvFile(returnValue.toString());
	}

	/**
	 * CSVArrayList`ŕԂ܂B
	 * 
	 * @since 2.33
	 * @return CSVArrayList`
	 */
	public ArrayList<String[]> toArrayList() {
		ArrayList<String[]> returnValue = new ArrayList<String[]>();
		String[] lines = m_value.toString().split("\n|\r\n");
		for (String line: lines) {
			returnValue.add(line.split(","));
		}
		return returnValue;
	}
	
	/**
	 * CSV̓et@Cɏo͂܂B
	 * 
	 * @since 2.33
	 * @param p_filePath o̓t@C̃pX
	 * @param p_charset Zbg
	 * @see <a href=
	 * "http://java.sun.com/javase/ja/6/docs/ja/technotes/guides/intl/encoding.doc.html">Zbg</a>
	 */
	public void save(String p_filePath, String p_charset) {
		TextFile f = new TextFile(p_filePath, p_charset);
		f.write(m_value.toString(), false);
	}

	/**
	 * CSV̓et@C͂܂B
	 * 
	 * @since 2.33
	 * @param p_filePath ̓t@C̃pX
	 * @param p_charset Zbg
	 * @see <a href=
	 * "http://java.sun.com/javase/ja/6/docs/ja/technotes/guides/intl/encoding.doc.html">Zbg</a>
	 */
	public void load(String p_filePath, String p_charset) {
		TextFile f = new TextFile(p_filePath, p_charset);
		m_value = f.read();
	}
	
}
