/**
 * Copyright (C) 2012 RobotBrain. All Rights Reserved.
 * ̃vO̓t[\tgEFAłBȂ͂t[\tgEFAc
 * ɂĔsꂽGNU򓙈ʌOpo[W3(LGPLv3)߂
 * ōĔЕz܂͉ς邱Ƃł܂B
 * ̃vO͗Lpł邱ƂĔЕz܂S̖ۏ؂łB
 * Ɖ\̕ۏ؂ړIւ̓ḰAOɎꂽ̂܂ߑS݂
 * BڂGNU򓙈ʌOpo[W3(LGPLv3)B
 * Ȃ͂̃vOƋɁAGNU򓙈ʌOpo[W3(LGPLv3)
 * Rs[ꕔ󂯎Ă͂łB
 * 󂯎ĂȂ<http://www.gnu.org/licenses/>B
 */
package jp.robotbrain.tools;

import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Scanner;

import jp.robotbrain.common.Location;
import jp.robotbrain.common.TextFile;
import jp.robotbrain.common.UtilDateTime;
import jp.robotbrain.common.UtilFile;
import jp.robotbrain.common.UtilString;
import jp.robotbrain.net.CookieException;
import jp.robotbrain.net.HttpRecvException;
import jp.robotbrain.net.HttpSendException;
import jp.robotbrain.net.Web;

/**
 * URLW͂Ŏ󂯎ăeLXgt@C_E[hNX<br>
 * ltJEgAbvă_E[h邱Ƃ\<br>
 * @EľJԂw<br>
 * @@&lt;N:l͈̔,<a href="http://docs.oracle.com/javase/jp/6/api/java/text/DecimalFormat.html"></a>&gt;<br>
 * @@ij<br>
 * @@http://robotbrain.jp/&lt;N:2-4,#0&gt;.html<br>
 * @@L̗̏ꍇAȉ̂悤URL̃XgӖ<br>
 *@@ http://robotbrain.jp/2.html<br>
 *@@ http://robotbrain.jp/3.html<br>
 *@@ http://robotbrain.jp/4.html<br>
 * @EťJԂw<br>
 * @@&lt;N:t͈̔́iyyyymmdd`j,<a href="http://docs.oracle.com/javase/jp/6/api/java/text/SimpleDateFormat.html"></a>&gt;<br>
 * @@ij<br>
 * @@http://robotbrain.jp/&lt;D:20120131-20120202,yyyy-MM-dd&gt;.html<br>
 * @@L̗̏ꍇAȉ̂悤URL̃XgӖ<br>
 *@@ http://robotbrain.jp/2012-01-31.html<br>
 *@@ http://robotbrain.jp/2012-02-01.html<br>
 *@@ http://robotbrain.jp/2012-02-02.html<br>
 * 
 * @since 2.70
 * @author Copyright (C) 2012 <a href="http://robotbrain.jp">
 * RobotBrain.</a> All Rights Reserved.
 */
public class WebDl {

	/**
	 * W͂URL̃t@C_E[h܂B
	 * 
	 * @since 2.70
	 * @param args [0]_E[ht@Ci[tH_̃pX<br>
	 * @@@@@[1]Ñt@C̕Zbg
	 * @see <a href=
	 * "http://docs.oracle.com/javase/7/docs/technotes/guides/intl/encoding.doc.html">Zbg</a>
	 */
	public static void main(String[] args) {
		// R}hC
		if (args.length<=0) {
			throw new RuntimeException("args length error");
		}
		// iK{j
		String destFolderPath = args[0];
		if (!UtilFile.isExists(destFolderPath)){
			throw new RuntimeException("args[0] folder is not exist: " + args[0]);
		}
		// iCӁj
		String charset = null;
		if (args.length>1) {
			charset = args[1];
		}
		Scanner stdin = new Scanner(System.in);
		try {
			while(stdin.hasNext()) {
				// W͂̓ǂݍ
				String line = stdin.nextLine();
				// uURL + TabR[h + Nv̌`œĂ 
				String[] fields = line.split("\t");
				if (fields==null) continue;
				if (fields.length<=0) continue;
				String url = fields[0];
				// JԂ̔o
				ArrayList<String>dirList = extractDateList(url);
				if (dirList.size()<=0) {
					dirList = extractNumberList(url);
				}
				// _E[h
				if (dirList.size()>0) {
					// JԂ
					for (String dir: dirList) {
						String convUrl = url.replaceFirst("<.+?>", dir);
						download(convUrl,charset,destFolderPath);
					}
				} else {
					// JԂȂ
					download(url,charset,destFolderPath);
				}
			}
		} finally {
			stdin.close();
		}
	}
	
	/**
	 * t@CƂĎgȂJbg܂B
	 * 
	 * @since 2.70
	 * @param p_src ̃t@C
	 * @return ϊ̃t@C
	 */
	private static String convFileName(String p_src) {
		String returnValue = p_src;
		returnValue = returnValue.replace("/" , "");
		returnValue = returnValue.replace("\\", "");
		returnValue = returnValue.replace(":" , "");
		returnValue = returnValue.replace("*" , "");
		returnValue = returnValue.replace("?" , "");
		returnValue = returnValue.replace("\"", "");
		returnValue = returnValue.replace("<" , "");
		returnValue = returnValue.replace(">" , "");
		returnValue = returnValue.replace("|" , "");
		return returnValue;
	}
	
	/**
	 * URLťJԂ𔲂o܂B
	 * 
	 * @since 2.80
	 * @param p_url URL
	 * @return ťJԂ
	 */
	protected static ArrayList<String> extractDateList(String p_url) {
		ArrayList<String> returnValue = new ArrayList<String>();
		String begin = UtilString.findFirstRegexKeyword(p_url, "<D:([0-9]{8})-([0-9]{8}),(.+?)>", 1);
		String end = UtilString.findFirstRegexKeyword(p_url, "<D:([0-9]{8})-([0-9]{8}),(.+?)>", 2);
		String format = UtilString.findFirstRegexKeyword(p_url, "<D:([0-9]{8})-([0-9]{8}),(.+?)>", 3);
		if (!begin.isEmpty() || !end.isEmpty() || !format.isEmpty()) {
			Calendar beginCal = UtilDateTime.parseCalendar(begin);
			Calendar endCal = UtilDateTime.parseCalendar(end);
			for (Calendar c=beginCal;c.compareTo(endCal)<=0;c.add(Calendar.DAY_OF_MONTH,1)) {
				SimpleDateFormat formatter;
				formatter = new SimpleDateFormat(format);
				returnValue.add(formatter.format(c.getTime()));
			}
		}
		return returnValue;
	}

	/**
	 * URL琔ľJԂ𔲂o܂B
	 * 
	 * @since 2.80
	 * @param p_url URL
	 * @return ľJԂ
	 */
	protected static ArrayList<String> extractNumberList(String p_url) {
		ArrayList<String> returnValue = new ArrayList<String>();
		String begin = UtilString.findFirstRegexKeyword(p_url, "<N:([0-9]+?)-([0-9]+?),(.+?)>", 1);
		String end = UtilString.findFirstRegexKeyword(p_url, "<N:([0-9]+?)-([0-9]+?),(.+?)>", 2);
		String format = UtilString.findFirstRegexKeyword(p_url, "<N:([0-9]+?)-([0-9]+?),(.+?)>", 3);
		if (!begin.isEmpty() || !end.isEmpty() || !format.isEmpty()) {
			long beginNum = Long.parseLong(begin);
			long endNum = Long.parseLong(end);
			for (long i=beginNum;i<=endNum;i++) {
				DecimalFormat fmt = new DecimalFormat(format);
				returnValue.add(fmt.format(i));
			}
		}
		return returnValue;
	}
	
	/**
	 * httpł̃_E[h
	 * 
	 * @param p_url URL
	 * @param p_charset Zbg
	 * @param p_destFolderPath _E[ht@Ci[tH_̃pX
	 */
	private static void download(String p_url, String p_charset, String p_destFolderPath) {
		// Zbg擾
		String charset = null;
		if (p_charset==null) {
			// HEAD\bhŎ擾
			charset = Web.getCharSet(p_url);
		} else {
			charset = p_charset;
		}
		if (charset==null) 	{
			throw new RuntimeException("charset error: " + p_charset);
		}
		// URĽƕϊ
		int lasts = p_url.lastIndexOf("/");
		if (lasts<0) return;
		String fileName;
		if (lasts<7 || lasts>=p_url.length()-1) {
			fileName = "index.html";
		} else {
			fileName = p_url.substring(lasts+1);
		}
		// _E[h
		Web web = new Web(p_charset);
		try {
			String html = web.go(p_url);
			TextFile dest = new TextFile(p_destFolderPath + Location.FSP + convFileName(fileName), p_charset);
			dest.write(html, false);
		} catch (HttpSendException e) {
			throw new RuntimeException("http send error: " + p_url);
		} catch (HttpRecvException e) {
			throw new RuntimeException("http recv error: " + p_url);
		} catch (CookieException e) {
			throw new RuntimeException("http cookie error: " + p_url);
		}
	}
	
}
