/**
 * Copyright (C) 2008-2011 RobotBrain. All Rights Reserved.
 * ̃vO̓t[\tgEFAłBȂ͂t[\tgEFAc
 * ɂĔsꂽGNU򓙈ʌOpo[W3(LGPLv3)߂
 * ōĔЕz܂͉ς邱Ƃł܂B
 * ̃vO͗Lpł邱ƂĔЕz܂S̖ۏ؂łB
 * Ɖ\̕ۏ؂ړIւ̓ḰAOɎꂽ̂܂ߑS݂
 * BڂGNU򓙈ʌOpo[W3(LGPLv3)B
 * Ȃ͂̃vOƋɁAGNU򓙈ʌOpo[W3(LGPLv3)
 * Rs[ꕔ󂯎Ă͂łB
 * 󂯎ĂȂ<http://www.gnu.org/licenses/>B
 */
package jp.robotbrain.signal;

import jp.robotbrain.framework.Gene;
import jp.robotbrain.framework.GeneDefaultLabelList;
import jp.robotbrain.framework.GeneList;
import jp.robotbrain.framework.GeneListException;

/**
 * ŒlCXg[
 * 
 * @since 1.02
 * @author Copyright (C) 2008-2011 <a href="http://robotbrain.jp">
 * RobotBrain.</a> All Rights Reserved.
 */
@TypeIndexStream("LiteralLine")
@InputComponentList(values={"@IndexObjectList"})
@GeneDefaultLabelList(values={"literalValue"})
public class LiteralLineStream extends IndexLineStream {

	/**
	 * VAo[WID
	 *  
	 * @since 1.02
	 */
	private static final long serialVersionUID = 1L;

	/**
	 * ŒlC
	 * 
	 * @since 1.02
	 */
	private final LiteralLine m_literalLine;
	
	/**
	 * LiteralLineStream𐶐܂B
	 * 
	 * @since 1.02
	 * @param p_label x
	 * @param p_geneList p[^Xg
	 * @param p_literalValueLabel Œl̃p[^x
	 * @throws GeneListException ݂Ȃp[^xw肵ꍇ
	 */
	public LiteralLineStream(String p_label, GeneList p_geneList, String p_literalValueLabel) throws GeneListException {
		super(p_label);
		// p[^̎擾
		Gene literalValueGene = p_geneList.getGene(p_literalValueLabel);
		// ŒlC̐
		double literalValue = literalValueGene.getDoubleValue();
		m_literalLine = new LiteralLine(literalValue);
		// eNjJwW̓|[gݒ
		getPortList().add("@IndexObjectList",1);
	}
	
	@Override
	public void notifyIndexSub() throws IndexStreamException {
		// eNjJwW̓|[g擾
		IndexStreamPort port = getPortList().get("@IndexObjectList");
		// CX^X`FbN
		if (!(port.getIndexStream().getValues() instanceof IndexObjectList<?>)) {
			throw new IndexStreamException("Instance Error");
		}
		// |Cgǉ
		m_literalLine.addPoint(port.getIndexStream().getValues());
		// ̃eNjJwWɒʒm
		notifyIndexNext();
	}

	/**
	 * ŒlCԂ܂B
	 * 
	 * @since 1.02
	 * @return ŒlC
	 */
	@Override
	public LiteralLine getValues() {
		return m_literalLine;
	}
	
	@Override
	public void economizeMemory() {
		m_literalLine.setCapacity(getDestinationMaxCost());
	}

}
