/**
 * Copyright (C) 2012-2013 RobotBrain. All Rights Reserved.
 * ̃vO̓t[\tgEFAłBȂ͂t[\tgEFAc
 * ɂĔsꂽGNU򓙈ʌOpo[W3(LGPLv3)߂
 * ōĔЕz܂͉ς邱Ƃł܂B
 * ̃vO͗Lpł邱ƂĔЕz܂S̖ۏ؂łB
 * Ɖ\̕ۏ؂ړIւ̓ḰAOɎꂽ̂܂ߑS݂
 * BڂGNU򓙈ʌOpo[W3(LGPLv3)B
 * Ȃ͂̃vOƋɁAGNU򓙈ʌOpo[W3(LGPLv3)
 * Rs[ꕔ󂯎Ă͂łB
 * 󂯎ĂȂ<http://www.gnu.org/licenses/>B
 */
package jp.robotbrain.graph;

import java.util.ArrayList;

import jp.robotbrain.signal.IndexObjectList;

/**
 * OtC̃Xg
 * 
 * @since 2.60
 * @author Copyright (C) 2012 <a href="http://robotbrain.jp">
 * RobotBrain.</a> All Rights Reserved.
 */
public class GraphLayerList implements Cloneable {

	/**
	 * epl
	 * 
	 * @since 2.60
	 */
	private final GraphPanel m_parent;
	
	/**
	 * vf̒ōő̃Cԍ
	 * 
	 * @since 2.60
	 */
	private int m_maxLayerNo;
	
	/**
	 * OtC̃Xg
	 * 
	 * @since 2.60
	 */
	private ArrayList<GraphLayer> m_graphLayerList;
	
	/**
	 * GraphLayerList𐶐܂B
	 * 
	 * @since 2.60
	 * @param p_parent epl
	 */
	public GraphLayerList(GraphPanel p_parent) {
		m_parent = p_parent;
		m_maxLayerNo = -1;
		m_graphLayerList = new ArrayList<GraphLayer>();
	}

	/**
	 * N[쐬܂B
	 * 
	 * @since 2.80
	 * @return CX^X̃N[
	 */
	@Override
	public GraphLayerList clone() {
		GraphLayerList returnValue = new GraphLayerList(m_parent);
		returnValue.m_maxLayerNo = m_maxLayerNo;
		returnValue.m_graphLayerList = new ArrayList<GraphLayer>();
		for (GraphLayer graphLayer: m_graphLayerList) {
			returnValue.m_graphLayerList.add(graphLayer);
		}
		return returnValue;
	}
	
	/**
	 * Cǉ܂B
	 * 
	 * @since 2.60
	 * @param p_name C
	 * @param p_srcList Ot\eNjJwW
	 * @param p_layerNo CԍB
	 *         ̃eNjJwW𓯂Cɏd˂ĕ\ꍇ͓lZbg܂B
	 *         ꃌCԍ̃C͍őlAŏl̓Ƃ܂B
	 *         XgœCԍꍇɏdˍ킹ĕ`悳܂B
	 *         GraphLayerListœCԍAĂKv܂B
	 * @param p_divCount ڐʂ̂悻ŕ`悷邩w肵܂B
	 * @param p_indexScale eNjJwW̏_ȉ̌
	 * @param p_titleBarTopOffset C̏[^Cgo[[܂ł̋
	 * @param p_indexBottomOffset C̉[eNjJwW`GA[܂ł̋
	 * @return ǉC̃CX^X
	 * @throws GraphException C̐Ɏsꍇ
	 */
	public GraphLayer add(String p_name, IndexObjectList<?> p_srcList, int p_layerNo, int p_divCount, int p_indexScale, 
			int p_titleBarTopOffset, int p_indexBottomOffset) throws GraphException {
		GraphLayer returnValue = null;
		if (p_layerNo>m_maxLayerNo) {
			m_maxLayerNo = p_layerNo;
		}
		if (m_graphLayerList.size()<=0) {
			// Xg̍ŏ̗vf̓CC
			returnValue = new GraphLayer(m_parent, p_name, true, p_srcList, p_layerNo, p_divCount, p_indexScale, p_titleBarTopOffset, p_indexBottomOffset);
		} else {
			// QԖڈȍ~̓TuC
			returnValue = new GraphLayer(m_parent, p_name, false, p_srcList, p_layerNo, p_divCount, p_indexScale, p_titleBarTopOffset, p_indexBottomOffset);
		}
		m_graphLayerList.add(returnValue);
		return returnValue;
	}
	
	/**
	 * CԍŖڐ̓ƂB
	 * 
	 * @since 2.60
	 */
	protected void syncRuler() {
		if (m_maxLayerNo<0) return;
		for (int i=0; i<=m_maxLayerNo; i++) {
			// ꃌCԍ̃C̍őlAŏl𓾂
			double vmax = Double.MIN_VALUE;
			double vmin = Double.MAX_VALUE;
			for (GraphLayer layer: m_graphLayerList) {
				if (layer.getLayerNo()==i && layer.isSyncRuler()) {
					if (vmax < layer.getMax()) {
						vmax = layer.getMax();
					}
					if (vmin > layer.getMin()) {
						vmin = layer.getMin();
					}
				}
			}
			// ꃌCԍ̃C͍őlAŏl킹
			for (GraphLayer layer: m_graphLayerList) {
				if (layer.getLayerNo()==i && layer.isSyncRuler()) {
					layer.setMax(vmax);
					layer.setMin(vmin);
				}
			}
		}
	}

	/**
	 * ׂẴC܂B
	 * 
	 * @since 2.80
	 * @throws GraphException C̏Ɏsꍇ
	 */
	public void init() throws GraphException {
		for (GraphLayer layer: m_graphLayerList) {
			layer.init();
		}
	}
	
	/**
	 * OtC̃XgԂ܂B
	 * 
	 * @since 2.60
	 * @return OtC̃Xg
	 */
	protected ArrayList<GraphLayer> getValues() {
		return m_graphLayerList;
	}

	/**
	 * vf̒ōő̃CԍԂ܂B
	 * 
	 * @since 2.80
	 * @return vf̒ōő̃Cԍ
	 */
	public int getMaxLayerNo() {
		return m_maxLayerNo;
	}
	
}
