/**
 * Copyright (C) 2009 RobotBrain. All Rights Reserved.
 * ̃vO̓t[\tgEFAłBȂ͂t[\tgEFAc
 * ɂĔsꂽGNU򓙈ʌOpo[W3(LGPLv3)߂
 * ōĔЕz܂͉ς邱Ƃł܂B
 * ̃vO͗Lpł邱ƂĔЕz܂S̖ۏ؂łB
 * Ɖ\̕ۏ؂ړIւ̓ḰAOɎꂽ̂܂ߑS݂
 * BڂGNU򓙈ʌOpo[W3(LGPLv3)B
 * Ȃ͂̃vOƋɁAGNU򓙈ʌOpo[W3(LGPLv3)
 * Rs[ꕔ󂯎Ă͂łB
 * 󂯎ĂȂ<http://www.gnu.org/licenses/>B
 */
package jp.robotbrain.common;

import java.math.BigDecimal;
import java.text.DecimalFormat;

/**
 * Doublep[eBeB
 * 
 * @since 2.05
 * @author Copyright (C) 2008-2009 <a href="http://robotbrain.jp">
 * RobotBrain.</a> All Rights Reserved.
 */
public class UtilDouble {

	/**
	 * [eBeBNX̂߃RXgN^͌J܂B
	 * 
	 * @since 2.05
	 */
	private UtilDouble() {
	}
	
	/**
	 * œnꂽ񂩂J}A^[R[hAXy[X菜doubleɕϊ܂
	 * 
	 * @since 2.05
	 * @param p_src ϊ
	 * @return ϊ̐l
	 * @throws NumberFormatException lւ̕ϊɎsꍇ
	 */
	public static double parseDouble(String p_src) throws NumberFormatException {
		String s = p_src.replaceAll(",","");
		s = s.replaceAll("\r","");
		s = s.replaceAll("\n","");
		double returnValue = Double.parseDouble(s.trim());
		return returnValue;
	}

	/**
	 * ľܓ܂Bp_src0.015p_scale2w肷0.02Ԃ܂B
	 * 
	 * @since 2.05
	 * @param p_src ľܓO̒l
	 * @param p_scale ľܓ̏_ȉ̌
	 * @return ľܓ̒l
	 */
	public static double round(double p_src, int p_scale) {
		BigDecimal bd = new BigDecimal(String.valueOf(p_src));
		double returnValue = bd.setScale(p_scale, BigDecimal.ROUND_HALF_UP).doubleValue();
		return returnValue;
	}

	/**
	 * ؎̂Ă܂Bp_src0.015p_scale2w肷0.01Ԃ܂B
	 * 
	 * @since 2.60
	 * @param p_src ؎̂đO̒l
	 * @param p_scale ؎̂Č̏_ȉ̌
	 * @return ؎̂Č̒l
	 */
	public static double fix(double p_src, int p_scale) {
		BigDecimal bd = new BigDecimal(String.valueOf(p_src));
		double returnValue = bd.setScale(p_scale, BigDecimal.ROUND_DOWN).doubleValue();
		return returnValue;
	}

	/**
	 * ؏グ܂Bp_src0.014p_scale2w肷0.02Ԃ܂B
	 * 
	 * @since 2.60
	 * @param p_src ؏グO̒l
	 * @param p_scale ؏グ̏_ȉ̌
	 * @return ؏グ̒l
	 */
	public static double ceil(double p_src, int p_scale) {
		BigDecimal bd = new BigDecimal(String.valueOf(p_src));
		double returnValue = bd.setScale(p_scale, BigDecimal.ROUND_UP).doubleValue();
		return returnValue;
	}

	/**
	 * double^̒l𕶎ŕԂ܂Bw`0.00`ɕϊĕԂ܂B
	 * 
	 * @since 2.05
	 * @param p_src ϊ̐l
	 * @param p_scale ϊ̏_ȉ̌
	 * @return w肵doublel̕\
	 */
	public static String format(double p_src, int p_scale) {
		String pattern = "";
		if (p_scale<=0) {
			pattern = "0";
		} else {
			pattern = "0.";
			for (int i=0;i<p_scale;i++) {
				pattern += "0";
			}
		}
		DecimalFormat fmt = new DecimalFormat(pattern);
		return fmt.format(p_src);
	}

	/**
	 * ؂̂liT̔{jԂ܂B
	 * 0  0
	 * 1  5
	 * 2  5
	 * 3  5
	 * 4  5
	 * 5  5
	 * 6  10(Jオ) 
	 * 7  10(Jオ)
	 * 8  10(Jオ)
	 * 9  10(Jオ)
	 * 
	 * @since 2.80
	 * @param p_src ϊl
	 * @return ؂̂liT̔{jB0`9łȂꍇ-1ԂB
	 */
	private static int calcUnit(int p_src) {
		switch (p_src) {
		case 0:
			return 0;
		case 1:
			return 5;
		case 2:
			return 5;
		case 3:
			return 5;
		case 4:
			return 5;
		case 5:
			return 5;
		case 6:
			return 10;
		case 7:
			return 10;
		case 8:
			return 10;
		case 9:
			return 10;
		}
		return -1;
	}

	/**
	 * ̐؂̂liT̔{jԂ܂B
	 * 
	 * @since 2.80
	 * @param p_src ϊl
	 * @param p_headSize 擪Ő؂̂lZo邩w肵܂B
	 * @return ؂̂liT̔{j
	 */
	private static double calcIntUnit(double p_src, int p_headSize) {
		int srcInt = (int)p_src;
		if (String.valueOf(srcInt).length()<=1) {
			return calcUnit(srcInt);
		}
		int tailLength = String.valueOf(srcInt).length() - p_headSize;
		int head = srcInt / ((int)Math.pow(10D,tailLength+1)) * 10;
		int last = (srcInt / (int)Math.pow(10D, tailLength)) % 10;
		return (head + calcUnit(last)) * Math.pow(10D, tailLength) ;
	}
	
	/**
	 * w肵l̏_ȉ̌Ԃ܂B
	 * 
	 * @since 2.80
	 * @param p_value _ȉ̌߂鐔lB10ʈȍ~͐؂̂ĂČvZ܂B
	 * @return _ȉ̌B10ʈȍ~͐؂̂ĂČvZ܂B
	 */
	public static int getScaleLength(double p_src) {
		String src = format(p_src, 10);
		return UtilString.getScaleLength(src);
	}
	
	/**
	 * ؂̂liT̔{jԂ܂B
	 * 
	 * @since 2.80
	 * @param p_src ϊlB10ʈȍ~͐؂̂ĂČvZ܂B
	 * @param p_headSize 擪Ő؂̂lZo邩w肵܂Bꍇ͏̐擪B
	 * @return ؂̂liT̔{jBُ펞-1Ԃ܂B
	 */
	public static double unit(double p_src, int p_headSize) {
		int intSrc = (int)p_src;
		int scaleLength = getScaleLength(p_src);
		double returnValue = -1D;
		if (intSrc>0) {
			// Ő؂̂lvZ
			returnValue = calcIntUnit((int)p_src, 2);
		} else {
			// Ő؂̂lvZ
			if (p_headSize<=0) return returnValue;
			int headSize = (p_headSize>scaleLength) ? scaleLength : p_headSize;
			int srcInt = (int)p_src;
			double srcDecimal = p_src - srcInt;
			// headSizeJグĐ؂悭ɓ؂艺
			int head = (int)(srcDecimal * Math.pow(10D, headSize));
			returnValue = srcInt + calcIntUnit(head, String.valueOf(head).length()) / Math.pow(10D, headSize);
		}
		return returnValue;
	}
	
}
