//	Roast+ License v0.1

//	SIMD

#ifndef __SFJP_OPENMGL_roast_simd_simd_types_HPP__
#define __SFJP_OPENMGL_roast_simd_simd_types_HPP__


#define ROAST_SIMD_TYPE_NULL		(0)
#define ROAST_SIMD_TYPE_NON			(0)
#define ROAST_SIMD_TYPE_NO_USE		(0)
#define ROAST_SIMD_TYPE_NO_SIMD		(0)

#define ROAST_SIMD_TYPE_MMX			(10)

#define ROAST_SIMD_TYPE_SSE_START	(20)
#define ROAST_SIMD_TYPE_SSE1		(20)
#define ROAST_SIMD_TYPE_SSE			(ROAST_SIMD_TYPE_SSE1)
#define ROAST_SIMD_TYPE_SSE2		(21)
#define ROAST_SIMD_TYPE_SSE3		(22)
#define ROAST_SIMD_TYPE_SSE4		(23)
//#define ROAST_SIMD_TYPE_SSE41		(24)
#define ROAST_SIMD_TYPE_SSE41		(ROAST_SIMD_TYPE_SSE4)
#define ROAST_SIMD_TYPE_SSE42		(25)
#define ROAST_SIMD_TYPE_SSE_END		(29)

#define ROAST_SIMD_TYPE_INTEL_AVX	(40)
#define ROAST_SIMD_TYPE_AVX			(ROAST_SIMD_TYPE_INTEL_AVX)

#define ROAST_SIMD_TYPE_INTEL_END	(79)

#define ROAST_SIMD_TYPE_3DNOW		(80)
#define ROAST_SIMD_TYPE_E3DNOW		(81)
//#define ROAST_SIMD_TYPE_3DNOW_PRO	(82)
#define ROAST_SIMD_TYPE_3DNOW_PRO	(ROAST_SIMD_TYPE_SSE)
#define ROAST_SIMD_TYPE_SSE5		(89)

//#define ROAST_SIMD_TYPE_AUTO		(ROAST_SIMD_TYPE_SSE)
//#define ROAST_SIMD_TYPE_DEFAULT		(ROAST_SIMD_TYPE_AUTO)



namespace roast
{
	namespace simd 
	{

		//	SIMDʁiROAST_SIMD_TYPE_`jenumQ
		typedef struct tag_simd_types
		{
			//	SIMD_TYPE_**
			enum {
				SIMD_TYPE_NULL =	ROAST_SIMD_TYPE_NULL,

				SIMD_TYPE_MMX =		ROAST_SIMD_TYPE_MMX,
				SIMD_TYPE_SSE =		ROAST_SIMD_TYPE_SSE,
				SIMD_TYPE_SSE2 =	ROAST_SIMD_TYPE_SSE2,
				SIMD_TYPE_SSE3 =	ROAST_SIMD_TYPE_SSE3,
				SIMD_TYPE_SSE4 =	ROAST_SIMD_TYPE_SSE4,
				SIMD_TYPE_SSE42 =	ROAST_SIMD_TYPE_SSE42,

				SIMD_TYPE_AVX =		ROAST_SIMD_TYPE_AVX,

				SIMD_TYPE_3DNOW =	ROAST_SIMD_TYPE_3DNOW,
				SIMD_TYPE_E3DNOW =	ROAST_SIMD_TYPE_E3DNOW,
				SIMD_TYPE_SSE5 =	ROAST_SIMD_TYPE_SSE5
			};
			enum {
				SIMD_TYPE_NON =			ROAST_SIMD_TYPE_NON,
				SIMD_TYPE_SSE1 =		ROAST_SIMD_TYPE_SSE1,
				SIMD_TYPE_SSE41 =		ROAST_SIMD_TYPE_SSE41,
				SIMD_TYPE_3DNOW_PRO =	ROAST_SIMD_TYPE_3DNOW_PRO
			};

			//	SIMD Types
			enum {
				MMX =		ROAST_SIMD_TYPE_MMX,
				SSE =		ROAST_SIMD_TYPE_SSE,
				SSE2 =		ROAST_SIMD_TYPE_SSE2,
				SSE3 =		ROAST_SIMD_TYPE_SSE3,
				SSE4 =		ROAST_SIMD_TYPE_SSE4,
				SSE42 =		ROAST_SIMD_TYPE_SSE42,

				AVX =		ROAST_SIMD_TYPE_AVX,

				_3DNOW =	ROAST_SIMD_TYPE_3DNOW,
				E3DNOW =	ROAST_SIMD_TYPE_E3DNOW,
				SSE5 =		ROAST_SIMD_TYPE_SSE5
			};
			enum {
				SSE1 =			ROAST_SIMD_TYPE_SSE1,
				SSE41 =			ROAST_SIMD_TYPE_SSE41,
				_3DNOW_PRO =	ROAST_SIMD_TYPE_3DNOW_PRO
			};
		} simd_types;
		
	}
}

#endif//__SFJP_OPENMGL_roast_simd_simd_types_HPP__
