<?php
/**
 * アップグレードFlavor画面(6)クラス
 *
 * アップグレードFlavor画面(6)を実現するためのクラス
 *
 * @package   risoluto
 * @author    Risoluto Developers
 * @license   http://opensource.org/licenses/bsd-license.php new BSD license
 * @copyright (C) 2008-2012 Risoluto Developers / All Rights Reserved.
 */

  /**
   * 基底クラス
   */
  require_once( 'upgrade_base.inc' );

  class page05 extends upgrade_base
  {
    //------------------------------------------------------//
    // クラス変数定義
    //------------------------------------------------------//
    /**
     * チェック情報格納用変数
     * @access private
     * @var    array
     */
    private $checklist;
    /**
     * チェック結果格納用変数
     * @access private
     * @var    array
     */
    private $checkresult;
    /**
     * エラー発生状況格納用変数
     * @access private
     * @var    boolean
     */
    private $errStatus;

    //------------------------------------------------------//
    // クラスメソッド定義
    //------------------------------------------------------//
    /**
     * コンストラクタメソッド
     *
     * コンストラクタメソッド
     *
     * @param     void なし
     * @return    void なし
     */
    public function __construct()
    {
    } // end of function:__construct()

    /**
     * クローンメソッド
     *
     * クローンメソッド
     *
     * @param     void なし
     * @return    void なし
     */
    public function __clone()
    {
    } // end of function:__clone()

    /**
     * modelメソッド（モデル）
     *
     * データ取得等のモデルに相当する部分の処理を行う
     *
     * @param     void なし
     * @return    boolean ファンクション実行結果（ true：正常終了 / false: 異常終了 ）
     */
    public function model()
    {
      // 前画面のCageが現在のCageと同一でない  or 前画面のActが「page04」 and 「page05」 and 「page06」でない場合、
      // インストーラトップに飛ばす
      $tmp_cage      = str_replace( DIRECTORY_SEPARATOR, '.', $this->obj_sess->sessLoad( 'lastcage' ) );
      $tmp_cage_self = str_replace( DIRECTORY_SEPARATOR, '.', $this->obj_sess->sessLoad( 'currentcage' ) );
      $tmp_act       = $this->obj_sess->sessLoad( 'lastact'  );
      if ( $tmp_cage != $tmp_cage_self or ( $tmp_act != 'page04' and $tmp_act != 'page05' and $tmp_act != 'page06' ) )
      {
        $this->obj_util->redirectTo( 'upgrade', $tmp_cage_self );
        return false;
      } // end of if

      // 配置対象をセットする
      // 他に配置する対象があれば、この配列に加えてください。
      // target: 対象ファイル名 / destination: 配置先のパス/パーミッション/オーナ名/グループ名） / 
      // operation: 操作の内容(copy/move/unlink/mkdir/rmdir)
      clearstatcache();
      $tmp_base = RISOLUTO_USERLAND . $this->obj_sess->sessLoad( 'currentcage' );
      $this->filelist = array(
                                array(
                                       'target'      => $tmp_base . '/file/simplepage_ckeditor.js'
                                     , 'destination' => RISOLUTO_DOCROOT . '/js/' . $this->target . '_ckeditor.js'
                                     , 'operation'   => 'copy'
                                     , 'pass'        => ( !file_exists( $tmp_base . '/file/simplepage_ckeditor.js' ) ? true : false )
                                     )
                              , array(
                                       'target'      => $tmp_base . '/file/simplepage_version'
                                     , 'destination' => RISOLUTO_CONF . $this->target . '_version'
                                     , 'operation'   => 'copy'
                                     , 'pass'        => ( !file_exists( $tmp_base . '/file/simplepage_version' ) ? true : false )
                                     )
                              , array(
                                       'target'      => $tmp_base . '/file/simplepage.ini'
                                     , 'destination' => RISOLUTO_CONF . $this->target . '.ini'
                                     , 'operation'   => 'copy'
                                     , 'pass'        => ( !file_exists( $tmp_base . '/file/simplepage.ini' ) ? true : false )
                                     )
                              , array(
                                       'target'      => $tmp_base . '/file/00004_simplepage.tpl'
                                     , 'destination' => RISOLUTO_USERLAND . 'admin/menu/00004_' . $this->target . '.tpl'
                                     , 'operation'   => 'copy'
                                     , 'pass'        => ( !file_exists( $tmp_base . '/file/0004_simplepage.tpl' ) ? true : false )
                                     )
                              , array(
                                       'target'      => $tmp_base . '/file/AUTHORS'
                                     , 'destination' => RISOLUTO_USERLAND . $this->target . '/AUTHORS'
                                     , 'operation'   => 'copy'
                                     , 'pass'        => ( !file_exists( $tmp_base . '/file/AUTHORS' ) ? true : false )
                                     )
                              , array(
                                       'target'      => $tmp_base . '/file/LICENSE'
                                     , 'destination' => RISOLUTO_USERLAND . $this->target . '/LICENSE'
                                     , 'operation'   => 'copy'
                                     , 'pass'        => ( !file_exists( $tmp_base . '/file/LICENSE' ) ? true : false )
                                     )
                              , array(
                                       'target'      => $tmp_base . '/file/pageadd_complete.php'
                                     , 'destination' => RISOLUTO_USERLAND . $this->target . '/pageadd_complete.php'
                                     , 'operation'   => 'copy'
                                     , 'pass'        => ( !file_exists( $tmp_base . '/file/pageadd_complete.php' ) ? true : false )
                                     )
                              , array(
                                       'target'      => $tmp_base . '/file/pageadd_complete.tpl'
                                     , 'destination' => RISOLUTO_USERLAND . $this->target . '/pageadd_complete.tpl'
                                     , 'operation'   => 'copy'
                                     , 'pass'        => ( !file_exists( $tmp_base . '/file/pageadd_complete.tpl' ) ? true : false )
                                     )
                              , array(
                                       'target'      => $tmp_base . '/file/pageadd_confirm.php'
                                     , 'destination' => RISOLUTO_USERLAND . $this->target . '/pageadd_confirm.php'
                                     , 'operation'   => 'copy'
                                     , 'pass'        => ( !file_exists( $tmp_base . '/file/pageadd_confirm.php' ) ? true : false )
                                     )
                              , array(
                                       'target'      => $tmp_base . '/file/pageadd_confirm.tpl'
                                     , 'destination' => RISOLUTO_USERLAND . $this->target . '/pageadd_confirm.tpl'
                                     , 'operation'   => 'copy'
                                     , 'pass'        => ( !file_exists( $tmp_base . '/file/pageadd_confirm.tpl' ) ? true : false )
                                     )
                              , array(
                                       'target'      => $tmp_base . '/file/pageadd_entry.php'
                                     , 'destination' => RISOLUTO_USERLAND . $this->target . '/pageadd_entry.php'
                                     , 'operation'   => 'copy'
                                     , 'pass'        => ( !file_exists( $tmp_base . '/file/pageadd_entry.php' ) ? true : false )
                                     )
                              , array(
                                       'target'      => $tmp_base . '/file/pageadd_entry.tpl'
                                     , 'destination' => RISOLUTO_USERLAND . $this->target . '/pageadd_entry.tpl'
                                     , 'operation'   => 'copy'
                                     , 'pass'        => ( !file_exists( $tmp_base . '/file/pageadd_entry.tpl' ) ? true : false )
                                     )
                              , array(
                                       'target'      => $tmp_base . '/file/pagedel_complete.php'
                                     , 'destination' => RISOLUTO_USERLAND . $this->target . '/pagedel_complete.php'
                                     , 'operation'   => 'copy'
                                     , 'pass'        => ( !file_exists( $tmp_base . '/file/pagedel_complete.php' ) ? true : false )
                                     )
                              , array(
                                       'target'      => $tmp_base . '/file/pagedel_complete.tpl'
                                     , 'destination' => RISOLUTO_USERLAND . $this->target . '/pagedel_complete.tpl'
                                     , 'operation'   => 'copy'
                                     , 'pass'        => ( !file_exists( $tmp_base . '/file/pagedel_complete.tpl' ) ? true : false )
                                     )
                              , array(
                                       'target'      => $tmp_base . '/file/pagedel_confirm.php'
                                     , 'destination' => RISOLUTO_USERLAND . $this->target . '/pagedel_confirm.php'
                                     , 'operation'   => 'copy'
                                     , 'pass'        => ( !file_exists( $tmp_base . '/file/pagedel_confirm.php' ) ? true : false )
                                     )
                              , array(
                                       'target'      => $tmp_base . '/file/pagedel_confirm.tpl'
                                     , 'destination' => RISOLUTO_USERLAND . $this->target . '/pagedel_confirm.tpl'
                                     , 'operation'   => 'copy'
                                     , 'pass'        => ( !file_exists( $tmp_base . '/file/pagedel_confirm.tpl' ) ? true : false )
                                     )
                              , array(
                                       'target'      => $tmp_base . '/file/pagelist.php'
                                     , 'destination' => RISOLUTO_USERLAND . $this->target . '/pagelist.php'
                                     , 'operation'   => 'copy'
                                     , 'pass'        => ( !file_exists( $tmp_base . '/file/pagelist.php' ) ? true : false )
                                     )
                              , array(
                                       'target'      => $tmp_base . '/file/pagelist.tpl'
                                     , 'destination' => RISOLUTO_USERLAND . $this->target . '/pagelist.tpl'
                                     , 'operation'   => 'copy'
                                     , 'pass'        => ( !file_exists( $tmp_base . '/file/pagelist.tpl' ) ? true : false )
                                     )
                              , array(
                                       'target'      => $tmp_base . '/file/pagemod_complete.php'
                                     , 'destination' => RISOLUTO_USERLAND . $this->target . '/pagemod_complete.php'
                                     , 'operation'   => 'copy'
                                     , 'pass'        => ( !file_exists( $tmp_base . '/file/pagemod_complete.php' ) ? true : false )
                                     )
                              , array(
                                       'target'      => $tmp_base . '/file/pagemod_complete.tpl'
                                     , 'destination' => RISOLUTO_USERLAND . $this->target . '/pagemod_complete.tpl'
                                     , 'operation'   => 'copy'
                                     , 'pass'        => ( !file_exists( $tmp_base . '/file/pagemod_complete.tpl' ) ? true : false )
                                     )
                              , array(
                                       'target'      => $tmp_base . '/file/pagemod_confirm.php'
                                     , 'destination' => RISOLUTO_USERLAND . $this->target . '/pagemod_confirm.php'
                                     , 'operation'   => 'copy'
                                     , 'pass'        => ( !file_exists( $tmp_base . '/file/pagemod_confirm.php' ) ? true : false )
                                     )
                              , array(
                                       'target'      => $tmp_base . '/file/pagemod_confirm.tpl'
                                     , 'destination' => RISOLUTO_USERLAND . $this->target . '/pagemod_confirm.tpl'
                                     , 'operation'   => 'copy'
                                     , 'pass'        => ( !file_exists( $tmp_base . '/file/pagemod_confirm.tpl' ) ? true : false )
                                     )
                              , array(
                                       'target'      => $tmp_base . '/file/pagemod_entry.php'
                                     , 'destination' => RISOLUTO_USERLAND . $this->target . '/pagemod_entry.php'
                                     , 'operation'   => 'copy'
                                     , 'pass'        => ( !file_exists( $tmp_base . '/file/pagemod_entry.php' ) ? true : false )
                                     )
                              , array(
                                       'target'      => $tmp_base . '/file/pagemod_entry.tpl'
                                     , 'destination' => RISOLUTO_USERLAND . $this->target . '/pagemod_entry.tpl'
                                     , 'operation'   => 'copy'
                                     , 'pass'        => ( !file_exists( $tmp_base . '/file/pagemod_entry.tpl' ) ? true : false )
                                     )
                              , array(
                                       'target'      => $tmp_base . '/file/pageview.php'
                                     , 'destination' => RISOLUTO_USERLAND . $this->target . '/pageview.php'
                                     , 'operation'   => 'copy'
                                     , 'pass'        => ( !file_exists( $tmp_base . '/file/pageview.php' ) ? true : false )
                                     )
                              , array(
                                       'target'      => $tmp_base . '/file/pageview.tpl'
                                     , 'destination' => RISOLUTO_USERLAND . $this->target . '/pageview.tpl'
                                     , 'operation'   => 'copy'
                                     , 'pass'        => ( !file_exists( $tmp_base . '/file/pageview.tpl' ) ? true : false )
                                     )
                              , array(
                                       'target'      => $tmp_base . '/file/simplepage_base.inc'
                                     , 'destination' => RISOLUTO_USERLAND . $this->target . '/simplepage_base.inc'
                                     , 'operation'   => 'copy'
                                     , 'pass'        => ( !file_exists( $tmp_base . '/file/simplepage_base.inc' ) ? true : false )
                                     )
                             );

      // 処理を行う
      foreach( $this->filelist as $dat )
      {
        if ( $dat[ 'pass' ] )
        {
          continue;
        } // end of if

        // 処理を呼び出す
        $tmp_errflag = $this->obj_util->fileOperator( $dat[ 'operation' ], $dat[ 'target' ], $dat[ 'destination' ] );

        // 処理結果によって、状態を変える
        if ( $tmp_errflag )
        {
          $this->checkresult[] = array(
                                        'operation'   => $dat[ 'operation'   ]
                                      , 'target'      => $dat[ 'target'      ]
                                      , 'destination' => $dat[ 'destination' ]
                                      , 'result'  => 'OK'
                                      );
        } // end of if
        else
        {
          $this->checkresult[] = array(
                                        'operation'   => $dat[ 'operation'   ]
                                      , 'target'      => $dat[ 'target'      ]
                                      , 'destination' => $dat[ 'destination' ]
                                      , 'result'  => 'NG'
                                      );
          $this->errStatus     = 'NG';
        } // end of else
      } // end of foreach

      return true;
    } // end of function:model()

    /**
     * viewメソッド（モデル）
     *
     * テンプレート関連処理等のビューに相当する部分の処理を行う
     *
     * @param     void なし
     * @return    boolean ファンクション実行結果（ true：正常終了 / false: 異常終了 ）
     */
    public function view()
    {
      // ヘッダ情報をセット
      $html_header[ 'robots' ] = 'NOINDEX,NOFOLLOW';
      $html_header[ 'css'    ] = array( './css/common.css' );
      $html_header[ 'title'  ] = 'アップグレードFlavor(5)';

      // アサイン
      $this->smarty->assign ( 'header',    $html_header       );
      $this->smarty->assign ( 'checklist', $this->checkresult );
      $this->smarty->assign ( 'err',       $this->errStatus   );

      $this->smarty->assign ( 'cage',   str_replace( DIRECTORY_SEPARATOR, '.' , $this->obj_sess->sessLoad( 'currentcage' ) ) );

      // 表示
      $this->smarty->display( 'page05.tpl' );

      return true;

    } // end of function:view()

  } // end of class:page05
?>
