{include file='../common/admin_header.tpl'}
<h1>ページ情報変更(編集)</h1>
<form method="POST" action="?cage={$mycage}&amp;act=pagemod_confirm">
 {if      $errMsg == 'empty_body'}
 <p class="warning">
    &gt;&gt;&gt;&nbsp;内容が入力されていません。
 </p>
 {elseif  $errMsg == 'invalid_slug'}
 <p class="warning">
    &gt;&gt;&gt;&nbsp;スラッグの指定が不正です。半角英数字および「.」、「-」、「_」のみで構成されており、255文字以内であることを確認してください。
 </p>
 {elseif  $errMsg == 'onlydigit_slug'}
 <p class="warning">
    &gt;&gt;&gt;&nbsp;数字1～10桁のみで構成されたスラッグは指定できません。
 </p>
 {elseif  $errMsg == 'slug_conflict'}
 <p class="warning">
    &gt;&gt;&gt;&nbsp;指定されたスラッグはすでに使用されています。
 </p>
 {elseif  $errMsg == 'invalid_robot_index'}
 <p class="warning">
    &gt;&gt;&gt;&nbsp;robots(index)の指定が不正です。
 </p>
 {elseif  $errMsg == 'invalid_robot_follow'}
 <p class="warning">
    &gt;&gt;&gt;&nbsp;robots(follow)の指定が不正です。
 </p>
 {elseif  $errMsg == 'invalid_title'}
 <p class="warning">
    &gt;&gt;&gt;&nbsp;titleの指定が不正です。10,000文字以内であることを確認してください。
 </p>
 {elseif  $errMsg == 'invalid_description'}
 <p class="warning">
    &gt;&gt;&gt;&nbsp;descriptionの指定が不正です。10,000文字以内であることを確認してください。
 </p>
 {elseif  $errMsg == 'invalid_keywords'}
 <p class="warning">
    &gt;&gt;&gt;&nbsp;keywordsの指定が不正です。10,000文字以内であることを確認してください。
 </p>
 {elseif  $errMsg == 'invalid_author'}
 <p class="warning">
    &gt;&gt;&gt;&nbsp;authorの指定が不正です。10,000文字以内であることを確認してください。
 </p>
 {elseif  $errMsg == 'invalid_javascript'}
 <p class="warning">
    &gt;&gt;&gt;&nbsp;javascriptの指定が不正です。10,000文字以内であることを確認してください。
 </p>
 {elseif  $errMsg == 'invalid_css'}
 <p class="warning">
    &gt;&gt;&gt;&nbsp;cssの指定が不正です。10,000文字以内であることを確認してください。
 </p>
 {elseif  $errMsg == 'invalid_favicon'}
 <p class="warning">
    &gt;&gt;&gt;&nbsp;faviconの指定が不正です。10,000文字以内であることを確認してください。
 </p>
 {/if}
 <p>
  下記に変更後のページの情報を入力してください。
 </p>
 <table>
  <tr>
   <th>内容</th>
   <td><textarea name="body" cols="100" rows="50">{$entered_body}</textarea></td>
{if $is_ckeditor}
  <script type="text/javascript">
    CKEDITOR.replace( 'body', { customConfig : '../js/{$mycage}_ckeditor.js' });
  </script>
{/if}
  </tr>
  <tr>
   <th width="10%">スラッグ<br />（URL用のページ名）</th>
   <td width="90%"><input name="slug" type="text" value="{$entered_slug}"  maxlength="255" size="80" /></td>
  </tr>
  <tr>
   <th>robots(index)の設定</th>
   <td>
    <select name="robot_index">
     {if $entered_headerinfo.robot_index == 0}
     <option value="0" selected="selected">noindex</option>
     {else}
      <option value="0">noindex</option>
     {/if}
     {if $entered_headerinfo.robot_index == 1}
     <option value="1" selected="selected">index</option>
     {else}
     <option value="1">index</option>
     {/if}
    </select>
   </td>
  </tr>
  <tr>
   <th>robots(follow)の設定</th>
   <td>
    <select name="robot_follow">
     {if $entered_headerinfo.robot_follow == 0}
     <option value="0" selected="selected">nofollow</option>
     {else}
      <option value="0">nofollow</option>
     {/if}
     {if $entered_headerinfo.robot_follow == 1}
     <option value="1" selected="selected">follow</option>
     {else}
     <option value="1">follow</option>
     {/if}
    </select>
   </td>
  </tr>
  <tr>
   <th>titleの設定</th>
   <td><textarea name="title" cols="50" rows="10">{$entered_headerinfo.title}</textarea></td>
  </tr>
  <tr>
   <th>descriptionに設定する内容</th>
   <td><textarea name="description" cols="50" rows="10">{$entered_headerinfo.description}</textarea></td>
  </tr>
  <tr>
   <th>keywordsに設定する内容</th>
   <td><textarea name="keywords" cols="50" rows="10">{$entered_headerinfo.keywords}</textarea></td>
  </tr>
  <tr>
   <th>authorに設定する内容</th>
   <td><textarea name="author" cols="50" rows="10">{$entered_headerinfo.author}</textarea></td>
  </tr>
  <tr>
   <th>javascriptに設定する内容</th>
   <td><textarea name="javascript" cols="50" rows="10">{$entered_headerinfo.javascript}</textarea></td>
  </tr>
  <tr>
   <th>cssに設定する内容</th>
   <td><textarea name="css" cols="50" rows="10">{$entered_headerinfo.css}</textarea></td>
  </tr>
  <tr>
   <th>faviconに設定する内容</th>
   <td><textarea name="favicon" cols="50" rows="10">{$entered_headerinfo.favicon}</textarea></td>
  </tr>
 </table>
 <input name="pageid" type="hidden" value="{$entered_pageid}" />
 <input type="button" value="一覧に戻る" onClick="location.href='?cage={$mycage}&amp;act=pagelist'"/>
 <input type="submit" value="入力内容の確認" />
 <input type="reset"  value="入力内容をリセットする" />
</form>
{include file='../common/admin_footer.tpl'}
