<?php
/**
 * カテゴリ情報変更確認画面クラス
 *
 * カテゴリ情報変更確認画面を実現するためのクラス
 *
 * @package   simpleblog
 * @author    Risoluto Developers
 * @license   http://opensource.org/licenses/bsd-license.php new BSD license
 * @copyright (C) 2008-2011 Risoluto Developers / All Rights Reserved.
 */

  /**
   * 基底クラス
   */
  require_once( "simpleblog_base.inc" );

  class categorymod_confirm extends simpleblog_base
  {
    //------------------------------------------------------//
    // クラス変数定義
    //------------------------------------------------------//
    /**
     * ユーティリティクラスインスタンスを保持する変数
     * @access private
     * @var    object
     */
    private $obj_conf;
    /**
     * 取得データを保持する変数
     * @access private
     * @var    object
     */
    private $gotDat;

    //------------------------------------------------------//
    // クラスメソッド定義
    //------------------------------------------------------//
    /**
     * コンストラクタメソッド
     *
     * コンストラクタメソッド
     *
     * @param     void なし
     * @return    void なし
     */
    public function __construct()
    {
    } // end of function:__construct()

    /**
     * クローンメソッド
     *
     * クローンメソッド
     *
     * @param     void なし
     * @return    void なし
     */
    public function __clone()
    {
    } // end of function:__clone()

    /**
     * modelメソッド（モデル）
     *
     * データ取得等のモデルに相当する部分の処理を行う
     *
     * @param     void なし
     * @return    boolean ファンクション実行結果（ true：正常終了 / false: 異常終了 ）
     */
    public function model()
    {
      // 必要なインスタンスを生成
      $this->obj_conf = new RisolutoConf();
      $this->obj_conf->parse( RISOLUTO_CONF . $this->mycage . '.ini' );

      // スーパバイザセッション又はアドミンセッションが存在しない場合は、
      // ログイン画面に遷移する
      if ( ! $this->obj_util->is_Admin() )
      {
        $this->obj_util->redirectTo( $this->obj_adminconf->get( 'COMMON', 'login_act'  )
                                   , $this->obj_adminconf->get( 'COMMON', 'login_cage' ) );
        return false;
      } // end of if

      // 前画面のCageが自分と同じでない or 前画面のActが「categorymod_entry」でない場合、
      // 入力画面に飛ばす
      $tmp_cage_last    = str_replace( DIRECTORY_SEPARATOR, '.', $this->obj_sess->sessLoad( 'lastcage'    ) );
      $tmp_cage_current = str_replace( DIRECTORY_SEPARATOR, '.', $this->obj_sess->sessLoad( 'currentcage' ) );
      $tmp_act  = $this->obj_sess->sessLoad( 'lastact' );

      if ( ( $tmp_cage_last != $tmp_cage_current ) or ( $tmp_act != 'categorymod_entry' ) )
      {
        $this->obj_util->redirectTo( 'categorylist', $tmp_cage_current );
        return false;
      } // end of if



      //------------------------------------------------------------------------
      // 前画面の入力値を取得
      //------------------------------------------------------------------------
      // 初期化
      $tmp_entered[ 'errMsg' ][ 'message'      ] = null;
      $tmp_entered[ 'errMsg' ][ 'categoryid'   ] = null;
      $tmp_entered[ 'errMsg' ][ 'categoryname' ] = null;

      // カテゴリID
      if ( isset( $_POST[ 'categoryid' ] ) )
      {
        $tmp_entered[ 'errMsg' ][ 'categoryid' ] = strip_tags( trim( $_POST[ 'categoryid' ] ) );
      } // end of if
      // カテゴリ名
      if ( isset( $_POST[ 'categoryname' ] ) )
      {
        $tmp_entered[ 'errMsg' ][ 'categoryname' ] = strip_tags( trim( $_POST[ 'categoryname' ] ) );
      } // end of if



      //------------------------------------------------------------------------
      // 入力情報のチェック
      //------------------------------------------------------------------------
      // カテゴリID
      if ( ! is_numeric( $tmp_entered[ 'errMsg' ][ 'categoryid' ] ) )
      {
        // エラーメッセージ表示用の情報をセッションに入れてから入力画面に遷移する
        $tmp_entered[ 'errMsg' ][ 'message' ] = 'invalid_categoryid';
        $this->obj_sess->sessStore( $this->obj_sess->sessLoad( 'currentcage' ), $tmp_entered );
        $this->obj_util->redirectTo( 'categorymod_entry', $tmp_cage_current );
        return false;
      } // end of if
      // カテゴリ名（入力値が空）
      if ( empty( $tmp_entered[ 'errMsg' ][ 'categoryname' ] ) )
      {
        // エラーメッセージ表示用の情報をセッションに入れてから入力画面に遷移する
        $tmp_entered[ 'errMsg' ][ 'message' ] = 'empty_categoryname';
        $this->obj_sess->sessStore( $this->obj_sess->sessLoad( 'currentcage' ), $tmp_entered[ 'errMsg' ] );
        $this->obj_util->redirectTo( 'categorymod_entry', $tmp_cage_current );
        return false;
      } // end of if



      //------------------------------------------------------------------------
      // 特に問題がなければ、画面表示用にクラス変数とセッションに値をセットする
      //------------------------------------------------------------------------
      $this->gotDat = $tmp_entered;
      $this->obj_sess->sessStore( $this->obj_sess->sessLoad( 'currentcage' ), $tmp_entered );

      return true;
    } // end of function:model()

    /**
     * viewメソッド（モデル）
     *
     * テンプレート関連処理等のビューに相当する部分の処理を行う
     *
     * @param     void なし
     * @return    boolean ファンクション実行結果（ true：正常終了 / false: 異常終了 ）
     */
    public function view()
    {
      // アサイン
      $this->smarty->assign ( 'header',               $this->obj_util->getHeader() );

      $this->smarty->assign ( 'entered_categoryname', $this->gotDat[ 'errMsg' ][ 'categoryname' ] );

      $this->smarty->assign ( 'mycage',               $this->mycage );

      // 表示
      $this->smarty->display( 'categorymod_confirm.tpl' );

      return true;

    } // end of function:view()

  } // end of class:categorymod_confirm

?>
