<?php
/**
 * ブログコメント表示画面クラス
 *
 * ブログコメント表示画面を実現するためのクラス
 *
 * @package   simpleblog
 * @author    Risoluto Developers
 * @license   http://opensource.org/licenses/bsd-license.php new BSD license
 * @copyright (C) 2008-2011 Risoluto Developers / All Rights Reserved.
 */

  /**
   * 基底クラス
   */
  require_once( "simpleblog_base.inc" );
  /**
   * データベース操作クラス
   */
  require_once( RISOLUTO_FUNC . 'risoluto_db.php' );

  class blogcomment extends simpleblog_base
  {
    //------------------------------------------------------//
    // クラス変数定義
    //------------------------------------------------------//
    /**
     * データベース操作クラスインスタンスを保持する変数
     * @access private
     * @var    object
     */
    private $obj_db;
    /**
     * ユーティリティクラスインスタンスを保持する変数
     * @access private
     * @var    object
     */
    private $obj_conf;
    /**
     * 取得データを保持する変数
     * @access private
     * @var    object
     */
    private $gotDat;

    //------------------------------------------------------//
    // クラスメソッド定義
    //------------------------------------------------------//
    /**
     * コンストラクタメソッド
     *
     * コンストラクタメソッド
     *
     * @param     void なし
     * @return    void なし
     */
    public function __construct()
    {
    } // end of function:__construct()

    /**
     * クローンメソッド
     *
     * クローンメソッド
     *
     * @param     void なし
     * @return    void なし
     */
    public function __clone()
    {
    } // end of function:__clone()

    /**
     * modelメソッド（モデル）
     *
     * データ取得等のモデルに相当する部分の処理を行う
     *
     * @param     void なし
     * @return    boolean ファンクション実行結果（ true：正常終了 / false: 異常終了 ）
     */
    public function model()
    {
      // 必要なインスタンスを生成
      $this->obj_db   = new RisolutoDb();
      $this->obj_conf = new RisolutoConf();
      $this->obj_conf->parse( RISOLUTO_CONF . 'risoluto.ini' );



      //------------------------------------------------------------------------
      // 前画面の入力値を取得
      //------------------------------------------------------------------------
      // 初期化
      $tmp_entered[ 'blogid' ] = null;

      // ブログID
      if ( isset( $_GET[ 'blogid' ] ) )
      {
        $tmp_entered[ 'blogid' ] = strip_tags( trim( $_GET[ 'blogid' ] ) );
      } // end of if



      //------------------------------------------------------------------------
      // 入力情報のチェック
      //------------------------------------------------------------------------
      // ブログID（ブログIDが不正）
      if ( empty( $tmp_entered[ 'blogid' ] ) or ! is_numeric( $tmp_entered[ 'blogid' ] ) )
      {
        // エラーの場合、例外を投げる
        throw new Exception( 'Invalid blogid' );
        return false;
      } // end of if



      //------------------------------------------------------------------------
      // DBから情報を取得する
      //------------------------------------------------------------------------

      // データベースに接続する
      if ( $this->obj_db->dbConnect( $this->obj_conf->get( 'DBS', 'DEFAULT_DSN' ) ) )
      {
        // テーブル名を可変にできるよう対応
        $tmp_t_blog      = $this->mycage . '_t_blog';
        $tmp_t_comment   = $this->mycage . '_t_comment';
        $tmp_t_trackback = $this->mycage . '_t_trackback';
        $tmp_t_category  = $this->mycage . '_t_category';

        // SQL文を組み立てる
        $sql =<<<End_Of_SQL

              SELECT  `user`.`user_name`                              -- ユーザ名
                    , `blog`.`blog_id`                                -- ブログID
                    , `blog`.`blog_title`                             -- ブログタイトル
                    , `blog`.`blog_body`                              -- ブログ本文
                    , `blog`.`post_datetime`                          -- 投稿日
                FROM `risoluto_t_user` user
                   , $tmp_t_blog blog
               WHERE TIMEDIFF( NOW(), `blog`.`open_datetime` ) >= 0
                 AND (
                          TIMEDIFF( NOW(), `blog`.`end_datetime` ) < 0
                       OR (
                            `blog`.`end_datetime` = '0000-00-00 00:00:00'
                          )
                     )
                 AND `blog`.`user_id` = `user`.`user_id`
                 AND `blog`.`blog_id` = ?

End_Of_SQL;

        // パラメタも用意する
        $param = array(
                        $tmp_entered[ 'blogid' ]
                      );

        // SQLを実行
        $tmp_result = $this->obj_db->dbGetRow( $sql, $param );
        if ( PEAR::isError( $tmp_result ) )
        {
          // エラーの場合は例外を投げる
          throw new Exception( 'SELECT Blog data Failure' );
          return false;
        } // end of if
        else
        {
          $this->gotDat[ 'blogdat' ] = $tmp_result;

          //--- コメントの取得
          // SQL文を組み立てる
          $sql =<<<End_Of_SQL

              SELECT `comment`.`commentator` -- お名前
                   , `comment`.`comment`     -- コメント
                   , `comment`.`ctime`       -- 作成日
                FROM $tmp_t_comment comment
               WHERE `comment`.`status`  = 1
                 AND `comment`.`blog_id` = ?
            ORDER BY `comment`.`comment_id` ASC

End_Of_SQL;

          // パラメタも用意する
          $param = array(
                          $tmp_entered[ 'blogid' ]
                        );
          // SQLを実行
          $tmp_result = $this->obj_db->dbGetAll( $sql, $param );
          if ( PEAR::isError( $tmp_result ) )
          {
            // エラーの場合でも無視する
            $this->gotDat[ 'commentdat' ] = null;
          } // end of if
          else
          {
            $this->gotDat[ 'commentdat' ] = $tmp_result;
          } // end of else



          //--- トラックバックの取得
          // SQL文を組み立てる
          $sql =<<<End_Of_SQL

              SELECT `tb`.`url`      -- URL
                   , `tb`.`blogname` -- ブログ名
                   , `tb`.`title`    -- タイトル
                   , `tb`.`body`     -- 本文
                FROM $tmp_t_trackback tb
               WHERE `tb`.`status`  = 1
                 AND `tb`.`blog_id` = ?
            ORDER BY `tb`.`trackback_id` ASC

End_Of_SQL;

          // パラメタも用意する
          $param = array(
                          $tmp_entered[ 'blogid' ]
                        );
          // SQLを実行
          $tmp_result = $this->obj_db->dbGetAll( $sql, $param );
          if ( PEAR::isError( $tmp_result ) )
          {
            // エラーの場合でも無視する
            $this->gotDat[ 'tbdat' ] = null;
          } // end of if
          else
          {
            $this->gotDat[ 'tbdat' ] = $tmp_result;
          } // end of else

        } // end of else



        // カテゴリ情報の取得
        $sql =<<<End_Of_SQL

              SELECT `cat`.`category_id`   -- カテゴリID
                   , `cat`.`category_name` -- カテゴリ名
                   , `blog`.`cnt`          -- 件数
                FROM $tmp_t_category cat
                     LEFT JOIN
                     (
                        SELECT `blog`.`category_id`
                             , count( `blog`.`category_id` ) as cnt
                          FROM $tmp_t_blog blog
                         WHERE TIMEDIFF( NOW(), `blog`.`open_datetime` ) >= 0
                           AND (
                                 TIMEDIFF( NOW(), `blog`.`end_datetime` ) < 0
                                 OR (
                                      `blog`.`end_datetime` = '0000-00-00 00:00:00'
                                    )
                               )
                      GROUP BY `blog`.`category_id`
                     ) blog
                     ON `cat`.`category_id` = `blog`.`category_id`
            ORDER BY `blog`.`cnt`        DESC
                   , `cat`.`category_id` ASC

End_Of_SQL;

        // パラメタも用意する
        $param = array(
                      );

        // SQLを実行
        $category4menubar_result = $this->obj_db->dbGetAll( $sql, $param );
        if ( PEAR::isError( $category4menubar_result ) )
        {
          throw new Exception( 'get category dat Failure' );
          return false;
        } // end of if
        else
        {
          $tmp_category4menubar = array();
          foreach( $category4menubar_result as $dat )
          {
            $tmp_category4menubar[ $dat[ 'category_id' ] ] = array(
                                                                    'categoryname' => $dat[ 'category_name' ]
                                                                  , 'cnt'          => $dat[ 'cnt' ]
                                                                  );
          } // end of foreach
        } // end of else



        // 執筆者情報の取得
        $sql =<<<End_Of_SQL

              SELECT `user`.`user_id`   -- ユーザID
                   , `user`.`user_name` -- ユーザ名
                   , `blog`.`cnt`       -- 件数
                FROM `risoluto_t_user` user
                     LEFT JOIN
                     (
                        SELECT `blog`.`user_id`
                             , count( `blog`.`user_id` ) as cnt
                          FROM $tmp_t_blog blog
                         WHERE TIMEDIFF( NOW(), `blog`.`open_datetime` ) >= 0
                           AND (
                                 TIMEDIFF( NOW(), `blog`.`end_datetime` ) < 0
                                 OR (
                                      `blog`.`end_datetime` = '0000-00-00 00:00:00'
                                    )
                               )
                      GROUP BY `blog`.`user_id`
                     ) blog
                     ON `user`.`user_id` = `blog`.`user_id`
            ORDER BY `blog`.`cnt`     DESC
                   , `user`.`user_id` ASC

End_Of_SQL;

        // パラメタも用意する
        $param = array(
                      );

        // SQLを実行
        $user4menubar_result = $this->obj_db->dbGetAll( $sql, $param );
        if ( PEAR::isError( $user4menubar_result ) )
        {
          throw new Exception( 'get author dat Failure' );
          return false;
        } // end of if
        else
        {
          $tmp_user4menubar = array();
          foreach( $user4menubar_result as $dat )
          {
            $tmp_user4menubar[ $dat[ 'user_id' ] ] = array(
                                                            'username' => $dat[ 'user_name' ]
                                                          , 'cnt'      => $dat[ 'cnt' ]
                                                          );
          } // end of foreach
        } // end of else



        // 日付情報の取得
        $sql =<<<End_Of_SQL

              SELECT *
                FROM (
                       SELECT SUBSTR( `blog`.`post_datetime`, 1, 4 )                                                            as year
                            , SUBSTR( `blog`.`post_datetime`, 6, 2 )                                                            as month
                            , CONCAT( SUBSTR( `blog`.`post_datetime`, 1, 4 ), SUBSTR( `blog`.`post_datetime`, 6, 2 ) )          as date
                            , count( CONCAT( SUBSTR( `blog`.`post_datetime`, 1, 4 ), SUBSTR( `blog`.`post_datetime`, 6, 2 ) ) ) as cnt
                         FROM $tmp_t_blog blog
                        WHERE TIMEDIFF( NOW(), `blog`.`open_datetime` ) >= 0
                          AND (
                                TIMEDIFF( NOW(), `blog`.`end_datetime` ) < 0
                                OR (
                                     `blog`.`end_datetime` = '0000-00-00 00:00:00'
                                   )
                              )
                     GROUP BY CONCAT( SUBSTR( `blog`.`post_datetime`, 1, 4 ), SUBSTR( `blog`.`post_datetime`, 6, 2 ) )
                     ) result
            ORDER BY `result`.`date` DESC

End_Of_SQL;

        // パラメタも用意する
        $param = array(
                      );

        // SQLを実行
        $date4menubar_result = $this->obj_db->dbGetAll( $sql, $param );
        if ( PEAR::isError( $user4menubar_result ) )
        {
          throw new Exception( 'get date dat Failure' );
          return false;
        } // end of if
        else
        {
          $tmp_date4menubar = array();
          foreach( $date4menubar_result as $dat )
          {
            $tmp_date4menubar[ $dat[ 'date' ] ] = array(
                                                         'year'  => $dat[ 'year' ]
                                                       , 'month' => $dat[ 'month' ]
                                                       , 'cnt'   => $dat[ 'cnt' ]
                                                       );
          } // end of foreach
        } // end of else

      } // end of if
      // データベースに接続できなかった場合は、例外を投げる
      else
      {
        throw new Exception( 'DB Connection Failure' );
        return false;
      } // end of else

      // ブログタイトルの取得
      $simpleblog_conf = new RisolutoConf();
      $simpleblog_conf->parse( RISOLUTO_CONF . $this->mycage . '.ini' );
      $this->gotDat[ 'title' ] = $simpleblog_conf->get( 'BLOGINFO', 'title' );

      // 付随情報の取得
      $this->gotDat[ 'mycage'        ] = $this->mycage;
      $this->gotDat[ 'baseURL'       ] = $this->obj_util->getBaseUrl();
      $this->gotDat[ 'permanentlink' ] = $this->gotDat[ 'baseURL' ] . '?cage=' . $this->gotDat[ 'mycage' ] . '&amp;act=blogcomment&amp;blogid=' . $this->gotDat[ 'blogdat' ][ 'blog_id' ];

      // サイドのmenubarに表示する内容を構成
      $tmp_menubar                = new Smarty;
      $tmp_menubar->template_dir  = RISOLUTO_USERLAND . $this->obj_sess->sessLoad( 'currentcage' );
      $tmp_menubar->config_dir    = RISOLUTO_USERLAND . $this->obj_sess->sessLoad( 'currentcage' );
      $tmp_menubar->compile_dir   = RISOLUTO_CACHE;
      $tmp_menubar->cache_dir     = RISOLUTO_CACHE;
      $tmp_menubar->caching       = false;
      $tmp_menubar->debugging     = false;
      $tmp_menubar->force_compile = true;
      $tmp_menubar->compile_check = true;

      $tmp_menubar->assign( 'categorylist', $tmp_category4menubar );
      $tmp_menubar->assign( 'userlist',     $tmp_user4menubar     );
      $tmp_menubar->assign( 'datelist',     $tmp_date4menubar     );
      $tmp_menubar->assign( 'mycage',       $this->mycage         );

      $this->gotDat[ 'menubar' ] = $tmp_menubar->fetch( 'blog_menubar.tpl' );

      return true;
    } // end of function:model()

    /**
     * viewメソッド（モデル）
     *
     * テンプレート関連処理等のビューに相当する部分の処理を行う
     *
     * @param     void なし
     * @return    boolean ファンクション実行結果（ true：正常終了 / false: 異常終了 ）
     */
    public function view()
    {

      // アサイン
      $headers            = $this->obj_util->getHeader();
      $headers[ 'title' ] = $this->gotDat[ 'title' ] . "：" . $this->gotDat[ 'blogdat' ][ 'blog_title' ] . "（" . $headers[ 'title' ] . "）";
      $this->smarty->assign ( 'header', $headers );

      $this->smarty->assign ( 'blog_title',        $this->gotDat[ 'blogdat' ][ 'blog_title'    ] );
      $this->smarty->assign ( 'enc_blog_title',    rawurlencode( $this->gotDat[ 'blogdat' ][ 'blog_title' ] ) );
      $this->smarty->assign ( 'user_name',         $this->gotDat[ 'blogdat' ][ 'user_name'     ] );
      $this->smarty->assign ( 'post_datetime',     $this->gotDat[ 'blogdat' ][ 'post_datetime' ] );
      $this->smarty->assign ( 'blog_body',         $this->gotDat[ 'blogdat' ][ 'blog_body'     ] );
      $this->smarty->assign ( 'blog_id',           $this->gotDat[ 'blogdat' ][ 'blog_id'       ] );

      $this->smarty->assign ( 'commentlist',       $this->gotDat[ 'commentdat' ] );
      $this->smarty->assign ( 'tblist',            $this->gotDat[ 'tbdat'      ] );
      $this->smarty->assign ( 'lapsed_days',       ( strtotime( date("Ymd") ) - strtotime( $this->gotDat[ 'blogdat' ][ 'post_datetime' ] ) ) / ( 24 * 60 * 60 )  );

      $this->smarty->assign ( 'menubar',           $this->gotDat[ 'menubar' ] );

      $this->smarty->assign ( 'mycage',            $this->gotDat[ 'mycage' ] );
      $this->smarty->assign ( 'blogname',          $this->gotDat[ 'title'  ] );
      $this->smarty->assign ( 'enc_blogname',      rawurlencode( $this->gotDat[ 'title' ] ) );

      $this->smarty->assign ( 'baseURL',           $this->gotDat[ 'baseURL' ] );
      $this->smarty->assign ( 'permanentlink',     $this->gotDat[ 'permanentlink' ] );
      $this->smarty->assign ( 'enc_permanentlink', rawurlencode( $this->gotDat[ 'permanentlink' ] ) );

      // 表示
      $this->smarty->display( 'blogcomment.tpl' );

      return true;

    } // end of function:view()

  } // end of class:blogcomment
?>
