<?php
/**
 * ブログ記事情報変更情報入力画面クラス
 *
 * ブログ記事情報変更情報入力画面を実現するためのクラス
 *
 * @package   simpleblog
 * @author    Risoluto Developers
 * @license   http://opensource.org/licenses/bsd-license.php new BSD license
 * @copyright (C) 2008-2011 Risoluto Developers / All Rights Reserved.
 */

  /**
   * 基底クラス
   */
  require_once( "simpleblog_base.inc" );
  /**
   * データベース操作クラス
   */
  require_once( RISOLUTO_FUNC . 'risoluto_db.php' );

  class blogmod_entry extends simpleblog_base
  {
    //------------------------------------------------------//
    // クラス変数定義
    //------------------------------------------------------//
    /**
     * データベース操作クラスインスタンスを保持する変数
     * @access private
     * @var    object
     */
    private $obj_db;
    /**
     * ユーティリティクラスインスタンスを保持する変数
     * @access private
     * @var    object
     */
    private $obj_conf;
    /**
     * 取得データを保持する変数
     * @access private
     * @var    object
     */
    private $gotDat;

    //------------------------------------------------------//
    // クラスメソッド定義
    //------------------------------------------------------//
    /**
     * コンストラクタメソッド
     *
     * コンストラクタメソッド
     *
     * @param     void なし
     * @return    void なし
     */
    public function __construct()
    {
    } // end of function:__construct()

    /**
     * クローンメソッド
     *
     * クローンメソッド
     *
     * @param     void なし
     * @return    void なし
     */
    public function __clone()
    {
    } // end of function:__clone()

    /**
     * modelメソッド（モデル）
     *
     * データ取得等のモデルに相当する部分の処理を行う
     *
     * @param     void なし
     * @return    boolean ファンクション実行結果（ true：正常終了 / false: 異常終了 ）
     */
    public function model()
    {
      // 必要なインスタンスを生成
      $this->obj_db   = new RisoluteDb();
      $this->obj_conf = new RisolutoConf();
      $this->obj_conf->parse( RISOLUTO_CONF . 'risoluto.ini' );

      // スーパバイザセッション又はアドミンセッションが存在しない場合は、
      // ログイン画面に遷移する
      if ( ! $this->obj_util->is_Admin() )
      {
        $this->obj_util->redirectTo( $this->obj_adminconf->get( 'COMMON', 'login_act'  )
                                   , $this->obj_adminconf->get( 'COMMON', 'login_cage' ) );
        return false;
      } // end of if

      // 前画面のCageが自分と同じでない or 前画面のActが「bloglist」または「blogview」または「blogmod_confirm」でない場合、
      // 入力画面に飛ばす
      $tmp_cage_last    = str_replace( DIRECTORY_SEPARATOR, '.', $this->obj_sess->sessLoad( 'lastcage'    ) );
      $tmp_cage_current = str_replace( DIRECTORY_SEPARATOR, '.', $this->obj_sess->sessLoad( 'currentcage' ) );

      $tmp_act  = $this->obj_sess->sessLoad( 'lastact'  );
      if ( ( $tmp_cage_last != $tmp_cage_current ) or ( $tmp_act != 'bloglist' and $tmp_act != 'blogview' and $tmp_act != 'blogmod_confirm' ) )
      {
        $this->obj_util->redirectTo( 'bloglist', $tmp_cage_current );
        return false;
      } // end of if



      //------------------------------------------------------------------------
      // CKEditorが存在すれば使用する
      //------------------------------------------------------------------------
      clearstatcache();
      $this->gotDat[ 'is_ckeditor' ] = file_exists( RISOLUTO_DOCROOT . '/ckeditor/' );



      //------------------------------------------------------------------------
      // セッション情報の取得
      //------------------------------------------------------------------------
      // 前画面のActが「blogmod_confirm」なら、必要な情報をセッションから取得する
      if ( $tmp_act == 'blogmod_confirm' )
      {
        // セッションからエラーメッセージと入力値を取得し、削除する
        $tmp_entered = $this->obj_sess->sessLoad( $this->obj_sess->sessLoad( 'currentcage' ) );
        $this->obj_sess->sessRevoke( $this->obj_sess->sessLoad( 'currentcage' ) );

        // 表示に必要な加工を行う
        $this->gotDat[ 'errMsg' ][ 'message'    ] = $tmp_entered[ 'errMsg' ][ 'message'            ];
        $this->gotDat[ 'errMsg' ][ 'blogid'     ] = $tmp_entered[ 'errMsg' ][ 'blogid'             ];
        $this->gotDat[ 'errMsg' ][ 'title'      ] = $tmp_entered[ 'errMsg' ][ 'title'              ];
        $this->gotDat[ 'errMsg' ][ 'body'       ] = $tmp_entered[ 'errMsg' ][ 'body'               ];
        $this->gotDat[ 'errMsg' ][ 'postyear'   ] = $tmp_entered[ 'errMsg' ][ 'entered_postyear'   ];
        $this->gotDat[ 'errMsg' ][ 'postmonth'  ] = $tmp_entered[ 'errMsg' ][ 'entered_postmonth'  ];
        $this->gotDat[ 'errMsg' ][ 'postday'    ] = $tmp_entered[ 'errMsg' ][ 'entered_postday'    ];
        $this->gotDat[ 'errMsg' ][ 'posthour'   ] = $tmp_entered[ 'errMsg' ][ 'entered_posthour'   ];
        $this->gotDat[ 'errMsg' ][ 'postminite' ] = $tmp_entered[ 'errMsg' ][ 'entered_postminite' ];
        $this->gotDat[ 'errMsg' ][ 'postsecond' ] = $tmp_entered[ 'errMsg' ][ 'entered_postsecond' ];
        $this->gotDat[ 'errMsg' ][ 'openyear'   ] = $tmp_entered[ 'errMsg' ][ 'entered_openyear'   ];
        $this->gotDat[ 'errMsg' ][ 'openmonth'  ] = $tmp_entered[ 'errMsg' ][ 'entered_openmonth'  ];
        $this->gotDat[ 'errMsg' ][ 'openday'    ] = $tmp_entered[ 'errMsg' ][ 'entered_openday'    ];
        $this->gotDat[ 'errMsg' ][ 'openhour'   ] = $tmp_entered[ 'errMsg' ][ 'entered_openhour'   ];
        $this->gotDat[ 'errMsg' ][ 'openminite' ] = $tmp_entered[ 'errMsg' ][ 'entered_openminite' ];
        $this->gotDat[ 'errMsg' ][ 'opensecond' ] = $tmp_entered[ 'errMsg' ][ 'entered_opensecond' ];
        $this->gotDat[ 'errMsg' ][ 'endyear'    ] = $tmp_entered[ 'errMsg' ][ 'entered_endyear'    ];
        $this->gotDat[ 'errMsg' ][ 'endmonth'   ] = $tmp_entered[ 'errMsg' ][ 'entered_endmonth'   ];
        $this->gotDat[ 'errMsg' ][ 'endday'     ] = $tmp_entered[ 'errMsg' ][ 'entered_endday'     ];
        $this->gotDat[ 'errMsg' ][ 'endhour'    ] = $tmp_entered[ 'errMsg' ][ 'entered_endhour'    ];
        $this->gotDat[ 'errMsg' ][ 'endminite'  ] = $tmp_entered[ 'errMsg' ][ 'entered_endminite'  ];
        $this->gotDat[ 'errMsg' ][ 'endsecond'  ] = $tmp_entered[ 'errMsg' ][ 'entered_endsecond'  ];

        return true;
      } // end of if


      //------------------------------------------------------------------------
      // 前画面の入力値を取得
      //------------------------------------------------------------------------
      // 初期化
      $tmp_entered[ 'errMsg' ][ 'blogid' ] = null;

      // ブログID
      if ( isset( $_GET[ 'blogid' ] ) )
      {
        $tmp_entered[ 'errMsg' ][ 'blogid' ] = strip_tags( trim( $_GET[ 'blogid' ] ) );
      } // end of if



      //------------------------------------------------------------------------
      // 入力情報のチェック
      //------------------------------------------------------------------------
      // 渡されてきたブログIDが数字でなければ、ユーザ選択画面に遷移する
      if ( empty( $tmp_entered[ 'errMsg' ][ 'blogid' ] ) or ! is_numeric( $tmp_entered[ 'errMsg' ][ 'blogid' ] ) )
      {
        // エラーメッセージ表示用の情報をセッションに入れてから入力画面に遷移する
        $tmp_entered[ 'errMsg' ][ 'message' ] = 'invalid_blogid';
        $this->obj_sess->sessStore( $this->obj_sess->sessLoad( 'currentcage' ), $tmp_entered );
        $this->obj_util->redirectTo( 'bloglist', $tmp_cage_current );
        return false;
      } // end of if



      //------------------------------------------------------------------------
      // ブログ記事情報の取得
      //------------------------------------------------------------------------

      // データベースに接続する
      if ( $this->obj_db->dbConnect( $this->obj_conf->get( 'DBS', 'DEFAULT_DSN' ) ) )
      {

        // ユーザ情報を取得する
        // SQL文を組み立てる
        $tmp_t_blog = $this->mycage . '_t_blog';
        $sql =<<<End_Of_SQL

              SELECT  `blog`.`blog_id`                                      -- ブログID
                    , `blog`.`blog_title`                                   -- ブログタイトル
                    , `blog`.`blog_body`                                    -- ブログ本文
                    , SUBSTR( `blog`.`open_datetime`,  1, 4 ) as openyear   -- 公開開始日・年
                    , SUBSTR( `blog`.`open_datetime`,  6, 2 ) as openmonth  -- 公開開始日・月
                    , SUBSTR( `blog`.`open_datetime`,  9, 2 ) as openday    -- 公開開始日・日
                    , SUBSTR( `blog`.`open_datetime`, 12, 2 ) as openhour   -- 公開開始日・時
                    , SUBSTR( `blog`.`open_datetime`, 15, 2 ) as openminite -- 公開開始日・分
                    , SUBSTR( `blog`.`open_datetime`, 18, 2 ) as opensecond -- 公開開始日・秒
                    , SUBSTR( `blog`.`end_datetime`,   1, 4 ) as endyear    -- 公開終了日・年
                    , SUBSTR( `blog`.`end_datetime`,   6, 2 ) as endmonth   -- 公開終了日・月
                    , SUBSTR( `blog`.`end_datetime`,   9, 2 ) as endday     -- 公開終了日・日
                    , SUBSTR( `blog`.`end_datetime`,  12, 2 ) as endhour    -- 公開終了日・時
                    , SUBSTR( `blog`.`end_datetime`,  15, 2 ) as endminite  -- 公開終了日・分
                    , SUBSTR( `blog`.`end_datetime`,  18, 2 ) as endsecond  -- 公開終了日・秒
                    , SUBSTR( `blog`.`post_datetime`,  1, 4 ) as postyear   -- 投稿日・年
                    , SUBSTR( `blog`.`post_datetime`,  6, 2 ) as postmonth  -- 投稿日・月
                    , SUBSTR( `blog`.`post_datetime`,  9, 2 ) as postday    -- 投稿日・日
                    , SUBSTR( `blog`.`post_datetime`, 12, 2 ) as posthour   -- 投稿日・時
                    , SUBSTR( `blog`.`post_datetime`, 15, 2 ) as postminite -- 投稿日・分
                    , SUBSTR( `blog`.`post_datetime`, 18, 2 ) as postsecond -- 投稿日・秒
                FROM $tmp_t_blog blog
               WHERE `blog`.`blog_id` = ?

End_Of_SQL;

        // パラメタも用意する
        $param = array(
                        $tmp_entered[ 'errMsg' ][ 'blogid' ]
                      );

        // SQLの実行に失敗した場合は、例外を投げる
        $tmp_blogdat = $this->obj_db->dbGetRow( $sql, $param );
        if ( PEAR::isError( $tmp_blogdat ) )
        {
          // 接続をクローズする
          $this->obj_db->dbDisConnect();
          throw new Exception( 'blog information get Failure' );
          return false;
        } // end of if
        // 正常に取得できていれば、クラス変数にセットする
        else
        {
          // 接続をクローズする
          $this->obj_db->dbDisConnect();
          $this->gotDat[ 'errMsg' ][ 'message'    ] = null;
          $this->gotDat[ 'errMsg' ][ 'blogid'     ] = $tmp_blogdat[ 'blog_id'    ];
          $this->gotDat[ 'errMsg' ][ 'title'      ] = $tmp_blogdat[ 'blog_title' ];
          $this->gotDat[ 'errMsg' ][ 'body'       ] = $tmp_blogdat[ 'blog_body'  ];
          $this->gotDat[ 'errMsg' ][ 'postyear'   ] = $tmp_blogdat[ 'postyear'   ];
          $this->gotDat[ 'errMsg' ][ 'postmonth'  ] = $tmp_blogdat[ 'postmonth'  ];
          $this->gotDat[ 'errMsg' ][ 'postday'    ] = $tmp_blogdat[ 'postday'    ];
          $this->gotDat[ 'errMsg' ][ 'posthour'   ] = $tmp_blogdat[ 'posthour'   ];
          $this->gotDat[ 'errMsg' ][ 'postminite' ] = $tmp_blogdat[ 'postminite' ];
          $this->gotDat[ 'errMsg' ][ 'postsecond' ] = $tmp_blogdat[ 'postsecond' ];
          $this->gotDat[ 'errMsg' ][ 'openyear'   ] = $tmp_blogdat[ 'openyear'   ];
          $this->gotDat[ 'errMsg' ][ 'openmonth'  ] = $tmp_blogdat[ 'openmonth'  ];
          $this->gotDat[ 'errMsg' ][ 'openday'    ] = $tmp_blogdat[ 'openday'    ];
          $this->gotDat[ 'errMsg' ][ 'openhour'   ] = $tmp_blogdat[ 'openhour'   ];
          $this->gotDat[ 'errMsg' ][ 'openminite' ] = $tmp_blogdat[ 'openminite' ];
          $this->gotDat[ 'errMsg' ][ 'opensecond' ] = $tmp_blogdat[ 'opensecond' ];
          $this->gotDat[ 'errMsg' ][ 'endyear'    ] = $tmp_blogdat[ 'endyear'    ];
          $this->gotDat[ 'errMsg' ][ 'endmonth'   ] = $tmp_blogdat[ 'endmonth'   ];
          $this->gotDat[ 'errMsg' ][ 'endday'     ] = $tmp_blogdat[ 'endday'     ];
          if ( $tmp_blogdat[ 'endyear' ] == '0000' and $tmp_blogdat[ 'endmonth' ] == '00' and $tmp_blogdat[ 'endday' ] == '00' )
          {
            $this->gotDat[ 'errMsg' ][ 'endhour'    ] = '----';
            $this->gotDat[ 'errMsg' ][ 'endminite'  ] = '--';
            $this->gotDat[ 'errMsg' ][ 'endsecond'  ] = '--';
          } // end of if
          else
          {
            $this->gotDat[ 'errMsg' ][ 'endhour'    ] = $tmp_blogdat[ 'endhour'    ];
            $this->gotDat[ 'errMsg' ][ 'endminite'  ] = $tmp_blogdat[ 'endminite'  ];
            $this->gotDat[ 'errMsg' ][ 'endsecond'  ] = $tmp_blogdat[ 'endsecond'  ];
          } // end of else
        } // end of else

      } // end of if
      // データベースに接続できなかった場合は、例外を投げる
      else
      {
        throw new Exception( 'DB Connection Failure' );
        return false;
      } // end of else



      return true;
    } // end of function:model()

    /**
     * viewメソッド（モデル）
     *
     * テンプレート関連処理等のビューに相当する部分の処理を行う
     *
     * @param     void なし
     * @return    boolean ファンクション実行結果（ true：正常終了 / false: 異常終了 ）
     */
    public function view()
    {
      // アサイン
      $this->smarty->assign ( 'header',           $this->obj_util->getHeader() );

      $this->smarty->assign ( 'menu_cage',        $this->obj_adminconf->get( 'COMMON', 'menu_cage' ) );
      $this->smarty->assign ( 'menu_act',         $this->obj_adminconf->get( 'COMMON', 'menu_act'  ) );

      $this->smarty->assign ( 'mycage',           $this->mycage );

      $this->smarty->assign ( 'is_ckeditor',      $this->gotDat[ 'is_ckeditor' ] );
      $this->smarty->assign ( 'base_url',         $this->obj_util->getBaseUrl() );

      $this->smarty->assign ( 'errMsg',           $this->gotDat[ 'errMsg' ][ 'message' ] );
      $this->smarty->assign ( 'entered_blogid',   $this->gotDat[ 'errMsg' ][ 'blogid'  ] );
      $this->smarty->assign ( 'entered_title',    $this->gotDat[ 'errMsg' ][ 'title'   ] );
      $this->smarty->assign ( 'entered_body',     $this->gotDat[ 'errMsg' ][ 'body'    ] );

      // ブログ投稿日（表示用）・年（デフォルト表示項目）
      $this->smarty->assign ( 'entered_postyear',   $this->gotDat[ 'errMsg' ][ 'postyear'   ] );
      // ブログ投稿日（表示用）・月（デフォルト表示項目）
      $this->smarty->assign ( 'entered_postmonth',  $this->gotDat[ 'errMsg' ][ 'postmonth'  ] );
      // ブログ投稿日（表示用）・日（デフォルト表示項目）
      $this->smarty->assign ( 'entered_postday',    $this->gotDat[ 'errMsg' ][ 'postday'    ] );
      // ブログ投稿日（表示用）・時（デフォルト表示項目）
      $this->smarty->assign ( 'entered_posthour',   $this->gotDat[ 'errMsg' ][ 'posthour'   ] );
      // ブログ投稿日（表示用）・分（デフォルト表示項目）
      $this->smarty->assign ( 'entered_postminite', $this->gotDat[ 'errMsg' ][ 'postminite' ] );
      // ブログ投稿日（表示用）・秒（デフォルト表示項目）
      $this->smarty->assign ( 'entered_postsecond', $this->gotDat[ 'errMsg' ][ 'postsecond' ] );

      // 公開開始日・年（デフォルト表示項目）
      $this->smarty->assign ( 'entered_openyear',   $this->gotDat[ 'errMsg' ][ 'openyear'   ] );
      // 公開開始日・月（デフォルト表示項目）
      $this->smarty->assign ( 'entered_openmonth',  $this->gotDat[ 'errMsg' ][ 'openmonth'  ] );
      // 公開開始日・日（デフォルト表示項目）
      $this->smarty->assign ( 'entered_openday',    $this->gotDat[ 'errMsg' ][ 'openday'    ] );
      // 公開開始日（表示用）・時（デフォルト表示項目）
      $this->smarty->assign ( 'entered_openhour',   $this->gotDat[ 'errMsg' ][ 'openhour'   ] );
      // 公開開始日（表示用）・分（デフォルト表示項目）
      $this->smarty->assign ( 'entered_openminite', $this->gotDat[ 'errMsg' ][ 'openminite' ] );
      // 公開開始日（表示用）・秒（デフォルト表示項目）
      $this->smarty->assign ( 'entered_opensecond', $this->gotDat[ 'errMsg' ][ 'opensecond' ] );

      // 公開終了日・年（デフォルト表示項目）
      $this->smarty->assign ( 'entered_endyear',   $this->gotDat[ 'errMsg' ][ 'endyear'   ] );
      // 公開終了日・月（デフォルト表示項目）
      $this->smarty->assign ( 'entered_endmonth',  $this->gotDat[ 'errMsg' ][ 'endmonth'  ] );
      // 公開終了日・日（デフォルト表示項目）
      $this->smarty->assign ( 'entered_endday',    $this->gotDat[ 'errMsg' ][ 'endday'    ] );
      // 公開終了日（表示用）・時（デフォルト表示項目）
      $this->smarty->assign ( 'entered_endhour',   $this->gotDat[ 'errMsg' ][ 'endhour'   ] );
      // 公開終了日（表示用）・分（デフォルト表示項目）
      $this->smarty->assign ( 'entered_endminite', $this->gotDat[ 'errMsg' ][ 'endminite' ] );
      // 公開終了日（表示用）・秒（デフォルト表示項目）
      $this->smarty->assign ( 'entered_endsecond', $this->gotDat[ 'errMsg' ][ 'endsecond' ] );

      // ブログ投稿日（表示用）・年（セレクトボックス表示用）
      $this->smarty->assign ( 'arrPostedYear',     $this->obj_util->genYear( false, date( 'Y' ) - 5, 10, 0 ) );
      // 公開開始日・年（セレクトボックス表示用）
      $this->smarty->assign ( 'arrOpenYear',       $this->obj_util->genYear( false, date( 'Y' ), 5, 0 ) );
      // 公開終了日・年（セレクトボックス表示用）
      $this->smarty->assign ( 'arrEndYear',        $this->obj_util->genYear( true,  date( 'Y' ), 5, 0 ) );

      // 月（セレクトボックス表示用）
      $this->smarty->assign ( 'arrMonth',          $this->obj_util->genMonth( false ) );
      // 日（セレクトボックス表示用）
      $this->smarty->assign ( 'arrDay',            $this->obj_util->genDay( false ) );
      // 時（セレクトボックス表示用）
      $this->smarty->assign ( 'arrHour',           $this->obj_util->genHour( false, true ) );
      // 分・秒（セレクトボックス表示用）
      $this->smarty->assign ( 'arrMinSec',         $this->obj_util->genMinSec( false ) );

      // 月（セレクトボックス表示用）、公開終了日用
      $this->smarty->assign ( 'arrMonth_end',      $this->obj_util->genMonth( true ) );
      // 日（セレクトボックス表示用）、公開終了日用
      $this->smarty->assign ( 'arrDay_end',        $this->obj_util->genDay( true )   );
      // 時（セレクトボックス表示用）、公開終了日用
      $this->smarty->assign ( 'arrHour_end',       $this->obj_util->genHour( true, true ) );
      // 分・秒（セレクトボックス表示用）、公開終了日用
      $this->smarty->assign ( 'arrMinSec_end',     $this->obj_util->genMinSec( true ) );

      // 表示
      $this->smarty->display( 'blogmod_entry.tpl' );

      return true;

    } // end of function:view()

  } // end of class:pageadd_entry

?>
