<?php
/**
 * 認証クラス
 *
 * 認証を行うためのクラス
 *
 * @package   risoluto
 * @author    Yuta Hayakawa <haya@hyec.org>
 * @license   http://opensource.org/licenses/bsd-license.php new BSD license
 * @copyright (C) 2008-2009 Yuta Hayakawa / All Rights Reserved.
 */

  /**
   * 基底クラス
   */
  require_once( 'admin_base.inc' );
  /**
   * データベース操作クラス
   */
  require_once( RISOLUTO_FUNC . 'risoluto_db.php' );

  class auth extends admin_base
  {
    //------------------------------------------------------//
    // クラス変数定義
    //------------------------------------------------------//
    /**
     * データベース操作クラスインスタンスを保持する変数
     * @access private
     * @var    object
     */
    private $obj_db;
    /**
     * ユーティリティクラスインスタンスを保持する変数
     * @access private
     * @var    object
     */
    private $obj_conf;

    //------------------------------------------------------//
    // クラスメソッド定義
    //------------------------------------------------------//
    /**
     * コンストラクタメソッド
     *
     * コンストラクタメソッド
     *
     * @param     void なし
     * @return    void なし
     */
    public function __construct()
    {
    } // end of function:__construct()

    /**
     * クローンメソッド
     *
     * クローンメソッド
     *
     * @param     void なし
     * @return    void なし
     */
    public function __clone()
    {
    } // end of function:__clone()

    /**
     * modelメソッド（モデル）
     *
     * データ取得等のモデルに相当する部分の処理を行う
     *
     * @param     void なし
     * @return    boolean ファンクション実行結果（ true：正常終了 / false: 異常終了 ）
     */
    public function model()
    {
      // 必要なインスタンスを生成
      $this->obj_conf = new RisolutoConf();
      $this->obj_conf->parse( RISOLUTO_CONF . 'risoluto.ini' );

      // すでにスーパバイザセッション又はアドミンセッションが存在する場合は、
      // 管理系メニュー画面に遷移する
      if ( $this->obj_util->is_Admin() )
      {
        $this->obj_util->redirectTo( $this->obj_adminconf->get( 'COMMON', 'menu_act'  )
                                   , $this->obj_adminconf->get( 'COMMON', 'menu_cage' ) );
        return true;
      } // end of if



      // 前画面のCageが「admin」で前画面のActが「login」でない場合は、
      // ログイン画面に遷移する
      if (    $this->obj_sess->sessLoad( 'lastcage' ) != 'admin'
           or $this->obj_sess->sessLoad( 'lastact'  ) != 'login'
         )
      {
        $this->obj_util->redirectTo( $this->obj_adminconf->get( 'COMMON', 'login_act'  )
                                   , $this->obj_adminconf->get( 'COMMON', 'login_cage' ) );
        return false;
      } // end of if



      // $_POST[ 'username' ] 及び $_POST[ 'password' ]がセットされていれば取得する
      if ( isset( $_POST[ 'username' ] ) )
      {
        $entered_username = strip_tags( trim( $_POST[ 'username' ] ) );
      } // end of if
      if ( isset( $_POST[ 'password' ] ) )
      {
        $entered_password = strip_tags( trim( $_POST[ 'password' ] ) );
      } // end of if



      // ユーザ名とパスワードのいずれかもしくは両方が空の場合、
      // ログイン画面に差し戻す
      if ( empty( $entered_username ) or empty( $entered_password ) )
      {
        // エラーメッセージ表示用の情報をセッションに入れてからログイン画面に遷移する
        $this->obj_sess->sessStore( $this->obj_sess->sessLoad( 'lastact' ), 'empty' );
        $this->obj_util->redirectTo( $this->obj_adminconf->get( 'COMMON', 'login_act'  )
                                   , $this->obj_adminconf->get( 'COMMON', 'login_cage' ) );
        return false;
      } // end of if



      // ユーザ名が不正な形式の場合、ログイン画面に差し戻す
      if ( ! preg_match( $this->obj_adminconf->get( 'COMMON', 'valid_username' ), $entered_username ) )
      {
        // エラーメッセージ表示用の情報をセッションに入れてからログイン画面に遷移する
        $this->obj_sess->sessStore( $this->obj_sess->sessLoad( 'lastact' ), 'notmatch' );
        $this->obj_util->redirectTo( $this->obj_adminconf->get( 'COMMON', 'login_act'  )
                                   , $this->obj_adminconf->get( 'COMMON', 'login_cage' ) );
        return false;
      } // end of if



      // データベースに接続する
      // データベース操作クラスのインスタンスを生成する
      $this->obj_db = new RisoluteDb();

      // データベースに接続する
      if ( $this->obj_db->dbConnect( $this->obj_conf->get( 'DBS', 'DEFAULT_DSN' ) ) )
      {
        // SQL文を組み立てる
        $sql =<<<End_Of_SQL

              SELECT `user`.`user_id`      -- ユーザID
                   , `user`.`group_id`     -- グループID
                FROM `risoluto_t_user` user
               WHERE `user`.`user_name`  = ?
                 AND `user`.`password`   = ?
                 AND `user`.`group_id`  <= 1
                 AND `user`.`status`     = 1

End_Of_SQL;

        // パラメタも用意する
        $param = array(
                        $entered_username
                      , sha1( $entered_password )
                      );

        // SQLの実行に失敗した場合は、ログイン画面に差し戻す
        $tmp_result = $this->obj_db->dbGetRow( $sql, $param );
        if ( PEAR::isError( $tmp_result ) )
        {
          // エラーメッセージ表示用の情報をセッションに入れてからログイン画面に遷移する
          $this->obj_sess->sessStore( $this->obj_sess->sessLoad( 'lastact' ), 'cannotdbconnect' );
          $this->obj_util->redirectTo( $this->obj_adminconf->get( 'COMMON', 'login_act'  )
                                     , $this->obj_adminconf->get( 'COMMON', 'login_cage' ) );
          return false;
        } // end of if

        // 接続に成功している場合は接続をクローズする
        $this->obj_db->dbDisConnect();
      } // end of if
      // データベースに接続できなかった場合は、例外を投げる
      else
      {
        throw new Exception( 'DB Connection Failure' );
        return false;
      } // end of else



      // レコードが取得できない場合は、ログイン画面に差し戻す
      if ( empty( $tmp_result ) )
      {
        // エラーメッセージ表示用の情報をセッションに入れてからログイン画面に遷移する
        $this->obj_sess->sessStore( $this->obj_sess->sessLoad( 'lastact' ), 'notmatch' );
        $this->obj_util->redirectTo( $this->obj_adminconf->get( 'COMMON', 'login_act'  )
                                   , $this->obj_adminconf->get( 'COMMON', 'login_cage' ) );
        return false;
      } // end of if



      // ここまで来ればログイン成功とみなし、セッションに必要な情報を格納した後、
      // 管理メニューに遷移する
      $this->obj_sess->sessStore( 'login_userid',   $tmp_result[ 'user_id'  ] );
      $this->obj_sess->sessStore( 'login_groupid',  $tmp_result[ 'group_id' ] );

      $this->obj_util->redirectTo( $this->obj_adminconf->get( 'COMMON', 'menu_act'  )
                                 , $this->obj_adminconf->get( 'COMMON', 'menu_cage' ) );
      return true;
    } // end of function:model()

    /**
     * viewメソッド（モデル）
     *
     * テンプレート関連処理等のビューに相当する部分の処理を行う
     *
     * @param     void なし
     * @return    boolean ファンクション実行結果（ true：正常終了 / false: 異常終了 ）
     */
    public function view()
    {
      // このクラスは画面表示を行いません
      return true;
    } // end of function:view()

  } // end of class:admin
?>
