<?php
/**
 * アップグレードFlavor画面(6)クラス
 *
 * アップグレードFlavor画面(6)を実現するためのクラス
 *
 * @package   risoluto
 * @author    Risoluto Developers
 * @license   http://opensource.org/licenses/bsd-license.php new BSD license
 * @copyright (C) 2008-2012 Risoluto Developers / All Rights Reserved.
 */

  /**
   * 基底クラス
   */
  require_once( 'upgrade_base.inc' );

  class page05 extends upgrade_base
  {
    //------------------------------------------------------//
    // クラス変数定義
    //------------------------------------------------------//
    /**
     * チェック情報格納用変数
     * @access private
     * @var    array
     */
    private $checklist;
    /**
     * チェック結果格納用変数
     * @access private
     * @var    array
     */
    private $checkresult;
    /**
     * エラー発生状況格納用変数
     * @access private
     * @var    boolean
     */
    private $errStatus;

    //------------------------------------------------------//
    // クラスメソッド定義
    //------------------------------------------------------//
    /**
     * コンストラクタメソッド
     *
     * コンストラクタメソッド
     *
     * @param     void なし
     * @return    void なし
     */
    public function __construct()
    {
    } // end of function:__construct()

    /**
     * クローンメソッド
     *
     * クローンメソッド
     *
     * @param     void なし
     * @return    void なし
     */
    public function __clone()
    {
    } // end of function:__clone()

    /**
     * modelメソッド（モデル）
     *
     * データ取得等のモデルに相当する部分の処理を行う
     *
     * @param     void なし
     * @return    boolean ファンクション実行結果（ true：正常終了 / false: 異常終了 ）
     */
    public function model()
    {
      // 前画面のCageが現在のCageと同一でない  or 前画面のActが「page04」 and 「page05」 and 「page06」でない場合、
      // インストーラトップに飛ばす
      $tmp_cage      = str_replace( DIRECTORY_SEPARATOR, '.', $this->obj_sess->sessLoad( 'lastcage' ) );
      $tmp_cage_self = str_replace( DIRECTORY_SEPARATOR, '.', $this->obj_sess->sessLoad( 'currentcage' ) );
      $tmp_act       = $this->obj_sess->sessLoad( 'lastact'  );
      if ( $tmp_cage != $tmp_cage_self or ( $tmp_act != 'page04' and $tmp_act != 'page05' and $tmp_act != 'page06' ) )
      {
        $this->obj_util->redirectTo( 'upgrade', $tmp_cage_self );
        return false;
      } // end of if

      // 配置対象をセットする
      // 他に配置する対象があれば、この配列に加えてください。
      // target: 対象ファイル名 / destination: 配置先のパス/パーミッション/オーナ名/グループ名） / 
      // operation: 操作の内容(copy/copy_with_replace/move/unlink/mkdir/rmdir)
      clearstatcache();
      $tmp_base = RISOLUTO_USERLAND . $this->obj_sess->sessLoad( 'currentcage' );
      $this->filelist = array(
                                array(
                                       'target'      => $tmp_base . '/file/simpleblog_ckeditor.js'
                                     , 'destination' => RISOLUTO_DOCROOT . '/js/' . $this->target . '_ckeditor.js'
                                     , 'operation'   => 'copy_with_replace'
                                     , 'pass'        => ( !file_exists( $tmp_base . '/file/simpleblog_ckeditor.js' ) ? true : false )
                                     )
                              , array(
                                       'target'      => $tmp_base . '/file/simpleblog_posttweet.php'
                                     , 'destination' => RISOLUTO_BATCH . $this->target . '_posttweet.php'
                                     , 'operation'   => 'copy_with_replace'
                                     , 'pass'        => ( !file_exists( $tmp_base . '/file/simpleblog_posttweet.php' ) ? true : false )
                                     )
                              , array(
                                       'target'      => $tmp_base . '/file/simpleblog_posttweet.tpl'
                                     , 'destination' => RISOLUTO_BATCH . $this->target . '_posttweet.tpl'
                                     , 'operation'   => 'copy_with_replace'
                                     , 'pass'        => ( !file_exists( $tmp_base . '/file/simpleblog_posttweet.tpl' ) ? true : false )
                                     )
                              , array(
                                       'target'      => $tmp_base . '/file/simpleblog_version'
                                     , 'destination' => RISOLUTO_CONF . $this->target . '_version'
                                     , 'operation'   => 'copy_with_replace'
                                     , 'pass'        => ( !file_exists( $tmp_base . '/file/simpleblog_version' ) ? true : false )
                                     )
                              , array(
                                       'target'      => $tmp_base . '/file/simpleblog.ini'
                                     , 'destination' => RISOLUTO_CONF . $this->target . '.ini'
                                     , 'operation'   => 'copy_with_replace'
                                     , 'pass'        => ( !file_exists( $tmp_base . '/file/simpleblog.ini' ) ? true : false )
                                     )
                              , array(
                                       'target'      => $tmp_base . '/file/00005_simpleblog.tpl'
                                     , 'destination' => RISOLUTO_USERLAND . 'admin/menu/00005_' . $this->target . '.tpl'
                                     , 'operation'   => 'copy_with_replace'
                                     , 'pass'        => ( !file_exists( $tmp_base . '/file/00005_simpleblog.tpl' ) ? true : false )
                                     )
                              , array(
                                       'target'      => $tmp_base . '/file/AUTHORS'
                                     , 'destination' => RISOLUTO_USERLAND . $this->target . '/AUTHORS'
                                     , 'operation'   => 'copy_with_replace'
                                     , 'pass'        => ( !file_exists( $tmp_base . '/file/AUTHORS' ) ? true : false )
                                     )
                              , array(
                                       'target'      => $tmp_base . '/file/LICENSE'
                                     , 'destination' => RISOLUTO_USERLAND . $this->target . '/LICENSE'
                                     , 'operation'   => 'copy_with_replace'
                                     , 'pass'        => ( !file_exists( $tmp_base . '/file/LICENSE' ) ? true : false )
                                     )
                              , array(
                                       'target'      => $tmp_base . '/file/blog_menubar.tpl'
                                     , 'destination' => RISOLUTO_USERLAND . $this->target . '/blog_menubar.tpl'
                                     , 'operation'   => 'copy_with_replace'
                                     , 'pass'        => ( !file_exists( $tmp_base . '/file/blog_menubar.tpl' ) ? true : false )
                                     )
                              , array(
                                       'target'      => $tmp_base . '/file/blogadd_complete.php'
                                     , 'destination' => RISOLUTO_USERLAND . $this->target . '/blogadd_complete.php'
                                     , 'operation'   => 'copy_with_replace'
                                     , 'pass'        => ( !file_exists( $tmp_base . '/file/blogadd_complete.php' ) ? true : false )
                                     )
                              , array(
                                       'target'      => $tmp_base . '/file/blogadd_complete.tpl'
                                     , 'destination' => RISOLUTO_USERLAND . $this->target . '/blogadd_complete.tpl'
                                     , 'operation'   => 'copy_with_replace'
                                     , 'pass'        => ( !file_exists( $tmp_base . '/file/blogadd_complete.tpl' ) ? true : false )
                                     )
                              , array(
                                       'target'      => $tmp_base . '/file/blogadd_confirm.php'
                                     , 'destination' => RISOLUTO_USERLAND . $this->target . '/blogadd_confirm.php'
                                     , 'operation'   => 'copy_with_replace'
                                     , 'pass'        => ( !file_exists( $tmp_base . '/file/blogadd_confirm.php' ) ? true : false )
                                     )
                              , array(
                                       'target'      => $tmp_base . '/file/blogadd_confirm.tpl'
                                     , 'destination' => RISOLUTO_USERLAND . $this->target . '/blogadd_confirm.tpl'
                                     , 'operation'   => 'copy_with_replace'
                                     , 'pass'        => ( !file_exists( $tmp_base . '/file/blogadd_confirm.tpl' ) ? true : false )
                                     )
                              , array(
                                       'target'      => $tmp_base . '/file/blogadd_entry.php'
                                     , 'destination' => RISOLUTO_USERLAND . $this->target . '/blogadd_entry.php'
                                     , 'operation'   => 'copy_with_replace'
                                     , 'pass'        => ( !file_exists( $tmp_base . '/file/blogadd_entry.php' ) ? true : false )
                                     )
                              , array(
                                       'target'      => $tmp_base . '/file/blogadd_entry.tpl'
                                     , 'destination' => RISOLUTO_USERLAND . $this->target . '/blogadd_entry.tpl'
                                     , 'operation'   => 'copy_with_replace'
                                     , 'pass'        => ( !file_exists( $tmp_base . '/file/blogadd_entry.tpl' ) ? true : false )
                                     )
                              , array(
                                       'target'      => $tmp_base . '/file/blogcomment.php'
                                     , 'destination' => RISOLUTO_USERLAND . $this->target . '/blogcomment.php'
                                     , 'operation'   => 'copy_with_replace'
                                     , 'pass'        => ( !file_exists( $tmp_base . '/file/blogcomment.php' ) ? true : false )
                                     )
                              , array(
                                       'target'      => $tmp_base . '/file/blogcomment.tpl'
                                     , 'destination' => RISOLUTO_USERLAND . $this->target . '/blogcomment.tpl'
                                     , 'operation'   => 'copy_with_replace'
                                     , 'pass'        => ( !file_exists( $tmp_base . '/file/blogcomment.tpl' ) ? true : false )
                                     )
                              , array(
                                       'target'      => $tmp_base . '/file/blogdel_complete.php'
                                     , 'destination' => RISOLUTO_USERLAND . $this->target . '/blogdel_complete.php'
                                     , 'operation'   => 'copy_with_replace'
                                     , 'pass'        => ( !file_exists( $tmp_base . '/file/blogdel_complete.php' ) ? true : false )
                                     )
                              , array(
                                       'target'      => $tmp_base . '/file/blogdel_complete.tpl'
                                     , 'destination' => RISOLUTO_USERLAND . $this->target . '/blogdel_complete.tpl'
                                     , 'operation'   => 'copy_with_replace'
                                     , 'pass'        => ( !file_exists( $tmp_base . '/file/blogdel_complete.tpl' ) ? true : false )
                                     )
                              , array(
                                       'target'      => $tmp_base . '/file/blogdel_confirm.php'
                                     , 'destination' => RISOLUTO_USERLAND . $this->target . '/blogdel_confirm.php'
                                     , 'operation'   => 'copy_with_replace'
                                     , 'pass'        => ( !file_exists( $tmp_base . '/file/blogdel_confirm.php' ) ? true : false )
                                     )
                              , array(
                                       'target'      => $tmp_base . '/file/blogdel_confirm.tpl'
                                     , 'destination' => RISOLUTO_USERLAND . $this->target . '/blogdel_confirm.tpl'
                                     , 'operation'   => 'copy_with_replace'
                                     , 'pass'        => ( !file_exists( $tmp_base . '/file/blogdel_confirm.tpl' ) ? true : false )
                                     )
                              , array(
                                       'target'      => $tmp_base . '/file/bloglist.php'
                                     , 'destination' => RISOLUTO_USERLAND . $this->target . '/bloglist.php'
                                     , 'operation'   => 'copy_with_replace'
                                     , 'pass'        => ( !file_exists( $tmp_base . '/file/bloglist.php' ) ? true : false )
                                     )
                              , array(
                                       'target'      => $tmp_base . '/file/bloglist.tpl'
                                     , 'destination' => RISOLUTO_USERLAND . $this->target . '/bloglist.tpl'
                                     , 'operation'   => 'copy_with_replace'
                                     , 'pass'        => ( !file_exists( $tmp_base . '/file/bloglist.tpl' ) ? true : false )
                                     )
                              , array(
                                       'target'      => $tmp_base . '/file/blogmod_complete.php'
                                     , 'destination' => RISOLUTO_USERLAND . $this->target . '/blogmod_complete.php'
                                     , 'operation'   => 'copy_with_replace'
                                     , 'pass'        => ( !file_exists( $tmp_base . '/file/blogmod_complete.php' ) ? true : false )
                                     )
                              , array(
                                       'target'      => $tmp_base . '/file/blogmod_complete.tpl'
                                     , 'destination' => RISOLUTO_USERLAND . $this->target . '/blogmod_complete.tpl'
                                     , 'operation'   => 'copy_with_replace'
                                     , 'pass'        => ( !file_exists( $tmp_base . '/file/blogmod_complete.tpl' ) ? true : false )
                                     )
                              , array(
                                       'target'      => $tmp_base . '/file/blogmod_confirm.php'
                                     , 'destination' => RISOLUTO_USERLAND . $this->target . '/blogmod_confirm.php'
                                     , 'operation'   => 'copy_with_replace'
                                     , 'pass'        => ( !file_exists( $tmp_base . '/file/blogmod_confirm.php' ) ? true : false )
                                     )
                              , array(
                                       'target'      => $tmp_base . '/file/blogmod_confirm.tpl'
                                     , 'destination' => RISOLUTO_USERLAND . $this->target . '/blogmod_confirm.tpl'
                                     , 'operation'   => 'copy_with_replace'
                                     , 'pass'        => ( !file_exists( $tmp_base . '/file/blogmod_confirm.tpl' ) ? true : false )
                                     )
                              , array(
                                       'target'      => $tmp_base . '/file/blogmod_entry.php'
                                     , 'destination' => RISOLUTO_USERLAND . $this->target . '/blogmod_entry.php'
                                     , 'operation'   => 'copy_with_replace'
                                     , 'pass'        => ( !file_exists( $tmp_base . '/file/blogmod_entry.php' ) ? true : false )
                                     )
                              , array(
                                       'target'      => $tmp_base . '/file/blogmod_entry.tpl'
                                     , 'destination' => RISOLUTO_USERLAND . $this->target . '/blogmod_entry.tpl'
                                     , 'operation'   => 'copy_with_replace'
                                     , 'pass'        => ( !file_exists( $tmp_base . '/file/blogmod_entry.tpl' ) ? true : false )
                                     )
                              , array(
                                       'target'      => $tmp_base . '/file/blogview.php'
                                     , 'destination' => RISOLUTO_USERLAND . $this->target . '/blogview.php'
                                     , 'operation'   => 'copy_with_replace'
                                     , 'pass'        => ( !file_exists( $tmp_base . '/file/blogview.php' ) ? true : false )
                                     )
                              , array(
                                       'target'      => $tmp_base . '/file/blogview.tpl'
                                     , 'destination' => RISOLUTO_USERLAND . $this->target . '/blogview.tpl'
                                     , 'operation'   => 'copy_with_replace'
                                     , 'pass'        => ( !file_exists( $tmp_base . '/file/blogview.tpl' ) ? true : false )
                                     )
                              , array(
                                       'target'      => $tmp_base . '/file/blogview.php'
                                     , 'destination' => RISOLUTO_USERLAND . $this->target . '/blogview.php'
                                     , 'operation'   => 'copy_with_replace'
                                     , 'pass'        => ( !file_exists( $tmp_base . '/file/blogview.php' ) ? true : false )
                                     )
                              , array(
                                       'target'      => $tmp_base . '/file/categoryadd_complete.tpl'
                                     , 'destination' => RISOLUTO_USERLAND . $this->target . '/categoryadd_complete.tpl'
                                     , 'operation'   => 'copy_with_replace'
                                     , 'pass'        => ( !file_exists( $tmp_base . '/file/categoryadd_complete.tpl' ) ? true : false )
                                     )
                              , array(
                                       'target'      => $tmp_base . '/file/categoryadd_complete.php'
                                     , 'destination' => RISOLUTO_USERLAND . $this->target . '/categoryadd_complete.php'
                                     , 'operation'   => 'copy_with_replace'
                                     , 'pass'        => ( !file_exists( $tmp_base . '/file/categoryadd_complete.php' ) ? true : false )
                                     )
                              , array(
                                       'target'      => $tmp_base . '/file/categoryadd_confirm.tpl'
                                     , 'destination' => RISOLUTO_USERLAND . $this->target . '/categoryadd_confirm.tpl'
                                     , 'operation'   => 'copy_with_replace'
                                     , 'pass'        => ( !file_exists( $tmp_base . '/file/categoryadd_confirm.tpl' ) ? true : false )
                                     )
                              , array(
                                       'target'      => $tmp_base . '/file/categoryadd_confirm.php'
                                     , 'destination' => RISOLUTO_USERLAND . $this->target . '/categoryadd_confirm.php'
                                     , 'operation'   => 'copy_with_replace'
                                     , 'pass'        => ( !file_exists( $tmp_base . '/file/categoryadd_confirm.php' ) ? true : false )
                                     )
                              , array(
                                       'target'      => $tmp_base . '/file/categoryadd_entry.tpl'
                                     , 'destination' => RISOLUTO_USERLAND . $this->target . '/categoryadd_entry.tpl'
                                     , 'operation'   => 'copy_with_replace'
                                     , 'pass'        => ( !file_exists( $tmp_base . '/file/categoryadd_entry.tpl' ) ? true : false )
                                     )
                              , array(
                                       'target'      => $tmp_base . '/file/categoryadd_entry.php'
                                     , 'destination' => RISOLUTO_USERLAND . $this->target . '/categoryadd_entry.php'
                                     , 'operation'   => 'copy_with_replace'
                                     , 'pass'        => ( !file_exists( $tmp_base . '/file/categoryadd_entry.php' ) ? true : false )
                                     )
                              , array(
                                       'target'      => $tmp_base . '/file/categorydel_complete.tpl'
                                     , 'destination' => RISOLUTO_USERLAND . $this->target . '/categorydel_complete.tpl'
                                     , 'operation'   => 'copy_with_replace'
                                     , 'pass'        => ( !file_exists( $tmp_base . '/file/categorydel_complete.tpl' ) ? true : false )
                                     )
                              , array(
                                       'target'      => $tmp_base . '/file/categorydel_complete.php'
                                     , 'destination' => RISOLUTO_USERLAND . $this->target . '/categorydel_complete.php'
                                     , 'operation'   => 'copy_with_replace'
                                     , 'pass'        => ( !file_exists( $tmp_base . '/file/categorydel_complete.php' ) ? true : false )
                                     )
                              , array(
                                       'target'      => $tmp_base . '/file/categorydel_confirm.tpl'
                                     , 'destination' => RISOLUTO_USERLAND . $this->target . '/categorydel_confirm.tpl'
                                     , 'operation'   => 'copy_with_replace'
                                     , 'pass'        => ( !file_exists( $tmp_base . '/file/categorydel_confirm.tpl' ) ? true : false )
                                     )
                              , array(
                                       'target'      => $tmp_base . '/file/categorydel_confirm.php'
                                     , 'destination' => RISOLUTO_USERLAND . $this->target . '/categorydel_confirm.php'
                                     , 'operation'   => 'copy_with_replace'
                                     , 'pass'        => ( !file_exists( $tmp_base . '/file/categorydel_confirm.php' ) ? true : false )
                                     )
                              , array(
                                       'target'      => $tmp_base . '/file/categorylist.tpl'
                                     , 'destination' => RISOLUTO_USERLAND . $this->target . '/categorylist.tpl'
                                     , 'operation'   => 'copy_with_replace'
                                     , 'pass'        => ( !file_exists( $tmp_base . '/file/categorylist.tpl' ) ? true : false )
                                     )
                              , array(
                                       'target'      => $tmp_base . '/file/categorylist.php'
                                     , 'destination' => RISOLUTO_USERLAND . $this->target . '/categorylist.php'
                                     , 'operation'   => 'copy_with_replace'
                                     , 'pass'        => ( !file_exists( $tmp_base . '/file/categorylist.php' ) ? true : false )
                                     )
                              , array(
                                       'target'      => $tmp_base . '/file/categorymod_complete.tpl'
                                     , 'destination' => RISOLUTO_USERLAND . $this->target . '/categorymod_complete.tpl'
                                     , 'operation'   => 'copy_with_replace'
                                     , 'pass'        => ( !file_exists( $tmp_base . '/file/categorymod_complete.tpl' ) ? true : false )
                                     )
                              , array(
                                       'target'      => $tmp_base . '/file/categorymod_complete.php'
                                     , 'destination' => RISOLUTO_USERLAND . $this->target . '/categorymod_complete.php'
                                     , 'operation'   => 'copy_with_replace'
                                     , 'pass'        => ( !file_exists( $tmp_base . '/file/categorymod_complete.php' ) ? true : false )
                                     )
                              , array(
                                       'target'      => $tmp_base . '/file/categorymod_confirm.tpl'
                                     , 'destination' => RISOLUTO_USERLAND . $this->target . '/categorymod_confirm.tpl'
                                     , 'operation'   => 'copy_with_replace'
                                     , 'pass'        => ( !file_exists( $tmp_base . '/file/categorymod_confirm.tpl' ) ? true : false )
                                     )
                              , array(
                                       'target'      => $tmp_base . '/file/categorymod_confirm.php'
                                     , 'destination' => RISOLUTO_USERLAND . $this->target . '/categorymod_confirm.php'
                                     , 'operation'   => 'copy_with_replace'
                                     , 'pass'        => ( !file_exists( $tmp_base . '/file/categorymod_confirm.php' ) ? true : false )
                                     )
                              , array(
                                       'target'      => $tmp_base . '/file/categorymod_entry.tpl'
                                     , 'destination' => RISOLUTO_USERLAND . $this->target . '/categorymod_entry.tpl'
                                     , 'operation'   => 'copy_with_replace'
                                     , 'pass'        => ( !file_exists( $tmp_base . '/file/categorymod_entry.tpl' ) ? true : false )
                                     )
                              , array(
                                       'target'      => $tmp_base . '/file/categorymod_entry.php'
                                     , 'destination' => RISOLUTO_USERLAND . $this->target . '/categorymod_entry.php'
                                     , 'operation'   => 'copy_with_replace'
                                     , 'pass'        => ( !file_exists( $tmp_base . '/file/categorymod_entry.php' ) ? true : false )
                                     )
                              , array(
                                       'target'      => $tmp_base . '/file/blogview.tpl'
                                     , 'destination' => RISOLUTO_USERLAND . $this->target . '/blogview.tpl'
                                     , 'operation'   => 'copy_with_replace'
                                     , 'pass'        => ( !file_exists( $tmp_base . '/file/blogview.tpl' ) ? true : false )
                                     )
                              , array(
                                       'target'      => $tmp_base . '/file/comment_add.php'
                                     , 'destination' => RISOLUTO_USERLAND . $this->target . '/comment_add.php'
                                     , 'operation'   => 'copy_with_replace'
                                     , 'pass'        => ( !file_exists( $tmp_base . '/file/comment_add.php' ) ? true : false )
                                     )
                              , array(
                                       'target'      => $tmp_base . '/file/comment_del.php'
                                     , 'destination' => RISOLUTO_USERLAND . $this->target . '/comment_del.php'
                                     , 'operation'   => 'copy_with_replace'
                                     , 'pass'        => ( !file_exists( $tmp_base . '/file/comment_del.php' ) ? true : false )
                                     )
                              , array(
                                       'target'      => $tmp_base . '/file/comment_ng.php'
                                     , 'destination' => RISOLUTO_USERLAND . $this->target . '/comment_ng.php'
                                     , 'operation'   => 'copy_with_replace'
                                     , 'pass'        => ( !file_exists( $tmp_base . '/file/comment_ng.php' ) ? true : false )
                                     )
                              , array(
                                       'target'      => $tmp_base . '/file/comment_notification.tpl'
                                     , 'destination' => RISOLUTO_USERLAND . $this->target . '/comment_notification.tpl'
                                     , 'operation'   => 'copy_with_replace'
                                     , 'pass'        => ( !file_exists( $tmp_base . '/file/comment_notification.tpl' ) ? true : false )
                                     )
                              , array(
                                       'target'      => $tmp_base . '/file/comment_ok.php'
                                     , 'destination' => RISOLUTO_USERLAND . $this->target . '/comment_ok.php'
                                     , 'operation'   => 'copy_with_replace'
                                     , 'pass'        => ( !file_exists( $tmp_base . '/file/comment_ok.php' ) ? true : false )
                                     )
                              , array(
                                       'target'      => $tmp_base . '/file/commentlist.php'
                                     , 'destination' => RISOLUTO_USERLAND . $this->target . '/commentlist.php'
                                     , 'operation'   => 'copy_with_replace'
                                     , 'pass'        => ( !file_exists( $tmp_base . '/file/commentlist.php' ) ? true : false )
                                     )
                              , array(
                                       'target'      => $tmp_base . '/file/commentlist.tpl'
                                     , 'destination' => RISOLUTO_USERLAND . $this->target . '/commentlist.tpl'
                                     , 'operation'   => 'copy_with_replace'
                                     , 'pass'        => ( !file_exists( $tmp_base . '/file/commentlist.tpl' ) ? true : false )
                                     )
                              , array(
                                       'target'      => $tmp_base . '/file/rss.php'
                                     , 'destination' => RISOLUTO_USERLAND . $this->target . '/rss.php'
                                     , 'operation'   => 'copy_with_replace'
                                     , 'pass'        => ( !file_exists( $tmp_base . '/file/rss.php' ) ? true : false )
                                     )
                              , array(
                                       'target'      => $tmp_base . '/file/rss_1.0.tpl'
                                     , 'destination' => RISOLUTO_USERLAND . $this->target . '/rss_1.0.tpl'
                                     , 'operation'   => 'copy_with_replace'
                                     , 'pass'        => ( !file_exists( $tmp_base . '/file/rss_1.0.tpl' ) ? true : false )
                                     )
                              , array(
                                       'target'      => $tmp_base . '/file/rss_2.0.tpl'
                                     , 'destination' => RISOLUTO_USERLAND . $this->target . '/rss_2.0.tpl'
                                     , 'operation'   => 'copy_with_replace'
                                     , 'pass'        => ( !file_exists( $tmp_base . '/file/rss_2.0.tpl' ) ? true : false )
                                     )
                              , array(
                                       'target'      => $tmp_base . '/file/rss_2.0_ya.tpl'
                                     , 'destination' => RISOLUTO_USERLAND . $this->target . '/rss_2.0_ya.tpl'
                                     , 'operation'   => 'copy_with_replace'
                                     , 'pass'        => ( !file_exists( $tmp_base . '/file/rss_2.0_ya.tpl' ) ? true : false )
                                     )
                              , array(
                                       'target'      => $tmp_base . '/file/simpleblog_base.inc'
                                     , 'destination' => RISOLUTO_USERLAND . $this->target . '/simpleblog_base.inc'
                                     , 'operation'   => 'copy_with_replace'
                                     , 'pass'        => ( !file_exists( $tmp_base . '/file/simpleblog_base.inc' ) ? true : false )
                                     )
                              , array(
                                       'target'      => $tmp_base . '/file/tb.php'
                                     , 'destination' => RISOLUTO_USERLAND . $this->target . '/tb.php'
                                     , 'operation'   => 'copy_with_replace'
                                     , 'pass'        => ( !file_exists( $tmp_base . '/file/tb.php' ) ? true : false )
                                     )
                              , array(
                                       'target'      => $tmp_base . '/file/trackback_del.php'
                                     , 'destination' => RISOLUTO_USERLAND . $this->target . '/trackback_del.php'
                                     , 'operation'   => 'copy_with_replace'
                                     , 'pass'        => ( !file_exists( $tmp_base . '/file/trackback_del.php' ) ? true : false )
                                     )
                              , array(
                                       'target'      => $tmp_base . '/file/trackback_ng.php'
                                     , 'destination' => RISOLUTO_USERLAND . $this->target . '/trackback_ng.php'
                                     , 'operation'   => 'copy_with_replace'
                                     , 'pass'        => ( !file_exists( $tmp_base . '/file/trackback_ng.php' ) ? true : false )
                                     )
                              , array(
                                       'target'      => $tmp_base . '/file/trackback_notification.tpl'
                                     , 'destination' => RISOLUTO_USERLAND . $this->target . '/trackback_notification.tpl'
                                     , 'operation'   => 'copy_with_replace'
                                     , 'pass'        => ( !file_exists( $tmp_base . '/file/trackback_notification.tpl' ) ? true : false )
                                     )
                              , array(
                                       'target'      => $tmp_base . '/file/trackback_ok.php'
                                     , 'destination' => RISOLUTO_USERLAND . $this->target . '/trackback_ok.php'
                                     , 'operation'   => 'copy_with_replace'
                                     , 'pass'        => ( !file_exists( $tmp_base . '/file/trackback_ok.php' ) ? true : false )
                                     )
                              , array(
                                       'target'      => $tmp_base . '/file/trackbacklist.php'
                                     , 'destination' => RISOLUTO_USERLAND . $this->target . '/trackbacklist.php'
                                     , 'operation'   => 'copy_with_replace'
                                     , 'pass'        => ( !file_exists( $tmp_base . '/file/trackbacklist.php' ) ? true : false )
                                     )
                              , array(
                                       'target'      => $tmp_base . '/file/trackbacklist.tpl'
                                     , 'destination' => RISOLUTO_USERLAND . $this->target . '/trackbacklist.tpl'
                                     , 'operation'   => 'copy_with_replace'
                                     , 'pass'        => ( !file_exists( $tmp_base . '/file/trackbacklist.tpl' ) ? true : false )
                                     )
                             );

      // 処理を行う
      foreach( $this->filelist as $dat )
      {
        if ( $dat[ 'pass' ] )
        {
          continue;
        } // end of if

        // 処理を呼び出す
        $tmp_errflag = $this->obj_util->fileOperator( $dat[ 'operation' ], $dat[ 'target' ], $dat[ 'destination' ], $this->target );

        // 処理結果によって、状態を変える
        if ( $tmp_errflag )
        {
          $this->checkresult[] = array(
                                        'operation'   => $dat[ 'operation'   ]
                                      , 'target'      => $dat[ 'target'      ]
                                      , 'destination' => $dat[ 'destination' ]
                                      , 'result'  => 'OK'
                                      );
        } // end of if
        else
        {
          $this->checkresult[] = array(
                                        'operation'   => $dat[ 'operation'   ]
                                      , 'target'      => $dat[ 'target'      ]
                                      , 'destination' => $dat[ 'destination' ]
                                      , 'result'  => 'NG'
                                      );
          $this->errStatus     = 'NG';
        } // end of else
      } // end of foreach

      return true;
    } // end of function:model()

    /**
     * viewメソッド（モデル）
     *
     * テンプレート関連処理等のビューに相当する部分の処理を行う
     *
     * @param     void なし
     * @return    boolean ファンクション実行結果（ true：正常終了 / false: 異常終了 ）
     */
    public function view()
    {
      // ヘッダ情報をセット
      $html_header[ 'robots' ] = 'NOINDEX,NOFOLLOW';
      $html_header[ 'css'    ] = array( './css/common.css' );
      $html_header[ 'title'  ] = 'アップグレードFlavor(5)';

      // アサイン
      $this->smarty->assign ( 'header',    $html_header       );
      $this->smarty->assign ( 'checklist', $this->checkresult );
      $this->smarty->assign ( 'err',       $this->errStatus   );

      $this->smarty->assign ( 'cage',   str_replace( DIRECTORY_SEPARATOR, '.' , $this->obj_sess->sessLoad( 'currentcage' ) ) );

      // 表示
      $this->smarty->display( 'page05.tpl' );

      return true;

    } // end of function:view()

  } // end of class:page05
?>
