<?php
/**
 * インストール画面(4)クラス
 *
 * インストール画面(4)を実現するためのクラス
 *
 * @package   risoluto
 * @author    Risoluto Developers
 * @license   http://opensource.org/licenses/bsd-license.php new BSD license
 * @copyright (C) 2008-2011 Risoluto Developers / All Rights Reserved.
 */

  /**
   * 基底クラス
   */
  require_once( 'install_base.inc' );

  /**
   * データベース操作クラス
   */
  require_once( RISOLUTO_FUNC . 'risoluto_db.php' );

  class page04 extends install_base
  {
    //------------------------------------------------------//
    // クラス変数定義
    //------------------------------------------------------//
    /**
     * チェック情報格納用変数
     * @access private
     * @var    array
     */
    private $checklist;
    /**
     * チェック結果格納用変数
     * @access private
     * @var    array
     */
    private $checkresult;
    /**
     * エラー発生状況格納用変数
     * @access private
     * @var    boolean
     */
    private $errStatus;
    /**
     * データベース操作クラスインスタンスを保持する変数
     * @access private
     * @var    object
     */
    private $obj_db;

    //------------------------------------------------------//
    // クラスメソッド定義
    //------------------------------------------------------//
    /**
     * コンストラクタメソッド
     *
     * コンストラクタメソッド
     *
     * @param     void なし
     * @return    void なし
     */
    public function __construct()
    {
    } // end of function:__construct()

    /**
     * クローンメソッド
     *
     * クローンメソッド
     *
     * @param     void なし
     * @return    void なし
     */
    public function __clone()
    {
    } // end of function:__clone()

    /**
     * modelメソッド（モデル）
     *
     * データ取得等のモデルに相当する部分の処理を行う
     *
     * @param     void なし
     * @return    boolean ファンクション実行結果（ true：正常終了 / false: 異常終了 ）
     */
    public function model()
    {
      // 前画面のCageが「install」でない or 前画面のActが「page03」 and 「page04」 and 「page05」でない場合、
      // インストーラトップに飛ばす
      $tmp_cage = str_replace( DIRECTORY_SEPARATOR, '.', $this->obj_sess->sessLoad( 'lastcage' ) );
      $tmp_act  = $this->obj_sess->sessLoad( 'lastact'  );
      if ( $tmp_cage != 'install' or ( $tmp_act != 'page03' and $tmp_act != 'page04' and $tmp_act != 'page05' ) )
      {
        $this->obj_util->redirectTo( 'install', 'install' );
        return false;
      } // end of if

      // チェック対象となるDSNをセットする
      // 他にチェック対象があれば、この配列に加えてください。
      // section: セクション名 / key: キー名
      $this->checklist = array(
                                array(
                                       'section'     => 'DBS'
                                     , 'key'         => 'DEFAULT_DSN'
                                     , 'description' => '既存テーブルの削除'
                                     , 'path'        => RISOLUTO_USERLAND . 'install/sql/DEFAULT_DSN_drop.sql'
                                     )
                              , array(
                                       'section'     => 'DBS'
                                     , 'key'         => 'DEFAULT_DSN'
                                     , 'description' => 'テーブルの作成'
                                     , 'path'        => RISOLUTO_USERLAND . 'install/sql/DEFAULT_DSN_create.sql'
                                     )
                              , array(
                                       'section'     => 'DBS'
                                     , 'key'         => 'DEFAULT_DSN'
                                     , 'description' => 'データの挿入'
                                     , 'path'        => RISOLUTO_USERLAND . 'install/sql/DEFAULT_DSN_data.sql'
                                     )
                              );

      // 指定された分だけ処理を回す
      foreach( $this->checklist as $dat )
      {
        // データベース操作クラスのインスタンスを生成する
        $this->obj_db = new RisolutoDb();

        // エラーフラグを初期化（デフォルトはtrue）
        $tmp_errflag = true;

        // データベースに接続する
        if ( $this->obj_db->dbConnect( $this->obj_conf->get( $dat[ 'section' ], $dat[ 'key' ] ) ) )
        {

          $tmp_errflag = $this->obj_db->fileSQLExec( $dat[ 'path' ] );

          // 接続に成功している場合は接続をクローズする
          $this->obj_db->dbDisConnect();

          // エラーフラグの値によって格納する値を変更する
          if ( $tmp_errflag )
          {
            $this->checkresult[] = array(
                                          'description' => $dat[ 'description' ]
                                        , 'result'      => 'OK'
                                        );
          } // end of if
          else
          {
            $this->checkresult[] = array(
                                          'description' => $dat[ 'description' ]
                                        , 'result'      => 'NG'
                                        );
            $this->errStatus     = 'NG';
          } // end of else
        } // end of if
        else
        {
          $this->checkresult[] = array(
                                        'description' => $dat[ 'description' ]
                                      , 'result'      => 'NG'
                                      );
          $this->errStatus     = 'NG';
        } // end of else
      } // end of foreach

      return true;
    } // end of function:model()

    /**
     * viewメソッド（モデル）
     *
     * テンプレート関連処理等のビューに相当する部分の処理を行う
     *
     * @param     void なし
     * @return    boolean ファンクション実行結果（ true：正常終了 / false: 異常終了 ）
     */
    public function view()
    {
      // ヘッダ情報をセット
      $html_header[ 'robots' ] = 'NOINDEX,NOFOLLOW';
      $html_header[ 'css'    ] = array( './css/common.css' );
      $html_header[ 'title'  ] = 'インストーラ(4)';

      // アサイン
      $this->smarty->assign ( 'header',    $html_header       );
      $this->smarty->assign ( 'checklist', $this->checkresult );
      $this->smarty->assign ( 'err',       $this->errStatus   );

      // 表示
      $this->smarty->display( 'page04.tpl' );

      return true;

    } // end of function:view()

  } // end of class:page04
?>
