<?php
/**
 * コメント追加画面クラス
 *
 * コメント追加画面を実現するためのクラス
 *
 * @package   simpleblog
 * @author    Risoluto Developers
 * @license   http://opensource.org/licenses/bsd-license.php new BSD license
 * @copyright (C) 2008-2009 Risoluto Developers / All Rights Reserved.
 */

  /**
   * 基底クラス
   */
  require_once( "simpleblog_base.inc" );
  /**
   * データベース操作クラス
   */
  require_once( RISOLUTO_FUNC . 'risoluto_db.php' );

  class comment_add extends simpleblog_base
  {
    //------------------------------------------------------//
    // クラス変数定義
    //------------------------------------------------------//
    /**
     * データベース操作クラスインスタンスを保持する変数
     * @access private
     * @var    object
     */
    private $obj_db;
    /**
     * ユーティリティクラスインスタンスを保持する変数
     * @access private
     * @var    object
     */
    private $obj_conf;
    /**
     * 取得データを保持する変数
     * @access private
     * @var    object
     */
    private $gotDat;

    //------------------------------------------------------//
    // クラスメソッド定義
    //------------------------------------------------------//
    /**
     * コンストラクタメソッド
     *
     * コンストラクタメソッド
     *
     * @param     void なし
     * @return    void なし
     */
    public function __construct()
    {
    } // end of function:__construct()

    /**
     * クローンメソッド
     *
     * クローンメソッド
     *
     * @param     void なし
     * @return    void なし
     */
    public function __clone()
    {
    } // end of function:__clone()

    /**
     * modelメソッド（モデル）
     *
     * データ取得等のモデルに相当する部分の処理を行う
     *
     * @param     void なし
     * @return    boolean ファンクション実行結果（ true：正常終了 / false: 異常終了 ）
     */
    public function model()
    {
      // 必要なインスタンスを生成
      $this->obj_db   = new RisoluteDb();
      $this->obj_conf = new RisolutoConf();
      $this->obj_conf->parse( RISOLUTO_CONF . 'risoluto.ini' );

      // 前画面のCageが自分と同じ又は「admin.site」でない or 前画面のActが「blogcomment」または「uploadviewer」でない場合、
      // 入力画面に飛ばす
      $tmp_cage_last    = str_replace( DIRECTORY_SEPARATOR, '.', $this->obj_sess->sessLoad( 'lastcage'    ) );
      $tmp_cage_current = str_replace( DIRECTORY_SEPARATOR, '.', $this->obj_sess->sessLoad( 'currentcage' ) );
      $tmp_act  = $this->obj_sess->sessLoad( 'lastact' );

      if ( ( $tmp_cage_last != $tmp_cage_current and $tmp_cage_last != 'admin.site' ) or ( $tmp_act != 'blogcomment' and $tmp_act != 'uploadviewer' ) )
      {
        $this->obj_util->redirectTo( 'blogview', $tmp_cage_current );
        return false;
      } // end of if



      //------------------------------------------------------------------------
      // 前画面の入力値を取得
      //------------------------------------------------------------------------
      // 初期化
      $tmp_entered[ 'id'      ] = null;
      $tmp_entered[ 'name'    ] = null;
      $tmp_entered[ 'comment' ] = null;

      // ID
      if ( isset( $_GET[ 'id' ] ) )
      {
        $tmp_entered[ 'id'      ] = strip_tags( trim( $_GET [ 'id'      ] ) );
      } // end of if

      // お名前
      if ( isset( $_POST[ 'name' ] ) )
      {
        $tmp_entered[ 'name'    ] = strip_tags( trim( $_POST[ 'name'    ] ) );
      } // end of if

      // コメント
      if ( isset( $_POST[ 'comment' ] ) )
      {
        $tmp_entered[ 'comment' ] = strip_tags( trim( $_POST[ 'comment' ] ) );
      } // end of if



      //------------------------------------------------------------------------
      // 入力情報のチェック
      //------------------------------------------------------------------------
      // ID（数値ではない）
      if ( ! is_numeric( $tmp_entered[ 'id' ] ) )
      {
        // 例外を投げる
        throw new Exception( 'invalid id' );
        return false;
      } // end of if

      // お名前（入力値が空）
      if ( empty( $tmp_entered[ 'name' ] ) )
      {
        // 前画面に戻る
        $this->obj_util->redirectTo( 'blogcomment', $tmp_cage_current, 'blogid', $tmp_entered[ 'id' ] );
        return true;
      } // end of if
      // 名前（入力値が半角255文字以上）
      if ( strlen( $tmp_entered[ 'name' ] ) > 255 )
      {
        // 前画面に戻る
        $this->obj_util->redirectTo( 'blogcomment', $tmp_cage_current, 'blogid', $tmp_entered[ 'id' ] );
        return true;
      } // end of if

      // コメント（入力値が空か、数値ではない）
      if ( empty( $tmp_entered[ 'comment' ] ) )
      {
        // 前画面に戻る
        $this->obj_util->redirectTo( 'blogcomment', $tmp_cage_current, 'blogid', $tmp_entered[ 'id' ] );
        return true;
      } // end of if



      //------------------------------------------------------------------------
      // 現在の最新IDを取得
      //------------------------------------------------------------------------

      // データベースに接続する
      if ( $this->obj_db->dbConnect( $this->obj_conf->get( 'DBS', 'DEFAULT_DSN' ) ) )
      {
        // トランザクションを開始
        $this->obj_db->dbBeginTransaction();

        // SQL文を組み立てる
        $sql =<<<End_Of_SQL

              SELECT MAX( `comment`.`comment_id` ) + 1 as latest_id
                FROM `simpleblog_t_comment` comment
                 FOR UPDATE;

End_Of_SQL;

        // パラメタも用意する
        $param = array(
                      );

        // SQLの実行に失敗した場合は、例外を投げる
        $tmp_result = $this->obj_db->dbGetRow( $sql, $param );
        if ( PEAR::isError( $tmp_result ) )
        {
          // 接続をクローズする
          $this->obj_db->dbDisConnect();
          throw new Exception( 'Latest comment_id Get Failure' );
          return false;
        } // end of if
        // 入力された値と、取得した値を使ってデータをインサートする
        else
        {

          // 取得したIDが上限値を上回っていた場合、例外を投げる
          if ( $tmp_result[ 'latest_id' ] > $this->obj_conf->get( 'LIMITS', 'id_upper' ) )
          {
            // 接続をクローズする
            $this->obj_db->dbDisConnect();
            throw new Exception( 'id was exceeded upper limit' );
            return false;
          }// end of if

          // 取得したIDがNULLなら「0」をセットする
          if ( is_null( $tmp_result[ 'latest_id' ] ) )
          {
            $tmp_result[ 'latest_id' ] = 0;
          } // end of if

          // トランザクションを開始
          $this->obj_db->dbBeginTransaction();

          // SQL文を組み立てる
          $sql =<<<End_Of_SQL

              INSERT INTO `simpleblog_t_comment`
              (
                `ctime`
              , `cuser`
              , `mtime`
              , `muser`
              , `comment_id`
              , `blog_id`
              , `commentator`
              , `comment`
              , `status`
              ) VALUES (
                  now()
                , ?
                , now()
                , ?
                , ?
                , ?
                , ?
                , ?
                , 1
              );

End_Of_SQL;

          // パラメタも用意する
          $tmp_myself = $this->obj_util->answerMyId();
          $param = array(
                          $tmp_myself
                        , $tmp_myself
                        , $tmp_result [ 'latest_id' ]
                        , $tmp_entered[ 'id'        ]
                        , $tmp_entered[ 'name'      ]
                        , $tmp_entered[ 'comment'   ]
                        );

          // Insertを実行
          $tmp_insert_result = $this->obj_db->dbExecSQL( $sql, $param );
          if ( PEAR::isError( $tmp_insert_result ) )
          {
            // エラーの場合はロールバックして接続を閉じ、例外を投げる
            $this->obj_db->dbRollback();
            $this->obj_db->dbDisConnect();
            throw new Exception( 'Insert Failure' );
            return false;
          } // end of if
          else
          {
            // 正常に実行できた場合はコミットして接続を閉じる
            $this->obj_db->dbCommit();
            $this->obj_db->dbDisConnect();
          } // end of else

        } // end of else

      } // end of if
      // データベースに接続できなかった場合は、例外を投げる
      else
      {
        throw new Exception( 'DB Connection Failure' );
        return false;
      } // end of else

      // コメント画面にリダイレクトする
      $this->obj_util->redirectTo( 'blogcomment', $tmp_cage_current, 'blogid', $tmp_entered[ 'id' ] );
      return true;
    } // end of function:model()

    /**
     * viewメソッド（モデル）
     *
     * テンプレート関連処理等のビューに相当する部分の処理を行う
     *
     * @param     void なし
     * @return    boolean ファンクション実行結果（ true：正常終了 / false: 異常終了 ）
     */
    public function view()
    {

      return true;

    } // end of function:view()

  } // end of class:comment_add

?>
