<?php
/**
 * ヘッダ一覧画面クラス
 *
 * ヘッダ一覧画面を実現するためのクラス
 *
 * @package   risoluto
 * @author    Risoluto Developers
 * @license   http://opensource.org/licenses/bsd-license.php new BSD license
 * @copyright (C) 2008-2009 Risoluto Developers / All Rights Reserved.
 */

  /**
   * 基底クラス
   */
  require_once( "admin_site_base.inc" );
  /**
   * データベース操作クラス
   */
  require_once( RISOLUTO_FUNC . 'risoluto_db.php' );

  /**
   * ページャクラス
   */
  require_once( 'Pager.php' );

  class headerlist extends admin_site_base
  {
    //------------------------------------------------------//
    // クラス変数定義
    //------------------------------------------------------//
    /**
     * データベース操作クラスインスタンスを保持する変数
     * @access private
     * @var    object
     */
    private $obj_db;
    /**
     * ユーティリティクラスインスタンスを保持する変数
     * @access private
     * @var    object
     */
    private $obj_conf;
    /**
     * 取得データを保持する変数
     * @access private
     * @var    object
     */
    private $gotDat;

    //------------------------------------------------------//
    // クラスメソッド定義
    //------------------------------------------------------//
    /**
     * コンストラクタメソッド
     *
     * コンストラクタメソッド
     *
     * @param     void なし
     * @return    void なし
     */
    public function __construct()
    {
    } // end of function:__construct()

    /**
     * クローンメソッド
     *
     * クローンメソッド
     *
     * @param     void なし
     * @return    void なし
     */
    public function __clone()
    {
    } // end of function:__clone()

    /**
     * modelメソッド（モデル）
     *
     * データ取得等のモデルに相当する部分の処理を行う
     *
     * @param     void なし
     * @return    boolean ファンクション実行結果（ true：正常終了 / false: 異常終了 ）
     */
    public function model()
    {
      // 必要なインスタンスを生成
      $this->obj_conf = new RisolutoConf();
      $this->obj_conf->parse( RISOLUTO_CONF . 'risoluto.ini' );

      // スーパバイザセッション又はアドミンセッションが存在しない場合は、
      // ログイン画面に遷移する
      if ( ! $this->obj_util->is_Admin() )
      {
        $this->obj_util->redirectTo( $this->obj_adminconf->get( 'COMMON', 'login_act'  )
                                   , $this->obj_adminconf->get( 'COMMON', 'login_cage' ) );
        return false;
      } // end of if



      //------------------------------------------------------------------------
      // ユーザ情報の取得
      //------------------------------------------------------------------------

      // データベースに接続する
      // データベース操作クラスのインスタンスを生成する
      $this->obj_db = new RisoluteDb();

      // データベースに接続する
      if ( $this->obj_db->dbConnect( $this->obj_conf->get( 'DBS', 'DEFAULT_DSN' ) ) )
      {
        // SQL文を組み立てる
        $sql =<<<End_Of_SQL

              SELECT `headers`.`act`          -- Act
                   , `headers`.`cage`         -- Cage
                   , `headers`.`robot_index`  -- robots(index)
                   , `headers`.`robot_follow` -- robots(follow)
                   , `headers`.`title`        -- title
                   , `headers`.`description`  -- description
                   , `headers`.`keywords`     -- keywords
                   , `headers`.`author`       -- author
                   , `headers`.`javascript`   -- JavaScriptファイルパス
                   , `headers`.`css`          -- CSSファイルパス
                   , `headers`.`favicon`      -- Faviconファイルパス
                FROM `risoluto_t_headerinfo` headers
            ORDER BY `headers`.`header_id` ASC

End_Of_SQL;

        // パラメタも用意する
        $param = array(
                      );

        // SQLの実行に失敗した場合は、例外を投げる
        $tmp_result = $this->obj_db->dbGetAll( $sql, $param );
        if ( PEAR::isError( $tmp_result ) )
        {
          // 接続をクローズする
          $this->obj_db->dbDisConnect();
          throw new Exception( 'header list get Failure' );
          return false;
        } // end of if

        // 接続に成功している場合は接続をクローズする
        $this->obj_db->dbDisConnect();
      } // end of if
      // データベースに接続できなかった場合は、例外を投げる
      else
      {
        throw new Exception( 'DB Connection Failure' );
        return false;
      } // end of else

      // 取得した情報を表示に適した形に加工する
      $tmp_result_cooked = array();
      for( $cnt = 0 ; $cnt < count( $tmp_result ) ; $cnt ++ )
      {
        array_push( $tmp_result_cooked, array(
                                               'act'          => $tmp_result[ $cnt ][ 'act'          ]
                                             , 'cage'         => $tmp_result[ $cnt ][ 'cage'         ]
                                             , 'robot_index'  => $tmp_result[ $cnt ][ 'robot_index'  ]
                                             , 'robot_follow' => $tmp_result[ $cnt ][ 'robot_follow' ]
                                             , 'title'        => $tmp_result[ $cnt ][ 'title'        ]
                                             , 'description'  => $tmp_result[ $cnt ][ 'description'  ]
                                             , 'keywords'     => $tmp_result[ $cnt ][ 'keywords'     ]
                                             , 'author'       => $tmp_result[ $cnt ][ 'author'       ]
                                             , 'javascript'   => $tmp_result[ $cnt ][ 'javascript'   ]
                                             , 'css'          => $tmp_result[ $cnt ][ 'css'          ]
                                             , 'favicon'      => $tmp_result[ $cnt ][ 'favicon'      ]
                                             )
                  );
      } // end of for


      //------------------------------------------------------------------------
      // Pagerのセットアップ
      //------------------------------------------------------------------------
      // Pagerオプション値を連想配列にセット
      $pager_params = array(
                       'itemData'              => $tmp_result_cooked
                     , 'urlVar'                => 'p'
                     , 'mode'                  => $this->obj_adminconf->get( 'PAGER', 'mode'         )
                     , 'perPage'               => $this->obj_adminconf->get( 'PAGER', 'perPage'      )
                     , 'prevImg'               => $this->obj_adminconf->get( 'PAGER', 'prevImg'      )
                     , 'nextImg'               => $this->obj_adminconf->get( 'PAGER', 'nextImg'      )
                     , 'separator'             => $this->obj_adminconf->get( 'PAGER', 'separator'    )
                     , 'spacesBeforeSeparator' => $this->obj_adminconf->get( 'PAGER', 'spacesSepCnt' )
                     , 'spacesAfterSeparator'  => $this->obj_adminconf->get( 'PAGER', 'spacesSepCnt' )
                     , 'clearIfVoid'           => ( !is_null( $this->obj_adminconf->get( "PAGER", "clearIfVoid" ) ) ? true : false )
      );

      // ページャのインスタンスを生成し、必要なデータを生成する
      $pager                        = & Pager::factory( $pager_params );
      $this->gotDat[ 'pager_link' ] = $pager->getLinks();

      // ページデータについては、一番外にある配列の添え字をゼロスタートへリセットする
      $this->gotDat[ 'pager_dat'  ] = array();
      foreach( $pager->getPageData() as $key => $val )
      {
        array_push( $this->gotDat[ 'pager_dat'  ], $val );
      }



      return true;
    } // end of function:model()

    /**
     * viewメソッド（モデル）
     *
     * テンプレート関連処理等のビューに相当する部分の処理を行う
     *
     * @param     void なし
     * @return    boolean ファンクション実行結果（ true：正常終了 / false: 異常終了 ）
     */
    public function view()
    {
      // アサイン
      $this->smarty->assign ( 'header',     $this->obj_util->getHeader() );

      $this->smarty->assign ( 'menu_cage',  $this->obj_adminconf->get( 'COMMON', 'menu_cage' ) );
      $this->smarty->assign ( 'menu_act',   $this->obj_adminconf->get( 'COMMON', 'menu_act'  ) );

      $this->smarty->assign ( 'headerlist', $this->gotDat[ 'pager_dat'  ] );
      $this->smarty->assign ( 'pagerlink',  $this->gotDat[ 'pager_link' ][ 'all' ] );

      // 表示
      $this->smarty->display( 'headerlist.tpl' );

      return true;

    } // end of function:view()

  } // end of class:headerlist

?>
