<?php
/**
 * 管理メニュー画面クラス
 *
 * 管理メニュー画面を実現するためのクラス
 *
 * @package   risoluto
 * @author    Yuta Hayakawa <haya@hyec.org>
 * @license   http://opensource.org/licenses/bsd-license.php new BSD license
 * @copyright (C) 2008-2009 Yuta Hayakawa / All Rights Reserved.
 */

  /**
   * 基底クラス
   */
  require_once( 'admin_base.inc' );

  class menu extends admin_base
  {
    //------------------------------------------------------//
    // クラス変数定義
    //------------------------------------------------------//
    /**
     * メニュー情報格納用変数
     * @access private
     * @var    string
     */
    private $menuDat;

    //------------------------------------------------------//
    // クラスメソッド定義
    //------------------------------------------------------//
    /**
     * コンストラクタメソッド
     *
     * コンストラクタメソッド
     *
     * @param     void なし
     * @return    void なし
     */
    public function __construct()
    {
    } // end of function:__construct()

    /**
     * クローンメソッド
     *
     * クローンメソッド
     *
     * @param     void なし
     * @return    void なし
     */
    public function __clone()
    {
    } // end of function:__clone()

    /**
     * modelメソッド（モデル）
     *
     * データ取得等のモデルに相当する部分の処理を行う
     *
     * @param     void なし
     * @return    boolean ファンクション実行結果（ true：正常終了 / false: 異常終了 ）
     */
    public function model()
    {
      // スーパバイザセッション又はアドミンセッションが存在しない場合は、
      // ログイン画面に遷移する
      if ( ! $this->obj_util->is_Admin() )
      {
        $this->obj_util->redirectTo( $this->obj_adminconf->get( 'COMMON', 'login_act'  )
                                   , $this->obj_adminconf->get( 'COMMON', 'login_cage' ) );
        return false;
      } // end of if

      // ディレクトリハンドラをオープンし、メニュー用テンプレートを取得する
      $this->menuDat = null;
      $tmp_menupath  = RISOLUTO_USERLAND . $this->obj_sess->sessLoad( 'currentcage' ) . '/menu/';
      if ( $tmp_dirHandle = opendir( $tmp_menupath ) )
      {
        while ( ( $tmp_filename = readdir( $tmp_dirHandle ) ) !== false )
        {
          if ( is_file( $tmp_menupath . $tmp_filename ) and preg_match( '/^[[:digit:]]{5}_[[:alnum:]._\-]*\.tpl$/', $tmp_filename ) )
          {
            $this->menuDat .= file_get_contents( $tmp_menupath . $tmp_filename );
          } // end of if
        } // end of while
        closedir( $tmp_dirHandle );
      } // end of if

      return true;
    } // end of function:model()

    /**
     * viewメソッド（モデル）
     *
     * テンプレート関連処理等のビューに相当する部分の処理を行う
     *
     * @param     void なし
     * @return    boolean ファンクション実行結果（ true：正常終了 / false: 異常終了 ）
     */
    public function view()
    {
      // ヘッダ情報をセット
      $html_header[ 'robots' ] = 'NOINDEX,NOFOLLOW';
      $html_header[ 'title'  ] = '管理メニュー';

      // アサイン
      $this->smarty->assign ( 'header',    $html_header    );

      $this->smarty->assign ( 'menus',     $this->menuDat  );

      // 表示
      $this->smarty->display( 'menu.tpl' );

      return true;

    } // end of function:view()

  } // end of class:menu
?>
