<?php
/**
 * 新規ユーザ追加画面クラス
 *
 * 新規ユーザ追加画面を実現するためのクラス
 *
 * @package   risoluto
 * @author    Risoluto Developers
 * @license   http://opensource.org/licenses/bsd-license.php new BSD license
 * @copyright (C) 2008-2011 Risoluto Developers / All Rights Reserved.
 */

  /**
   * 基底クラス
   */
  require_once( "admin_user_base.inc" );
  /**
   * データベース操作クラス
   */
  require_once( RISOLUTO_FUNC . 'risoluto_db.php' );

  class useradd_entry extends admin_user_base
  {
    //------------------------------------------------------//
    // クラス変数定義
    //------------------------------------------------------//
    /**
     * データベース操作クラスインスタンスを保持する変数
     * @access private
     * @var    object
     */
    private $obj_db;
    /**
     * ユーティリティクラスインスタンスを保持する変数
     * @access private
     * @var    object
     */
    private $obj_conf;
    /**
     * 取得データを保持する変数
     * @access private
     * @var    object
     */
    private $gotDat;

    //------------------------------------------------------//
    // クラスメソッド定義
    //------------------------------------------------------//
    /**
     * コンストラクタメソッド
     *
     * コンストラクタメソッド
     *
     * @param     void なし
     * @return    void なし
     */
    public function __construct()
    {
    } // end of function:__construct()

    /**
     * クローンメソッド
     *
     * クローンメソッド
     *
     * @param     void なし
     * @return    void なし
     */
    public function __clone()
    {
    } // end of function:__clone()

    /**
     * modelメソッド（モデル）
     *
     * データ取得等のモデルに相当する部分の処理を行う
     *
     * @param     void なし
     * @return    boolean ファンクション実行結果（ true：正常終了 / false: 異常終了 ）
     */
    public function model()
    {
      // 必要なインスタンスを生成
      $this->obj_conf = new RisolutoConf();
      $this->obj_conf->parse( RISOLUTO_CONF . 'risoluto.ini' );

      // スーパバイザセッション又はアドミンセッションが存在しない場合は、
      // ログイン画面に遷移する
      if ( ! $this->obj_util->is_Admin() )
      {
        $this->obj_util->redirectTo( $this->obj_adminconf->get( 'COMMON', 'login_act'  )
                                   , $this->obj_adminconf->get( 'COMMON', 'login_cage' ) );
        return false;
      } // end of if



      //------------------------------------------------------------------------
      // グループ情報の取得
      //------------------------------------------------------------------------

      // データベースに接続する
      // データベース操作クラスのインスタンスを生成する
      $this->obj_db = new RisoluteDb();

      // データベースに接続する
      if ( $this->obj_db->dbConnect( $this->obj_conf->get( 'DBS', 'DEFAULT_DSN' ) ) )
      {
        // SQL文を組み立てる
        $sql =<<<End_Of_SQL

              SELECT `groups`.`group_id`   -- グループID
                   , `groups`.`group_name` -- グループ名
                FROM `risoluto_m_group` groups
               WHERE `groups`.`group_id` >= ?
                 AND `groups`.`status`    = 1
            ORDER BY `groups`.`group_id` ASC

End_Of_SQL;

        // パラメタも用意する
        $param = array(
                        $this->obj_sess->sessLoad( 'login_groupid' )
                      );

        // SQLの実行に失敗した場合は、例外を投げる
        $tmp_result = $this->obj_db->dbGetAll( $sql, $param );
        if ( PEAR::isError( $tmp_result ) )
        {
          // 接続をクローズする
          $this->obj_db->dbDisConnect();
          throw new Exception( 'DB Connection Failure' );
          return false;
        } // end of if

        // 接続に成功している場合は接続をクローズする
        $this->obj_db->dbDisConnect();
      } // end of if
      // データベースに接続できなかった場合は、例外を投げる
      else
      {
        throw new Exception( 'DB Connection Failure' );
        return false;
      } // end of else

      // 取得した値を適切な形式に加工
      foreach( $tmp_result as $dat )
      {
        $this->gotDat[ 'grouplist' ][ $dat[ 'group_id' ] ] = $dat[ 'group_name' ];
      } // end of foreach



      //------------------------------------------------------------------------
      // セッション情報の取得
      //------------------------------------------------------------------------

      // セッションからエラーメッセージと入力値を取得し、削除する
      $this->gotDat[ 'errMsg' ] = $this->obj_sess->sessLoad( $this->obj_sess->sessLoad( 'currentcage' ) );
      $this->obj_sess->sessRevoke( $this->obj_sess->sessLoad( 'currentcage' ) );

      return true;
    } // end of function:model()

    /**
     * viewメソッド（モデル）
     *
     * テンプレート関連処理等のビューに相当する部分の処理を行う
     *
     * @param     void なし
     * @return    boolean ファンクション実行結果（ true：正常終了 / false: 異常終了 ）
     */
    public function view()
    {
      // アサイン
      $this->smarty->assign ( 'header',            $this->obj_util->getHeader() );

      $this->smarty->assign ( 'menu_cage',         $this->obj_adminconf->get( 'COMMON', 'menu_cage' ) );
      $this->smarty->assign ( 'menu_act',          $this->obj_adminconf->get( 'COMMON', 'menu_act'  ) );

      $this->smarty->assign ( 'errMsg',            $this->gotDat[ 'errMsg' ][ 'message'  ] );
      $this->smarty->assign ( 'entered_username',  $this->gotDat[ 'errMsg' ][ 'username' ] );
      $this->smarty->assign ( 'entered_group_id',  $this->gotDat[ 'errMsg' ][ 'group_id' ] );
      $this->smarty->assign ( 'entered_mail',      $this->gotDat[ 'errMsg' ][ 'mail'     ] );
      $this->smarty->assign ( 'grouplist',         $this->gotDat[ 'grouplist' ] );

      // 表示
      $this->smarty->display( 'useradd_entry.tpl' );

      return true;

    } // end of function:view()

  } // end of class:useradd_entry

?>
