<?php
/**
 * トラックバックPing受付画面クラス
 *
 * トラックバックPing受付画面を実現するためのクラス
 *
 * @package   simpleblog
 * @author    Risoluto Developers
 * @license   http://opensource.org/licenses/bsd-license.php new BSD license
 * @copyright (C) 2008-2011 Risoluto Developers / All Rights Reserved.
 */

  /**
   * 基底クラス
   */
  require_once( "simpleblog_base.inc" );
  /**
   * データベース操作クラス
   */
  require_once( RISOLUTO_FUNC . 'risoluto_db.php' );

  class tb extends simpleblog_base
  {
    //------------------------------------------------------//
    // クラス変数定義
    //------------------------------------------------------//
    /**
     * データベース操作クラスインスタンスを保持する変数
     * @access private
     * @var    object
     */
    private $obj_db;
    /**
     * ユーティリティクラスインスタンスを保持する変数
     * @access private
     * @var    object
     */
    private $obj_conf;
    /**
     * 取得データを保持する変数
     * @access private
     * @var    object
     */
    private $gotDat;
    /**
     * Smartyインスタンス格納用変数
     * @access private
     * @var    object
     */
    private $mail;

    //------------------------------------------------------//
    // クラスメソッド定義
    //------------------------------------------------------//
    /**
     * コンストラクタメソッド
     *
     * コンストラクタメソッド
     *
     * @param     void なし
     * @return    void なし
     */
    public function __construct()
    {
    } // end of function:__construct()

    /**
     * クローンメソッド
     *
     * クローンメソッド
     *
     * @param     void なし
     * @return    void なし
     */
    public function __clone()
    {
    } // end of function:__clone()

    /**
     * modelメソッド（モデル）
     *
     * データ取得等のモデルに相当する部分の処理を行う
     *
     * @param     void なし
     * @return    boolean ファンクション実行結果（ true：正常終了 / false: 異常終了 ）
     */
    public function model()
    {
      // 必要なインスタンスを生成
      $this->obj_db   = new RisoluteDb();
      $this->obj_conf = new RisolutoConf();
      $this->obj_conf->parse( RISOLUTO_CONF . 'risoluto.ini' );

      //------------------------------------------------------------------------
      // 前画面の入力値を取得
      //------------------------------------------------------------------------
      // 初期化
      $tmp_entered[ 'id'        ] = null;
      $tmp_entered[ 'url'       ] = null;
      $tmp_entered[ 'blog_name' ] = null;
      $tmp_entered[ 'title'     ] = null;
      $tmp_entered[ 'excerpt'   ] = null;

      // ID
      if ( isset( $_GET[ 'id' ] ) )
      {
        $tmp_entered[ 'id' ] = strip_tags( trim( $_GET [ 'id'      ] ) );
      } // end of if

      // URL
      if ( isset( $_POST[ 'url' ] ) )
      {
        $tmp_entered[ 'url' ] = htmlentities( strip_tags( trim( $_POST[ 'url' ] ) ), ENT_QUOTES, 'UTF-8' );
      } // end of if

      // ブログ名
      if ( isset( $_POST[ 'blog_name' ] ) )
      {
        $tmp_entered[ 'blog_name' ] = htmlentities( strip_tags( trim( $_POST[ 'blog_name' ] ) ), ENT_QUOTES, 'UTF-8' );
      } // end of if

      // 記事タイトル
      if ( isset( $_POST[ 'title' ] ) )
      {
        $tmp_entered[ 'title' ] = htmlentities( strip_tags( trim( $_POST[ 'title' ] ) ), ENT_QUOTES, 'UTF-8' );
      } // end of if

      // 記事本文
      if ( isset( $_POST[ 'excerpt' ] ) )
      {
        $tmp_entered[ 'excerpt' ] = htmlentities( strip_tags( trim( $_POST[ 'excerpt' ] ) ), ENT_QUOTES, 'UTF-8' );
      } // end of if



      //------------------------------------------------------------------------
      // 入力情報のチェック
      //------------------------------------------------------------------------
      // ID（数値ではない）
      if ( ! is_numeric( $tmp_entered[ 'id' ] ) )
      {
        echo '<?xml version="1.0" encoding="iso-8859-1"?><response><error>1</error><message>Invalid ID error</message></response>';
        $this->obj_logs->logging( 'debug', "[tb::model]Error: Invalid ID error" );
        $this->obj_logs->logging( 'debug', "[tb::model]POST Data : " . print_r( $_POST, true ) );
        return false;
      } // end of if

      // URL（入力値が空）
      if ( empty( $tmp_entered[ 'url' ] ) )
      {
        echo '<?xml version="1.0" encoding="iso-8859-1"?><response><error>1</error><message>empty URL error</message></response>';
        $this->obj_logs->logging( 'debug', "[tb::model]Error: empty URL error" );
        $this->obj_logs->logging( 'debug', "[tb::model]POST Data : " . print_r( $_POST, true ) );
        return false;
      } // end of if



      //------------------------------------------------------------------------
      // 現在の最新IDを取得
      //------------------------------------------------------------------------

      // データベースに接続する
      if ( $this->obj_db->dbConnect( $this->obj_conf->get( 'DBS', 'DEFAULT_DSN' ) ) )
      {
        // SQL文を組み立てる
        $tmp_t_blog = $this->mycage . '_t_blog';
        $sql =<<<End_Of_SQL

              SELECT `blog`.`blog_title` -- ブログタイトル
                   , `user`.`mail`       -- ユーザ名
                FROM $tmp_t_blog blog LEFT JOIN `risoluto_t_user` user
                                             ON `blog`.`user_id` = `user`.`user_id`
               WHERE `blog`.`blog_id` = ?

End_Of_SQL;

        // パラメタも用意する
        $param = array(
                        $tmp_entered[ 'id' ]
                      );

        // SQLを実行
        $tmp_result = $this->obj_db->dbGetRow( $sql, $param );
        if ( PEAR::isError( $tmp_result ) )
        {
          // エラーをスローし、接続をクローズする
          $this->obj_db->dbDisConnect();
          throw new Exception( 'SELECT mail Failure' );
          return false;
        } // end of if
        else
        {
          // 必要情報を変数にセット
          $tmp_entered[ 'baseurl'    ] = $this->obj_util->getBaseUrl();
          $tmp_entered[ 'cage'       ] = $this->mycage;
          $tmp_entered[ 'blog_title' ] = $tmp_result[ 'blog_title' ];
          $tmp_entered[ 'mail'       ] = $tmp_result[ 'mail' ];
        }

        // トランザクションを開始
        $this->obj_db->dbBeginTransaction();

        // SQL文を組み立てる
        $tmp_t_trackback = $this->mycage . '_t_trackback';
        $sql =<<<End_Of_SQL

              SELECT MAX( `tb`.`trackback_id` ) + 1 as latest_id
                FROM $tmp_t_trackback tb
                 FOR UPDATE;

End_Of_SQL;

        // パラメタも用意する
        $param = array(
                      );

        // SQLの実行に失敗した場合は、例外を投げる
        $tmp_result = $this->obj_db->dbGetRow( $sql, $param );
        if ( PEAR::isError( $tmp_result ) )
        {
          // 接続をクローズする
          $this->obj_db->dbDisConnect();
          echo '<?xml version="1.0" encoding="iso-8859-1"?><response><error>1</error><message>Get Id error</message></response>';
          $this->obj_logs->logging( 'debug', "[tb::model]Error: Get Id error" );
          $this->obj_logs->logging( 'debug', "[tb::model]POST Data : " . print_r( $_POST, true ) );
          $this->obj_logs->logging( 'debug', "[tb::model]Result Data : " . print_r( $tmp_result, true ) );
          return false;
        } // end of if
        // 入力された値と、取得した値を使ってデータをインサートする
        else
        {

          // 取得したIDが上限値を上回っていた場合、例外を投げる
          if ( $tmp_result[ 'latest_id' ] > $this->obj_conf->get( 'LIMITS', 'id_upper' ) )
          {
            // 接続をクローズする
            $this->obj_db->dbDisConnect();
            echo '<?xml version="1.0" encoding="iso-8859-1"?><response><error>1</error><message>Id range error</message></response>';
            $this->obj_logs->logging( 'debug', "[tb::model]Error: Id range error" );
            $this->obj_logs->logging( 'debug', "[tb::model]POST Data : " . print_r( $_POST, true ) );
            $this->obj_logs->logging( 'debug', "[tb::model]Result Data : " . print_r( $tmp_result, true ) );
            return false;
          }// end of if

          // 取得したIDが空なら「0」をセットする
          if ( empty( $tmp_result[ 'latest_id' ] ) )
          {
            $tmp_result[ 'latest_id' ] = 0;
          } // end of if

          // SQL文を組み立てる
        $tmp_t_trackback = $this->mycage . '_t_trackback';
          $sql =<<<End_Of_SQL

              INSERT INTO $tmp_t_trackback
              (
                `ctime`
              , `cuser`
              , `mtime`
              , `muser`
              , `trackback_id`
              , `blog_id`
              , `url`
              , `blogname`
              , `title`
              , `body`
              , `status`
              ) VALUES (
                  now()
                , ?
                , now()
                , ?
                , ?
                , ?
                , ?
                , ?
                , ?
                , ?
                , 0
              );

End_Of_SQL;

          // パラメタも用意する
          $tmp_myself = $this->obj_util->answerMyId();
          $param = array(
                          $tmp_myself
                        , $tmp_myself
                        , $tmp_result [ 'latest_id' ]
                        , $tmp_entered[ 'id'        ]
                        , $tmp_entered[ 'url'       ]
                        , $tmp_entered[ 'blog_name' ]
                        , $tmp_entered[ 'title'     ]
                        , $tmp_entered[ 'excerpt'   ]
                        );

          // Insertを実行
          $tmp_insert_result = $this->obj_db->dbExecSQL( $sql, $param );
          if ( PEAR::isError( $tmp_insert_result ) )
          {
            // エラーの場合はロールバックして接続を閉じ、例外を投げる
            $this->obj_db->dbRollback();
            $this->obj_db->dbDisConnect();
            echo '<?xml version="1.0" encoding="iso-8859-1"?><response><error>1</error><message>DB Insert error</message></response>';
            $this->obj_logs->logging( 'debug', "[tb::model]Error: DB Insert error" );
            $this->obj_logs->logging( 'debug', "[tb::model]POST Data : " . print_r( $_POST, true ) );
            $this->obj_logs->logging( 'debug', "[tb::model]Result Data : " . print_r( $tmp_insert_result, true ) );
            return false;
          } // end of if
          else
          {
            // 正常に実行できた場合はコミットして接続を閉じる
            $this->obj_db->dbCommit();
            $this->obj_db->dbDisConnect();

            // メールアドレスがセットされていれば、コメントが付与された旨のメールを送信する
            if ( !empty( $tmp_entered[ 'mail' ] ) )
            {
              // Smarty関連定義
              $this->mail                = new Smarty;
              $this->mail->template_dir  = RISOLUTO_USERLAND . $this->mycage;
              $this->mail->config_dir    = RISOLUTO_USERLAND . $this->mycage;
              $this->mail->compile_dir   = RISOLUTO_CACHE;
              $this->mail->cache_dir     = RISOLUTO_CACHE;
              $this->mail->caching       = false;
              $this->mail->debugging     = false;
              $this->mail->force_compile = true;
              $this->mail->compile_check = true;

              // メール本文を生成
              $this->mail->assign( 'trackbackinfo', $tmp_entered );
              $tmp_mails = $this->mail->fetch( 'trackback_notification.tpl' );

              // メール送信
              mb_send_mail( $tmp_entered[ 'mail' ], '[' . $this->obj_util->getBaseUrl() . ']トラックバックが投稿されました', $tmp_mails );

            } // end of if

            echo '<?xml version="1.0" encoding="iso-8859-1"?><response><error>0</error></response>';
          } // end of else

        } // end of else

      } // end of if
      // データベースに接続できなかった場合は、例外を投げる
      else
      {
        echo '<?xml version="1.0" encoding="iso-8859-1"?><response><error>1</error><message>DB Connection error</message></response>';
        $this->obj_logs->logging( 'debug', "[tb::model]Error: DB Connection error" );
        $this->obj_logs->logging( 'debug', "[tb::model]POST Data : " . print_r( $_POST, true ) );
        return false;
      } // end of else

      return true;
    } // end of function:model()

    /**
     * viewメソッド（モデル）
     *
     * テンプレート関連処理等のビューに相当する部分の処理を行う
     *
     * @param     void なし
     * @return    boolean ファンクション実行結果（ true：正常終了 / false: 異常終了 ）
     */
    public function view()
    {

      return true;

    } // end of function:view()

    /**
     * エラー処理メソッド（エラーハンドラ）
     *
     * 当該クラス内でエラーが発生したときの処理を行う
     *
     * @param     void なし
     * @return    boolean ファンクション実行結果（ true：正常終了 / false: 異常終了 ）
     */
    public function errHandler()
    {

      return true;

    } // end of function:errHandler()

  } // end of class:tb

?>
