<?php
/**
 * ページ削除確認画面クラス
 *
 * ページ削除確認画面を実現するためのクラス
 *
 * @package   simplepage
 * @author    Risoluto Developers
 * @license   http://opensource.org/licenses/bsd-license.php new BSD license
 * @copyright (C) 2008-2011 Risoluto Developers / All Rights Reserved.
 */

  /**
   * 基底クラス
   */
  require_once( "simplepage_base.inc" );
  /**
   * データベース操作クラス
   */
  require_once( RISOLUTO_FUNC . 'risoluto_db.php' );

  class pagedel_confirm extends simplepage_base
  {
    //------------------------------------------------------//
    // クラス変数定義
    //------------------------------------------------------//
    /**
     * データベース操作クラスインスタンスを保持する変数
     * @access private
     * @var    object
     */
    private $obj_db;
    /**
     * ユーティリティクラスインスタンスを保持する変数
     * @access private
     * @var    object
     */
    private $obj_conf;
    /**
     * 取得データを保持する変数
     * @access private
     * @var    object
     */
    private $gotDat;

    //------------------------------------------------------//
    // クラスメソッド定義
    //------------------------------------------------------//
    /**
     * コンストラクタメソッド
     *
     * コンストラクタメソッド
     *
     * @param     void なし
     * @return    void なし
     */
    public function __construct()
    {
    } // end of function:__construct()

    /**
     * クローンメソッド
     *
     * クローンメソッド
     *
     * @param     void なし
     * @return    void なし
     */
    public function __clone()
    {
    } // end of function:__clone()

    /**
     * modelメソッド（モデル）
     *
     * データ取得等のモデルに相当する部分の処理を行う
     *
     * @param     void なし
     * @return    boolean ファンクション実行結果（ true：正常終了 / false: 異常終了 ）
     */
    public function model()
    {
      // 必要なインスタンスを生成
      $this->obj_db   = new RisoluteDb();
      $this->obj_conf = new RisolutoConf();
      $this->obj_conf->parse( RISOLUTO_CONF . 'risoluto.ini' );

      // スーパバイザセッション又はアドミンセッションが存在しない場合は、
      // ログイン画面に遷移する
      if ( ! $this->obj_util->is_Admin() )
      {
        $this->obj_util->redirectTo( $this->obj_adminconf->get( 'COMMON', 'login_act'  )
                                   , $this->obj_adminconf->get( 'COMMON', 'login_cage' ) );
        return false;
      } // end of if

      // 前画面のCageが自分と同じでない or 前画面のActが「pagelist」または「pageview」でない場合、
      // 入力画面に飛ばす
      $tmp_cage_last    = str_replace( DIRECTORY_SEPARATOR, '.', $this->obj_sess->sessLoad( 'lastcage'    ) );
      $tmp_cage_current = str_replace( DIRECTORY_SEPARATOR, '.', $this->obj_sess->sessLoad( 'currentcage' ) );

      $tmp_act  = $this->obj_sess->sessLoad( 'lastact'  );
      if ( ( $tmp_cage_last != $tmp_cage_current ) or ( $tmp_act != 'pagelist' and $tmp_act != 'pageview' ) )
      {
        $this->obj_util->redirectTo( 'pagelist', $tmp_cage_current );
        return false;
      } // end of if



      //------------------------------------------------------------------------
      // 前画面の入力値を取得
      //------------------------------------------------------------------------
      // 初期化
      $tmp_entered[ 'pageid' ] = null;

      // ページID
      if ( isset( $_GET[ 'pageid' ] ) )
      {
        $tmp_entered[ 'pageid' ] = strip_tags( trim( $_GET[ 'pageid' ] ) );
      } // end of if



      //------------------------------------------------------------------------
      // 入力情報のチェック
      //------------------------------------------------------------------------
      // ページID（ユーザIDが不正）
      if ( $tmp_entered[ 'pageid' ] == null or ! is_numeric( $tmp_entered[ 'pageid' ] ) )
      {
        // エラーの場合、例外を投げる
        throw new Exception( 'Invalid pageid' );
        return false;
      } // end of if



      //------------------------------------------------------------------------
      // 表示の取得
      //------------------------------------------------------------------------

      // データベースに接続する
      if ( $this->obj_db->dbConnect( $this->obj_conf->get( 'DBS', 'DEFAULT_DSN' ) ) )
      {
        // SQL文を組み立てる
        $sql =<<<End_Of_SQL

              SELECT `pages`.`page_title`        -- ページタイトル
                FROM `simplepage_t_pages` pages
               WHERE `pages`.`page_id` = ?

End_Of_SQL;

        // パラメタも用意する
        $param = array(
                        $tmp_entered[ 'pageid'  ]
                      );

        // SQLの実行に失敗した場合は、例外を投げる
        $tmp_result = $this->obj_db->dbGetRow( $sql, $param );
        if ( PEAR::isError( $tmp_result ) )
        {
          // 接続をクローズする
          $this->obj_db->dbDisConnect();
          throw new Exception( 'pagetitle get Failure' );
          return false;
        } // end of if
        // 成功したなら、変数に取得した値を入れる
        else
        {
          $tmp_entered[ 'title' ] = $tmp_result[ 'page_title' ];
        } // end of else

        // 接続に成功している場合は接続をクローズする
        $this->obj_db->dbDisConnect();
      } // end of if
      // データベースに接続できなかった場合は、例外を投げる
      else
      {
        throw new Exception( 'DB Connection Failure' );
        return false;
      } // end of else



      //------------------------------------------------------------------------
      // 特に問題がなければ、画面表示用にクラス変数とセッションに値をセットする
      //------------------------------------------------------------------------
      $this->gotDat = $tmp_entered;
      $this->obj_sess->sessStore( $this->obj_sess->sessLoad( 'currentcage' ), $tmp_entered );

      return true;
    } // end of function:model()

    /**
     * viewメソッド（モデル）
     *
     * テンプレート関連処理等のビューに相当する部分の処理を行う
     *
     * @param     void なし
     * @return    boolean ファンクション実行結果（ true：正常終了 / false: 異常終了 ）
     */
    public function view()
    {
      // アサイン
      $this->smarty->assign ( 'header',        $this->obj_util->getHeader() );

      $this->smarty->assign ( 'entered_title', $this->gotDat[ 'title'  ] );

      $this->smarty->assign ( 'mycage',        str_replace( DIRECTORY_SEPARATOR, '.', $this->obj_sess->sessLoad( 'currentcage' ) ) );

      // 表示
      $this->smarty->display( 'pagedel_confirm.tpl' );

      return true;

    } // end of function:view()

  } // end of class:pagedel_confirm

?>
