<?php
/**
 * 新規カテゴリ追加画面クラス
 *
 * 新規カテゴリ追加画面を実現するためのクラス
 *
 * @package   simpleblog
 * @author    Risoluto Developers
 * @license   http://opensource.org/licenses/bsd-license.php new BSD license
 * @copyright (C) 2008-2011 Risoluto Developers / All Rights Reserved.
 */

  /**
   * 基底クラス
   */
  require_once( "simpleblog_base.inc" );

  class categoryadd_entry extends simpleblog_base
  {
    //------------------------------------------------------//
    // クラス変数定義
    //------------------------------------------------------//
    /**
     * ユーティリティクラスインスタンスを保持する変数
     * @access private
     * @var    object
     */
    private $obj_conf;
    /**
     * 取得データを保持する変数
     * @access private
     * @var    object
     */
    private $gotDat;

    //------------------------------------------------------//
    // クラスメソッド定義
    //------------------------------------------------------//
    /**
     * コンストラクタメソッド
     *
     * コンストラクタメソッド
     *
     * @param     void なし
     * @return    void なし
     */
    public function __construct()
    {
    } // end of function:__construct()

    /**
     * クローンメソッド
     *
     * クローンメソッド
     *
     * @param     void なし
     * @return    void なし
     */
    public function __clone()
    {
    } // end of function:__clone()

    /**
     * modelメソッド（モデル）
     *
     * データ取得等のモデルに相当する部分の処理を行う
     *
     * @param     void なし
     * @return    boolean ファンクション実行結果（ true：正常終了 / false: 異常終了 ）
     */
    public function model()
    {
      // 必要なインスタンスを生成
      $this->obj_conf = new RisolutoConf();
      $this->obj_conf->parse( RISOLUTO_CONF . 'risoluto.ini' );

      // スーパバイザセッション又はアドミンセッションが存在しない場合は、
      // ログイン画面に遷移する
      if ( ! $this->obj_util->is_Admin() )
      {
        $this->obj_util->redirectTo( $this->obj_adminconf->get( 'COMMON', 'login_act'  )
                                   , $this->obj_adminconf->get( 'COMMON', 'login_cage' ) );
        return false;
      } // end of if



      //------------------------------------------------------------------------
      // セッション情報の取得
      //------------------------------------------------------------------------

      // セッションからエラーメッセージと入力値を取得し、削除する
      $this->gotDat[ 'errMsg' ] = $this->obj_sess->sessLoad( $this->obj_sess->sessLoad( 'currentcage' ) );
      $this->obj_sess->sessRevoke( $this->obj_sess->sessLoad( 'currentcage' ) );



      //------------------------------------------------------------------------
      // デフォルト値の設定
      //------------------------------------------------------------------------

      // エラーメッセージ
      if ( empty( $this->gotDat[ 'errMsg' ][ 'message' ] ) )
      {
        $this->gotDat[ 'errMsg' ][ 'message' ] = null;
      } // end of if

      // カテゴリ名
      if ( empty( $this->gotDat[ 'errMsg' ][ 'categoryname' ] ) )
      {
        $this->gotDat[ 'errMsg' ][ 'categoryname' ] = null;
      } // end of if

    } // end of function:model()

    /**
     * viewメソッド（モデル）
     *
     * テンプレート関連処理等のビューに相当する部分の処理を行う
     *
     * @param     void なし
     * @return    boolean ファンクション実行結果（ true：正常終了 / false: 異常終了 ）
     */
    public function view()
    {
      // アサイン
      $this->smarty->assign ( 'header',         $this->obj_util->getHeader() );

      $this->smarty->assign ( 'menu_cage',      $this->obj_adminconf->get( 'COMMON', 'menu_cage' ) );
      $this->smarty->assign ( 'menu_act',       $this->obj_adminconf->get( 'COMMON', 'menu_act'  ) );

      $this->smarty->assign ( 'mycage',         $this->mycage );

      $this->smarty->assign ( 'errMsg',               $this->gotDat[ 'errMsg' ][ 'message'      ] );
      $this->smarty->assign ( 'entered_categoryname', $this->gotDat[ 'errMsg' ][ 'categoryname' ] );

      // 表示
      $this->smarty->display( 'categoryadd_entry.tpl' );

      return true;

    } // end of function:view()

  } // end of class:categoryadd_entry

?>
