<?php
/**
 * 新規ブログ記事追加確認画面クラス
 *
 * 新規ブログ記事追加確認画面を実現するためのクラス
 *
 * @package   simpleblog
 * @author    Risoluto Developers
 * @license   http://opensource.org/licenses/bsd-license.php new BSD license
 * @copyright (C) 2008-2011 Risoluto Developers / All Rights Reserved.
 */

  /**
   * 基底クラス
   */
  require_once( "simpleblog_base.inc" );

  class blogadd_confirm extends simpleblog_base
  {
    //------------------------------------------------------//
    // クラス変数定義
    //------------------------------------------------------//
    /**
     * ユーティリティクラスインスタンスを保持する変数
     * @access private
     * @var    object
     */
    private $obj_conf;
    /**
     * ユーティリティクラスインスタンスを保持する変数
     * @access private
     * @var    object
     */
    private $obj_simpleblogconf;
    /**
     * 取得データを保持する変数
     * @access private
     * @var    object
     */
    private $gotDat;

    //------------------------------------------------------//
    // クラスメソッド定義
    //------------------------------------------------------//
    /**
     * コンストラクタメソッド
     *
     * コンストラクタメソッド
     *
     * @param     void なし
     * @return    void なし
     */
    public function __construct()
    {
    } // end of function:__construct()

    /**
     * クローンメソッド
     *
     * クローンメソッド
     *
     * @param     void なし
     * @return    void なし
     */
    public function __clone()
    {
    } // end of function:__clone()

    /**
     * modelメソッド（モデル）
     *
     * データ取得等のモデルに相当する部分の処理を行う
     *
     * @param     void なし
     * @return    boolean ファンクション実行結果（ true：正常終了 / false: 異常終了 ）
     */
    public function model()
    {
      // 必要なインスタンスを生成
      $this->obj_conf = new RisolutoConf();
      $this->obj_conf->parse( RISOLUTO_CONF . 'risoluto.ini' );

      $this->obj_simpleblogconf = new RisolutoConf();
      $this->obj_simpleblogconf->parse( RISOLUTO_CONF . $this->mycage . '.ini' );

      // スーパバイザセッション又はアドミンセッションが存在しない場合は、
      // ログイン画面に遷移する
      if ( ! $this->obj_util->is_Admin() )
      {
        $this->obj_util->redirectTo( $this->obj_adminconf->get( 'COMMON', 'login_act'  )
                                   , $this->obj_adminconf->get( 'COMMON', 'login_cage' ) );
        return false;
      } // end of if

      // 前画面のCageが自分と同じでない or 前画面のActが「blogadd_entry」でない場合、
      // 入力画面に飛ばす
      $tmp_cage_last    = str_replace( DIRECTORY_SEPARATOR, '.', $this->obj_sess->sessLoad( 'lastcage'    ) );
      $tmp_cage_current = str_replace( DIRECTORY_SEPARATOR, '.', $this->obj_sess->sessLoad( 'currentcage' ) );
      $tmp_act  = $this->obj_sess->sessLoad( 'lastact' );

      if ( ( $tmp_cage_last != $tmp_cage_current and $tmp_cage_last != 'admin.site' ) or ( $tmp_act != 'blogadd_entry' and $tmp_act != 'uploadviewer' ) )
      {
        $this->obj_util->redirectTo( 'bloglist', $tmp_cage_current );
        return false;
      } // end of if



      //------------------------------------------------------------------------
      // 前画面の入力値を取得
      //------------------------------------------------------------------------
      // 初期化
      $tmp_entered[ 'title'              ] = null;
      $tmp_entered[ 'body'               ] = null;
      $tmp_entered[ 'category'           ] = null;
      $tmp_entered[ 'categoryname'       ] = null;
      $tmp_entered[ 'tb_url'             ] = null;
      $tmp_entered[ 'postdate'           ] = null;
      $tmp_entered[ 'entered_postyear'   ] = null;
      $tmp_entered[ 'entered_postmonth'  ] = null;
      $tmp_entered[ 'entered_postday'    ] = null;
      $tmp_entered[ 'entered_posthour'   ] = null;
      $tmp_entered[ 'entered_postminite' ] = null;
      $tmp_entered[ 'entered_postsecond' ] = null;
      $tmp_entered[ 'opendate'           ] = null;
      $tmp_entered[ 'entered_openyear'   ] = null;
      $tmp_entered[ 'entered_openmonth'  ] = null;
      $tmp_entered[ 'entered_openday'    ] = null;
      $tmp_entered[ 'entered_openhour'   ] = null;
      $tmp_entered[ 'entered_openminite' ] = null;
      $tmp_entered[ 'entered_opensecond' ] = null;
      $tmp_entered[ 'enddate'            ] = null;
      $tmp_entered[ 'entered_endyear'    ] = null;
      $tmp_entered[ 'entered_endmonth'   ] = null;
      $tmp_entered[ 'entered_endday'     ] = null;
      $tmp_entered[ 'entered_endhour'    ] = null;
      $tmp_entered[ 'entered_endminite'  ] = null;
      $tmp_entered[ 'entered_endsecond'  ] = null;

      // タイトル
      if ( isset( $_POST[ 'title' ] ) )
      {
        $tmp_entered[ 'title' ] = strip_tags( trim( $_POST[ 'title' ] ) );
      } // end of if

      // 本文
      if ( isset( $_POST[ 'body' ] ) )
      {
        $tmp_entered[ 'body'  ] = strip_tags( trim( $_POST[ 'body'  ] ), $this->obj_simpleblogconf->get( 'ALLOWTAGS', 'body' ) );
      } // end of if

      // カテゴリ
      if ( isset( $_POST[ 'category' ] ) and !empty( $_POST[ 'category' ] ) )
      {
        $tmp_entered[ 'category' ] = htmlentities( trim( $_POST[ 'category' ] ), ENT_QUOTES, 'UTF-8' );
      } // end of if
      else
      {
        $tmp_entered[ 'category' ] = 0;
      } // end of else

      // トラックバックPing送信先URL
      if ( isset( $_POST[ 'tb_url' ] ) and !empty( $_POST[ 'tb_url' ] ) )
      {
        $tmp_entered[ 'tb_url' ] = htmlentities( trim( $_POST[ 'tb_url' ] ), ENT_QUOTES, 'UTF-8' );
      } // end of if

      // 投稿日
      if (     isset( $_POST[ 'posted_year' ] ) and isset( $_POST[ 'posted_month'  ] ) and isset( $_POST[ 'posted_day'    ] )
           and isset( $_POST[ 'posted_hour' ] ) and isset( $_POST[ 'posted_minite' ] ) and isset( $_POST[ 'posted_second' ] ) )
      {
        $tmp_entered[ 'postdate'           ] = $_POST[ 'posted_year' ] . '-' . $_POST[ 'posted_month'  ] . '-' . $_POST[ 'posted_day'    ] . ' '
                                             . $_POST[ 'posted_hour' ] . ':' . $_POST[ 'posted_minite' ] . ':' . $_POST[ 'posted_second' ];
        $tmp_entered[ 'entered_postyear'   ] = strip_tags( trim( $_POST[ 'posted_year'   ] ) );
        $tmp_entered[ 'entered_postmonth'  ] = strip_tags( trim( $_POST[ 'posted_month'  ] ) );
        $tmp_entered[ 'entered_postday'    ] = strip_tags( trim( $_POST[ 'posted_day'    ] ) );
        $tmp_entered[ 'entered_posthour'   ] = strip_tags( trim( $_POST[ 'posted_hour'   ] ) );
        $tmp_entered[ 'entered_postminite' ] = strip_tags( trim( $_POST[ 'posted_minite' ] ) );
        $tmp_entered[ 'entered_postsecond' ] = strip_tags( trim( $_POST[ 'posted_second' ] ) );
      } // end of if

      // 公開開始日
      if (     isset( $_POST[ 'open_year' ] ) and isset( $_POST[ 'open_month'  ] ) and isset( $_POST[ 'open_day'    ] )
           and isset( $_POST[ 'open_hour' ] ) and isset( $_POST[ 'open_minite' ] ) and isset( $_POST[ 'open_second' ] ) )
      {
        $tmp_entered[ 'opendate'           ] = $_POST[ 'open_year' ] . '-' . $_POST[ 'open_month'  ] . '-' . $_POST[ 'open_day'    ] . ' '
                                             . $_POST[ 'open_hour' ] . ':' . $_POST[ 'open_minite' ] . ':' . $_POST[ 'open_second' ];
        $tmp_entered[ 'entered_openyear'   ] = strip_tags( trim( $_POST[ 'open_year'   ] ) );
        $tmp_entered[ 'entered_openmonth'  ] = strip_tags( trim( $_POST[ 'open_month'  ] ) );
        $tmp_entered[ 'entered_openday'    ] = strip_tags( trim( $_POST[ 'open_day'    ] ) );
        $tmp_entered[ 'entered_openhour'   ] = strip_tags( trim( $_POST[ 'open_hour'   ] ) );
        $tmp_entered[ 'entered_openminite' ] = strip_tags( trim( $_POST[ 'open_minite' ] ) );
        $tmp_entered[ 'entered_opensecond' ] = strip_tags( trim( $_POST[ 'open_second' ] ) );
      } // end of if

      // 公開終了日
      if (     isset( $_POST[ 'end_year' ] ) and isset( $_POST[ 'end_month'  ] ) and isset( $_POST[ 'end_day'    ] )
           and isset( $_POST[ 'end_hour' ] ) and isset( $_POST[ 'end_minite' ] ) and isset( $_POST[ 'end_second' ] ) )
      {
        $tmp_entered[ 'enddate'           ] = $_POST[ 'end_year' ] . '-' . $_POST[ 'end_month'  ] . '-' . $_POST[ 'end_day'    ] . ' '
                                            . $_POST[ 'end_hour' ] . ':' . $_POST[ 'end_minite' ] . ':' . $_POST[ 'end_second' ];
        $tmp_entered[ 'entered_endyear'   ] = strip_tags( trim( $_POST[ 'end_year'   ] ) );
        $tmp_entered[ 'entered_endmonth'  ] = strip_tags( trim( $_POST[ 'end_month'  ] ) );
        $tmp_entered[ 'entered_endday'    ] = strip_tags( trim( $_POST[ 'end_day'    ] ) );
        $tmp_entered[ 'entered_endhour'   ] = strip_tags( trim( $_POST[ 'end_hour'   ] ) );
        $tmp_entered[ 'entered_endminite' ] = strip_tags( trim( $_POST[ 'end_minite' ] ) );
        $tmp_entered[ 'entered_endsecond' ] = strip_tags( trim( $_POST[ 'end_second' ] ) );
      } // end of if



      //------------------------------------------------------------------------
      // 入力情報のチェック
      //------------------------------------------------------------------------
      // タイトル（入力値が空）
      if ( empty( $tmp_entered[ 'title' ] ) )
      {
        // エラーメッセージ表示用の情報をセッションに入れてから入力画面に遷移する
        $tmp_entered[ 'message' ] = 'empty_title';
        $this->obj_sess->sessStore( $this->obj_sess->sessLoad( 'currentcage' ), $tmp_entered );
        $this->obj_util->redirectTo( 'blogadd_entry', $tmp_cage_current );
        return false;
      } // end of if
      // タイトル（入力値が半角255文字以上）
      if ( strlen( $tmp_entered[ 'title' ] ) > 255 )
      {
        // エラーメッセージ表示用の情報をセッションに入れてから入力画面に遷移する
        $tmp_entered[ 'message' ] = 'toolong_title';
        $this->obj_sess->sessStore( $this->obj_sess->sessLoad( 'currentcage' ), $tmp_entered );
        $this->obj_util->redirectTo( 'blogadd_entry', $tmp_cage_current );
        return false;
      } // end of if

      // 本文（入力値が空）
      if ( empty( $tmp_entered[ 'body' ] ) )
      {
        // エラーメッセージ表示用の情報をセッションに入れてから入力画面に遷移する
        $tmp_entered[ 'message' ] = 'empty_body';
        $this->obj_sess->sessStore( $this->obj_sess->sessLoad( 'currentcage' ), $tmp_entered );
        $this->obj_util->redirectTo( 'blogadd_entry', $tmp_cage_current );
        return false;
      } // end of if

      // カテゴリ（入力値が数字ではない）
      if ( !preg_match( '/^[[:digit:]].*$/', $tmp_entered[ 'category' ] ) )
      {
        throw new Exception( 'CANNOT HAPPENDED! - category_id is strange' );
        return false;
      } // end of if

      // 投稿日（未指定項目がある）
      if (    $tmp_entered[ 'entered_postday'  ] == '----' or $tmp_entered[ 'entered_postmonth'  ] == '--' or $tmp_entered[ 'entered_postyear'   ] == '--'
           or $tmp_entered[ 'entered_posthour' ] == '--'   or $tmp_entered[ 'entered_postminite' ] == '--' or $tmp_entered[ 'entered_postsecond' ] == '--' )
      {
        // エラーメッセージ表示用の情報をセッションに入れてから入力画面に遷移する
        $tmp_entered[ 'message' ] = 'invalid_postdate';
        $this->obj_sess->sessStore( $this->obj_sess->sessLoad( 'currentcage' ), $tmp_entered );
        $this->obj_util->redirectTo( 'blogadd_entry', $tmp_cage_current );
        return false;
      } // end of if
      // 投稿日（日付が不正）
      if ( ! checkdate( $tmp_entered[ 'entered_postmonth' ], $tmp_entered[ 'entered_postday' ], $tmp_entered[ 'entered_postyear' ] ) )
      {
        // エラーメッセージ表示用の情報をセッションに入れてから入力画面に遷移する
        $tmp_entered[ 'message' ] = 'invalid_postdate';
        $this->obj_sess->sessStore( $this->obj_sess->sessLoad( 'currentcage' ), $tmp_entered );
        $this->obj_util->redirectTo( 'blogadd_entry', $tmp_cage_current );
        return false;
      } // end of if

      // 公開開始日（未指定項目がある）
      if (    $tmp_entered[ 'entered_openyear' ] == '----' or $tmp_entered[ 'entered_openmonth'  ] == '--' or $tmp_entered[ 'entered_openday'    ] == '--'
           or $tmp_entered[ 'entered_openhour' ] == '--'   or $tmp_entered[ 'entered_openminite' ] == '--' or $tmp_entered[ 'entered_opensecond' ] == '--' )
      {
        // エラーメッセージ表示用の情報をセッションに入れてから入力画面に遷移する
        $tmp_entered[ 'message' ] = 'invalid_opendate';
        $this->obj_sess->sessStore( $this->obj_sess->sessLoad( 'currentcage' ), $tmp_entered );
        $this->obj_util->redirectTo( 'blogadd_entry', $tmp_cage_current );
        return false;
      } // end of if
      // 公開開始日（日付が不正）
      if ( ! checkdate( $tmp_entered[ 'entered_openmonth' ], $tmp_entered[ 'entered_openday' ], $tmp_entered[ 'entered_openyear' ] ) )
      {
        // エラーメッセージ表示用の情報をセッションに入れてから入力画面に遷移する
        $tmp_entered[ 'message' ] = 'invalid_opendate';
        $this->obj_sess->sessStore( $this->obj_sess->sessLoad( 'currentcage' ), $tmp_entered );
        $this->obj_util->redirectTo( 'blogadd_entry', $tmp_cage_current );
        return false;
      } // end of if

      // 公開終了日はすべて未指定ならチェックしない
      if (     $tmp_entered[ 'entered_endyear' ] == '----' and $tmp_entered[ 'entered_endmonth'  ] == '--' and $tmp_entered[ 'entered_endhour'   ] == '--'
           and $tmp_entered[ 'entered_endhour' ] == '--'   and $tmp_entered[ 'entered_endminite' ] == '--' and $tmp_entered[ 'entered_endsecond' ] == '--' )
      {
        $tmp_entered[ 'enddate'           ] = '---------- --:--:--';
        $tmp_entered[ 'entered_endyear'   ] = '----';
        $tmp_entered[ 'entered_endmonth'  ] = '--';
        $tmp_entered[ 'entered_endday'    ] = '--';
        $tmp_entered[ 'entered_endhour'   ] = '--';
        $tmp_entered[ 'entered_endminite' ] = '--';
        $tmp_entered[ 'entered_endsecond' ] = '--';
      } // end of if
      else
      {
        // 公開終了日（未指定項目がある）
        if (    $tmp_entered[ 'entered_endyear' ] == '----' or $tmp_entered[ 'entered_endmonth'  ] == '--' or $tmp_entered[ 'entered_endhour'   ] == '--'
             or $tmp_entered[ 'entered_endhour' ] == '--'   or $tmp_entered[ 'entered_endminite' ] == '--' or $tmp_entered[ 'entered_endsecond' ] == '--' )
        {
          // エラーメッセージ表示用の情報をセッションに入れてから入力画面に遷移する
          $tmp_entered[ 'message' ] = 'invalid_enddate';
          $this->obj_sess->sessStore( $this->obj_sess->sessLoad( 'currentcage' ), $tmp_entered );
          $this->obj_util->redirectTo( 'blogadd_entry', $tmp_cage_current );
          return false;
        } // end of if
        // 公開終了日（日付が不正）
        if ( ! checkdate( $tmp_entered[ 'entered_endmonth' ], $tmp_entered[ 'entered_endday' ], $tmp_entered[ 'entered_endyear' ] ) )
        {
          // エラーメッセージ表示用の情報をセッションに入れてから入力画面に遷移する
          $tmp_entered[ 'message' ] = 'invalid_enddate';
          $this->obj_sess->sessStore( $this->obj_sess->sessLoad( 'currentcage' ), $tmp_entered );
          $this->obj_util->redirectTo( 'blogadd_entry', $tmp_cage_current );
          return false;
        } // end of if
        // 公開終了日（公開開始日と同じかそれ以前になっている）
        if ( mktime( $tmp_entered[ 'entered_openhour'  ], $tmp_entered[ 'entered_openminite' ], $tmp_entered[ 'entered_opensecond' ]
                   , $tmp_entered[ 'entered_openmonth' ], $tmp_entered[ 'entered_openday'    ], $tmp_entered[ 'entered_openyear'   ] )
             >=
             mktime( $tmp_entered[ 'entered_endhour'  ], $tmp_entered[ 'entered_endminite' ], $tmp_entered[ 'entered_endsecond' ]
                   , $tmp_entered[ 'entered_endmonth' ], $tmp_entered[ 'entered_endday'    ], $tmp_entered[ 'entered_endyear'   ] ) )
        {
          // エラーメッセージ表示用の情報をセッションに入れてから入力画面に遷移する
          $tmp_entered[ 'message' ] = 'invalid_enddate';
          $this->obj_sess->sessStore( $this->obj_sess->sessLoad( 'currentcage' ), $tmp_entered );
          $this->obj_util->redirectTo( 'blogadd_entry', $tmp_cage_current );
          return false;
        } // end of if
      } // end of else



      //------------------------------------------------------------------------
      // カテゴリの取得
      //------------------------------------------------------------------------
      // データベースに接続する
      $this->obj_db   = new RisolutoDb();
      if ( $this->obj_db->dbConnect( $this->obj_conf->get( 'DBS', 'DEFAULT_DSN' ) ) )
      {
        // SQL文を組み立てる
        $tmp_t_category = $this->mycage . '_t_category';
        $sql =<<<End_Of_SQL

              SELECT `cat`.`category_id`   -- カテゴリID
                   , `cat`.`category_name` -- カテゴリ名
                FROM $tmp_t_category cat
               WHERE `cat`.`category_id` = ?

End_Of_SQL;

        // パラメタも用意する
        $param = array(
                        $tmp_entered[ 'category' ]
                      );

        // SQLの実行に失敗した場合は、例外を投げる
        $tmp_result = $this->obj_db->dbGetRow( $sql, $param );
        if ( PEAR::isError( $tmp_result ) )
        {
          // 接続をクローズする
          $this->obj_db->dbDisConnect();
          throw new Exception( 'category_name get Failure' );
          return false;
        } // end of if
        // 成功したなら、変数に取得した値を入れる
        else
        {
          $tmp_entered[ 'categoryname' ] = $tmp_result[ 'category_name' ];
        } // end of else

        // 接続に成功している場合は接続をクローズする
        $this->obj_db->dbDisConnect();
      } // end of if
      // データベースに接続できなかった場合は、例外を投げる
      else
      {
        throw new Exception( 'DB Connection Failure' );
        return false;
      } // end of else



      //------------------------------------------------------------------------
      // 特に問題がなければ、画面表示用にクラス変数とセッションに値をセットする
      //------------------------------------------------------------------------
      $this->gotDat = $tmp_entered;
      $this->obj_sess->sessStore( $this->obj_sess->sessLoad( 'currentcage' ), $tmp_entered );

      return true;
    } // end of function:model()

    /**
     * viewメソッド（モデル）
     *
     * テンプレート関連処理等のビューに相当する部分の処理を行う
     *
     * @param     void なし
     * @return    boolean ファンクション実行結果（ true：正常終了 / false: 異常終了 ）
     */
    public function view()
    {
      // アサイン
      $this->smarty->assign ( 'header',               $this->obj_util->getHeader() );

      $this->smarty->assign ( 'entered_title',        $this->gotDat[ 'title'        ] );
      $this->smarty->assign ( 'entered_body',         stripslashes( $this->gotDat[ 'body' ] ) );
      $this->smarty->assign ( 'entered_categoryname', $this->gotDat[ 'categoryname' ] );
      $this->smarty->assign ( 'entered_tb_url',       $this->gotDat[ 'tb_url'       ] );
      $this->smarty->assign ( 'entered_postdate',     $this->gotDat[ 'postdate'     ] );
      $this->smarty->assign ( 'entered_opendate',     $this->gotDat[ 'opendate'     ] );
      $this->smarty->assign ( 'entered_enddate',      $this->gotDat[ 'enddate'      ] );

      $this->smarty->assign ( 'mycage',               $this->mycage );

      // 表示
      $this->smarty->display( 'blogadd_confirm.tpl' );

      return true;

    } // end of function:view()

  } // end of class:blogadd_confirm

?>
