<?php
/**
 * インストール画面(6)クラス
 *
 * インストール画面(6)を実現するためのクラス
 *
 * @package   risoluto
 * @author    Yuta Hayakawa <haya@hyec.org>
 * @license   http://opensource.org/licenses/bsd-license.php new BSD license
 * @copyright (C) 2008-2009 Yuta Hayakawa / All Rights Reserved.
 */

  /**
   * 基底クラス
   */
  require_once( 'install_base.inc' );

  class page05 extends install_base
  {
    //------------------------------------------------------//
    // クラス変数定義
    //------------------------------------------------------//
    /**
     * チェック情報格納用変数
     * @access private
     * @var    array
     */
    private $checklist;
    /**
     * チェック結果格納用変数
     * @access private
     * @var    array
     */
    private $checkresult;
    /**
     * エラー発生状況格納用変数
     * @access private
     * @var    boolean
     */
    private $errStatus;

    //------------------------------------------------------//
    // クラスメソッド定義
    //------------------------------------------------------//
    /**
     * コンストラクタメソッド
     *
     * コンストラクタメソッド
     *
     * @param     void なし
     * @return    void なし
     */
    public function __construct()
    {
    } // end of function:__construct()

    /**
     * クローンメソッド
     *
     * クローンメソッド
     *
     * @param     void なし
     * @return    void なし
     */
    public function __clone()
    {
    } // end of function:__clone()

    /**
     * modelメソッド（モデル）
     *
     * データ取得等のモデルに相当する部分の処理を行う
     *
     * @param     void なし
     * @return    boolean ファンクション実行結果（ true：正常終了 / false: 異常終了 ）
     */
    public function model()
    {
      // 前画面のCageが「install」でない or 前画面のActが「page04」 and 「page05」 and 「page06」でない場合、
      // インストーラトップに飛ばす
      $tmp_cage = str_replace( DIRECTORY_SEPARATOR, '.', $this->obj_sess->sessLoad( 'lastcage' ) );
      $tmp_act  = $this->obj_sess->sessLoad( 'lastact'  );
      if ( $tmp_cage != 'install' or ( $tmp_act != 'page04' and $tmp_act != 'page05' and $tmp_act != 'page06' ) )
      {
        $this->obj_util->redirectTo( 'install', 'install' );
        return false;
      } // end of if

      // 配置対象をセットする
      // 他に配置する対象があれば、この配列に加えてください。
      // target: 対象ファイル名 / destination: 配置先のパス/パーミッション/オーナ名/グループ名） / 
      // operation: 操作の内容(copy/move/unlink/mkdir/rmdir)
      $this->filelist = array(
                                array(
                                       'target'      => RISOLUTO_USERLAND . 'install/file/config_template.ini'
                                     , 'destination' => RISOLUTO_CONF     . 'config_template.ini'
                                     , 'operation'   => 'copy'
                                     )
                              );

      // 処理を行う
      foreach( $this->filelist as $dat )
      {

        // 処理を呼び出す
        $tmp_errflag = $this->obj_util->fileOperator( $dat[ 'operation' ], $dat[ 'target' ], $dat[ 'destination' ] );

        // 処理結果によって、状態を変える
        if ( ! $tmp_errflag )
        {
          $this->checkresult[] = array(
                                        'operation'   => $dat[ 'operation'   ]
                                      , 'target'      => $dat[ 'target'      ]
                                      , 'destination' => $dat[ 'destination' ]
                                      , 'result'  => 'OK'
                                      );
        } // end of if
        else
        {
          $this->checkresult[] = array(
                                        'operation'   => $dat[ 'operation'   ]
                                      , 'target'      => $dat[ 'target'      ]
                                      , 'destination' => $dat[ 'destination' ]
                                      , 'result'  => 'NG'
                                      );
          $this->errStatus     = 'NG';
        } // end of else
      } // end of foreach

      return true;
    } // end of function:model()

    /**
     * viewメソッド（モデル）
     *
     * テンプレート関連処理等のビューに相当する部分の処理を行う
     *
     * @param     void なし
     * @return    boolean ファンクション実行結果（ true：正常終了 / false: 異常終了 ）
     */
    public function view()
    {
      // ヘッダ情報をセット
      $html_header[ 'robots' ] = 'NOINDEX,NOFOLLOW';
      $html_header[ 'css'    ] = array( './css/common.css' );
      $html_header[ 'title'  ] = 'インストーラ(5)';

      // アサイン
      $this->smarty->assign ( 'header',    $html_header       );
      $this->smarty->assign ( 'checklist', $this->checkresult );
      $this->smarty->assign ( 'err',       $this->errStatus   );

      // 表示
      $this->smarty->display( 'page05.tpl' );

      return true;

    } // end of function:view()

  } // end of class:page05
?>
