# \GfB^tH[}bgc[(RGSSr_[c[p)
# Copyright (C) 2005 Y.Fukuyama

require 'fileutils'

def rename(file1,file2)
  if FileTest.file? file1
    if not FileTest.file? file2
      File.rename file1, file2
    elsif FileUtils.cmp file1, file2
      File.delete file1
    else
      File.rename file1, file2
    end
  end
end

if ARGV.size == 0
  puts 'error'
  exit
end

logfile = open(File.basename(ARGV[0],'.*') + '.log','w')

filepath = ''
filename = ''
section = ''

while line = gets
  if line =~ /^#.* $/
    name = line.gsub(/[# \n]/,'')
    if File.extname(name) == '.rb'
      filename = name
      output_file = open(filename + '.new','w')
      logfile.puts(filepath + filename) if filename.size != 0
    else
      if not FileTest.directory?(name)
        Dir.mkdir(name)
      end
      filepath += name + '/'
      filename = name + '/package.txt'
      output_file = open(filename + '.new','w')
    end
    section = name
  elsif line =~ /^\t$/
    if section.size != 0
      output_file.close
      rename filename + '.new', filename
      Dir.chdir(section)
    end
  elsif line =~ /^( +) $/
    seq = $1
    tl = filepath.split(/\//)
    if (tl.size - seq.size) <= 0
      filepath = ''
    else
      filepath = tl[0 ... (tl.size - seq.size)].join('/') + '/'
    end
    if section.size != 0
      path = seq.gsub(/ /,'../')
      output_file.close
      rename filename + '.new', filename
      Dir.chdir(path)
    end
  elsif line =~ /^ $/
    if File.extname(filename) == '.rb'
      output_file.close
      rename filename + '.new', filename
    end
    next
  else
    if (not output_file.nil?) and (not output_file.closed?)
      output_file.write line
    end
  end
end
