$data_map_info = load_data("Data/MapInfos.rxdata")

$data_map_info.keys.sort.each do |key|
  Debug.log("#{key}\t#{$data_map_info[key].name}")
end

# }bv}[W
def map_blt(dest_map_id, x, y, src_map_id, src_rect, layer=[0,1,2])

  dest_map_filename = sprintf("Data/Map%03d.rxdata", dest_map_id)
  dest_map = load_data(dest_map_filename)

  src_map_filename = sprintf("Data/Map%03d.rxdata", src_map_id)
  src_map = load_data(src_map_filename)

  sx = src_rect.x
  sy = src_rect.y
  for ix in 0 ... src_rect.width
    for iy in 0 ... src_rect.height
      for l in layer
        dest_map.data[x + ix,y + iy,l] = src_map.data[sx + ix,sy + iy,l]
      end
    end
  end

  save_data(dest_map,dest_map_filename)

end

#17  C[t@AS
map_all_id = 17
width = 130
height = 130

#5 C[t@ÅX@k
map_blt( 5,0,0,map_all_id,Rect.new(  0,  0,width,height))
#12 C[t@ÅX@k
map_blt(12,0,0,map_all_id,Rect.new(100,  0,width,height))
#14 C[t@ÅX@k
map_blt(14,0,0,map_all_id,Rect.new(  0,100,width,height))
#20 C[t@ÅX@
map_blt(20,0,0,map_all_id,Rect.new(  0,200,width,height))
#16 C[t@ÅX@
map_blt(16,0,0,map_all_id,Rect.new(100,100,width,height))

exit(0)

