# ACegf[^
# Q[IuWFNg
# Author:: fukuyama
# Date:: 2008/12/12
# Copyright:: Copyright (c) 2008 rgss-lib

# ACegf[^NX
class Game_Item_Attribute

  # 
  attr_accessor :attr_name
  # l
  attr_accessor :attr_value
  # g`
  attr_accessor :exp_type
  # 
  # item_attr:: f[^ ::RPG::Item_Attribute
  # generator:: ACeWFl[^[ Game_Item_Generator
  def initialize(item_attr,generator)
    @exp_type = item_attr.exp_type
    @attr_name = item_attr.attr_name
    case @exp_type
    when ::RPG::Item_Attribute::TYPE_NORMAL_FIX, ::RPG::Item_Attribute::TYPE_PERCENT_FIX
      @attr_value = item_attr.attr_value
    when ::RPG::Item_Attribute::TYPE_NORMAL_RANGE, ::RPG::Item_Attribute::TYPE_PERCENT_RANGE
      r = item_attr.attr_value
      @attr_value = rand((r.last - r.first + (r.exclude_end? ? 0 : 1))) + r.first
    else
      @attr_value = item_attr.attr_value
    end
  end

  # gf[^f
  # item:: gf[^𔽉fACe Game_Item | Game_Weapon | Game_Armor
  def apply(item)
    begin
      if @exp_type == ::RPG::Item_Attribute::TYPE_METHOD
        # \bh̏ꍇ
        send(@attr_name,item)
      else
        # \bhȊȌꍇ
        value = item.send(@attr_name)

        case @exp_type
        when ::RPG::Item_Attribute::TYPE_NORMAL_FIX, ::RPG::Item_Attribute::TYPE_NORMAL_RANGE
          # ʂZ
          value += @attr_value
        when ::RPG::Item_Attribute::TYPE_PERCENT_FIX, ::RPG::Item_Attribute::TYPE_PERCENT_RANGE
          # f[^̒lx[XɍlB(percent̏ꍇ)
          base = item.data_base.send(@attr_name)
          value += (base.to_f * @attr_value.to_f / 100.0).to_i
        end

        item.send(@attr_name + '=',value)
      end
    rescue
      return false
    end
    return true
  end

  # Xe[g̕ω{
  def plus_state_set(item)
    unless item.plus_state_set.include?(@attr_value)
      item.plus_state_set.push(@attr_value)
    end
  end

  # Xe[g̕ω|
  def minus_state_set(item)
    unless item.minus_state_set.include?(@attr_value)
      item.minus_state_set.push(@attr_value)
    end
  end

  # ̕ω
  def element_set(item)
    unless item.element_set.include?(@attr_value)
      item.element_set.push(@attr_value)
    end
  end

  # K[h
  def guard_element_set(item)
    unless item.guard_element_set.include?(@attr_value)
      item.guard_element_set.push(@attr_value)
    end
  end

  # K[hXe[g
  def guard_state_set(item)
    unless item.guard_state_set.include?(@attr_value)
      item.guard_state_set.push(@attr_value)
    end
  end

  # \Pbgǉ
  def item_socket(item)
    # ACeRei
    if item.container.nil?
      item.container = Item_Max_Container.new(@attr_value)
    end
  end

end
