#==============================================================================
#  Window_Status_Summary
#------------------------------------------------------------------------------
# AN^[ȈՃXe[^X
# Copyright (C) 2005 fukuyama
#==============================================================================

module DQ
  unless defined? STATUS_SUMMARY_PROPERTIES
    STATUS_SUMMARY_PROPERTIES = [
      {:key=>Game_Actor::PROPERTY_SEX,:display=>'ׂF',:default=>'HHH'}
    ]
  end

  class Window_Status_Summary < Window_Base
    #--------------------------------------------------------------------------
    #  IuWFNg
    #--------------------------------------------------------------------------
    def initialize(actor)
      @item_height = ITEM_HEIGHT
      @name_space = 0
      # @name_space = (@item_height * 11 + 32) - (@item_height * 9 + 32 * 2)
      if @name_space < 0
        @name_space = 0
      end
      @actor = actor
      property_size = STATUS_SUMMARY_PROPERTIES.size
      super(0,0, 32 * 6 + 32, @item_height * (3 + property_size) + 32 + @name_space)
      self.contents = Bitmap.new(self.width - 32, self.height - 32)
      refresh
    end

    #--------------------------------------------------------------------------
    #  AN^[̐ݒ
    #--------------------------------------------------------------------------
    def actor=(actor)
      if @actor != actor
        @actor = actor
        refresh
      end
    end

    #--------------------------------------------------------------------------
    #  tbV
    #--------------------------------------------------------------------------
    def refresh
      self.contents.clear
      return if @actor.nil?

      (x,y) = 0,0
      width = self.contents.width

      status_system_color = self.system_color
      status_normal_color = self.normal_color

      contents.font.color = status_normal_color
      contents.draw_text(x,y,width,@item_height,@actor.name,1)
      y += @item_height
      job_name = @actor.properties[Game_Actor::PROPERTY_JOB]
      contents.draw_text(x,y,width,@item_height,job_name,1)
      y += @item_height
      y += @name_space / 2

      (x,y,display_width) = refresh_properties(x,y,contents)

      contents.font.color = status_system_color
      contents.draw_text(x,y,display_width,@item_height,'xF',2)
      contents.font.color = status_normal_color
      contents.draw_text(x + display_width,y,width - display_width,@item_height,@actor.level.to_s,1)

    end

    def refresh_properties(x,y,contents)
      width = self.contents.width
      status_system_color = self.system_color
      status_normal_color = self.normal_color

      display_width = STATUS_SUMMARY_PROPERTIES.collect(){|data| contents.text_size(data[:display]).width }.max

      STATUS_SUMMARY_PROPERTIES.each do |data|
        contents.font.color = status_system_color
        contents.draw_text(x,y,display_width,@item_height,data[:display],2)
        contents.font.color = status_normal_color
        if @actor.properties.member?(data[:key])
          contents.draw_text(x + display_width,y,width - display_width,@item_height,@actor.properties[data[:key]],1)
        else
          contents.draw_text(x + display_width,y,width - display_width,@item_height,data[:default],1)
        end
        y += @item_height
      end
      return x,y,display_width
    end
  end

end
