#==============================================================================
#  Window_Item
#------------------------------------------------------------------------------
# ACeEBhE
# Copyright (C) 2005 fukuyama
#==============================================================================

module DQ
  class Window_Item < Window_Item_Base
    include Window_Item_Help_Module
    #--------------------------------------------------------------------------
    # 
    #--------------------------------------------------------------------------
    def initialize(parent,help=true)
      @column_max = 1
      @row_max = 12
      super(parent)
      # ʒu̐ݒ
      self.top  = top_window.top
      self.left = parent.right

      if help
        setup_window_help()
      end
    end

    #--------------------------------------------------------------------------
    # ĕ`
    #--------------------------------------------------------------------------
    def refresh
      self.clear
      refresh_actor_items
      refresh_help
      super
    end

    #--------------------------------------------------------------------------
    # ACeEBhEĕ`
    #--------------------------------------------------------------------------
    def active_event
      active_event_help
    end

    def make_item_status_description
      return '' if @actor.nil?
      return '' if not @actor.is_a?(Game_Actor)
      return '' if item.is_a?(Game_Item)
      text = '\bottom'
      if Item_Facade.equippable?(item,@actor)
        (a,b) = Item_Facade.equip_ability_calc(item,@actor)
        text << "\\left[#{a}]."
        text << "\\center_left[]"
        text << "\\center_right[ #{b}] #{b}"
      else
        text << "\\left[тłȂ]."
      end
      return text
    end

    #--------------------------------------------------------------------------
    # ACȇI
    #--------------------------------------------------------------------------
    def select_item
      window = Window_Item_Menu.new(self)
      set_active_window(window.class)
    end

    #--------------------------------------------------------------------------
    # LZ
    #--------------------------------------------------------------------------
    def input_b
      cancel_se
      self.index = -1
      window_help_off
      set_active_window(Window_Actor_Menu_Item)
    end
  end

end
