#==============================================================================
#  Window_Config
#------------------------------------------------------------------------------
# ĂEBhE
# Copyright (C) 2005 fukuyama
#==============================================================================

module DQ
  
  class Window_Config_Item < ::DQ::Window_Page_Menu
    include Window_Tree_Module
    # IuWFNg
    def initialize(parent,config)
      @config = config
      @title = @config.name
      @title_align = 0
      @index = @config.values.index(@config.get.call())
      @config.texts.each do |text|
        add_menu(text.to_s, :select_config)
      end
      @left_label_width = 0
      @right_label_width = 0
      
      case @config.texts[0]
      when Integer
        label_test = Bitmap.new(640,32)
        @cellspacing = Rect.new(4,0,4,0) if @cellspacing.nil?
        @left_label_width = label_test.text_size(@config.min_label).width + @cellspacing.x + @cellspacing.width
        @right_label_width = label_test.text_size(@config.max_label).width
        label_test.dispose
        @column_max = @config.texts.size
      when String
        @column_max = 1
      end
      
      super(parent)
      
      # ʒu̐ݒ
      self.top = parent.top + 32
      self.left = parent.left + 32
    end
    
    def select_config
      @config.set.call(@config.values[@index])
      self.parent.refresh
      dispose
    end
    
    #--------------------------------------------------------------------------
    # tbV
    #--------------------------------------------------------------------------
    def refresh
      super
      case @config.texts[0]
      when Integer
        self.contents.font.size -= 2
        w = self.contents.width
        h = _menu_height
        x = 0
        y = _title_height
        self.contents.draw_text(x,y,w,h,@config.min_label,0)
        self.contents.draw_text(x,y,w,h,@config.max_label,2)
        self.contents.font.size += 2
      when String
        # XXX: ȂɂȂH
      end
    end
    
    #--------------------------------------------------------------------------
    # ڂ̍W
    #--------------------------------------------------------------------------
    def menu_rect(index)
      rect = super(index)
      rect.x += @left_label_width + @cellspacing.x
      return rect
    end
    #---------------------------------------------------------------------------
    # Rec̍쐬
    def _contents_width
      return super + @left_label_width + @right_label_width
    end
    #---------------------------------------------------------------------------
    # j[̍쐬
    def _menu_width
      return (self.contents.width - @left_label_width - @right_label_width) / @column_max
    end
  end
  
  class Window_Config < ::DQ::Window_Page_Menu
    include Window_Tree_Module
    
    @@configs = []
    
    class Config
      attr_accessor :name
      attr_accessor :values
      attr_accessor :texts
      attr_accessor :get
      attr_accessor :set
      attr_accessor :min_label
      attr_accessor :max_label
    end
    
    def self.create(name,values,texts)
      cf = Config.new
      cf.name = name
      cf.values = values
      cf.texts  = texts
      @@configs.push cf
      return cf
    end
    
    # IuWFNg
    def initialize(parent)
      @title = 'Ă'
      @index = 0
      @backup_config = []
      for cf in @@configs
        add_menu(cf.name, :command_config)
        @backup_config.push cf.get.call
      end
      
      #    add_menu('^Cg', :command_to_title)
      #    add_menu('Vbg_E', :command_shutdown)
      
      super(parent)
      
      # ʒu̐ݒ
      rect = parent.menu_rect(parent.index)
      self.top = parent.top + rect.y
      self.left = parent.left + rect.x
    end
    
    # ݒ荀ڑI
    def command_config
      window = Window_Config_Item.new(self,@@configs[@index])
      set_active_window(window.class)
    end
    
    # [^Cg] Ȉ
    def command_to_title
      # BGMABGSAME tF[hAEg
      Audio.bgm_fade(800)
      Audio.bgs_fade(800)
      Audio.me_fade(800)
      # ^Cgʂɐ؂ւ
      $scene = ::Scene_Title.new
    end
    
    # R}h [Vbg_E] Ȉ
    def command_shutdown
      # BGMABGSAME tF[hAEg
      Audio.bgm_fade(800)
      Audio.bgs_fade(800)
      Audio.me_fade(800)
      # Vbg_E
      $scene = nil
    end
    
    # ڂ̕`
    def draw_menu_item(index,color,rect,name)
      super
      if @@configs.size <= index
        return
      end
      cf = @@configs[index]
      text = cf.texts[cf.values.index(cf.get.call)].to_s
      self.contents.font.size -= 2
      self.contents.draw_text(rect,text,2)
      self.contents.font.size += 2
    end
    
    # Rec̍쐬
    def _contents_width
      return _menu_width
    end
    
    # j[̍쐬
    def _menu_width
      return WINDOW_CONFIG_WIDTH
    end
  end
  
end
