# IAN^[쐬pCxgXNvg
# Author:: fukuyama
# Date:: 2008/07/05
# Copyright:: Copyright (C) 2008 rgss-lib

module DQ
  
  class Window_Actor_List < ::DQ::Window_Page_Menu
    include Window_Tree_Module
    attr_accessor :select_proc
    attr_accessor :cancel_proc
    attr_accessor :change_proc
    
    def initialize(actors,row_max=10)
      @select_proc = nil
      @cancel_proc = nil
      @change_proc = nil
      @row_max = row_max
      @column_max = 1
      @actors = actors
      @actors.each do |actor|
        add_menu(actor, :select_actor)
      end
      @index = 0
      super(nil)
      
      add_input_handler(Input::UP,:change_actor)
      add_input_handler(Input::DOWN,:change_actor)
      screen_center
    end
    
    # AN^[̎擾
    def actor
      return nil if @index < 0
      return @actors[@index]
    end
    
    def input_b
      if not @cancel_proc.nil?
        result = @cancel_proc.call()
        if result == false
          return
        end
      end
      super
    end
    
    def select_actor
      if not @select_proc.nil?
        if not self.actor.nil?
          @select_proc.call(self.actor)
        end
      end
    end
    
    def change_actor
      if not @change_proc.nil?
        if not self.actor.nil?
          @change_proc.call(self.actor)
        end
      end
    end
    
    def draw_menu_item(index,color,rect,actor)
      self.contents.font.color = color
      self.contents.fill_rect(rect, Color.new(0, 0, 0, 0))
      
      # O x EƁ@
      
      name_rect = Rect.new(rect.x,rect.y,rect.width * 0.25,rect.height)
      self.contents.draw_text(name_rect, actor.name, 0)
      
      level_rect = Rect.new(rect.x + name_rect.width, rect.y,rect.width * 0.15,rect.height)
      level_rect.x += 2
      level_rect.width -= 4
      self.contents.draw_text(level_rect, "Lv:", 0)
      self.contents.draw_text(level_rect, actor.level.to_s, 2)
      level_rect.x -= 2
      level_rect.width += 4
      
      job_rect = Rect.new(level_rect.x + level_rect.width, rect.y,rect.width * 0.35,rect.height)
      job_rect.x += 8
      job_rect.width -= 8
      job_name = actor.properties[Game_Actor::PROPERTY_JOB]
      self.contents.draw_text(job_rect,job_name,0)
      job_rect.x -= 8
      job_rect.width += 8
      
      sex_rect = Rect.new(job_rect.x + job_rect.width, rect.y,rect.width * 0.25,rect.height)
      sex_str = actor.properties[Game_Actor::PROPERTY_SEX]
      self.contents.draw_text(sex_rect,sex_str,1)
      
    end
    
    #---------------------------------------------------------------------------
    # Rec̍쐬
    def _contents_width
      return _menu_width * @column_max
    end
    #---------------------------------------------------------------------------
    # j[̍쐬
    def _menu_width
      return 400
    end
  end
  
end
