#==============================================================================
#  Windowskin_Rule_Module
#------------------------------------------------------------------------------
# EBhEXLύXW[
#==============================================================================

module Windowskin_Rule_Module
  @@windowskin_rules = []
  @@windowskins = []
  
  $data_system = load_data("Data/System.rxdata")
  $game_system = Game_System.new
  w = Window_Base.new(0,0,0,0)
  @@normal_color = w.normal_color
  @@system_color = w.system_color
  w.dispose
  # 肷
  
  module_function
  
  # [NXǉ
  def add_windowskin_rule(klass)
    return if @@windowskin_rules.include?(klass)
    @@windowskin_rules.push klass
    @@windowskins.push klass.windowskin_name
  end
  
  # [XV
  def update_windowskin
    if not @@windowskins.include?($game_system.windowskin_name)
      # [ŎgpȂXLɕύXĂ烋[͓KpȂB
      return
    end
    modify = false
    for rule in @@windowskin_rules
      if rule.change?
        if $game_system.windowskin_name != rule.windowskin_name
          $game_system.windowskin_name = rule.windowskin_name
          modify = true
        end
        if @@normal_color != rule.normal_color
          @@normal_color = rule.normal_color
          modify = true
        end
        if @@system_color != rule.system_color
          @@system_color = rule.system_color
          modify = true
        end
        break
      end
    end
    if modify
      Window_Collection.window_list.each do |w|
        w.update_windowskin
        w.refresh
      end
    end
  end
  
  def normal_color
    return @@normal_color
  end
  def system_color
    return @@system_color
  end
end

class Window_Base
  def normal_color
    return Windowskin_Rule_Module.normal_color
  end
  def system_color
    return Windowskin_Rule_Module.system_color
  end
end

class Window_Message
  alias windowskin_rule_module_refresh refresh
  def refresh
    windowskin_rule_module_refresh
    @sprite_message.bitmap.font.color = normal_color
  end
end

class Scene_Map
  alias windowskin_rule_module_update update
  def update
    Windowskin_Rule_Module.update_windowskin
    windowskin_rule_module_update
  end
end
module DQ
  class Scene_Menu
    alias windowskin_rule_module_main_start main_start
    def main_start
      Windowskin_Rule_Module.update_windowskin
      windowskin_rule_module_main_start
    end
    alias windowskin_rule_module_update update
    def update
      Windowskin_Rule_Module.update_windowskin
      windowskin_rule_module_update
    end
  end
  module Battle
    class Scene_Battle
      alias windowskin_rule_module_main_start main_start
      def main_start
        Windowskin_Rule_Module.update_windowskin
        windowskin_rule_module_main_start
      end
      alias windowskin_rule_module_update update
      def update
        Windowskin_Rule_Module.update_windowskin
        windowskin_rule_module_update
      end
    end
  end
end

