#==============================================================================
#  Window_Skill
#------------------------------------------------------------------------------
# XLEBhE
# Copyright (C) 2005 fukuyama
#==============================================================================

module DQ
  module Battle
    
    class Window_Skill < ::DQ::Battle::Window_Page_Menu
      include Window_Tree_Module
      include Window_Target_Module
      
      #--------------------------------------------------------------------------
      # 
      #--------------------------------------------------------------------------
      def initialize(parent,actor)
        @actor = actor
        
        if not @actor.nil?
          skills = Skill_Facade.actor_battle_skills @actor
          skills.each do |skill|
            add_menu(skill, :select_skill)
          end
        end
        
        @index = 0
        @column_max = 2
        @row_max = 5
        
        super(parent)
        
        # EBhEʒu
        self.left = parent.left
        self.top = parent.top
        
        # ACewvEBhE쐬
        x = self.right
        y = self.top
        w = 640 - x - 16
        h = self.height
        @window_help = Window_Markup_Text.new(x,y,w,h)
        @window_help.back_opacity = WINDOW_BACK_OPACITY
        
        # qEBhEɒǉ
        add_child @window_help
        @window_help.visible = false
        add_input_handler(Input::UP,:change_skill)
        add_input_handler(Input::DOWN,:change_skill)
        add_input_handler(Input::LEFT,:change_skill)
        add_input_handler(Input::RIGHT,:change_skill)
      end
      def skill
        return get_menu
      end
      #--------------------------------------------------------------------------
      # Cxgnh
      #--------------------------------------------------------------------------
      def input_b
        if event_handling_trigger?
          @index = -1
          cancel_se
          dispose
        end
      end
      def select_skill
        if not @actor.skill_can_use?(skill.id)
          # uU[ SE t
          buzzer_se
          return
        end
        get_window(Window_Actor_Command).skill = skill
        next_window(skill)
      end
      
      #--------------------------------------------------------------------------
      # XLύX
      #--------------------------------------------------------------------------
      def change_skill
        if @index >= 0
          refresh_help
        end
      end
      def active_event
        if (not @window_help.nil?) and (not @window_help.disposed?)
          if self.active
            @window_help.visible = true
            refresh_help
          end
        end
      end
      #--------------------------------------------------------------------------
      # ĕ`
      #--------------------------------------------------------------------------
      def refresh
        super
        refresh_help
      end
      def refresh_help
        if (not @window_help.nil?) and (not @window_help.disposed?)
          if not self.skill.nil?
            text = self.skill.description.dup
            text << "\\bottom"
            text << "\\center_left[#{skill.sp_cost}/]#{skill.sp_cost}/"
            text << "\\right[#{@actor.sp}]#{@actor.sp}"
            @window_help.set_text text
          else
            @window_help.set_text ""
          end
        end
      end
      
      #--------------------------------------------------------------------------
      # ڂ̕`
      #--------------------------------------------------------------------------
      def draw_menu_item(index,color,rect,skill)
        self.contents.font.color = color
        self.contents.fill_rect(rect, Color.new(0, 0, 0, 0))
        self.contents.draw_text(rect, skill.name)
      end
      #---------------------------------------------------------------------------
      # Rec̍쐬
      def _contents_height
        return parent.contents.height
      end
      #---------------------------------------------------------------------------
      # Rec̍쐬
      def _contents_width
        max_width = _menu_width
        max_width += @cellspacing.x + @cellspacing.width
        return max_width * @column_max
      end
      #---------------------------------------------------------------------------
      # j[̍쐬
      def _menu_width
        return BATTLE_WINDOW_SKILL_WIDTH
      end
    end
    
  end
end
