#==============================================================================
#  Best_Battle
#------------------------------------------------------------------------------
# 퓬`h
# Copyright (C) 2005 fukuyama
#==============================================================================

module Best_Battle_Data

  module_function
  # AIp[^[擾
  def ai_params(key)
    return @ai_params[key]
  end

  # bf[^ǂݍ
  def load()
    # AIp[^[
    @ai_params = {}

    # i
    @character_infos = load_character_infos()

    # AIp[^[ǂݍ
    @character_infos.each do |key,value|
      if value.include? 'ai_param'
        ai_param_name = value['ai_param']
        @ai_params[key] = load_ai_param(ai_param_name)
      end
    end
  end

  # i
  def load_character_infos()
    # i`t@C
    txfile = "Character.txt"
    rxfile = "Data/AICharacterInfo.rxdata"
    list = Data_Loader.data_section_map(rxfile,txfile)

    # i쐬
    character_infos = {}
    list.each do |data|
      # ZNVi
      character = data['section']
      # d̓}[Wiڏ㏑j
      if character_infos.include? character
        character_infos[character].update data
      else
        character_infos[character] = data
      end
    end
    return character_infos
  end

  # AIf[^
  def load_ai_param(ai_param_name)
    # AI`t@C
    txfile = "#{ai_param_name}.txt"
    rxfile = "Data/AIParam" + ai_param_name.gsub(/\//,'_') + ".rxdata"
    return Data_Loader.data_section_map(rxfile,txfile)
  end
end

class Best_Battle < Condition_AI_Base

  # og[XL
  attr_reader :battler_skill
  # 
  def initialize(name)
    super(name)
  end

  # Xgč쐬
  def create_bast_battle_condition_list(ai_param)
    # AIp[^[烋[Xg쐬
    ai_param.each do |param|
      # NX
      name = 'Cond_' + param['section']
      # NX`FbN
      unless Best_Battle.const_defined?(name)
        p "Error [#{name}]"
        next
      end
      # NX擾
      klass = Best_Battle.const_get(name)
      unless klass.nil?
        # NXCX^X
        condition = klass.method('new').call(param)
        # ǉ
        add_condition(condition)
      end
    end
    # ftHgǉ
    add_condition(Cond_Default.new())
  end

  def make_action_initialize
    # XLǗNX쐬iXL͈ꉞ`FbNj
    @battler_skill = Game_Battler_Skill.new(battler)

    # og[ɐi񂪂邩H iςĂAIč쐬
    if @_prev_character_type != battler.properties['character']
      # og[琫i擾
      @_prev_character_type = battler.properties['character']
      # iAIp[^[擾
      ai_param = Best_Battle_Data.ai_params(@_prev_character_type)
      # [Xgč쐬
      clear_condition()
      create_bast_battle_condition_list(ai_param)
    end

    # e[ condition_initialize Ă΂
    super
  end

  # NA[
  def clear
    @battler_skill = nil
    super
  end

  # ob`΂p̃[NX
  class Best_Battle_AI_Condition < AI_Condition
    attr_reader :param
    # 
    def initialize(param={})
      @param = param
      super()
    end

    # og[XL
    def battler_skill
      return @ai.battler_skill
    end

    # og[ACe
    def battler_items
      items = []
      battler.backpack.each_item do |item|
        next if Item_Facade.get_use_item(item).nil?
        next unless item.use_battle?
        items.push item
      end
      return items
    end

    # lp[^[擾
    def param_i(k,default=0)
      unless @param.include? k
        return default
      end
      return @param[k].to_i
    end

    # p[^[擾
    def param_s(k,default=nil)
      unless @param.include? k
        return default
      end
      return @param[k].to_s
    end

    # ݊mF
    def param?(k)
      return @param.include?(k)
    end

    # s
    def execute
      # O
      unless execute_pre_condition
        return false
      end
      # 
      unless execute_main_condition
        return false
      end
      # 
      unless execute_post_condition
        return false
      end
      return true
    end

    # OiftHgj
    def execute_pre_condition
      # ڕW̍ő吔
      n = param_i('targets_max_size',-1)
      if n >= 0
        return false if targets.size > n
      end
      # ڕW̍Œᐔ
      n = param_i('targets_min_size',-1)
      if n >= 0
        return false if targets.size < n
      end
      # Ԃ̍ő吔
      n = param_i('partners_max_size',-1)
      if n >= 0
        return false if partners.size > n
      end
      # Ԃ̍Œᐔ
      n = param_i('partners_min_size',-1)
      if n >= 0
        return false if partners.size < n
      end
      # ĝgoő劄
      n = param_i('battler_hp_max_rate',-1)
      if n >= 0
        return false if (battler.hp / battler.maxhp.to_f * 100.0) > n
      end
      # ĝgoŒኄ
      n = param_i('battler_hp_min_rate',-1)
      if n >= 0
        return false if (battler.hp / battler.maxhp.to_f * 100.0) < n
      end
      # ĝroő劄
      n = param_i('battler_sp_max_rate',-1)
      if n >= 0
        return false if (battler.sp / battler.maxsp.to_f * 100.0) > n
      end
      # ĝroŒኄ
      n = param_i('battler_sp_min_rate',-1)
      if n >= 0
        return false if (battler.sp / battler.maxsp.to_f * 100.0) < n
      end
      # TODO ^[

      return true
    end

    # iftHgj
    def execute_main_condition
      return false
    end

    # iftHgj
    def execute_post_condition
      return true
    end

    # ʃXLtB^[
    def skills_filter(_skills)
      skills = _skills.dup
      # XLIiXR[vj
      skill_scope = param_s('skill_scope')
      unless skill_scope.nil?
        case skill_scope
        when 'all'
          # S̃XLȊO폜
          skills.delete_if {|s| (not s.scope_all?)}
        when 'single'
          # P̃XLȊO폜
          skills.delete_if {|s| (not s.scope_single?)}
        end
      end

      # pXLîhcj
      skill_use_id_list = param_s('skill_use_id_list')
      unless skill_use_id_list.nil?
        skill_use_id_list = skill_use_id_list.split(/\s*,\s*/).collect {|s| s.to_i}
        # w肳ꂽXLhcȊO폜
        skills.delete_if {|s| (not skill_use_id_list.include?(s.id))}
      end
      # gpXLîhcj
      skill_not_id_list = param_s('skill_not_id_list')
      unless skill_not_id_list.nil?
        skill_not_id_list = skill_not_id_list.split(/\s*,\s*/).collect {|s| s.to_i}
        # w肳ꂽXLhc폜
        skills.delete_if {|s| (skill_not_id_list.include?(s.id))}
      end
      return skills
    end

    # ʃACetB^[
    def items_filter(_items)
      items = _items.dup
      # ACeIiXR[vj
      item_scope = param_s('item_scope')
      unless item_scope.nil?
        case item_scope
        when 'all'
          # S̃ACeȊO폜
          items.delete_if {|i| (not i.scope_all?)}
        when 'single'
          # P̃ACeȊO폜
          items.delete_if {|i| (not i.scope_single?)}
        end
      end
      # TODO ^Ȃ
      return items
    end

    # XLĂ邩`FbNij
    def skills_state?(target,skills)
      skills.each do |skill|
        # tXe[g
        unless Game_Battler_Module.skill_state?(target,skill)
          return false
        end
      end
      return true
    end

    # ACẽXe[gĂ邩`FbNij
    def items_state?(target,items)
      items.each do |item|
        # tXe[g
        unless Game_Battler_Module.item_state?(target,item)
          return false
        end
      end
      return true
    end

    # ZbgAbv^[QbgXL
    def setup_skills(skills,skill_targets)
      # ΏۂȂ
      if skill_targets.empty?
        return false
      end
      # XLȂ
      if skills.empty?
        return false
      end
      # ڕW̍ő吔
      n = param_i('targets_max_size',-1)
      if n >= 0
        return false if skill_targets.size > n
      end
      # ڕW̍Œᐔ
      n = param_i('targets_min_size',-1)
      if n >= 0
        return false if skill_targets.size < n
      end
      # Ώ
      target = skill_targets[0]
      # XL
      skills.each do |skill|
        if skill_targets.size == 1
          # P̂̃XLI
          setup_skill(skill,target)
          if skill.scope_single?
            break
          end
        else
          # ̃XLI
          setup_skill(skill,target)
          if skill.scope_all?
            break
          end
        end
      end
      return true
    end
  end

  # ftHg
  class Cond_Default < Best_Battle_AI_Condition
    def execute
      # |₷߂
      s = @ai.create_score_hp_pdef(targets)
      # _P̑IiXRÄԒႢj
      t = @ai.get_single_target_min(targets,s)
      # ʏU
      @ai.setup_normal_attack(t)
      return true
    end
  end

  # U͋
  # ʏUŖڕW񐔈ȓɓ|Ȃꍇ
  class Cond_Skill_Attack_Up < Best_Battle_AI_Condition
    def execute_main_condition
      # U͋XLꍇ
      skills = battler_skill.attack_up_skills
      return false if skills.empty?
      skills = skills_filter(skills)
      return false if skills.empty?
      # SP̒ႢɃ\[g
      skills.sort! { |a,b| a.sp_cost <=> b.sp_cost }

      # ڕWU
      attack_count = param_i('attack_count',4)
      # ΏۂƂp[eBo[̍őʒu
      party_max_index = [param_i('party_max_index',0),partners.size].min - 1
      attack_partners = partners[0 .. party_max_index]

      # Ώۂ
      skill_targets = []
      attack_partners.each do |partner|
        # łꍇ́AǉȂ
        next if partner.dead?
        # Xe[gĂȂԂǉB
        unless skills_state?(partner,skills)
          # U񐔂̊mF
          targets.each do |target|
            # _[WvZ
            damage = Game_Battler_Module.calculate_attack_damage(target,partner)
            next if damage <= 0
            # ڕWU񐔂葽̍UKvȏꍇ
            if (target.maxhp / damage.to_f).ceil > attack_count
              skill_targets.push(partner)
              break
            end
          end
        end
      end

      return setup_skills(skills,skill_targets)
    end
  end

  # h͋
  # G̒ʏUڕW񐔑ςȂꍇ
  class Cond_Skill_Defense_Up < Best_Battle_AI_Condition
    def execute_main_condition
      # h͋XLꍇ
      skills = battler_skill.pdef_up_skills
      return false if skills.empty?
      skills = skills_filter(skills)
      return false if skills.empty?
      # SP̒ႢɃ\[g
      skills.sort! { |a,b| a.sp_cost <=> b.sp_cost }

      # ڕWU
      attack_count = param_i('attack_count',3)

      # Ώۂ
      skill_targets = []
      partners.each do |partner|
        # łꍇ́AǉȂ
        next if partner.dead?
        # Xe[gĂȂԂǉB
        unless skills_state?(partner,skills)
          # U񐔂̊mF
          targets.each do |target|
            damage = Game_Battler_Module.calculate_attack_damage(partner,target)
            next if damage <= 0
            if (partner.maxhp / damage.to_f).ceil <= attack_count
              skill_targets.push(partner)
              break
            end
          end
        end
      end

      return setup_skills(skills,skill_targets)
    end
  end

  # ͋
  # 肻ɖƂc
  class Cond_Skill_Hit_Up < Best_Battle_AI_Condition
    def execute_main_condition
      # ͋XLꍇ
      skills = battler_skill.hit_up_skills
      return false if skills.empty?
      skills = skills_filter(skills)
      return false if skills.empty?
      # SP̒ႢɃ\[g
      skills.sort! { |a,b| a.sp_cost <=> b.sp_cost }

      # TODO ĂȂꍇ

      # ڕW(K{)
      hit_rate = param_i('hit_rate',-1)
      if hit_rate < 0
        return false
      end

      # ΏۂƂp[eBo[̍őʒu
      party_max_index = [param_i('party_max_index',0),partners.size].min - 1
      attack_partners = partners[0 .. party_max_index]

      # Ώۂ
      skill_targets = []
      attack_partners.each do |partner|
        # łꍇ́AǉȂ
        next if partner.dead?
        # Xe[gĂȂԂǉB
        unless skills_state?(partner,skills)
          # ̌vZ
          targets.each do |target|
            hit = Game_Battler_Module.calculate_attack_hit(target,partner)
            if hit < hit_rate
              skill_targets.push(partner)
              break
            end
          end
        end
      end

      return setup_skills(skills,skill_targets)
    end
  end

  # U͎
  # G̒ʏUڕW񐔑ςȂꍇ
  class Cond_Skill_Attack_Down < Best_Battle_AI_Condition
    def execute_main_condition
      # Ủ͎XLꍇ
      skills = battler_skill.attack_down_skills
      return false if skills.empty?
      skills = skills_filter(skills)
      return false if skills.empty?
      # SP̒ႢɃ\[g
      skills.sort! { |a,b| a.sp_cost <=> b.sp_cost }

      # ڕWU
      attack_count = param_i('attack_count',3)

      # ̉Ώۂ
      skill_targets = []
      targets.each do |target|
        # Xe[gĂȂԂǉB
        unless skills_state?(target,skills)
          # U񐔂̊mF
          partners.each do |partner|
            # _[WvZ
            damage = Game_Battler_Module.calculate_attack_damage(partner,target)
            next if damage <= 0
            # ڕWU񐔈ȉŎł܂ꍇ
            if (partner.maxhp / damage.to_f).ceil <= attack_count
              skill_targets.push(target)
              break
            end
          end
        end
      end

      return setup_skills(skills,skill_targets)
    end
  end

  # h͎
  # ʏUŖڕW񐔈ȓɓ|Ȃꍇ
  class Cond_Skill_Defense_Down < Best_Battle_AI_Condition
    def execute_main_condition
      # h͎̉XLꍇ
      skills = battler_skill.pdef_down_skills
      return false if skills.empty?
      skills = skills_filter(skills)
      return false if skills.empty?
      # SP̒ႢɃ\[g
      skills.sort! { |a,b| a.sp_cost <=> b.sp_cost }

      # ڕWU
      attack_count = param_i('attack_count',4)
      # ΏۂƂp[eBo[̍őʒu
      party_max_index = [param_i('party_max_index',0),partners.size].min - 1
      attack_partners = partners[0 .. party_max_index]

      # ̉Ώۂ
      skill_targets = []
      targets.each do |target|
        # Xe[gĂȂ^[QbgǉB
        unless skills_state?(target,skills)
          # U񐔂̊mF
          attack_partners.each do |partner|
            # _[WvZ
            damage = Game_Battler_Module.calculate_attack_damage(target,partner)
            next if damage <= 0
            # ڕWU񐔂葽̍UKvȏꍇ
            if (target.maxhp / damage.to_f).ceil > attack_count
              skill_targets.push(target)
              break
            end
          end
        end
      end

      return setup_skills(skills,skill_targets)
    end
  end

  # ͎
  class Cond_Skill_Hit_Down < Best_Battle_AI_Condition
    def execute_main_condition
      # ͎̃XLꍇ
      skills = battler_skill.hit_down_skills
      return false if skills.empty?
      skills = skills_filter(skills)
      return false if skills.empty?
      # SP̒ႢɃ\[g
      skills.sort! { |a,b| a.sp_cost <=> b.sp_cost }

      # ̉Ώۂ
      skill_targets = targets.dup

      # s\ȓG̐
      action_targets_min_count = param_i('action_targets_min_count',-1)
      if action_targets_min_count >= 0
        return false if skill_targets.size < action_targets_min_count
      end
      # s\ȓG̐ĩp[eB̍s\lƂ̔rj
      if param?('action_targets_gap_count')
        # p[gi[Xgss\̃p[gi[폜
        action_partners = partners.dup.delete_if {|p| (not p.movable?)}
        # p[eBlMbvBvXƎ̃p[eB̃p[eB̕
        action_targets_gap_count = param_i('action_targets_gap_count')
        # MbvƎsȂ
        return false if skill_targets.size - action_partners.size < action_targets_gap_count
      end

      # ڕW
      hit_min_rate = param_i('hit_min_rate',0)
      hit_max_rate = param_i('hit_max_rate',100)
      hit_rate_range = hit_min_rate .. hit_max_rate

      old_skill_targets = skill_targets
      skill_targets = []
      old_skill_targets.each do |target|
        # Xe[gĂȂ^[QbgǉB
        unless skills_state?(target,skills)
          # ̌vZ
          partners.each do |partner|
            # ^[QbgɍUꍇ̖vZ
            hit = Game_Battler_Module.calculate_attack_hit(partner,target)
            if hit_rate_range.include?(hit)
              skill_targets.push(target)
              break
            end
          end
        end
      end

      return setup_skills(skills,skill_targets)
    end
  end

  # @
  # @gāAfxڕWl荂ꍇH
  class Cond_Skill_Magic_Restriction < Best_Battle_AI_Condition
    def execute_main_condition
      # @XLꍇ
      skills = battler_skill.magic_blockade_skills
      return false if skills.empty?
      skills = skills_filter(skills)
      return false if skills.empty?
      # SP̒ႢɃ\[g
      skills.sort! { |a,b| a.sp_cost <=> b.sp_cost }

      # @XLgp\ȑW߂
      skill_targets = []
      targets.each do |target|
        # ɖ@XLĂ鑊͖
        next if target.restriction == 1
        # gXLĂȂ͖
        next if target.skills.empty?
        # XXX Ɓcd
        target_skill = Game_Battler_Skill.new(target)
        # @XLĂȂΖ
        next if target_skill.magic_skills.empty?
        # ɒǉ
        skill_targets.push(target)
      end
      # XL̃^[QbgȂꍇ
      if skill_targets.empty?
        return false
      end

      # Ώېl
      magic_users_count = param_i('magic_users_count',0)
      if skill_targets.size < magic_users_count
        return false
      end

      # TODO {Ɏg邩ǂfقǂ

      # TODO @XĽŃ\[g Gl~[skills \bh́Adcǂ悤ȁ`
      # skill_targets.sort! {|a,b| b.skills.size <=> a.skills.size}

      # Ƃ肠HP̍Ƀ\[g
      skill_targets.sort! {|a,b| b.hp <=> a.hp}

      return setup_skills(skills,skill_targets)
    end
  end

  # s
  # UXL̖fxڕWl荂ꍇH
  # ̃XLꍇH
  class Cond_Skill_Action_Restriction < Best_Battle_AI_Condition
    def execute_main_condition
      # sXLꍇ
      skills = battler_skill.action_blockade_skills
      return false if skills.empty?
      skills = skills_filter(skills)
      return false if skills.empty?
      # SP̒ႢɃ\[g
      skills.sort! { |a,b| a.sp_cost <=> b.sp_cost }

      # TODO ^[Qbg̍i݁iHPj
      # Ȃ^[Qbg폜
      skill_targets = targets.dup.delete_if {|t| (not t.movable?)}
      # ^[QbgȂ
      if skill_targets.empty?
        return false
      end
      # s\ȓG̐
      action_targets_min_count = param_i('action_targets_min_count',-1)
      if action_targets_min_count >= 0
        return false if skill_targets.size < action_targets_min_count
      end
      # s\ȓG̐ĩp[eB̍s\lƂ̔rj
      if param?('action_targets_gap_count')
        # p[gi[Xgss\̃p[gi[폜
        action_partners = partners.dup.delete_if {|p| (not p.movable?)}
        # p[eBlMbvBvXƎ̃p[eB̃p[eB̕
        action_targets_gap_count = param_i('action_targets_gap_count')
        # TODO FIX?
        # MbvƎsȂ
        return false if skill_targets.size - action_partners.size < action_targets_gap_count
      end

      # TODO t悤ƂĂXe[gtĂ邩ǂ肷KvH

      return setup_skills(skills,skill_targets)
    end
  end

  # ԉ񕜃XL
  class Cond_Skill_Recover_State < Best_Battle_AI_Condition
    def execute_main_condition
      # ԉ񕜃XLꍇ
      skills = battler_skill.state_cancel_skills
      return false if skills.empty?
      skills = skills_filter(skills)
      return false if skills.empty?

      # ΏۃXe[g(K{)
      unless param?('state_id_list')
        return false
      end
      # TODO قm͎ȂƂǂ낤H

      state_id_list = param_s('state_id_list').split(/\s*,\s*/).collect {|s| s.to_i}
      state_id_list.each do |state_id|
        # ^[Qbg̑I
        skill_targets = []
        partners.each do |partner|
          # Ώۂ̃Xe[gĂꍇɒǉ
          if partner.state?(state_id)
            skill_targets.push partner
          end
        end
        # TODO Ώۂ́AHPōi݂ƂH
        # ΏۂȂꍇ́ÃXe[g`FbN
        next if skill_targets.empty?

        # ΏۃXe[gXLW߂
        cancel_skills = skills.dup.delete_if {|skill| (not skill.minus_state_set.include?(state_id))}

        # ꍇ́ÃXe[g`FbN
        next if cancel_skills.empty?

        return setup_skills(cancel_skills,skill_targets)
      end
      return false
    end
  end

  # 񕜃XL
  # cgoݒ芄ꍇ
  # FIXME ꌂ̃_[W֌WƂ͎v񂾂ǁc
  class Cond_Skill_Recover < Best_Battle_AI_Condition
    def execute_main_condition
      # 񕜃XLꍇ
      skills = battler_skill.recover_skills
      return false if skills.empty?
      skills = skills_filter(skills)
      return false if skills.empty?

      # Ώێcgo
      partner_hp_rate = param_i('partner_hp_rate',-1)
      # ڕWU
      attack_count = param_i('attack_count',-1)
      # ǂꍇ́A肵Ȃiݒ~Xj
      if partner_hp_rate < 0 and attack_count < 0
        return false
      end

      # p[gi[cHP̒ႢɃ\[g
      skill_targets = partners.sort {|a,b| a.hp <=> b.hp}

      # 񕜃XLSPRXgɃ\[g
      skills.sort! { |a,b| a.sp_cost <=> b.sp_cost }

      # ΏێcgoŔ
      if partner_hp_rate >= 0
        skill_targets.each do |target|
          # łꍇ́AǉȂ
          next if target.dead?
          # _[WȂ
          next if target.hp == target.maxhp
          # HPvZ
          if (target.hp / target.maxhp.to_f * 100.0) < partner_hp_rate
            # 񕜃XLI
            last_skill = skills[0]
            last_recover = 0
            skills.each do |skill|
              # 񕜗ʂvZ
              damage = Game_Battler_Module.calculate_skill_damage(target,battler,skill)
              # TODO 񕜌HPmF(ǂ̂炢܂ŉ񕜂邩HKvB100%ȏ)
              if (target.hp - damage) >= target.maxhp
                # [ɉ񕜂XLŉ
                last_skill = skill
                break
              end
              recover = damage.abs
              if recover > last_recover
                last_recover = recover
                last_skill = skill
              end
            end
            # Ō̃XLŉ
            setup_skill(last_skill,target)
            return true
          end
        end
        return false
      end

      # ڕWU񐔂Ŕ
      if attack_count >= 0
        skill_targets.each do |partner|
          # _[WȂ
          next if partner.hp == partner.maxhp
          targets.each do |enemy|
            # 肩p[gi[ւ̃_[WvZ
            damage = Game_Battler_Module.calculate_attack_damage(partner,enemy)
            next if damage <= 0
            # ڕWU񐔂Ŏł܂ꍇ
            if (partner.hp / damage.to_f).ceil <= attack_count
              # ^[Qbg
              target = partner
              # 񕜃XLI
              skills.each do |skill|
                # 񕜗ʂvZ
                damage = Game_Battler_Module.calculate_skill_damage(partner,battler,skill)
                # TODO 񕜌HPmF(ǂ̂炢܂ŉ񕜂邩HKvB100%ȏ)
                if (partner.hp - damage) >= partner.maxhp
                  # [ɉ񕜂XLŉ
                  setup_skill(skill,target)
                  return true
                end
              end
              # Ō̃XLŉ
              setup_skill(skill,target)
              return true
            end
          end
        end
      end

      return false
    end
  end

  # @XL
  # @XLŖڕW񐔈ȓɓ|ꍇ
  # ȂA|񐔕ro
  # ΏۃXL̏ꍇǂc
  class Cond_Skill_Magic < Best_Battle_AI_Condition
    def execute_main_condition
      # @XLꍇ
      skills = battler_skill.magic_skills
      return false if skills.empty?
      skills = skills_filter(skills)
      return false if skills.empty?
      # ڕWU
      attack_count = param_i('attack_count',1)

      # TODO \[g(I邩BƂ肠SPʗD)
      skills.sort! { |a,b| a.sp_cost <=> b.sp_cost }

      last_target = nil
      last_skill = nil

      # œ|邩vZ
      targets.each do |target|
        skills.each do |skill|
          # ^[Qbgւ̃XL_[Wǂ̒xH
          damage = Game_Battler_Module.calculate_skill_damage(target,battler,skill)
          next if damage <= 0
          if (target.hp / damage.to_f).ceil <= attack_count
            last_target = target
            last_skill = skill
            break
          end
        end
        # ȂG玟̓GĂ݂H
        unless last_target.nil?
          if last_target.movable?
            next
          end
          break
        end
      end
      if last_target.nil?
        return false
      end
      setup_skill(last_skill,last_target)
      return true
    end
  end

  # UXL
  # UXLŖڕW񐔈ȓɓ|ꍇ
  # ȂA|񐔕ro
  # ΏۃXL̏ꍇǂc
  class Cond_Skill_Attack < Best_Battle_AI_Condition
    def execute_main_condition
      # UXLꍇ
      skills = battler_skill.attack_skills
      return false if skills.empty?
      skills = skills_filter(skills)
      return false if skills.empty?
      # ڕWU
      attack_count = param_i('attack_count',1)

      # TODO \[g(I邩BƂ肠SPʗD)
      skills.sort! { |a,b| a.sp_cost <=> b.sp_cost }

      last_target = nil
      last_skill = nil
      # œ|邩vZ
      targets.each do |target|
        skills.each do |skill|
          # ^[Qbgւ̃XL_[Wǂ̒xH
          damage = Game_Battler_Module.calculate_skill_damage(target,battler,skill)
          next if damage <= 0
          if (target.hp / damage.to_f).ceil <= attack_count
            last_target = target
            last_skill = skill
            break
          end
        end
        # ȂG玟̓GĂ݂H
        unless last_target.nil?
          if last_target.movable?
            next
          end
          break
        end
      end
      if last_target.nil?
        return false
      end
      setup_skill(last_skill,last_target)
      return true
    end
  end

  # ʏU
  # ʏUŖڕW񐔈ȓɓ|ꍇ
  class Cond_Attack < Best_Battle_AI_Condition
    def execute_main_condition
      # ڕWU
      attack_count = param_i('attack_count',1)

      last_target = nil
      # œ|邩vZ
      targets.each do |target|
        # ^[Qbgւ̒ʏ_[Wǂ̒xH
        damage = Game_Battler_Module.calculate_attack_damage(target,battler)
        next if damage <= 0
        if (target.hp / damage.to_f).ceil <= attack_count
          last_target = target
          # ȂG玟̓GĂ݂H
          if last_target.movable?
            next
          end
          setup_normal_attack(last_target)
          return true
        end
      end
      if last_target.nil?
        return false
      end
      setup_normal_attack(last_target)
      return true
    end
  end

  # h
  # ʏUŖڕW񐔈ȓɎł܂ꍇ
  class Cond_Guard < Best_Battle_AI_Condition
    def execute_main_condition
      # ڕWU
      attack_count = param_i('attack_count',2)

      # œ|ꂻvZ
      targets.each do |target|
        # ^[Qbg玩ւ̒ʏ_[Wǂ̒xH
        # TODO @ÚAǂ悤H
        damage = Game_Battler_Module.calculate_attack_damage(battler,target)
        next if damage <= 0
        if (battler.hp / damage.to_f).ceil <= attack_count
          setup_normal_guard()
          return true
        end
      end
      return false
    end
  end

  # U͋ACe
  # ʏUŖڕW񐔈ȓɓ|Ȃꍇ
  class Cond_Item_Attack_Up < Best_Battle_AI_Condition
    def execute_main_condition
      # gp\ACe
      items = battler_items
      # gACeꍇ
      return false if items.empty?
      # U͋ACeȊO폜
      items.delete_if {|item| (not item.attack_up_item?)}
      # U͋ACeꍇ
      return false if items.empty?
      # ʃtB^[
      items = items_filter(items)
      # gACe
      return false if items.empty?

      # ڕWU
      attack_count = param_i('attack_count',4)
      # ΏۂƂp[eBo[̍őʒu
      party_max_index = [param_i('party_max_index',0),partners.size].min - 1
      attack_partners = partners[0 .. party_max_index]

      # Ώۂ
      item_targets = []
      attack_partners.each do |partner|
        # łꍇ́AǉȂ
        next if partner.dead?
        # Xe[gĂȂԂǉB
        unless items_state?(partner,items)
          # U񐔂̊mF
          targets.each do |target|
            # _[WvZ
            damage = Game_Battler_Module.calculate_attack_damage(target,partner)
            next if damage <= 0
            # ڕWU񐔂葽̍UKvȏꍇ
            if (target.maxhp / damage.to_f).ceil > attack_count
              item_targets.push(partner)
              break
            end
          end
        end
      end

      # ACe^[QbgȂ
      if item_targets.empty?
        return false
      end

      return setup_item(items[0],item_targets[0])
    end
  end

  # h͋ACe
  # G̒ʏUڕW񐔑ςȂꍇ
  class Cond_Item_Defense_Up < Best_Battle_AI_Condition
    def execute_main_condition
      # gp\ACe
      items = battler_items
      # gACeꍇ
      return false if items.empty?
      # h͋ACeȊO폜
      items.delete_if {|item| (not item.pdef_up_item?)}
      # h͋ACeꍇ
      return false if items.empty?
      # ʃtB^[
      items = items_filter(items)
      # gACe
      return false if items.empty?

      # ڕWU
      attack_count = param_i('attack_count',3)

      # Ώۂ
      item_targets = []
      partners.each do |partner|
        # łꍇ́AǉȂ
        next if partner.dead?
        # Xe[gĂȂԂǉB
        unless items_state?(partner,items)
          # U񐔂̊mF
          targets.each do |target|
            damage = Game_Battler_Module.calculate_attack_damage(partner,target)
            next if damage <= 0
            # ڕWU񐔈ȓ̍UŎł܂ꍇ
            if (partner.maxhp / damage.to_f).ceil <= attack_count
              item_targets.push(partner)
              break
            end
          end
        end
      end

      # ACe^[QbgȂ
      if item_targets.empty?
        return false
      end

      return setup_item(items[0],item_targets[0])
    end
  end

  # ͋ACe
  # 肻ɖƂc
  class Cond_Item_Hit_Up < Best_Battle_AI_Condition
    def execute_main_condition
      # gp\ACe
      items = battler_items
      # gACeꍇ
      return false if items.empty?
      # ͋ACeȊO폜
      items.delete_if {|item| (not item.hit_up_item?)}
      # ͋ACeꍇ
      return false if items.empty?
      # ʃtB^[
      items = items_filter(items)
      # gACe
      return false if items.empty?

      # TODO ĂȂꍇ

      # ڕW(K{)
      hit_rate = param_i('hit_rate',-1)
      if hit_rate < 0
        return false
      end

      # ΏۂƂp[eBo[̍őʒu
      party_max_index = [param_i('party_max_index',0),partners.size].min - 1
      attack_partners = partners[0 .. party_max_index]

      # Ώۂ
      item_targets = []
      attack_partners.each do |partner|
        # łꍇ́AǉȂ
        next if partner.dead?
        # Xe[gĂȂԂǉB
        unless items_state?(partner,items)
          # ̌vZ
          targets.each do |target|
            hit = Game_Battler_Module.calculate_attack_hit(target,partner)
            if hit < hit_rate
              item_targets.push(partner)
              break
            end
          end
        end
      end
      # ACe^[QbgȂ
      if item_targets.empty?
        return false
      end
      return setup_item(items[0],item_targets[0])
    end
  end

  # Ũ͎ACe
  # G̒ʏUڕW񐔑ςȂꍇ
  class Cond_Item_Attack_Down < Best_Battle_AI_Condition
    def execute_main_condition
      # gp\ACe
      items = battler_items
      # gACeꍇ
      return false if items.empty?
      # Ũ͎ACeȊO폜
      items.delete_if {|item| (not item.attack_down_item?)}
      # Ũ͎ACeꍇ
      return false if items.empty?
      # ʃtB^[
      items = items_filter(items)
      # gACe
      return false if items.empty?

      # ڕWU
      attack_count = param_i('attack_count',3)

      # ̉Ώۂ
      item_targets = []
      targets.each do |target|
        # Xe[gĂȂԂǉB
        unless items_state?(target,items)
          # U񐔂̊mF
          partners.each do |partner|
            # _[WvZ
            damage = Game_Battler_Module.calculate_attack_damage(partner,target)
            next if damage <= 0
            # ڕWU񐔈ȉŎł܂ꍇ
            if (partner.maxhp / damage.to_f).ceil <= attack_count
              item_targets.push(target)
              break
            end
          end
        end
      end

      # ACe^[QbgȂ
      if item_targets.empty?
        return false
      end
      return setup_item(items[0],item_targets[0])
    end
  end

  # h͎̃ACe
  # ʏUŖڕW񐔈ȓɓ|Ȃꍇ
  class Cond_Item_Defense_Down < Best_Battle_AI_Condition
    def execute_main_condition
      # gp\ACe
      items = battler_items
      # gACeꍇ
      return false if items.empty?
      # h͎̃ACeȊO폜
      items.delete_if {|item| (not item.pdef_down_item?)}
      # h͎̃ACeꍇ
      return false if items.empty?
      # ʃtB^[
      items = items_filter(items)
      # gACe
      return false if items.empty?

      # ڕWU
      attack_count = param_i('attack_count',4)
      # ΏۂƂp[eBo[̍őʒu
      party_max_index = [param_i('party_max_index',0),partners.size].min - 1
      attack_partners = partners[0 .. party_max_index]

      # ̉Ώۂ
      item_targets = []
      targets.each do |target|
        # Xe[gĂȂ^[QbgǉB
        unless items_state?(target,items)
          # U񐔂̊mF
          attack_partners.each do |partner|
            # _[WvZ
            damage = Game_Battler_Module.calculate_attack_damage(target,partner)
            next if damage <= 0
            # ڕWU񐔂葽̍UKvȏꍇ
            if (target.maxhp / damage.to_f).ceil > attack_count
              item_targets.push(target)
              break
            end
          end
        end
      end

      # ACe^[QbgȂ
      if item_targets.empty?
        return false
      end
      return setup_item(items[0],item_targets[0])
    end
  end

  # ͎̃ACe
  class Cond_Item_Hit_Down < Best_Battle_AI_Condition
    def execute_main_condition
      # gp\ACe
      items = battler_items
      # gACeꍇ
      return false if items.empty?
      # ͎̃ACeȊO폜
      items.delete_if {|item| (not item.hit_down_item?)}
      # ͎̃ACeꍇ
      return false if items.empty?
      # ʃtB^[
      items = items_filter(items)
      # gACe
      return false if items.empty?

      # ̉Ώۂ
      item_targets = targets.dup

      # s\ȓG̐
      action_targets_min_count = param_i('action_targets_min_count',-1)
      if action_targets_min_count >= 0
        return false if item_targets.size < action_targets_min_count
      end
      # s\ȓG̐ĩp[eB̍s\lƂ̔rj
      if param?('action_targets_gap_count')
        # p[gi[Xgss\̃p[gi[폜
        action_partners = partners.dup.delete_if {|p| (not p.movable?)}
        # p[eBlMbvBvXƎ̃p[eB̃p[eB̕
        action_targets_gap_count = param_i('action_targets_gap_count')
        # MbvƎsȂ
        return false if item_targets.size - action_partners.size < action_targets_gap_count
      end

      # ڕW
      hit_min_rate = param_i('hit_min_rate',0)
      hit_max_rate = param_i('hit_max_rate',100)
      hit_rate_range = hit_min_rate .. hit_max_rate

      old_skill_targets = item_targets
      item_targets = []
      old_skill_targets.each do |target|
        # Xe[gĂȂ^[QbgǉB
        unless items_state?(target,items)
          # ̌vZ
          partners.each do |partner|
            # ^[QbgɍUꍇ̖vZ
            hit = Game_Battler_Module.calculate_attack_hit(partner,target)
            if hit_rate_range.include?(hit)
              item_targets.push(target)
              break
            end
          end
        end
      end

      # ACe^[QbgȂ
      if item_targets.empty?
        return false
      end
      return setup_item(items[0],item_targets[0])
    end
  end

  # @ACe
  # @gāAfxڕWl荂ꍇH
  class Cond_Item_Magic_Restriction < Best_Battle_AI_Condition
    def execute_main_condition
      # gp\ACe
      items = battler_items
      # gACeꍇ
      return false if items.empty?
      # @ACeȊO폜
      items.delete_if {|item| (not item.magic_blockade_item?)}
      # @ACeꍇ
      return false if items.empty?
      # ʃtB^[
      items = items_filter(items)
      # gACe
      return false if items.empty?

      # @XLgp\ȑW߂
      item_targets = []
      targets.each do |target|
        # ɖ@XLĂ鑊͖
        next if target.restriction == 1
        # gXLĂȂ͖
        next if target.skills.empty?
        # XXX Ɓcd
        target_skill = Game_Battler_Skill.new(target)
        # @XLĂȂΖ
        next if target_skill.magic_skills.empty?
        # ɒǉ
        item_targets.push(target)
      end
      # ACẽ^[QbgȂꍇ
      if item_targets.empty?
        return false
      end

      # Ώېl
      magic_users_count = param_i('magic_users_count',0)
      if item_targets.size < magic_users_count
        return false
      end

      # TODO {Ɏg邩ǂfقǂ

      # TODO @XĽŃ\[g Gl~[skills \bh́Adcǂ悤ȁ`
      # skill_targets.sort! {|a,b| b.skills.size <=> a.skills.size}

      # Ƃ肠HP̍Ƀ\[g
      item_targets.sort! {|a,b| b.hp <=> a.hp}

      # TODO \[gȂƁc
      return setup_item(items[0],item_targets[0])
    end
  end

  # sACe
  # UACe̖fxڕWl荂ꍇH
  # ̃ACeꍇH
  class Cond_Item_Action_Restriction < Best_Battle_AI_Condition
    def execute_main_condition
      # gp\ACe
      items = battler_items
      # gACeꍇ
      return false if items.empty?
      # sACeȊO폜
      items.delete_if {|item| (not item.action_blockade_item?)}
      # sACeꍇ
      return false if items.empty?
      # ʃtB^[
      items = items_filter(items)
      # gACe
      return false if items.empty?

      # TODO ^[Qbg̍i݁iHPj
      # Ȃ^[Qbg폜
      item_targets = targets.dup.delete_if {|t| (not t.movable?)}
      # ^[QbgȂ
      if item_targets.empty?
        return false
      end
      # s\ȓG̐
      action_targets_min_count = param_i('action_targets_min_count',-1)
      if action_targets_min_count >= 0
        return false if item_targets.size < action_targets_min_count
      end
      # s\ȓG̐ĩp[eB̍s\lƂ̔rj
      if param?('action_targets_gap_count')
        # p[gi[Xgss\̃p[gi[폜
        action_partners = partners.dup.delete_if {|p| (not p.movable?)}
        # p[eBlMbvBvXƎ̃p[eB̃p[eB̕
        action_targets_gap_count = param_i('action_targets_gap_count')
        # TODO FIX?
        # MbvƎsȂ
        return false if item_targets.size - action_partners.size < action_targets_gap_count
      end

      # TODO t悤ƂĂXe[gtĂ邩ǂ肷KvH

      return setup_item(items[0],item_targets[0])
    end
  end

  # ԉ񕜃ACe
  class Cond_Item_Recover_State < Best_Battle_AI_Condition
    def execute_main_condition
      # gp\ACe
      items = battler_items
      # gACeꍇ
      return false if items.empty?
      # ԉ񕜃ACeȊO폜
      items.delete_if {|item| (not item.state_cancel_item?)}
      # ԉ񕜃ACeꍇ
      return false if items.empty?
      # ʃtB^[
      items = items_filter(items)
      # gACe
      return false if items.empty?

      # ΏۃXe[g(K{)
      unless param?('state_id_list')
        return false
      end
      # TODO قm͎ȂƂǂ낤H

      state_id_list = param_s('state_id_list').split(/\s*,\s*/).collect {|s| s.to_i}
      state_id_list.each do |state_id|
        # ^[Qbg̑I
        item_targets = []
        partners.each do |partner|
          # Ώۂ̃Xe[gĂꍇɒǉ
          if partner.state?(state_id)
            item_targets.push partner
          end
        end
        # TODO Ώۂ́AHPōi݂ƂH
        # ΏۂȂꍇ́ÃXe[g`FbN
        next if item_targets.empty?

        # ΏۃXe[gACeW߂
        cancel_items = items.dup.delete_if {|item| (not item.minus_state_set.include?(state_id))}

        # ꍇ́ÃXe[g`FbN
        next if cancel_items.empty?

        return setup_item(cancel_items[0],item_targets[0])
      end
      return false
    end
  end

  # 񕜃ACe
  # cgoݒ芄ꍇ
  # FIXME ꌂ̃_[W֌WƂ͎v񂾂ǁc
  class Cond_Item_Recover < Best_Battle_AI_Condition
    def execute_main_condition
      # gp\ACe
      items = battler_items
      # gACeꍇ
      return false if items.empty?
      # 񕜃ACeȊO폜
      items.delete_if {|item| (not item.recover_item?)}
      # 񕜃ACeꍇ
      return false if items.empty?
      # ʃtB^[
      items = items_filter(items)
      # gACe
      return false if items.empty?

      # Ώێcgo
      partner_hp_rate = param_i('partner_hp_rate',-1)
      # ڕWU
      attack_count = param_i('attack_count',-1)
      # ǂꍇ́A肵Ȃiݒ~Xj
      if partner_hp_rate < 0 and attack_count < 0
        return false
      end

      # p[gi[cHP̒ႢɃ\[g
      item_targets = partners.sort {|a,b| a.hp <=> b.hp}

      # ΏێcgoŔ
      if partner_hp_rate >= 0
        item_targets.each do |target|
          # _[WȂ
          next if target.hp == target.maxhp
          # HPvZ
          if (target.hp / target.maxhp.to_f * 100.0) < partner_hp_rate
            # 񕜃ACeI
            last_item = items[0]
            last_recover = 0
            items.each do |item|
              # 񕜗ʂvZ
              recover = Game_Battler_Module.calculate_item_recover_hp(target,battler,item)
              # TODO 񕜌HPmF(ǂ̂炢܂ŉ񕜂邩HKvB100%ȏ)
              if (target.hp + recover) >= target.maxhp
                # [ɉ񕜂
                last_item = item
                break
              end
              if recover > last_recover
                last_recover = recover
                last_item = item
              end
            end
            # Ō̃ACeŉ
            setup_item(last_item,target)
            return true
          end
        end
        return false
      end

      # ڕWU񐔂Ŕ
      if attack_count >= 0
        item_targets.each do |partner|
          # _[WȂ
          next if partner.hp == partner.maxhp
          targets.each do |enemy|
            # 肩p[gi[ւ̃_[WvZ
            damage = Game_Battler_Module.calculate_attack_damage(partner,enemy)
            next if damage <= 0
            # ڕWU񐔂Ŏł܂ꍇ
            if (partner.hp / damage.to_f).ceil <= attack_count
              # ^[Qbg
              target = partner
              # 񕜃ACeI
              items.each do |item|
                # 񕜗ʂvZ
                damage = Game_Battler_Module.calculate_item_damage(partner,battler,item)
                # TODO 񕜌HPmF(ǂ̂炢܂ŉ񕜂邩HKvB100%ȏ)
                if (partner.hp - damage) >= partner.maxhp
                  # [ɉ񕜂ACeŉ
                  setup_item(item,target)
                  return true
                end
              end
              # Ō̃ACeŉ
              setup_item(item,target)
              return true
            end
          end
        end
      end

      return false
    end
  end

  # UACe
  # UACeŖڕW񐔈ȓɓ|ꍇ
  # ȂA|񐔕ꍇH
  class Cond_Item_Attack < Best_Battle_AI_Condition
    def execute_main_condition
      # gp\ACe
      items = battler_items
      # gACeꍇ
      return false if items.empty?
      # UACeȊO폜
      items.delete_if {|item| (not item.damage_item?)}
      # UACeꍇ
      return false if items.empty?
      # ʃtB^[
      items = items_filter(items)
      # gACe
      return false if items.empty?

      # ڕWU
      attack_count = param_i('attack_count',1)

      # TODO \[g(I邩)

      last_target = nil
      last_item = nil
      # œ|邩vZ
      targets.each do |target|
        items.each do |item|
          # ^[Qbgւ̃ACe_[Wǂ̒xH
          damage = Game_Battler_Module.calculate_item_damage(target,battler,item)
          next if damage <= 0
          if (target.hp / damage.to_f).ceil <= attack_count
            last_target = target
            last_item = item
            break
          end
        end
        # ȂG玟̓GĂ݂H
        unless last_target.nil?
          if last_target.movable?
            next
          end
          break
        end
      end
      if last_target.nil?
        return false
      end
      setup_item(last_item,last_target)
      return true
    end
  end
end
