# VX Game_Map XPΉ
# Author:: fukuyama
# Date:: 2009/02/11
# Copyright:: Copyright (c) 2009 rgss-lib

class Game_Map
  #--------------------------------------------------------------------------
  #  \ʒu̐ݒ
  #     x : V\ X W (*128)
  #     y : V\ Y W (*128)
  #--------------------------------------------------------------------------
  def set_display_pos(x, y)
    @display_x = (x + @map.width * 128) % (@map.width * 128)
    @display_y = (y + @map.height * 128) % (@map.height * 128)
    @parallax_x = x
    @parallax_y = y
  end
  #--------------------------------------------------------------------------
  #  XN[̃ZbgAbv
  #--------------------------------------------------------------------------
  def setup_scroll
    @scroll_direction = 2
    @scroll_rest = 0
    @scroll_speed = 4
    @margin_x = (width - 20) * 128 / 2      # ʔ\̉ / 2
    @margin_y = (height - 15) * 128 / 2     # ʔ\̏c / 2
  end
  #--------------------------------------------------------------------------
  #  ĩZbgAbv
  #--------------------------------------------------------------------------
  def setup_parallax
#    @parallax_name = @map.parallax_name
#    @parallax_loop_x = @map.parallax_loop_x
#    @parallax_loop_y = @map.parallax_loop_y
#    @parallax_sx = @map.parallax_sx
#    @parallax_sy = @map.parallax_sy
    @parallax_x = 0
    @parallax_y = 0
  end
  #--------------------------------------------------------------------------
  #  \W X W̌vZ
  #     x : X W
  #--------------------------------------------------------------------------
  def adjust_x(x)
    if loop_horizontal? and x < @display_x - @margin_x
      return x - @display_x + @map.width * 128
    else
      return x - @display_x
    end
  end
  #--------------------------------------------------------------------------
  #  \W Y W̌vZ
  #     y : Y W
  #--------------------------------------------------------------------------
  def adjust_y(y)
    if loop_vertical? and y < @display_y - @margin_y
      return y - @display_y + @map.height * 128
    else
      return y - @display_y
    end
  end
  #--------------------------------------------------------------------------
  #  Ƀ[v邩H
  #--------------------------------------------------------------------------
  def loop_horizontal?
    return false
  end
  #--------------------------------------------------------------------------
  #  cɃ[v邩H
  #--------------------------------------------------------------------------
  def loop_vertical?
    return false
  end
  #--------------------------------------------------------------------------
  #  [v␳ X WvZ
  #     x : X W
  #--------------------------------------------------------------------------
  def round_x(x)
    if loop_horizontal?
      return (x + width) % (width)
    else
      return x
    end
  end
  #--------------------------------------------------------------------------
  #  [v␳ Y WvZ
  #     y : Y W
  #--------------------------------------------------------------------------
  def round_y(y)
    if loop_vertical?
      return (y + height) % (height)
    else
      return y
    end
  end
  #--------------------------------------------------------------------------
  #  ɃXN[
  #     distance : XN[鋗
  #--------------------------------------------------------------------------
  def scroll_down(distance)
    if loop_vertical?
      @display_y += distance
      @display_y %= @map.height * 128
      @parallax_y += distance
    else
      last_y = @display_y
      @display_y = [@display_y + distance, (height - 15) * 128].min
      @parallax_y += @display_y - last_y
    end
  end
  #--------------------------------------------------------------------------
  #  ɃXN[
  #     distance : XN[鋗
  #--------------------------------------------------------------------------
  def scroll_left(distance)
    if loop_horizontal?
      @display_x += @map.width * 128 - distance
      @display_x %= @map.width * 128
      @parallax_x -= distance
    else
      last_x = @display_x
      @display_x = [@display_x - distance, 0].max
      @parallax_x += @display_x - last_x
    end
  end
  #--------------------------------------------------------------------------
  #  EɃXN[
  #     distance : XN[鋗
  #--------------------------------------------------------------------------
  def scroll_right(distance)
    if loop_horizontal?
      @display_x += distance
      @display_x %= @map.width * 128
      @parallax_x += distance
    else
      last_x = @display_x
      @display_x = [@display_x + distance, (width - 20) * 128].min
      @parallax_x += @display_x - last_x
    end
  end
  #--------------------------------------------------------------------------
  #  ɃXN[
  #     distance : XN[鋗
  #--------------------------------------------------------------------------
  def scroll_up(distance)
    if loop_vertical?
      @display_y += @map.height * 128 - distance
      @display_y %= @map.height * 128
      @parallax_y -= distance
    else
      last_y = @display_y
      @display_y = [@display_y - distance, 0].max
      @parallax_y += @display_y - last_y
    end
  end
end
