# rbg}bvg
# Author:: fukuyama
# Date:: 2008/08/11
# Copyright:: Copyright (c) 2008 rgss-lib


class Bitmap
  def draw_line(sx,sy,ex,ey,color)
    nx = sx
    ny = sy
    tx = sx < ex ? 1 : -1
    ty = sy < ey ? 1 : -1
    dx = (sx - ex).abs
    dy = (sy - ey).abs
    if dx < dy
      if 0 <= nx and nx <= self.width and 0 <= ny and ny <= self.height
        set_pixel(nx, ny, color)
      end
      f = dx * 2 - dy
      while ny != ey
        if f >= 0
          nx += tx
          f = f - (ny - ey).abs
          if 0 <= nx and nx <= self.width and 0 <= ny and ny <= self.height
            set_pixel(nx, ny, color)
          end
        end
        ny += ty
        f = f + (nx - ex).abs
        if 0 <= nx and nx <= self.width and 0 <= ny and ny <= self.height
          set_pixel(nx, ny, color)
        end
      end
    else
      if 0 <= nx and nx <= self.width and 0 <= ny and ny <= self.height
        set_pixel(nx, ny, color)
      end
      f = dy * 2 - dx
      while nx != ex
        if f >= 0
          ny += ty
          f = f - (nx - ex).abs
          if 0 <= nx and nx <= self.width and 0 <= ny and ny <= self.height
            set_pixel(nx, ny, color)
          end
        end
        nx += tx
        f = f + (ny - ey).abs
        if 0 <= nx and nx <= self.width and 0 <= ny and ny <= self.height
          set_pixel(nx, ny, color)
        end
      end
    end
  end

  def draw_gradation(sx,sy,ex,ey,scr,ecr,w=1.0)
    nx = sx
    ny = sy
    tx = sx < ex ? 1 : -1
    ty = sy < ey ? 1 : -1
    dx = (sx - ex).abs
    dy = (sy - ey).abs
    sx2 = (dy * -1) * w
    sy2 = (dx * 1)  * w
    ex2 = (dy * 1)  * w
    ey2 = (dx * -1) * w
    ix = 0
    iy = 0
    if dx < dy
      tr = (ecr.red   - scr.red  ).to_f / dy.to_f
      tg = (ecr.green - scr.green).to_f / dy.to_f
      tb = (ecr.blue  - scr.blue ).to_f / dy.to_f
      ta = (ecr.alpha - scr.alpha).to_f / dy.to_f
      color = scr.dup
      draw_line(sx2 + ix,sy2 + iy,ex2 + ix,ey2 + iy,color)
      f = dx * 2 - dy
      while ny != ey
        if f >= 0
          nx += tx
          ix += tx
          f = f - (ny - ey).abs
        end
        ny += ty
        iy += ty
        f = f + (nx - ex).abs
        color.red   = scr.red   + (tr * iy).to_i
        color.green = scr.green + (tg * iy).to_i
        color.blue  = scr.bule  + (tb * iy).to_i
        color.alpha = scr.alpha + (ta * iy).to_i
        draw_line(sx2 + ix,sy2 + iy,ex2 + ix,ey2 + iy,color)
      end
    else
      tr = (ecr.red   - scr.red  ).to_f / dx.to_f
      tg = (ecr.green - scr.green).to_f / dx.to_f
      tb = (ecr.blue  - scr.blue ).to_f / dx.to_f
      ta = (ecr.alpha - scr.alpha).to_f / dx.to_f
      color = scr.dup
      draw_line(sx2 + ix,sy2 + iy,ex2 + ix,ey2 + iy,color)
      f = dy * 2 - dx
      while nx != ex
        if f >= 0
          ny += ty
          iy += ty
          f = f - (nx - ex).abs
        end
        nx += tx
        ix += tx
        f = f + (ny - ey).abs
        color.red   = (scr.red   + tr * ix).to_i
        color.green = (scr.green + tg * ix).to_i
        color.blue  = (scr.blue  + tb * ix).to_i
        color.alpha = (scr.alpha + ta * ix).to_i
        draw_line(sx2 + ix,sy2 + iy,ex2 + ix,ey2 + iy,color)
      end
    end
  end
end
