#==============================================================================
#  RPG::Stateg
#------------------------------------------------------------------------------
# Xe[gpǉ\bh
#==============================================================================

module RPG
  module State_Common_Function_Module
    # restriction  (0:ȂA1:@gpłȂA2:GʏUA3:ʏUA4:słȂ)
    # rating [eBO (0..10)
    
    def menace_score
      return 100.0 * $data_states.size if @id == 1
      score = 0
      score += @restriction
      score += @rating
      score += 1 if @nonresistance
      score += 1 if @zero_hp
      score += 1 if @cant_get_exp
      score += 1 if @cant_evade
      score += 1 if @slip_damage
      score_rate = 0
      score_rate += @hit_rate
      score_rate += @maxhp_rate
      score_rate += @maxsp_rate
      score_rate += @str_rate
      score_rate += @dex_rate
      score_rate += @agi_rate
      score_rate += @int_rate
      score_rate += @atk_rate
      score_rate += @pdef_rate
      score_rate += @mdef_rate
      # FIXME ǂ悤H
      # @eva
      return (score.to_f * (2000.0 - score_rate.to_f) / 1000.0)
    end
    
    def change_ability?
      return (@hit_rate != 100 or
              @maxhp_rate != 100 or
              @maxsp_rate != 100 or
              @str_rate != 100 or
              @dex_rate != 100 or
              @agi_rate != 100 or
              @int_rate != 100 or
              @atk_rate != 100 or
              @pdef_rate != 100 or
              @mdef_rate != 100 or
              @eva != 0)
    end
  end
  class State
    include State_Common_Function_Module
  end
end
