# Spriteset_Map LN^[XvCg̍œK
# Auther:: fukuyama
# Date:: 2006/05/16
# Copyright:: Copyright (C) 2006 fukuyama

class Spriteset_Map

  DISPLAY_WIDTH = Game_Player::CENTER_X + 2 * 32 * 4
  DISPLAY_HEIGHT = Game_Player::CENTER_Y + 2 * 32 * 4

  # LN^[XvCgXV
  def update_character_sprites
    dw = $game_map.width * 128
    dh = $game_map.height * 128
    mw = $game_map.width * 64
    mh = $game_map.height * 64
    cx = ($game_map.display_x + Game_Player::CENTER_X) % dw
    cy = ($game_map.display_y + Game_Player::CENTER_Y) % dh
    for sprite in @character_sprites
      tx = (cx - sprite.character.real_x)
      ty = (cy - sprite.character.real_y)
      if mw < tx.abs
        if tx < 0
          tx += dw
        else
          tx -= dw
        end
      end
      if mh < ty.abs
        if ty < 0
          ty += dh
        else
          ty -= dh
        end
      end
      if tx.abs < DISPLAY_WIDTH and ty.abs < DISPLAY_HEIGHT
        sprite.update
      else
        sprite.visible = false
      end
    end
  end
end
