#==============================================================================
#  Markup_Clear
#------------------------------------------------------------------------------
# \Ă镨폜
# Copyright (C) 2005 fukuyama
#==============================================================================
#
# \clear
# \delete_line[Jns,Is]
#
#==============================================================================

module Markup_Clear
  module_function
  def query
    return /^\\clear/
  end
  def transfer(instance, bmp, x, y, text, match)
    instance.clear
    text[query] = ''
    return 0,0,text
  end
end

String_Operation_Module.add_markup(Markup_Clear)

module Markup_Delete_Line
  module_function
  def query
    return /^\\delete_line\[([0-9]+),([0-9]+)\]/
  end
  def transfer(bmp, x, y, text, match)
    index = match[1].to_i
    length = match[2].to_i
    delete_y = Markup_New_Line.line_height * index
    delete_height = Markup_New_Line.line_height * length
    bmp.fill_rect(0,delete_y,bmp.width,delete_height,Color.new(0,0,0,0))
    text[query] = ''
    return x,y,text
  end
end

String_Operation_Module.add_markup(Markup_Delete_Line)
