#==============================================================================
#  Sprite_Cursor
#------------------------------------------------------------------------------
# J[\XvCg
# Copyright (C) 2005 fukuyama
#==============================================================================

class Sprite_Cursor < RPG::Sprite
  DEFAULT_CURSOR_ICON = RPG::Cache.icon('037-Item06')
  
  def initialize(viewport)
    super(viewport)
    @_blink_count = 0
    @_anime_count = 0
    @_anime_index = 0
    @_anime_wait = 3
    @_anime_wait_count = @_anime_wait
    @_anime_flag = false
    @_white_blink = false
    initialize_cursor_bitmap
  end
  def initialize_cursor_bitmap
    self.bitmap = DEFAULT_CURSOR_ICON
  end
  def bitmap=(bmp)
    super(bmp)
    if @_anime_flag
      self.src_rect.set(0,0,bmp.height,bmp.height)
      @_anime_count = bmp.width / bmp.height
    else
      @_anime_count = 0
    end
  end
  def white_blink_on
    unless @_white_blink
      @_white_blink = true
      @_blink_count = 0
    end
  end
  def white_blink_off
    if @_white_blink
      @_white_blink = false
      self.color.set(0, 0, 0, 0)
    end
  end
  def anime_on
    @_anime_flag = true
  end
  def anime_off
    @_anime_flag = false
    self.src_rect.x = 0
  end
  def update
    update_white_blink if @_white_blink
    update_anime if @_anime_flag
    super
  end
  def update_white_blink
    if @_white_blink
      @_blink_count = (@_blink_count + 1) % 32
      if @_blink_count < 16
        self.color.set(0, 0, 0, (16 - @_blink_count) * 6)
      else
        self.color.set(0, 0, 0, (@_blink_count - 16) * 6)
      end
    end
  end
  def update_anime
    if @_anime_wait_count > 0
      @_anime_wait_count -= 1
      return
    else
      @_anime_wait_count = @_anime_wait
    end
    @_anime_index = (@_anime_index + 1) % @_anime_count
    self.src_rect.x = self.src_rect.width * @_anime_index
  end
end
